/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7OqS
 */

// forked from kihon's flash on 2010-4-13
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    //import flash.filters.*;
 
    public class Main extends Sprite
    {
        public function Main()
        {
            graphics.beginFill(0x1C1C1C);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
 
            var slider:Slider = new Slider(1.0, 8.0);
            slider.x = slider.y = 100;
            slider.addEventListener(Event.CHANGE, function():void { trace(slider.value); } );
            //slider.filters = [new BevelFilter(2)];
            addChild(slider);
        }
    }
}
 
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import com.bit101.components.Label;
 
class Slider extends Sprite
{
    public var value:Number = 0.0;
    private var bar:Sprite;
    private var max:Number = 1.0;
    private var min:Number = 0.0;
    private var label:Label;
 
    public function Slider(min:Number = 0.0, max:Number = 1.0)
    {
        this.min = min;
        this.max = max;
 
        label = new Label(this, 220, -10, value.toFixed(1));// ****** スライダー幅に応じる
        label.scaleX = label.scaleY = 1.3;
 
        var line:Sprite = new Sprite();
        line.graphics.lineStyle(2.0, 0x656565);
        line.graphics.beginFill(0x3B3B3A);
        line.graphics.drawRoundRect(-2, 0, 200, 5, 5, 5);
        line.graphics.endFill();
        addChild(line);
 
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(12, 15, 90 * Math.PI / 180, -6, -5);
 
        bar = new Sprite();
        bar.graphics.lineStyle(1.0, 0xE0E0E0);
        bar.graphics.beginGradientFill("linear", [0x999999, 0x444444], [1.0, 1.0], [0, 255], matrix);
        bar.graphics.moveTo( -6, -4);
        bar.graphics.lineTo( 6, -4);
        bar.graphics.lineTo( 6, 4);
        bar.graphics.lineTo( 0, 11);
        bar.graphics.lineTo(-6, 4);
        bar.graphics.endFill();
        addChild(bar);
 
        bar.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
 
    private function onMouseDown(event:MouseEvent):void
    {
        bar.startDrag(false, new Rectangle(0, 0, 100*2, 0));// ****** スライダー幅に応じる
        var stop:Function = function():void { bar.stopDrag(); removeEventListener(Event.ENTER_FRAME, onEnterFrame); };
        stage.addEventListener(Event.MOUSE_LEAVE, stop);
        stage.addEventListener(MouseEvent.MOUSE_UP, stop);
 
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
 
    private function onEnterFrame(event:Event):void
    {
        this.value = this.min + bar.x / this.x * (this.max - this.min);
        this.dispatchEvent(new Event(Event.CHANGE));
 
        this.label.text = this.value.toFixed(1);
    }
}
