/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7JsY
 */

// forked from majoraze's flash on 2010-11-22
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.utils.setInterval;
    import flash.utils.clearInterval;
    
    public class Boundaries extends Sprite {
        private var count:int = 400;
        private var gravity:Number = .5;
        private var balls:Array;
        private var numIntervalInit:Number = 0;
        private var numTimeInterval:Number = 5;
        
        
        public function Boundaries() {
            init();
        }
        
        private function init():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            balls = [];
     
            numIntervalInit = setInterval(addBall, numTimeInterval);   
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function addBall():void {
            clearInterval(numIntervalInit);
            
            if (count == balls.length - 1) {
                //finish populating the array
                return;
            }
            
            var ball:Ball = new Ball(2, Math.random() * 0xffffff);
            ball.x = stage.stageWidth/2;
            ball.y = stage.stageHeight;
            ball.vx = Math.random() * 4 - 2;
            ball.vy = Math.random() * -10 - 10;
            addChild(ball);
            balls.push(ball);
            
            numIntervalInit = setInterval(addBall, numTimeInterval);
        }

        
        private function onEnterFrame(e:Event):void {
            for (var i:int = 0; i < balls.length; i++){
                var ball:Ball = balls[i] as Ball;
                ball.x += ball.vx;
                ball.y += ball.vy;
                ball.vy += gravity;
                if (ball.x - ball.radius > stage.stageWidth ||
                    ball.x + ball.radius < 0 ||
                    ball.y - ball.radius > stage.stageHeight ||
                    ball.y + ball.radius < 0) {
                        ball.x = stage.stageWidth/2;
                        ball.y = stage.stageHeight;
                        ball.vx = Math.random() * 4 - 2;
                        ball.vy = Math.random() * -10 - 10;
                }
            }
        }
    }
}




//ball class

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;    
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}
