/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6gDy
 */

// forked from coppieee's パーティクル崩し
//コードはめっちゃ汚いよ！
//ブロックの数465*100
//がんばってクリアしてください
package 
{
    import flash.geom.Point;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import net.hires.debug.Stats;
    
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = 0x000000)]
    public class BlockBreaker extends Sprite 
    {
        private const backURL:String = "http://chibitami.net/works/flash/sweeper/img/main4.png";
        private const clothesURL:String = "http://chibitami.net/works/flash/sweeper/img/main1.png";
        
        private static const HEIGHT:Number = 465;
        private static const WIDTH:Number = 465;
        private var _canvas:BitmapData;
        private var _blocks:Blocks;
        private var _fallBlocks:Vector.<Particle>;
        private var _balls:Vector.<Particle>;
        private var _bar:Bitmap;
        
        private var _isclear:Boolean = false;
        
        public function BlockBreaker()
        {
            var background:Bitmap;
            loadImage(backURL, function(bd:BitmapData):void
            {
                background = new Bitmap(bd);
                loadComplete();
            });
            loadImage(clothesURL, function(bd:BitmapData):void
            {
                var clothesData:BitmapData = new BitmapData(WIDTH,HEIGHT,true,0x00000000);
                clothesData.copyPixels(bd,bd.rect,new Point(0,0));
                _blocks = Blocks.createFromBitmapData(clothesData);
                loadComplete();
            });
            
            _canvas = new BitmapData(WIDTH, HEIGHT,true,0x00000000);
            addChild(new Bitmap(_canvas));
            
            //_blocks = new Blocks(WIDTH, 100);
            
            _fallBlocks = new Vector.<Particle>();
            
            var loadCount:Number = 2;
            function loadComplete():void
            {
                loadCount--;
                if(loadCount > 0)return;
                
                addChildAt(background, 0);
                gameStart();
            }
            
        }
        private function gameStart():void
        {
            var b:BitmapData = new BitmapData(50, 10, false, 0x00FF00);
            addChild(_bar = new Bitmap(b));
            _bar.y = HEIGHT -50;
            var _ball:Particle = new Particle(WIDTH / 2, HEIGHT - 50);
            _ball.vx = Math.random() *10;
            _ball.vy = -Math.random() *9 -1;
            _ball.color = 0xFFFFFF;
            
            _balls = new Vector.<Particle>();
            _balls.push(_ball);
            
            //var stats:Stats = new Stats();
            //stats.y = 200;
            //addChild(stats);
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function loadImage(url:String, callback:Function):void
        {
            var loader:Loader = new Loader();
            var req:URLRequest = new URLRequest(url);
            loader.load(req, new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.INIT, function(e:Event):void
            {
                var l:Loader = new Loader();
                l.loadBytes(loader.contentLoaderInfo.bytes);
                l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
                {
                    var result:BitmapData = new BitmapData(l.width, l.height);
                    result.draw(l);
                    callback(result);
                });
            });
        }
        private function update(e:Event):void
        {
            _canvas.lock();
            var ctrans:ColorTransform = new ColorTransform();
            ctrans.alphaOffset = -255/20;
            _canvas.colorTransform(_canvas.rect, ctrans);
            
            for each(var block:Particle in _blocks.values)
            {
                if (block)
                {
                    _canvas.setPixel32(block.x, block.y, block.color|0xFF000000);
                }
            }
            var removeBalls:Vector.<Particle> = new Vector.<Particle>();
             for each(var ball:Particle in _balls)
             {
                var bvx:Number = ball.vx;
                var bvy:Number = ball.vy;
                var bspeed:Number = Math.sqrt(bvx * bvx + bvy * bvy);
                var bradius:Number = Math.atan2(bvy, bvx);
                for (var i:int = 0; i < bspeed;i++)
                {
                    ball.x += ball.vx/bspeed;
                    ball.y += ball.vy/bspeed;
                    var hitParticle:Particle = _blocks.getParticle(ball.x, ball.y);
                    if(hitParticle)
                    {
                        var removedP:Particle = _blocks.removeParticle(ball.x, ball.y);
                        removedP.vx = Math.cos(bradius+Math.PI*2/(30*Math.random())-15)*3;
                        removedP.vy = 1;
                        removedP.color = hitParticle.color;
                        _fallBlocks.push(removedP);
                        ball.vy = -ball.vy;
                    }
                    
                    if ((ball.x < 0 && ball.vx < 0) || (ball.x > WIDTH && ball.vx > 0))
                    {
                        ball.vx = -ball.vx;
                    }
                    if (ball.y < 0 && ball.vy < 0)
                    {
                        ball.vy = -ball.vy;
                    }
                    if (ball.y > HEIGHT)
                    {
                        removeBalls.push(ball);
                    }
                    if (!_isclear && _bar.hitTestPoint(ball.x, ball.y))
                    {
                        ball.vy = -Math.abs(ball.vy);
                    }
                    _canvas.setPixel32(ball.x, ball.y, ball.color|0xFF000000);
                }
            }
            removeBalls.forEach(function(b:Particle, ...args):void {
                var index:int = _balls.indexOf(b);
                if (index != -1)
                {
                    _balls.splice(index, 1);
                }
            });
            
            var removeFallBs:Vector.<Particle> = new Vector.<Particle>();
            _fallBlocks.forEach(function(fallP:Particle, ...args):void {
                fallP.vy += 0.1;
                fallP.x += fallP.vx;
                fallP.y += fallP.vy;
                _canvas.setPixel32(fallP.x, fallP.y, fallP.color|0xFF000000);
                if (_bar.hitTestPoint(fallP.x,fallP.y))
                {
                    var newball:Particle = new Particle(fallP.x,fallP.y);
                    newball.vx = Math.random() * 10;
                    newball.vy = Math.random() * 9 + 1;
                    newball.color = fallP.color;
                    _balls.push(newball);
                    removeFallBs.push(fallP);
                }else if (fallP.y > HEIGHT)
                {
                    removeFallBs.push(fallP);
                }
            });
            
            removeFallBs.forEach(function(b:Particle,...args):void{
                var index:int = _fallBlocks.indexOf(b);
                if (index != -1)
                {
                    _fallBlocks.splice(index, 1);
                }
            });
            _bar.x = stage.mouseX;
            _canvas.unlock();
            
            if (_blocks.count == 0)
            {
                //removeEventListener(Event.ENTER_FRAME, update);
                var clearTF:TextField = new TextField();
                clearTF.text = "CLEAR!";
                _isclear = true;
                clearTF.textColor = 0xFFFFFF;
                clearTF.autoSize = TextFieldAutoSize.LEFT;
                _canvas.draw(clearTF,new Matrix(5,0,0,5,WIDTH/2-clearTF.width*5/2,HEIGHT-clearTF.height*5/2));
            }
            
        }
    }
}
import flash.display.BitmapData;
import frocessing.color.ColorHSV;
class Blocks
{
    public function get count():int { return _count;}
    private var _count:int;
    public function get width():Number { return _width; }
    private var _width:Number;
    public function get height():Number { return _height; }
    private var _height:Number;
    public var values:Vector.<Particle>;
    function Blocks(width:Number,height:Number)
    {
        _width = width;
        _height = height;
        _count = width * height;
        values = new Vector.<Particle>(width * height, false);
        var c:ColorHSV = new ColorHSV();
        for (var i:int = 0; i < _width; i++)
        {
            c.h = 360 * i / _width;
            for (var j:int = 0 ; j < _height; j++ )
            {
                var p:Particle = new Particle(i, j);
                p.color = c.value|0xFF000000;
                values[i + j * _width] = p;
            }
        }
    }
    public static function createFromBitmapData(data:BitmapData):Blocks
    {
        var w:Number = data.width;
        var h:Number = data.height;
        var result:Blocks = new Blocks(w,h);
        for(var i:int = 0; i < w; i++)
        {
            for(var j:int = 0; j < h; j++)
            {
                var color:uint = data.getPixel32(i,j);
                if(color == 0)
                {
                    result.removeParticle(i,j);
                }
                else
                {
                    result.values[i + j * w].color = color|0xFF000000;
                }
            }
        }
        return result;
    }
    public function getParticle(x:int, y:int):Particle
    {
        var index:int = x + y * _width;
        if (index >= values.length || index < 0)
        {
            return null;
        }
        return values[x + y * _width];
    }
    public function removeParticle(x:int, y:int):Particle
    {
        var p:Particle = values[x + y * _width];
        if (p)
        {
            _count--;
            values[x + y * _width] = undefined;
        }
        return p;
    }
}
class Particle
{
    public var x:Number;
    public var y:Number;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var color:uint;
    public function Particle(x:Number=0,y:Number=0 )
    {
        this.x = x;
        this.y = y;
    }
}