/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6cx8
 */

// forked from h_kamizono's test_case2
package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.Font;
    import flash.display.CapsStyle;
    import flash.display.StageDisplayState;
    
    public class FlashTest extends MovieClip {
        
        public const TOTTE:Number = 0;
        public const OMORI:Number = 1;
        public const OMORI2:Number = 2;
        
        public const acc:Number = 10;
        
           
        public var pt:Array = new Array();
        public var hammerAlpha:Number = 0;
            
        public var preMouse:Point;
        public var curMouse:Point;
            
        public var cirNum:Number = 2;
        public var loc:Array = new Array();
        public var isPressed:Boolean = false;
        public function FlashTest() {
            
            for (var i:Number = 0; i < cirNum; ++i) {
                pt[i] = new PhysicalPoint(); 
            }
 
            stage.addEventListener(MouseEvent.MOUSE_DOWN,
                                   function(ev:MouseEvent) :void {isPressed = true;});

            curMouse = new Point(mouseX, mouseY);
            cerateFullScreenBtn();
            var timer:Timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);                       
            timer.start();
        }
        
        
        public function loop(event:TimerEvent) :void {
            preMouse = curMouse;
            curMouse = new Point(mouseX, mouseY);
            
            if (preMouse.x != curMouse.x || 
                preMouse.y != curMouse.y) {
                
                pt[TOTTE].x += (curMouse.x - pt[TOTTE].x)/4;
                pt[TOTTE].y += (curMouse.y - pt[TOTTE].y)/4;
                var w:Number = 5;
                for (var i:Number = 0; i < pt.length-1; ++i) {
                    //var w:Number = (Math.random()*100)%10+1;
                    
                    pt[i+1].setAcceleration((pt[i].x - pt[i+1].x)*w,
                                      (pt[i].y - pt[i+1].y)*w);
                }

            } else {
                
                pt[OMORI].setAcceleration((pt[TOTTE].x - pt[OMORI].x)*2,
                                      (pt[TOTTE].y - pt[OMORI].y)*2);
                pt[TOTTE].setAccelerationsetAccelerationsetAccelerationsetAcceleration((-pt[TOTTE].x + pt[OMORI].x)*10,
                                      (-pt[TOTTE].y + pt[OMORI].y)*10);
                //                
            }
            
            for (i = 0; i < pt.length; ++i) {
                if (pt[i].x < 0) {
                    pt[i].setAcceleration(acc, 0);
                }
                if (pt[i].y < 0) {
                    pt[i].setAcceleration(0, acc);
                }
                if (pt[i].x > stage.stageWidth) {
                    pt[i].setAcceleration(-acc, 0);
                }
                if (pt[i].y > stage.stageHeight) {
                    pt[i].setAcceleration(0, -acc);
                }
            }
            hammerAlpha = Math.min(1, hammerAlpha+0.1);
            
            this.graphics.clear();
            this.graphics.lineStyle(3, 0xCCCCCC, hammerAlpha);
            this.graphics.beginFill(0x00FF0000, hammerAlpha);
            this.graphics.drawCircle(pt[TOTTE].x, pt[TOTTE].y, 8);
            this.graphics.endFill();
            for (i = 1; i < cirNum; ++i) {
                this.graphics.beginFill(0x88888888, hammerAlpha);
                this.graphics.drawCircle(pt[i].x, pt[i].y, 30);
                this.graphics.endFill();
            }
        }
        
        private function btn_clickHandler(event:MouseEvent):void {
            stage.displayState = stage.displayState == StageDisplayState.FULL_SCREEN
                ? StageDisplayState.NORMAL
                : stage.displayState = StageDisplayState.FULL_SCREEN;
        }
        private function cerateFullScreenBtn():void {
            var btn:Sprite = new Sprite();
            btn.buttonMode = true;
            btn.graphics.beginFill(0x808080, 0);
            btn.graphics.drawRect(0, 0, 60, 40);
            btn.graphics.endFill();
            btn.graphics.beginFill(0x808080, 0.5);
            btn.graphics.drawRect(6, 6, 49, 29);
            btn.graphics.endFill();
            btn.graphics.lineStyle(1, 0x808080, 0.5);
            btn.graphics.drawRect(0.5, 0.5, 60, 40);
            btn.x = 5;
            btn.y = 5;
            btn.addEventListener(MouseEvent.CLICK, btn_clickHandler);
            addChild(btn);
        }
    }
}

import flash.geom.Point;
import flash.events.TimerEvent;
import flash.utils.Timer;

import flash.display.Sprite;
import flash.display.MovieClip;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.ui.Mouse;

class Functions {
    public static function hsbToRgb(h:Number,
                                    s:Number,
                                    b:Number) :uint {
        while (h < 0) {
            h+=360;
        }
        while (h >= 360) {
            h -= 360;
        }
        var h2:Number = Math.floor(h/60);
        var f:Number = h/60 - h2;
        var parFull:Number = 255;
        var parEmp:Number = 0;
        var parZoka:Number = 255*f;
        var parGensho:Number = 255*(1-f);
        var red:Number = 0;
        var green:Number = 0;
        var blue:Number = 0;
        
        switch (h2) {
          case 0:
            red = parFull; green = parZoka; blue = parEmp;
            break;
          case 1:
            red = parGensho; green = parFull; blue = parEmp;
            break;
          case 2:
            red = parEmp; green = parFull; blue = parZoka;
            break;
          case 3:
            red = parEmp; green = parGensho; blue = parFull;
            break;
          case 4:
            red = parZoka; green = parEmp; blue = parFull;
            break;
          case 5:
            red = parFull; green = parEmp; blue = parGensho;
            break;
        }
        var max:Number = Math.max(Math.max(red, green), blue);
        red = max - (max - red)*s;
        green = max - (max - green)*s;
        blue = max - (max - blue)*s;
        red *= b; green *= b; blue *= b;
        var ret:uint = int(red) << 16 | int(green) << 8 | int(blue);
        return ret; 
    }
    
    //public static function rgbToHsb(rgb:uint) :Array {
        
    //}
    
}


class PhysicalPoint extends Point {
    public var vx:Number, vy:Number;
    public var ax:Number, ay:Number;
    public var b:Number;
    public var sakkiTime:Number;
    public var timer:Timer;
    
    public var preX:Number, preY:Number;
    
    public var kb:Number;
    public var angle:Number;
    public var preAngle:Number;
    public var kakusokudo:Number;
    public var kakukasokudo:Number;
    
    public var limitter:Number = 0.3;
    
    function PhysicalPoint(xx: Number = 0, yy:Number = 0, an:Number = 0) {
        x = xx; y = yy;
        preX = xx; preY = yy;
        b = 0.9;
        vx = 0; vy = 0;
        ax = 0; ay = 0;
        
        angle = an;
        preAngle = an;
        kb = 0.9;
        kakusokudo = 0;
        kakukasokudo = 0;
        
        sakkiTime = new Date().getTime();
        timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
        
    }
    
    public function loop(event:TimerEvent) :void {
        var nowTime:Number = new Date().getTime();
        var t:Number = (nowTime - sakkiTime)/1000;
        
        if (t > limitter) t = limitter;
        
        preX = x;
        preY = y;
        
        x += vx*t + 0.5*ax*t*t;
        y += vy*t + 0.5*ay*t*t;
        
        vx += ax*t; vy += ay*t;
        vx *= b;    vy *= b;
        ax = 0;     ay = 0;
        preAngle = angle;
        angle += kakusokudo * t + 0.5*kakukasokudo*t*t;
        kakusokudo += kakusokudo*t;
        
        kakusokudo *= kb;
        kakukasokudo = 0;
        sakkiTime = nowTime;
    }
    
    public function setAcceleration(aax:Number = 0, aay:Number = 0) :void {
        ax += aax;
        ay += aay;
    }
    
    public function setKasokudoByPolar(r:Number=0, dire:Number = 0) :void {
        ax += r*Math.cos(dire);
        ay += r*Math.sin(dire);
    }
    
    public function setKakuKasokudo(aan:Number = 0) :void {
        kakukasokudo += aan;
    }
    
    public function setKakuKasokudo2(dire:Number, val:Number) :void {
        var aan:Number = val * Math.sin(dire - angle);
        setKakuKasokudo(aan);
    }

}
