/**
 * Copyright atsu ( http://wonderfl.net/user/atsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6CXi
 */

package  
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    
    import org.papervision3d.view.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.cameras.*;
    
    import caurina.transitions.*;
    import caurina.transitions.properties.*;
    
    /**
     * ...
     * @author atsu
     */
    [SWF(backgroundColor = "#FFFFFF", frameRate = "60")]
    public class Main100629 extends BasicView
    {
        //private var _this;
        private const PLANES_NUMBER:int = 60;
        private var planesArray:Array = new Array();
        private var planesParent:DisplayObject3D;
        public function Main100629()
        {
            addEventListener(Event.ADDED_TO_STAGE, ats);
        }
        
        private function ats(e:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, ats);
            init();
            stage.quality = StageQuality.MEDIUM;
        }
        
        private function init():void
        {
            planesParent = new DisplayObject3D();
            scene.addChild(planesParent);
            //var material:ColorMaterial = new ColorMaterial(0xFFFFFF);
            //material.doubleSided = true;
            for (var i:int = 0; i < PLANES_NUMBER; i++) {
                var material:ColorMaterial = new ColorMaterial(0xFFFFFF*Math.random());
                material.doubleSided=true;
                var plane:Plane = new Plane(material, 15, 15);
                plane.useOwnContainer = true;
                plane.x = Math.sin(36 * i * Math.PI / 180) * 100;
                plane.z = Math.cos(36 * i * Math.PI / 180) * 100;
                plane.y = -150 + 5 * i;
                var lookAtDO3D:DisplayObject3D = new DisplayObject3D();
                lookAtDO3D.y = plane.y;
                plane.lookAt(lookAtDO3D);
                planesParent.addChild(plane);
                planesArray.push(plane);
            }
            camera.focus = 20;
            camera.z = -camera.zoom * camera.focus;
            trace(camera.z);
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void
        {
            planesParent.rotationY += 1;
            var targetDO3D:DisplayObject3D = new DisplayObject3D();
            for (var i:int; i < PLANES_NUMBER; i++) {
                var plane:Plane = planesArray[i] as Plane;
                targetDO3D.x = plane.sceneX;
                targetDO3D.y = plane.sceneY;
                targetDO3D.z = plane.sceneZ;
                var dis:Number = camera.distanceTo(targetDO3D);
                var blur:Number = (dis / 100 - 7) * 4;
                plane.filters = [new BlurFilter(blur, blur)];
            }
            targetDO3D = null;
        }
        
    }

}