/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/63QQ
 */

// forked from kotobuki's Japanino Test

// 
// 大人の科学マガジンVol.27
// http://otonanokagaku.net/magazine/vol27/
// 
// wonderfl x japanino
// http://wonderfl.net/event/japanino/
// 
// 注意：光残像キットは、あまり激しく操作すると壊れてしまうことが
// ありますので注意してください。

package {
    import com.bit101.components.*;

    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.media.*;
    import flash.net.*;

    import funnel.*;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#000000")]

    public class AdultyScience extends Sprite {
        // 制限時間
        private static const TIME_LIMIT:int = 100;

        // Japanino
        private var _japanino:Arduino;

        // カウントを表示するためのテキストフィールド
        private var _countLabel:Label;
        // カウントを表示するためのテキストフィールド
        private var _countRatioLabel:Label;

        // 残りの時間を表示するためのテキストフィールド
        private var _remainingTimeLabel:Label;

        // 光残像キットのハンドルを回転させた回数
        private var _count:int = 0;
        // 前回のカウント
        private var _past_count:int = 0;
        // 擬似回転率
        private var _count_ratio:int = 0;

        // カウントダウン用のタイマ
        private var _countdownTimer:Timer;
        // Youtubeの動画を読み込むためのインスタンス
        private var _ytbLoader:YouTubeLoader;
        
        // Text to SpeechのためのRequest
        private var _req:URLRequest;
        // url
        private var _url:String = "http://transrate.google.com/transrate_tts?tl=en&q=" + encodeURI("Go for it!!");
        // voice
        private var _voice:Sound;

        public function AdultyScience() {
            // Japaninoのインスタンスを生成
            _japanino = new Arduino(Arduino.FIRMATA);

            // カウントを表示するためのテキストフィールドを生成
            _countLabel = new Label(this, 100, 200);
            _countLabel.text = "Waiting...";
            _countLabel.scaleX = 2;
            _countLabel.scaleY = 2;
            addChild(_countLabel);
            
            // カウントを表示するためのテキストフィールドを生成
            _countRatioLabel = new Label(this, 100, 300);
            _countRatioLabel.text = "Ratio:";
            _countRatioLabel.scaleX = 2;
            _countRatioLabel.scaleY = 2;
            addChild(_countRatioLabel);

            // 残り時間を表示するためのテキストフィールドを生成
            _remainingTimeLabel = new Label(this, 100, 160);
            _remainingTimeLabel.scaleX = 2;
            _remainingTimeLabel.scaleY = 2;
            addChild(_remainingTimeLabel);

            // Japaninoの準備が完了した時に発生するイベントに対するイベントリスナをセット
            _japanino.addEventListener(FunnelEvent.READY, onReady);
            //動画読み込み
            _ytbLoader = new YouTubeLoader("635WJcPK9JM");
			
			
        }

        // Japaninoの準備ができると呼ばれる
        private function onReady(event:FunnelEvent):void {
            // Japaninoの準備ができたら、10秒間をカウントダウンするタイマを生成してスタート
            // タイムアウトが発生した時にonTimeoutを呼び出す
            _countdownTimer = new Timer(1000, TIME_LIMIT);
            _countdownTimer.addEventListener(TimerEvent.TIMER, onTick);
            _countdownTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
            _countdownTimer.start();

            
            // P.O.V pattern
            var pattern:Array = [
                parseInt("1111111", 2),
                parseInt("0100000", 2),
                parseInt("0011000", 2),
                parseInt("0100000", 2),
                parseInt("1111111", 2),
                parseInt("0000000", 2),
                parseInt("1010000", 2),
                parseInt("0100000", 2),
                parseInt("1010000", 2),
                parseInt("0000000", 2),
                parseInt("0000001", 2),
                parseInt("1000001", 2),
                parseInt("1000001", 2),
                parseInt("0111111", 2),
                parseInt("0000001", 2),];

            // パターンをカスタムのメッセージとしてJapaninoに転送する
            _japanino.sendSysexMessage(0x10, pattern);

            // JapaninoのFIRMATA_STRINGイベントに対するイベントリスナをセット
            _japanino.addEventListener(FunnelEvent.FIRMATA_STRING, onMessage);

            _countLabel.text = "Spin the handle!";
            
            //set movie
            _ytbLoader.runAway();
            addChild(_ytbLoader);
        }

        // Japaninoからメッセージを受信すると呼ばれる
        private function onMessage(event:FunnelEvent):void {
            // メッセージが"!"でかつ残り時間があれば
            if (event.message == "!") {
                // カウントを増やしてテキストフィールドの表示を更新
                _count++;
                
                _countLabel.text = "Count: " + _count;
                
                // P.O.V pattern
	            var pattern:Array = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0001110", 2),
	                parseInt("0011111", 2),
	                parseInt("0111111", 2),
	                parseInt("1111110", 2),
	                parseInt("0111111", 2),
	                parseInt("0011111", 2),
	                parseInt("0001110", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000111", 2),
	                parseInt("0001111", 2),
	                parseInt("0011111", 2),
	                parseInt("0111111", 2),
	                parseInt("0011111", 2),
	                parseInt("0001111", 2),
	                parseInt("0000111", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000011", 2),
	                parseInt("1000111", 2),
	                parseInt("1001111", 2),
	                parseInt("0011111", 2),
	                parseInt("1001111", 2),
	                parseInt("1000111", 2),
	                parseInt("0000011", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("1000001", 2),
	                parseInt("1100011", 2),
	                parseInt("1100111", 2),
	                parseInt("1001111", 2),
	                parseInt("1100111", 2),
	                parseInt("1100011", 2),
	                parseInt("1000001", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("1100000", 2),
	                parseInt("1110001", 2),
	                parseInt("1110011", 2),
	                parseInt("1100111", 2),
	                parseInt("1110011", 2),
	                parseInt("1110001", 2),
	                parseInt("1100000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("1110000", 2),
	                parseInt("1111000", 2),
	                parseInt("1111001", 2),
	                parseInt("1110011", 2),
	                parseInt("1111001", 2),
	                parseInt("1111000", 2),
	                parseInt("1110000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0111000", 2),
	                parseInt("1111100", 2),
	                parseInt("1111100", 2),
	                parseInt("1111001", 2),
	                parseInt("1111100", 2),
	                parseInt("1111100", 2),
	                parseInt("0111000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0011100", 2),
	                parseInt("0111110", 2),
	                parseInt("1111110", 2),
	                parseInt("1111100", 2),
	                parseInt("1111110", 2),
	                parseInt("0111110", 2),
	                parseInt("0011100", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0011100", 2),
	                parseInt("0111110", 2),
	                parseInt("1111110", 2),
	                parseInt("1111100", 2),
	                parseInt("1111110", 2),
	                parseInt("0111110", 2),
	                parseInt("0011100", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
	            
	            pattern = [
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0001110", 2),
	                parseInt("0011111", 2),
	                parseInt("0111111", 2),
	                parseInt("1111110", 2),
	                parseInt("0111111", 2),
	                parseInt("0011111", 2),
	                parseInt("0001110", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),
	                parseInt("0000000", 2),];
		
	            // パターンをカスタムのメッセージとしてJapaninoに転送する
	            _japanino.sendSysexMessage(0x10, pattern);
            }
            
            _ytbLoader.fadeOut();
        }

        // カウントダウン用のタイマでイベントが発生すると呼ばれる
        private function onTick(e:TimerEvent):void {
            _count_ratio = _count - _past_count;
            
            _ytbLoader.alpha = _count_ratio / 10;
            
            _countRatioLabel.text = "Ratio: " + _count_ratio;
            
            _past_count = _count;//カウント保存。
            
            _req = new URLRequest(_url);
            _voice = new Sound(_req);
            _voice.play();
        }

        private function onTimeout(e:TimerEvent):void {
            // Japaninoからのイベントを受取らないようにリスナを削除
            _japanino.removeEventListener(FunnelEvent.FIRMATA_STRING, onMessage);

            // 転送するパターン（OVERのつもりです）を用意する（15桁x7行）
            // ここでは二進数で記述しているがそれ以外の方法でも構わない
            var pattern:Array = [
                parseInt("0000000", 2),
                parseInt("1111111", 2),
                parseInt("0001001", 2),
                parseInt("0011001", 2),
                parseInt("0010110", 2),
                parseInt("0100000", 2),
                parseInt("0000000", 2),
                parseInt("1111011", 2),
                parseInt("0000000", 2),
                parseInt("0011100", 2),
                parseInt("0100010", 2),
                parseInt("1000001", 2),
                parseInt("0100010", 2),
                parseInt("0011100", 2),
                parseInt("0000000", 2),];

            // パターンをカスタムのメッセージとしてJapaninoに転送する
            _japanino.sendSysexMessage(0x10, pattern);

            
        }
    }
}



import flash.display.DisplayObject;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.display.MovieClip;
import flash.events.Event;
import flash.net.URLRequest;
import flash.system.Security;
	
/**
 * 
 */
class YouTubeLoader extends MovieClip
{
	private var _youtubePlayer:Object;
	private var _mid:String;
	
	public function YouTubeLoader(movie_id:String)
	{
		_mid = movie_id;
		Security.allowDomain("www.youtube.com");
		
		var loader:Loader = new Loader();
		loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
		loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
	}
	private function initHandler(event:Event):void
	{
		_youtubePlayer = Loader(LoaderInfo(event.currentTarget).loader).content as Object;
		addChild(_youtubePlayer as DisplayObject);
		_youtubePlayer.addEventListener("onReady", onReadyHandler);
		_youtubePlayer.addEventListener("onError", onErrorHandler);
		_youtubePlayer.addEventListener("onStateChange", onStateChangeHandler);
		_youtubePlayer.addEventListener("onPlaybackQualityChange", onPlaybackQualityChangeHandler);
	}
	
	private function onReadyHandler(event:Event):void
	{
		trace("ready", Object(event).data);
		_youtubePlayer.setSize(465, 348);
		
		// キューする（スタートボタンが画面中央に表示したまま停止）
		//_youtubePlayer.cueVideoById("6hzrDeceEKc");
		
		// すぐさまロードして自動再生
		_youtubePlayer.loadVideoById(_mid);
		
	}
	private function onErrorHandler(event:Event):void
	{
		// error 150 となる場合は、指定した映像が「埋め込み拒否」されている。（どうしようもない）
		trace("error", Object(event).data);
	}
	private function onStateChangeHandler(event:Event):void
	{
		trace("state", Object(event).data);
	}
	private function onPlaybackQualityChangeHandler(event:Event):void
	{
		// クオリティを変更した場合
		trace("quality", Object(event).data);
	}
	
	public function fadeIn():void {
		this.alpha += 0.05;
	}
	
	public function fadeOut():void {
		this.alpha -= 0.05;
	}
	
	public function runAway():void {
		this.alpha = 0;
	}
	
	public function comeOn():void {
		this.alpha = 1;
	}
}
