/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5zQb
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.display.GradientType;
    import flash.geom.Matrix;
    import flash.display.SpreadMethod;
    import flash.display.InterpolationMethod;
    
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private var stars:/*MoveStar*/Array;
        private var _starImg:Star;
        
        private var _canvas:BitmapData;
        
        private var _step:int = 0;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var mat:Matrix = new Matrix();
            mat.createGradientBox( stage.stageWidth, stage.stageHeight, 45 );
            graphics.beginFill( 0 );

            graphics.beginGradientFill(
                GradientType.LINEAR,
                [0x000022, 0x000077],
                [1, 1],
                [0, 255],
                mat,
                SpreadMethod.PAD,
                InterpolationMethod.LINEAR_RGB,
                0.0 );        
            graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
            graphics.endFill();
            
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0 );
            addChild( new Bitmap( _canvas ) );
            
            _starImg = new Star();
            
            
            stars = new Array();
            
            addEventListener( Event.ENTER_FRAME, Update );
        }
        
        private function Update(e:Event) : void
        {
            var i:int = 0;
            
            if( _step % 3 == 0 )    GenerateMoveStar();
            _step++;
            
            for ( i = stars.length - 1; i >= 0; i-- )
            {
                stars[i].Update();
                
                if ( stars[i].x < -stage.stageWidth/2 || stars[i].y > stage.stageHeight + stage.stageHeight/2 )
                {
                    stars.splice( i, 1 );
                }
            }
            
            _canvas.lock();
            //_canvas.fillRect( _canvas.rect, 0 );
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), new BlurFilter(4, 4, 10) );
            for ( i = 0; i < stars.length; i++ )
            {
                _canvas.draw( _starImg, stars[i].mat, stars[i].color, "add" );
            }
            _canvas.unlock();
        }
        
        private function GenerateMoveStar() : void
        {
            var p1:Point = new Point( stage.stageWidth / 2, - stage.stageHeight / 2 );
            var p2:Point = new Point( stage.stageWidth + stage.stageWidth / 2, stage.stageHeight / 2 );
            var ratio:Number = Math.random();
            
            var xx:Number = p1.x + (p2.x - p1.x) * ratio;
            var yy:Number = p1.y + (p2.y - p1.y) * ratio;
            
            var star:MoveStar = new MoveStar();
            var angle:Number = 135;
            var scale:Number = 1 - (Math.random() * 0.7);
            star.Init( xx, yy, angle, scale );
            
            var starnum:int = stars.length;
            var i:int = 0;
            for ( i = 0; i < starnum; i++ )
            {
                if ( stars[i].scale >= scale )    break;
            }
            stars.splice( i, 0, star );
        }
    }
    
}
import flash.display.Shape;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import frocessing.color.ColorHSV;

class Star extends Shape {
    
    public function Star () {
        
        x = 100;
        y = 100;
        
        //    星を描く
        graphics.beginFill(0xFFFFFF);
        for ( var i:int = 0; i < 10; i++ )
        {
            var radius:Number = 50;
            var angle:Number = (90 + i * (360 / 10)) % 360;
            if ( i % 2 == 0 )    radius = 25;
            var xx:Number = Math.cos( angle * Math.PI / 180 ) * radius;
            var yy:Number = Math.sin( angle * Math.PI / 180 ) * radius;
            if ( i == 0 )    graphics.moveTo( xx, yy );
            else             graphics.lineTo( xx, yy );
        }
        graphics.endFill();
    }
}


class MoveStar {
    
    private var _x:Number;
    public    function get x():Number { return    _x;    }
    private var _y:Number;
    public    function get y():Number { return    _y;    }
    private var _mx:Number;
    private var _my:Number;
    
    private var _scale:Number;
    public    function    get scale():Number { return    _scale;    }
    
    private var _mat:Matrix;
    public    function    get mat():Matrix { return    _mat;    }
    private var _color:ColorTransform;
    public    function    get color():ColorTransform { return    _color;    }
    
    private var _rotate:int;
    
    public    function    MoveStar() {
        
    }
    
    public    function    Init(__x:Number, __y:Number, __angle:Number, __scale:Number) : void
    {
        _x = __x;
        _y = __y;
        _scale = __scale;
        
        var speed:Number = 30 * _scale * _scale;
        
        var tempAngle:Number = Math.random() * 10 - 5;
        
        _mx = Math.cos( (__angle + tempAngle) * Math.PI / 180 ) * speed;
        _my = Math.sin( (__angle + tempAngle) * Math.PI / 180 ) * speed;
        
        _mat = new Matrix( _scale, 0, 0, _scale, _x, _y );
        
        var hsv:ColorHSV = new ColorHSV( Math.random() * 360, 0.8, 1, 0.5 );
        _color = new ColorTransform( 0, 0, 0, 1, hsv.r, hsv.g, hsv.b, hsv.a ); 
        
        _rotate = 0;
    }
    
    public    function    Update() : void
    {
        _x += _mx;
        _y += _my;
        
        _rotate = (_rotate + 5) % 360;
        
        _mat = new Matrix( _scale, 0, 0, _scale, 0, 0 );
        _mat.rotate( _rotate * Math.PI / 180 );
        _mat.translate( _x, _y );
    }
}
