/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5QiX
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Point;

    [SWF(width="465",height="465")]
    public class Main extends Sprite {
        
        public var mapBMD:BitmapData;
        public var mapBM:Bitmap;
        public var perlinNum:Number=0;

        public function Main() {
            init();
        }
        
        public function init():void {
            mapBMD = new BitmapData(400,300);
            mapBMD = getMap(1,1);
            mapBM = new Bitmap(mapBMD);
            addChild(mapBM);
            mapBM.x = stage.stageWidth/2-mapBM.width/2;
            mapBM.y = stage.stageHeight/2-mapBM.height/2;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function getMap(px:Number,py:Number):BitmapData {
            
            var bmd:BitmapData = new BitmapData(400,300);
            var baseX:Number = 400;
            var baseY:Number = 300;
            var numOctaves:uint = 2;
            var ramdomseed:int = 10;
            var stitch:Boolean = true;
            var factalNoize:Boolean = false;
            var channelOption:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE;
            var grayScale:Boolean = false;
            var offsets:Array = [new Point(0,px),new Point(0,py)];
            bmd.perlinNoise(baseX, baseY, numOctaves, ramdomseed, stitch, factalNoize, channelOption, grayScale, offsets);
            return bmd;
            
        }
        
        public function onEnterFrame(e:Event):void {
            perlinNum += 5;
            mapBMD = getMap(perlinNum, perlinNum);
            mapBM.bitmapData = mapBMD;
        }
        

    }


}