/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Rtw
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.getTimer;
	import com.bit101.components.PushButton;
 
	public class Main extends Sprite
	{
		private var start:Boolean = false;	// 再生/停止状態を表す
		private var button:PushButton;		// START/STOPのトグルボタン
		private var reset:PushButton;		// リセットボタン
		private var tf:TextField;			// 時間を表示するためのTextField
		private var sDate:Date;				// 開始時間
		private var cDate:Date;				// ストップした時の時間
 
		public function Main()
		{
			tf = new TextField();
			tf.defaultTextFormat = new TextFormat("_typeWriter", 40, 0x0, true);
			tf.text = "00:00:000";
			tf.autoSize = "left";
			tf.selectable = false;
			addChild(tf);
 
			tf.x = (465 - tf.width) / 2;
			tf.y = (465 - tf.height) / 2;
 
			button = new PushButton(this, 365 / 2, tf.y + 70, "START", buttonHandler);
			reset = new PushButton(this, button.x, button.y + 20, "RESET", resetHandler);
 
			resetHandler();
		}
 
		private function resetHandler(event:Event = null):void
		{
			// 実行中だったらトグルボタンを呼び出す、つまり停止状態にさせる
			if (start) buttonHandler();
 
			// ストップボタンが押されたときに時間を保持する変数に0を入れる
			cDate = new Date();
			cDate.setTime(0);
			tf.text = "00:00:000";
		}
 
		private function buttonHandler(event:Event = null):void
		{
			if (!start) // 停止状態の時に押されたら開始させる
			{
				sDate = new Date();		// 開始時間を取得
				button.label = "STOP";	// ボタンの表示テキストを"STOP"に変える。
				addEventListener(Event.ENTER_FRAME, onEnterFrame);
			}
			else
			{
				// ストップした時に、表示されている時間を保持しておく。
				cDate.setTime(new Date().getTime() - sDate.getTime() + cDate.getTime());
				button.label = "START"; // ボタンの表示テキストを"START"に変える。
				removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			}
 
			start = !start; // falseだったらtrueに, trueだったらfalseに変える。
		}
 
		private function onEnterFrame(event:Event):void
		{
			var date:Date = new Date();
			date.setTime(date.getTime() - sDate.getTime() + cDate.getTime());
 
			var minute:String = date.minutes.toString();
			if (minute.length == 1) minute = "0" + minute;
 
			var second:String = date.seconds.toString();
			if (second.length == 1) second = "0" + second;
 
			var msecond:String = date.milliseconds.toString();
			if (msecond.length == 1) msecond = "00" + msecond;
			if (msecond.length == 2) msecond = "0" + msecond;
 
			tf.text = minute + ":" + second + ":" + msecond; 
		}
	}
}
