/**
 * Copyright nyamogera ( http://wonderfl.net/user/nyamogera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4MEa
 */

// forked from clockmaker's [最適化 Tips] SpriteとMovieClipってそんなに変わるの？
// forked from muta244's [最適化 Tips] 変数名の長さによる処理速度の違い
package {

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;
import flash.system.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 2000;
    
    private var wrap:Sprite;
    
    private function _init():void
    {
        while(wrap.numChildren) wrap.removeChildAt(0);
        
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        System.gc();
        
        var old1:int = System.totalMemory;
        _measure("MovieClip", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var mc:MovieClip = new MovieClip();
                wrap.addChild(mc)
            }
        });
        _debug("(MovieClipのメモリ使用量 : " + int((System.totalMemory - old1)/1000) + "KB");
        
        
        System.gc();
        _debug("")
        

        var old:int = System.totalMemory;
        _measure("Sprite", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var sp:Sprite = new Sprite();
                wrap.addChild(sp)
            }
        });
        _debug("(Spriteのメモリ使用量 : " + int((System.totalMemory - old)/1000) + "KB");
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        wrap = new Sprite
        addChild(wrap)
        
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
