/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Lgn
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import org.papervision3d.cameras.SpringCamera3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.PaperPlane;	
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.core.geom.renderables.Particle;
	import org.papervision3d.core.geom.Particles;

	[SWF(width = "480", height = "480", backgroundColor = "0x000000", frameRate = "60")] 
	public class Practice60 extends Sprite{
		private var scene:Scene3D;
		private var camera:SpringCamera3D;
		private var viewport:Viewport3D;
		private var render:BasicRenderEngine;
		private var rootNode:DisplayObject3D;	
		private var speed:Number = 10;
		private var isDown:Boolean = false;

		public function Practice60() {
			scene = new Scene3D();
			viewport = new Viewport3D(0, 0, true, false);
			addChild(viewport);
			rootNode = new DisplayObject3D();
			scene.addChild(rootNode);
			camera = new SpringCamera3D();
			camera.fov = 120;
			camera.mass = 10, camera.damping = 10, camera.stiffness = 2;
			camera.lookOffset = new Number3D(0, 0, 10);
			camera.positionOffset = new Number3D(0, 30, -70);
			render = new BasicRenderEngine();
			var material:MaterialObject3D = new ColorMaterial(0xff0000, 0.8);
			material.doubleSided = true;
			var s:PaperPlane = new PaperPlane(material, 0.25);
			s.useOwnContainer = true;
			s.filters = [new BlurFilter(2, 2, 2), new GlowFilter(0, 1, 8, 8, 2)];
			camera.target = s;
			rootNode.addChild(s);
			var part:Particles = new Particles("stardust");
			scene.addChild(part);
			var pm:ParticleMaterial = new ParticleMaterial(0xffdd00, 1);
			for (var i:int = 0; i < 20000; i++) {
				var pc:Particle = new Particle(pm, 10*Math.random(), 20000*Math.random()-10000, 20000*Math.random()-10000, 20000*Math.random()-10000);
				part.addParticle(pc);
			}
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function onDown(e:MouseEvent):void {
			isDown = true;
		}
		
		private function onUp(e:MouseEvent):void {
			isDown = false;
		}
		
		private var angle:Number = 0;
		private function update(e:Event):void {
			var ww:Number = stage.width / 3.0;
			var hh:Number = stage.height / 3.0;
			render.renderScene(scene, camera, viewport);
			if (mouseX < ww) {
				camera.target.rotationY -= 1;
			}else if (mouseX > 2 * ww) {
				camera.target.rotationY += 1;
			}
			if (mouseY < hh) {
				angle = Math.max( -90, Math.min(90, angle - 1));
			}else if (mouseY > 2 * hh) {
				angle = Math.max( -90, Math.min(90, angle + 1));
			}else {
				if (angle > 0) angle--;
				if (angle < 0) angle++;
			}
			if (isDown) {
				speed = Math.min(20, speed + (20 - speed) * 0.2);
			}else {
				speed = Math.max(0, speed - 2);
			}
			camera.target.moveForward(speed*Math.cos(angle/180*Math.PI));
			camera.target.moveUp(speed * Math.sin(angle / 180 * Math.PI));
		}
	}
}