/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3mMT
 */

package
{
    import flash.geom.Point;
    import flash.filters.BitmapFilter;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.TimerEvent;
    
    import flash.utils.Timer;
    import flash.utils.getTimer;
    
    public class fps extends Sprite
    {
        private var txt:TextField;
        private var bmd:BitmapData;
        private var prevTime:int;
        private var secondTimer:Timer;
        private var FPS:int;
        private var bg:uint=0x00000F;
        
        private var frames:int=(1000/30);
        
        public function fps()
        {
            //create background
            bmd    =    new BitmapData(465, 465, false, bg);
            addChild(new Bitmap(bmd));
            
            //create timer
            secondTimer    =    new Timer(frames);
            secondTimer.start();
            
            //create textfield
            txt            =    new TextField();
            txt.x          =    465/2.2;
            txt.y          =    465/2.2;
            txt.textColor  =    0xFFFFFF;
            txt.selectable =    false;
            txt.scaleX     =    3;
            txt.scaleY     =    3;
            addChild(txt);
            
            //create frames
            secondTimer.addEventListener(TimerEvent.TIMER, onFrame);
        }
        
        private function onFrame(evt:TimerEvent):void
        {
            FPS         =    1000 / (getTimer() - prevTime);
            prevTime    =    getTimer();
            txt.text    =    FPS.toString();
            
            handler();
        }
        
        private function handler():void
        {
            //create element
            bmd.lock();
            (Math.random()>0.5)? bmd.fillRect(new Rectangle(Math.random()*465, 0, 20, 20), Math.random()*65025) : null;
            
            for (var y:int=this.bmd.height; y>=0; y--)
            {
                for (var x:int=this.bmd.width; x>=0; x--)
                {
                    var p:uint=bmd.getPixel(x, y);
                    var n:uint=bmd.getPixel(x, y+1);
                    
                    if (p != bg)
                    {
                        if (n == bg)
                        {
                            bmd.setPixel(x, y, bg);
                            bmd.setPixel(x, y+1, p);
                        }
                    }
                    
                    if (y>=bmd.height-1) bmd.setPixel(x, y, bg);
                }



            }
            
            bmd.unlock();
        }
    }
}