/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2AYy
 */

package {
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.geom.*;
    import flash.events.Event;
    
    public class Matrix3DdecomposeExample extends MovieClip {
        private var ellipse:Shape = new Shape();

        public function Matrix3DdecomposeExample():void {
            
            ellipse.x = (this.stage.stageWidth / 2);
            ellipse.y = (this.stage.stageHeight - 40);
            ellipse.z = 1;
            ellipse.graphics.beginFill(0xFF0000);
            ellipse.graphics.lineStyle(2);
            ellipse.graphics.drawEllipse(0, 0, 50, 40);
            ellipse.graphics.endFill();
            addChild(ellipse);

            ellipse.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }

        private function enterFrameHandler(e:Event):void {  

            var v3:Vector.<Vector3D> = new Vector.<Vector3D>(3);
            v3 = ellipse.transform.matrix3D.decompose();
            v3[0].incrementBy(new Vector3D(0,0,1));
            v3[2].incrementBy(new Vector3D(0.01,0,0));
            ellipse.transform.matrix3D.recompose(v3);
        }
    }
}
