/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1uCy
 */

/*
他のものからもコピペしている。
Picasaから画像検索をして表示する。
http://wonderfl.net/code/157b76089d7f10f24ecec76ba53237aa997c5dd2
FileLoader(multi0.3)
http://wonderfl.net/code/45f48a224808de498e6a530b4a57267be72d4cc3

*/
package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.filters.DropShadowFilter;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	[SWF(backgroundColor = "#000000")];
	public class Main extends Sprite {
		private var _multiLoader:MultiLoader;
		public function Main() {
			//検索結果のロード
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
			var xmlURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&q=apple%20fruits&imglic=commercial&max-results=20&imgmax=288";
			//crossdomain.xml（クロスドメインポリシーファイル）の位置を指定
			Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");		//*1
			myURLLoader.load(new URLRequest(xmlURL));
		}
		
		private function onCompleteXML(e:Event):void {
			//取得したデータをXML型にする。
			var myXML:XML = new XML(e.currentTarget.data);		//*2
			
			//XMLを解析
			var titleStr:String = myXML.channel.item[0].title;		//*3
			var linkURL:String = myXML.channel.item[0].link;		//*4
			//namespaceを設定
			default xml namespace = new Namespace("http://search.yahoo.com/mrss/");		//*5
			var creditStr:String = myXML.channel.item[0].group.credit;		//*6
			var imgURL:String = myXML.channel.item[0].group.content.@url;		//*7
			
			_multiLoader = new MultiLoader("main");
			var n:int = myXML.channel.item.length();
			for (var i:int = 0; i < n; i++) {
				_multiLoader.add(String(myXML.channel.item[i].group.content.@url),{context:new LoaderContext(true)});
			}
			_multiLoader.addEventListener(MultiLoader.COMPLETE, onCompleteHandler);
			_multiLoader.start();
			
		}
		private function onCompleteHandler(event:Event):void{
			init();
		}
		private var _red:Sample5;
		private var _blue:Sample5;
		private var _bitmapData:BitmapData;
		public function init():void {
			_red = new Sample5(-50,_multiLoader);
			this.addChild(_red);
			_blue = new Sample5(50,_multiLoader);
			this.addChild(_blue);
			
			_bitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
			addChild(new Bitmap(_bitmapData))
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			_red.loop(null);
			_blue.loop(null);
			
			_bitmapData.lock();
			_bitmapData.fillRect(new Rectangle(0,0,stage.stageWidth,stage.stageHeight), 0x000000);
			_bitmapData.draw(_red, null,new ColorTransform(1,0,0,1,0,0,0,0));
			_bitmapData.draw(_blue, null,new ColorTransform(0,1,1,1,0,0,0,0), "add");
			_bitmapData.unlock();
		}
		
	}
}

/**
 * Papervision3Dで被写界深度
 * 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
 */
import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.display.BitmapData;

import org.papervision3d.view.*;
import org.papervision3d.materials.*;
import org.papervision3d.objects.*;
import org.papervision3d.objects.primitives.*
	
	//[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#000000")]
	
	class Sample5 extends BasicView 
	{	
		// const vars
		static private const OBJ_LENGTH   :int = 20;
		static private const CIRCLE_RANGE :int = 500;
		
		// 3d vars
		private var list :Array = []
		private var wrap :DisplayObject3D;
		
		/**
		 * Constructor
		 */
		public function Sample5(dX:Number,multiLoader:MultiLoader)
		{
			//camera
			camera.x         = -dX;
			camera.y         = 200;
			camera.z         = 1000;
			camera.rotationX = 5;
			
			// wrap
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			wrap.x = -dX / 3;
			
			for (var i:int = 0; i < OBJ_LENGTH; i++)
			{
				var rot:Number = 360 * i / OBJ_LENGTH ;
				
				//var m:ColorMaterial = new ColorMaterial(0xFFFFFF);
				//var m:BitmapFileMaterial = new BitmapFileMaterial(textureURLs[i]);
				//m.checkPolicyFile = true;
				
				var bitmapData:BitmapData = multiLoader.getBitmapData(multiLoader.items[i].url.url);
				var m:BitmapMaterial = new BitmapMaterial(bitmapData);
				m.doubleSided = true;
				
				var o:Plane = new Plane(m, 250, 250);
				o.x = CIRCLE_RANGE * Math.sin(rot * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE * Math.cos(rot * Math.PI / 180);
				o.rotationY = rot+90;
				o.useOwnContainer = true; //ココ重要
				
				// 配列に追加　＆　wrapの子供にする
				list.push(wrap.addChild(o));
			}
			
			//addEventListener(Event.ENTER_FRAME, loop);
			startRendering(); 
		}
		
		// loop
		public function loop(event:Event):void
		{
			wrap.yaw(-1);
			
			// 被写界深度
			for (var i:int = 0; i < list.length; i++)
			{
				var o:DisplayObject3D = list[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 50); 
				o.filters = [new BlurFilter(blur, blur, 2)];
			}
		}
	}
	
	/*
	* Fileローダー
	* */
	
	import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.system.Security;
import flash.utils.Dictionary;

class MultiLoader{
	public static var IMAGE_EXTENSIONS:Array = ["swf", "jpg", "jpeg", "gif", "png"];
	public static var TEXT_EXTENSIONS:Array = ["txt", "js", "xml", "php", "asp"];
	public static const COMPLETE:String = "complete";
	private var _listener:Function = function(event:Event):void{};
	private var _loads:Dictionary;
	private var _loadCount:int;
	private var _itemsLoaded:int;
	public var items:Array;
	public function MultiLoader(name:String){
		_loads = new Dictionary();
		_itemsLoaded = 0;
		items = [];
	}
	public function add(url:String,props:Object = null):void{
		var loadingItem:LoadingItem = new LoadingItem();
		loadingItem.url = new URLRequest(url);
		loadingItem.type = getType(url);
		if(props){
			if(props.context){
				loadingItem.context = props.context;
			}
		}
		items.push(loadingItem); 
	}
	private function getType(url:String):String{
		var i:int;
		var extension:String;
		var n:int = IMAGE_EXTENSIONS.length;
		var result:String = "";
		for (i = 0; i < n; i++) {
			extension = IMAGE_EXTENSIONS[i];
			if(extension == url.substr(-extension.length).toLowerCase()){
				result = "image";
				break;
			}
		}
		if(result == ""){
			n = TEXT_EXTENSIONS.length;
			for (i = 0; i < n; i++) {
				extension = TEXT_EXTENSIONS[i];
				if(extension == url.substr(-extension.length).toLowerCase()){
					result = "text";
					break;
				}
			}
		}
		return result;
	}
	
	public function start():void{
		var n:int = items.length;
		for (var i:int = 0; i < n; i++) {
			var type:String = items[i].type;
			if(type == "image"){
				_loads[items[i].url.url] = loadImage(items[i].url,items[i].context);
			}if(type == "text"){
				_loads[items[i].url.url] = loadText(items[i].url);
			}
			
		}
	}
	public function addEventListener(type:String,listener:Function):void{
		_listener = listener;
	}
	public function getBitmap(key:String):Bitmap{
		var bitmap:Bitmap = _loads[key].content;
		return bitmap;
	}
	public function getBitmapData(key:String):BitmapData{
		var bitmap:Bitmap = getBitmap(key);
		var bitmapData:BitmapData = new BitmapData(bitmap.width,bitmap.height);
		bitmapData.draw(bitmap);
		return bitmapData;
	}
	private function loadImage(url:URLRequest,context:LoaderContext = null):Loader {
		var loader:Loader = new Loader();
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
		loader.load(url,context);
		return loader;
	}
	public function getText(key:String):String{
		return _loads[key].data;
	}
	private function loadText(url:URLRequest):URLLoader{
		var loader:URLLoader = new URLLoader();
		loader.addEventListener(Event.COMPLETE,onComp);
		loader.load(url);
		return loader;
	}
	private function onComp(event:Event):void{
		_itemsLoaded ++;
		if(_itemsLoaded == items.length){
			_listener(event);
		}
	}
	public function get itemsTotal():int{
		return items.length;
	}
	public function get itemsLoaded():int{
		return _itemsLoaded;
	}
	public function get loadedRatio():Number {
		return _itemsLoaded/items.length;
	}
}
class LoadingItem{
	public var url:URLRequest;
	public var type:String;
	public var status:String;
	public var context:LoaderContext;
	public function LoadingItem(){};
}