/**
 * Copyright faunus ( http://wonderfl.net/user/faunus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1kAV
 */

// forked from Saqoosha's flash on 2010-3-9
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.CapsStyle;
    import flash.display.LineScaleMode;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    
    public class FlashTest extends Sprite {

        
        private var img:BitmapData;

        public function FlashTest() {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onComplete);
            loader.load(new URLRequest("http://saqoosha.net/lab/wonderfl/saqoosha.jpg"), new LoaderContext(true));
        }

        
        private function _onComplete(event:Event):void {
            var loader:Loader = LoaderInfo(event.target).loader;
            img = Bitmap(loader.content).bitmapData;
                
            stage.quality = StageQuality.BEST;
                
            var thickness:Number = 300;
            var x0:Number = 50;
            var y0:Number = 50;
            var x1:Number = 350;
            var y1:Number = 100;
            var dx:Number = x1 - x0;
            var dy:Number = y1 - y0;
            var len:Number = Math.sqrt(dx * dx + dy * dy);
            var a:Number = Math.atan2(dy, dx);
                
            var mtx:Matrix = new Matrix();
            mtx.scale(len / img.width, thickness / img.height);
            mtx.translate(0, -thickness / 2);
            mtx.rotate(a);
            mtx.translate(x0, y0);
                
            graphics.lineStyle(thickness, 0, 0, false, LineScaleMode.NORMAL, CapsStyle.NONE);
            graphics.lineBitmapStyle(img, mtx, false, false);
            graphics.moveTo(x0, y0);
            graphics.lineTo(x1, y1);
        }
    }
}