/**
 * Copyright a24 ( http://wonderfl.net/user/a24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1St7
 */

// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
* あなたのイベントハンドラを教えて！
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
    
        private var _btnA:MyButton;
        private var _btnB:MyButton;
        private var _btnC:MyButton;
        private var _label:MyTextField;

        public function FlashTest()
        {
            // @24 流
            // MyButtonクラスに書いちゃう。 ルール違反かな・・？
            
            _build();
            _btnA.name = "A";
            _btnB.name = "B";
            _btnC.name = "C";    
        }
        
        /**
        * インターフェースを作る
        */
        private function _build():void {
            _label = new MyTextField();
            _label.x = 150; _label.y = 280;
            addChild(_label);

            _btnA = new MyButton(_label);
            _btnA.text = "Button A"; 
            _btnA.x = 70; _btnA.y = 230;
            addChild(_btnA);
            
            _btnB = new MyButton(_label);
            _btnB.text = "Button B";
            _btnB.x = 190; _btnB.y = 230;
            addChild(_btnB);
   
            _btnC = new MyButton(_label);            
            _btnC.text = "Button C";
            _btnC.x = 310; _btnC.y = 230;
            addChild(_btnC);
        }
    }
}

import flash.display.*
import flash.text.*;
import flash.events.MouseEvent;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
* ここにマウスイベントも書いちゃう。
*/
class MyButton extends Sprite {
    private var _text:MyTextField;
    private var _label:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(label:MyTextField)
    {
        _label = label;
        
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
        
        addEventListener(MouseEvent.CLICK, clickHandler);
        addEventListener(MouseEvent.ROLL_OVER, rollOverHandler);
    }
    
    private function clickHandler(e:MouseEvent):void
    {
        _label.text = name + " がクリックされました";
    }
    
    private function rollOverHandler(e:MouseEvent):void
    {
        _label.text = name + " がロールオーバーされました";
    }
    
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}

