/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Zj2B
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
 
	public class Main extends Sprite
	{
		private var circle:Sprite;
		private var tx:Number = 0.0;
		private var ty:Number = 0.0;
		private var sx:Number = 0.0;
		private var sy:Number = 0.0;
		private var count:int = 0;
		private var time:Number = 10;
		private var FR:int = 30;
 
		public function Main()
		{
			circle = new Sprite();
			circle.graphics.lineStyle(1.0);
			circle.graphics.drawCircle(0, 0, 15);
			circle.graphics.endFill();
			addChild(circle);
 
			stage.addEventListener(MouseEvent.CLICK, onMouseClick);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onMouseClick(event:MouseEvent):void
		{
			count = 0;
 
			tx = (mouseX - circle.x) / (time * FR);
			ty = (mouseY - circle.y) / (time * FR);
 
			sx = circle.x;
			sy = circle.y;
 
			graphics.clear();
			graphics.lineStyle(1.0, 0xED1A3D);
			graphics.drawCircle(mouseX, mouseY, 15);
			graphics.endFill();
		}
 
		private function onEnterFrame(event:Event):void
		{
			if (count >= time * FR) return;
 
			sx += tx;
			sy += ty;
 
			circle.x = sx;
			circle.y = sy;
 
			count++;
		}
	}
}
