/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ZXbu
 */

// forked from lizhi's agal 2d lights
package  
{
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DProgramType;
    import flash.display3D.Context3DTextureFormat;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.textures.Texture;
    import flash.display3D.VertexBuffer3D;
    import flash.events.Event;
    /**
     * ...
     * @author lizhi
     */
    public class AgalLights extends Sprite
    {
        private var context3d:Context3D;
        private var lights:Array=[];
        private var ibuf:IndexBuffer3D;
        public function AgalLights() 
        { 
            stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, stage3Ds_context3dCreate);
            stage.stage3Ds[0].requestContext3D();

        }
        
        private function stage3Ds_context3dCreate(e:Event):void 
        {
            var c:int = 24;
            while (c-->0) lights.push(new Light);
            
            
            context3d = stage.stage3Ds[0].context3D;
            context3d.configureBackBuffer(465, 465, 0);
            var vsa:AGALMiniAssembler = new AGALMiniAssembler(false);
            vsa.assemble(Context3DProgramType.VERTEX,
                "mov op,va0\n"+
                "mov v0,va1");
            var fsa:AGALMiniAssembler = new AGALMiniAssembler(false);
            
            var code:String = "tex ft0,v0,fs0<2d,linear,nomip>\n" +
                "mov ft1.z,fc0.x\n";
                
            for (var i:int = 1; i <= lights.length;i++ ) {
                code+="sub ft1.xy,v0.xy,fc"+i+".xy\n" +
                "mul ft1.xy,ft1.xy,ft1.xy\n" +
                "add ft1.x,ft1.x,ft1.y\n" +
                "sqt ft1.x,ft1.x\n" +
                "div ft1.x,ft1.x,fc"+i+".z\n" +
                "sub ft1.x,fc0.y,ft1.x\n" +
                "sat ft1.x,ft1.x\n" +
                "add ft1.z,ft1.x,ft1.z\n";
            }
            code+="sat ft1.z,ft1.z\n" +
                "mul ft0.xyz,ft0.xyz,ft1.zzz\n"+
                "mov oc,ft0"
            
            fsa.assemble(Context3DProgramType.FRAGMENT, code);
            var program:Program3D = context3d.createProgram();
            program.upload(vsa.agalcode, fsa.agalcode);
            
            var vdata:Vector.<Number> = Vector.<Number>([-1, 1, 0, 0, 0,
            1, 1, 0, 1, 0, 
            -1, -1, 0, 0, 1, 
            1, -1, 0, 1, 1]);
            var vbuf:VertexBuffer3D = context3d.createVertexBuffer(4, 5);
            vbuf.uploadFromVector(vdata, 0, 4);
            
            var bmd:BitmapData = new BitmapData(512, 512, true, 0);
            bmd.perlinNoise(400, 400, 3, 1, true, true);
            var texture:Texture = context3d.createTexture(512, 512, Context3DTextureFormat.BGRA, false);
            texture.uploadFromBitmapData(bmd);
            
            context3d.setVertexBufferAt(0, vbuf,0,"float3");
            context3d.setVertexBufferAt(1, vbuf,3,"float2");
            context3d.setTextureAt(0, texture);
            context3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, Vector.<Number>([0, 1, 0, 0]));
            
            context3d.setProgram(program);
            
            ibuf = context3d.createIndexBuffer(6);
            ibuf.uploadFromVector(Vector.<uint>([0, 1, 2, 1, 2, 3]), 0, 6);
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(e:Event):void 
        {
            for (var i:int = 1; i <= lights.length; i++ ) {
                var light:Light = lights[i - 1];
                light.v[0] += light.vx;
                light.v[1] += light.vy;
                if (light.v[0]<0||light.v[0]>1)light.vx*=-1;
                if (light.v[1]<0||light.v[1]>1)light.vy*=-1;
                context3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, i, light.v);
            }
            context3d.clear();
            context3d.drawTriangles(ibuf, 0, 2);
            context3d.present();
            
        }
        
    }

}
class Light {
    public var v:Vector.<Number> = Vector.<Number>([Math.random(), Math.random(), 0.05+0.2 * Math.random(), 0]);
    public var vx:Number = 0.03 * (Math.random() - 0.5);
    public var vy:Number = 0.03 * (Math.random() - 0.5);
}