/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Yn0b
 */

package
{
    import flash.events.Event;
    import flash.utils.getTimer;

    import away3d.primitives.*;
    import away3d.entities.Mesh;
    import away3d.containers.View3D;
    import away3d.lights.PointLight;
    import away3d.core.base.Geometry;
    import away3d.core.base.SubGeometry;
    import away3d.filters.BloomFilter3D;
    import away3d.materials.ColorMaterial;
    import away3d.materials.methods.RimLightMethod;
    import away3d.materials.lightpickers.StaticLightPicker;

    public class POINTLIGHT extends View3D
    {
        private var material : ColorMaterial;
        private var cube : Mesh;

        private var spotA : PointLight;
        private var spotB : PointLight;

        private var dist : Number = 500;

        private var ballA : Mesh;
        private var ballB : Mesh;

        public function POINTLIGHT () { addEventListener (Event.ADDED_TO_STAGE, init); }

        private function init (e : Event) : void
        {
            removeEventListener (Event.ADDED_TO_STAGE, init);

            with (stage) { align = 'TL'; scaleMode = 'noScale'; frameRate = 60; color = 0xFFFFFF; }

            backgroundColor = 0xFFFFFF;
            height = stage.stageHeight;
            width = stage.stageWidth;
            antiAlias = 16;

            spotA = new PointLight ();
            spotA.ambient = 0.1;
            spotA.specular = 1;
            spotA.diffuse = 0.5;
            spotA.radius = 90000;
            spotA.fallOff = 100000;

            spotB = new PointLight ();
            spotB.ambient = 0.1;
            spotB.specular = 1;
            spotB.diffuse = 0.5;
            spotB.radius = 90000;
            spotB.fallOff = 100000;

            var picker : StaticLightPicker = new StaticLightPicker ([spotA, spotB]);
            material = new ColorMaterial (0xFF00FF, 1);
            material.lightPicker = picker;

            material.addMethod (new RimLightMethod (0xFFFFFF, 0.4, 2, 'mix'));

            filters3d = [new BloomFilter3D (15, 15, 1.5, 1.5, 3)];

            super.scene.addChild (ballA = new Mesh (new SphereGeometry (20), new ColorMaterial (0xFFFFFF, 0.75)));
            super.scene.addChild (ballB = Mesh (ballA.clone ()));

            ballA.material.lightPicker = ballB.material.lightPicker = picker;

            var subGeometry: SubGeometry = new SubGeometry ();

            subGeometry.updateVertexData (Vector.<Number>([    
                                                             1, -1,  1, 
                                                             1, -1, -1, 
                                                             1,  1, -1, 
                                                             1,  1,  1, 
                                                            -1, -1,  1, 
                                                            -1, -1, -1, 
                                                            -1,  1, -1, 
                                                            -1,  1,  1
                                                            ]));

            subGeometry.updateIndexData (Vector.<uint>([        
                                                        4, 0, 3, 4, 3, 7, 
                                                        0, 1, 2, 0, 2, 3, 
                                                        1, 5, 6, 1, 6, 2, 
                                                        5, 4, 7, 5, 7, 6, 
                                                        7, 3, 2, 7, 2, 6, 
                                                        0, 5, 1, 0, 4, 5
                                                        ]));

            var geometry : Geometry = new Geometry ();
            geometry.subGeometries[0] = subGeometry;

            cube = new Mesh (geometry, material);
            cube.scale (250);

            super.scene.addChild (cube);

            addEventListener (Event.ENTER_FRAME, frame);
        }

        public function frame (e : Event) : void
        {
            cube.yaw (1); cube.pitch (1);

            var t : Number = getTimer () / 500;

            ballB.x = -(ballA.x = Math.sin (t) * dist);
            ballB.y = -(ballA.y = Math.cos (t) * dist);
            ballB.z = -(ballA.z = Math.cos (t) * dist);

            spotA.position = ballA.position;
            spotB.position = ballB.position;
            
            camera.z = -1500;

            super.render ();
        }
    }
}