/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Ykvz
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{
		private var vp:Point = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
		private var ball:Ball;
		private var camera:Camera = new Camera();
 
		public function Main()
		{
			ball = new Ball();
			addChild(ball);
 
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			var scale:Number = camera.getScale(ball.pz);
			ball.scaleX = ball.scaleY = scale;
 
			if (ball.pz > camera.z - camera.f)
			{
				ball.x = vp.x + (ball.px - camera.x) * scale;
				ball.y = vp.y + (ball.py - camera.y) * scale;
				ball.visible = true;
			}
			else
			{
				ball.visible = false;
			}
		}
 
		private function onKeyDown(event:KeyboardEvent):void 
		{
			if (event.keyCode == 37) camera.x -= 10;
			if (event.keyCode == 39) camera.x += 10;
			if (event.keyCode == 38) camera.y -= 10;
			if (event.keyCode == 40) camera.y += 10;
 
			if (event.keyCode == 83) camera.z -= 10;
			if (event.keyCode == 87) camera.z += 10;
		}
	}
}
 
 
import flash.display.Sprite;
 
class Ball extends Sprite
{
	public var px:Number = 0;
	public var py:Number = 0;
	public var pz:Number = 100;
 
	public function Ball()
	{
		graphics.beginFill(0x0);
		graphics.drawCircle(0, 0, 30);
		graphics.endFill();
	}
}
 
class Camera
{
	public var x:Number = 0;
	public var y:Number = 0;
	public var z:Number = 0;
	public var f:Number = 200;
 
	public function getScale(objZ:Number):Number
	{
		var scale:Number = f / (f + objZ - z);
		return (scale < 0) ? 0 : scale;
	}
}
