/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/YQ6o
 */

// forked from ikke's SoundVisualizerTest
/**
* 音は http://shw.in/sozai/ を使わせていただきました。 
*
* 2010.5.2 エラー回避のため、90行目に下記のコードを追加しました。
*
* if(n == 0)    return;
*
* matacat 様、エラーのご報告有難うございます！！（コメントで失礼します）
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;

    public class FlashTest extends Sprite
    {
        private const SIZE:int = 300;
        private var canvas:BitmapData;
        
        private var sound:Sound;
        private var soundMixier:SoundMixer;
        private var soundChannel:SoundChannel;
        
        private var ctfm:ColorTransform;
        private var bytes:ByteArray = new ByteArray();
        private var particles:Array = [];
        private var sw:Number;
        private var sh:Number;
        
        public function FlashTest()
        {
                        Wonderfl.capture_delay( 3 )
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.frameRate =  30;
            sw = stage.stageWidth;
            sh = stage.stageHeight;
            
            var baseBmd:BitmapData = new BitmapData(sw, sh, false, 0 );
            addChild( new Bitmap( baseBmd ) );
            
            canvas = new BitmapData( sw, sh, false, 0 );
            var bmp:Bitmap = new Bitmap( canvas );
            bmp.blendMode = BlendMode.ADD;
            addChild( bmp );
            
            ctfm = new ColorTransform();
            ctfm.alphaMultiplier = .1;
            
            sound = new Sound();
            sound.addEventListener( Event.COMPLETE, comp );
            Security.loadPolicyFile( "http://psalms.weblike.jp/crossdomain.xml" );
            sound.load( new URLRequest("http://dhai-haif.rhcloud.com/lxpp/music/qznh.mp3"));
        }
        
        private function comp(e:Event):void
        {
            soundChannel = sound.play();
            var stfm:SoundTransform = new SoundTransform();
            soundChannel.soundTransform = stfm;
            
            addEventListener( Event.ENTER_FRAME, enterFrame );
        }

        private function enterFrame(e:Event):void
        {
            SoundMixer.computeSpectrum(bytes, false, 0 );
            canvas.colorTransform( canvas.rect, ctfm);
            canvas.lock();
            var n:Number = 0;
            var size:Number = 0;
            
        
            for (var i:int = 0; i < 512; i++)
            {
                n = ( bytes.readFloat() + 1) / 2;
                size = n * SIZE;
                if(n == 0)    return;
                var l:Number = (size/2)*Math.PI;
                var interval:Number = l / 360 * (3.14*5); // (3.14*5) 調整用。
                
                for( var j:Number = 0; j <= l; j+= interval )
                {
                    var x:Number = size/2 * Math.sin( j );
                    var y:Number = size/2 * Math.cos( j );
                    if( x == 0 ) continue;
                    
                    var r:uint = 0xcc;
                    var g:uint = 0xff * n;
                    var b:uint = 0xff * n;
                    var color:uint = r << 16 | g << 8 | b;
                    if( n <= .8 )    canvas.setPixel( x + sw/2, y + sh/2, color );
                    
                    if( n >= .8 && particles.length <= size/5)
                    {
                        var p:Particle = new Particle(x + sw/2, y + sh/2, n, 0xff0066, canvas );
                        particles.push( p );
                    }
                }
                
                
                for( var k:int = 0; k < particles.length; k++ )
                {
                    p = particles[ k ];
                    if( p != null )
                    {
                        p.update();
                        if( p.isEnd )    particles.splice( k, 1 );
                    }
                }
            }
            
            canvas.unlock();
        }
        
    }
}

import flash.display.BitmapData;
import flash.events.EventDispatcher;
import flash.events.Event;

class Particle
{
    private var vx:Number = 0;
    private var vy:Number = 0;
    private var x:Number = 0;
    private var y:Number = 0;
    private var col:uint;
    private var bmd:BitmapData;
    private var limit:int = 0;
    public var isEnd:Boolean = false;
    private var max:int = 0;
    
    public function Particle(x:Number,y:Number, sp:Number, col:uint, bmd:BitmapData):void
    {
        this.x = x;
        this.y = y;
        this.col = col;
        max  = 1000 * sp;
        vx = ( Math.random() -.5 )/15 * sp;
        vy = ( Math.random() -.5 )/15 * sp;
        this.bmd = bmd;
    }
    
    public function update( ):void
    {
        x += vx;
        y += vy;
        bmd.setPixel( x, y, col );
        limit+=1;
        if( limit >= max )    isEnd = true;
    }
}