/**
 * Copyright Antonio.Meneses ( http://wonderfl.net/user/Antonio.Meneses )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/YMg8
 */

// forked from WLAD's Calculate Angle Direction from Middle Point in Rectangle
/// @mxmlc -swf-version 15
package {
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.geom.Point;
[SWF(width="465", height="465")]
public class MXMLC extends Sprite {

///-----------------------
///    VARIABLES         |
///-----------------------

private var m_w:int;
private var m_h:int;
private var m_p:Point;
private var m_a:Number = 0;
private var m_1:Number = 0;
private var m_2:Number = 0;
private var m_3:Number = 0;
private var m_4:Number = 0;

private var m_s:String = "";

///-----------------------
///    UPDATE          |
///-----------------------

private function update(e:*= null):void
{    
    m_w = p2.x - p1.x;
    m_h = p2.y - p1.y;
    
    m_p = new Point( m_w/2 + p1.x, m_h/2 + p1.y );
    
    var a_y:Number = stage.mouseY - m_p.y;
    var a_x:Number = stage.mouseX - m_p.x;
    
    m_a = Math.atan2( a_y , a_x );
    
    m_1 = Math.atan2( -m_h, m_w );
    m_2 = Math.atan2( m_h, m_w );
    m_3 = Math.atan2( m_h, -m_w );
    m_4 = Math.atan2( -m_h, -m_w );
    
    if ( m_a == m_1 ) m_s = "top right";
    else if ( m_a > m_1 && m_a < m_2 ) m_s = "right";
    else if ( m_a == m_2 ) m_s = "bottom right";
    else if ( m_a > m_2 && m_a < m_3 ) m_s = "bottom";
    else if ( m_a == m_3 ) m_s = "bottom left";
    //else if ( m_a > m_3 && m_a > m_4 ) m_s = "left";
    //else if ( m_a < m_4 && m_a < m_1 ) m_s = "left";
    else if ( m_a == m_4 ) m_s = "top left";
    else if ( m_a > m_4 && m_a < m_1 ) m_s = "top";
    else if ( m_a > m_4 || m_a < m_4 ) m_s = "left";
    else m_s = "null";
    
    debugDraw();
}
    
///-----------------------
///    DISPLAY           |
///-----------------------
private var tx:TextField;
private var canvas:Sprite;
private var run:Boolean;
private var p1:DragPoint;
private var p2:DragPoint;

public function MXMLC () 
{
    // init stage
    stage.align = 'tl';
    stage.scaleMode = 'noScale';
    stage.frameRate = 40;
    m_w = stage.stageWidth;
    m_h = stage.stageHeight;
    graphics.beginFill(0x26274A);
    graphics.drawRect(0,0, m_w,100);
    graphics.endFill();
    graphics.beginFill(0xFEE285);
    graphics.drawRect(0,100, m_w,m_h-100);
    
    // text
    var ft:TextFormat = new TextFormat();
    ft.size = 22;
    ft.color = 0xD6E2D6;
    ft.leftMargin = 12;
    ft.letterSpacing = 4;
    ft.tabStops = [60,220,280];
    tx = new TextField();
    tx.mouseEnabled = false;
    tx.defaultTextFormat = ft;
    tx.mouseEnabled = false;
    tx.defaultTextFormat = ft;
    tx.setTextFormat( ft );
    tx.width = stage.stageWidth;
    tx.height = 70;
    tx.y = 20;
    addChild( tx );
    
    // canvas
    canvas = new Sprite();
    addChild( canvas );
    
    p1 = new DragPoint(0x62E0EE, 0x126C76);
    p1.x = 100;
    p1.y = 170;
    addChild( p1 );
    p2 = new DragPoint(0x62E0EE, 0x126C76);
    p2.x = 350;
    p2.y = 400;
    addChild( p2 );
                
    // stage events 
    run = true; 
    stage.addEventListener('rightMouseDown', function(e:*):void {run = !run;});
    stage.addEventListener('enterFrame', function(e:*):void {if (!run) return; update(); });
} // constractor 
private function debugDraw():void
{
    // Trace data 
    tx.text = "W" + "\t" + m_w.toFixed(0) + 
        "\t" + "H" + "\t" + m_h.toFixed(0) + 
        "\n" + "A" + "\t" + (m_a * 57.296).toFixed(2) + 
        "\t" + "S" + "\t" + m_s.toUpperCase();
        
    // Draw data
    canvas.graphics.clear();
    
    // Draw fill 
    canvas.graphics.lineStyle();
    canvas.graphics.beginFill(0x03FCFC,0.2);
    if ( m_s.indexOf('left') >-1 ) 
    {
        canvas.graphics.moveTo(p1.x, p1.y);
        canvas.graphics.lineTo(m_p.x, m_p.y);
        canvas.graphics.lineTo(p1.x, p2.y);
        canvas.graphics.lineTo(p1.x, p1.y);
    }
    if ( m_s.indexOf('top') >-1 ) 
    {
        canvas.graphics.moveTo(p1.x, p1.y);
        canvas.graphics.lineTo(m_p.x, m_p.y);
        canvas.graphics.lineTo(p2.x, p1.y);
        canvas.graphics.lineTo(p1.x, p1.y);
    }
    if ( m_s.indexOf('right') >-1 ) 
    {
        canvas.graphics.moveTo(p2.x, p2.y);
        canvas.graphics.lineTo(m_p.x, m_p.y);
        canvas.graphics.lineTo(p2.x, p1.y);
        canvas.graphics.lineTo(p2.x, p2.y);
    }
    if ( m_s.indexOf('bottom') >-1 ) 
    {
        canvas.graphics.moveTo(p2.x, p2.y);
        canvas.graphics.lineTo(m_p.x, m_p.y);
        canvas.graphics.lineTo(p1.x, p2.y);
        canvas.graphics.lineTo(p2.x, p2.y);
    }
    canvas.graphics.endFill();
    
    // Draw angle
    var p:Point = Point.polar( 50, m_a ).add( m_p );
    canvas.graphics.lineStyle(30, 0xC2A84E);
    canvas.graphics.moveTo(m_p.x, m_p.y);
    canvas.graphics.lineTo(p.x, p.y);
    
    // Draw lines 
    canvas.graphics.lineStyle(3, 0x968034 );
    canvas.graphics.moveTo(p1.x, p1.y);
    canvas.graphics.lineTo(p2.x, p2.y);
    canvas.graphics.moveTo(p2.x, p1.y);
    canvas.graphics.lineTo(p1.x, p2.y);
    canvas.graphics.lineStyle(4, 0xC2A84E );
    canvas.graphics.drawRect(p1.x, p1.y, m_w, m_h);
    
} // debugDraw
} // class
} // package
import flash.display.Sprite;
import flash.geom.Point;
class DragPoint extends Sprite
{
    public function get point():Point { return new Point(x, y); }
    public function DragPoint(c:uint, l:uint)
    {
        graphics.lineStyle(4, l );
        graphics.beginFill(c);
        graphics.drawCircle(0, 0, 14);
        buttonMode = useHandCursor = true;
        var down:Boolean = false;
        addEventListener('mouseDown', function(e:*):void { 
            if ( down ) return; down = true;
            function drag(_e:*):void{
                x = stage.mouseX;
                y = stage.mouseY;
                alpha = 0.5;
            };
            function stop(_e:*):void{
                down = false;
                stage.removeEventListener('mouseUp', stop);
                removeEventListener('enterFrame', drag );
                alpha = 1;
            };
            stage.addEventListener('mouseUp', stop);
            addEventListener('enterFrame', drag, false, 0 );
        });
        addEventListener('rollOver', function(e:*):void { scaleX = scaleY = 1.4; } );
        addEventListener('rollOut', function(e:*):void { scaleX = scaleY = 1; } );
    }
}