/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/YJPl
 */

// forked from WLAD's Change Number's Range
package {
    import flash.events.Event;
    import flash.display.Sprite;
     import flash.geom.Point;
    public class FlashTest extends Sprite {
        
        private var sliderA:LineSlider;
        private var sliderB:LineSlider;
        private var sliderC:LineSlider;
        private var sliderD:LineSlider;
        
        /////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////
        
        public function FlashTest() {
            // write as3 code here..
            
                sliderA = make("A","0","","1", 0xFFFFFF);
                sliderB = make("B","-1/2","0","1/2", 0xB0EB4E);
                sliderC = make("C","1","0","1", 0xF07D57);
                sliderD = make("D","0","1","0", 0x67AAE0);
            
            addEventListener("enterFrame", loop);
        }
          
          private var A:Number, B:Number, C:Number, D:Number;
          
        private function loop(e:Event):void
        {
            redraw();
            
            A = stage.mouseX / stage.stageWidth;
            
            sliderA.setValue( A, A );        draw( sliderA, A );
            
            B = A - 0.5;
            
            sliderB.setValue( A, B );        draw( sliderB, B );
            
            C = 2 * Math.abs( B );
            
            sliderC.setValue( A, C );        draw( sliderC, C );
            
            D = 1 - C;
            
            sliderD.setValue( A, D );        draw( sliderD, D );
      }
        
        /////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////
        
         private var nextY:Number = 60;
          private function make( L:String, a:String, b:String, c:String, color:uint ):LineSlider
          {
                var w:Number = stage.stageWidth - 300;
                
                var slider:LineSlider = new LineSlider( w, a, b, c, color );
                addChild( slider );
                slider.x = 110;
                slider.y = nextY;
                
                nextY += 110;
              
               var text:Text;
            text = new Text( L, slider.color, 60 );
            addChild( text );
            text.x = 20;
            text.y = slider.y - 30;
                
                return slider;
          }
          
          private function redraw():void
          {
            graphics.clear();
            graphics.lineStyle();
            graphics.beginFill(0x0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
          }
          
        private function draw( slider:LineSlider, val:Number ):void
        {
            var rx:Number = stage.stageWidth - 100;
            graphics.lineStyle( 5, slider.color );
            graphics.moveTo( rx, slider.y );
            var p:Point = Point.polar( 45, Math.PI * 2 * val );
            graphics.lineTo( rx + p.x, slider.y + p.y );
            graphics.drawCircle( rx, slider.y, 45 );
            
            graphics.lineStyle();
            graphics.beginFill( slider.color );
            graphics.drawRect( stage.stageWidth - 40, slider.y - 45, 20, 90 * val ); 
            graphics.endFill();
        }
   }
}
/////////////////////////////////
//        SLIDER
/////////////////////////////////
import flash.geom.Rectangle;
import flash.text.TextFormat;
import flash.text.TextField;
import flash.display.Sprite;

class LineSlider extends Sprite
{
    public var lblA:Text;
    public var lblB:Text;
    public var lblC:Text;
    public var color:uint;
    public var slider:LineSliderValue;
    public var w:Number;
     
    public function LineSlider(width:Number, a:String, b:String, c:String, color:uint = 0xFF0000 )
    {
         this.color = color;
         
        w = width;
          
        lblA = new Text(a, color);addChild(lblA);
        lblB = new Text(b, color);addChild(lblB);
        lblC = new Text(c, color);addChild(lblC);
        
        slider = new LineSliderValue(color);
        addChild(slider);
        
        graphics.lineStyle(4, color);
        graphics.moveTo(0, -6);
        graphics.lineTo(0,0);
        graphics.lineTo(width, 0);
        graphics.lineTo(width, -6);
        
        lblB.x = (width - lblB.width)/2;
        lblC.x = width - lblC.width;
    }
     
     /// x [ 0, 1 ], val [ any ]
    public function setValue( x:Number, val:Number ):void
    {
        slider.value = val;
        slider.x = x * w;
    }

}

class LineSliderValue extends Sprite
{
    private var label:Text;
    private var color:uint = 0x0;
    
    public function LineSliderValue(color:uint = 0x0)
    {
        this.color = color;
        
        label = new Text("0", color);
        addChild(label);
        label.x = -label.width/2;
        label.y = -label.height - 12;
        
    }
    public function set value(val:Number):void
    {
        label.text = val.toFixed(2);
        label.x = -label.width/2;
        graphics.clear();
        graphics.lineStyle(3, color,1,true);
        graphics.beginFill(color, 0.1);
        //var mx:Number = Math.max(label.width, label.height);
        //graphics.drawCircle(label.x + label.width/2, label.y + label.height/2, mx/2 + 2);
        //graphics.drawRoundRect(label.x-3, label.y, label.width+6, label.height, label.height/2);
        var r:Rectangle = new Rectangle(label.x-3, label.y, label.width+6, label.height);
        graphics.moveTo(r.left,r.bottom);
        graphics.lineTo(r.left,r.top);
        graphics.lineTo(r.right,r.top);
        graphics.lineTo(r.right,r.bottom);
        graphics.lineTo(0,-4);
        graphics.lineTo(r.left,r.bottom);
        graphics.endFill();
    }
}
class Text extends TextField
{
    private var color:uint;
    public function Text(txt:String, color:uint = 0x0, size:int = 18)
    {
        this.color = color;
        super();
        this.defaultTextFormat = new TextFormat("_sans", size, color, true);    
        this.multiline = false;
        this.wordWrap = false;
        this.selectable = false;
        this.autoSize = "left";
        this.mouseEnabled = false;
        this.text = txt;
        
    }    
    public function set size(value:int):void {
        this.setTextFormat(new TextFormat("_sans", value, color));
    }
}