/**
 * Copyright ffffine ( http://wonderfl.net/user/ffffine )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Y41W
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.filters.ShaderFilter;
	
	/**
	 * ...
     * Pixel Bender`s study
	 * Custom Filter : http://www.adobe.com/cfusion/exchange/index.cfm?event=extensionDetail&loc=en_us&extid=1695035
	 * by Frank Reitberger
	 */
	
    [SWF(width = 465, height = 465, backgroundColor = 0x0, frameRate = 60)]
	
	public class WebCam extends Sprite
	{
		private var video:Video;
		private var camera:Camera;
		private var currentBMD:BitmapData;
		private var myShader:deformer = new deformer();
		private var myFilter:ShaderFilter = new ShaderFilter(myShader);

		public function WebCam() 
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			cameraSetting();
			
			var screen:Bitmap = new Bitmap(currentBMD);
			addChild(screen);
			addEventListener(Event.ENTER_FRAME, render);
		}
		
		private function cameraSetting():void
		{
			camera = Camera.getCamera();
			camera.setMode(stage.stageWidth, stage.stageHeight, 30);
			video = new Video(stage.stageWidth, stage.stageHeight);
			video.attachCamera(camera);
			currentBMD = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
		}
		
		private function render(e:Event):void 
		{
			currentBMD.draw(video);
			currentBMD.applyFilter(currentBMD, currentBMD.rect, new Point(), myFilter);
			myFilter.shader.data.center_x.value = [mouseX];
			myFilter.shader.data.center_y.value = [mouseY];
			
		}
		
	}

}

 

    import flash.display.Shader;
    import flash.utils.ByteArray;
    
    /**
     * deformer
     * deforms whatever get´s in the way.
     * @author Frank Reitberger
     * @version 1
     * @namespace deformer
     */
    class deformer extends Shader
    {
        //Parameters
        /**
         * (Parameter) center_x [Number]
         * center point x
         * @type float
         * @minValue [182]
         * @maxValue [249]
         * @defaultValue [204.63999938964844]
         */
        public function get center_x():Array { return data.center_x.value; }
        public function set center_x(value:Array):void { data.center_x.value = value; }
        public function get center_x_min():Array { return [182]; }
        public function get center_x_max():Array { return [249]; }
        public function get center_x_default():Array { return [204.63999938964844]; }
        public function get center_x_type():String { return "float"; }
        
        /**
         * (Parameter) center_y [Number]
         * center point y
         * @type float
         * @minValue [158]
         * @maxValue [249]
         * @defaultValue [182.16000366210938]
         */
        public function get center_y():Array { return data.center_y.value; }
        public function set center_y(value:Array):void { data.center_y.value = value; }
        public function get center_y_min():Array { return [158]; }
        public function get center_y_max():Array { return [249]; }
        public function get center_y_default():Array { return [182.16000366210938]; }
        public function get center_y_type():String { return "float"; }
        
        /**
         * (Parameter) imageHeight [Number]
         * set image height
         * @type float
         * @minValue [1]
         * @maxValue [2024]
         * @defaultValue [323]
         */
        public function get imageHeight():Array { return data.imageHeight.value; }
        public function set imageHeight(value:Array):void { data.imageHeight.value = value; }
        public function get imageHeight_min():Array { return [1]; }
        public function get imageHeight_max():Array { return [2024]; }
        public function get imageHeight_default():Array { return [323]; }
        public function get imageHeight_type():String { return "float"; }
        
        /**
         * (Parameter) stretch [int]
         * calculate stretch(es)
         * @type int
         * @minValue [1]
         * @maxValue [3]
         * @defaultValue [2]
         */
        public function get stretch():Array { return data.stretch.value; }
        public function set stretch(value:Array):void { data.stretch.value = value; }
        public function get stretch_min():Array { return [1]; }
        public function get stretch_max():Array { return [3]; }
        public function get stretch_default():Array { return [2]; }
        public function get stretch_type():String { return "int"; }
        
        //Inputs
        /**
         * (Input) src
         * @channels 4
         */
        public function get src():Object { return data.src.input; }
        public function set src(input:Object):void { data.src.input = input; }
        public function get src_width():int { return data.src.width; }
        public function set src_width(width:int):void { data.src.width = width; }
        public function get src_height():int { return data.src.height; }
        public function set src_height(height:int):void { data.src.height = height; }
        
        //Constructor
        public function deformer(init:Object = null):void
        {
            if (_byte == null)
            {
                _byte = new ByteArray();
                for (var i:uint = 0, l:uint = _data.length; i < l; ++i) _byte.writeByte(_data[i]);
            }
            super(_byte);
            for (var prop:String in init) this[prop] = init[prop];
        }
        
        //Data
        private static var _byte:ByteArray = null;
        private static var _data:Vector.<int> = Vector.<int>([-91, 1, 0, 0, 0, -92, 8, 0, 100, 101, 102, 111, 114, 109, 101, 114, -96, 12, 110, 97, 109, 101, 115, 112, 97, 99, 101, 0, 100, 101, 102, 111, 114, 109, 101, 114, 0, -96, 12, 118, 101, 110, 100, 111, 114, 0, 70, 114, 97, 110, 107, 32, 82, 101, 105, 116, 98, 101, 114, 103, 101, 114, 0, -96, 8, 118, 101, 114, 115, 105, 111, 110, 0, 1, 0, -96, 12, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 100, 101, 102, 111, 114, 109, 115, 32, 119, 104, 97, 116, 101, 118, 101, 114, 32, 103, 101, 116, -76, 115, 32, 105, 110, 32, 116, 104, 101, 32, 119, 97, 121, 46, 0, -95, 1, 2, 0, 0, 12, 95, 79, 117, 116, 67, 111, 111, 114, 100, 0, -95, 1, 1, 0, 0, 2, 99, 101, 110, 116, 101, 114, 95, 120, 0, -94, 1, 109, 105, 110, 86, 97, 108, 117, 101, 0, 67, 54, 0, 0, -94, 1, 109, 97, 120, 86, 97, 108, 117, 101, 0, 67, 121, 0, 0, -94, 1, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 67, 76, -93, -41, -94, 12, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 99, 101, 110, 116, 101, 114, 32, 112, 111, 105, 110, 116, 32, 120, 0, -95, 1, 1, 0, 0, 1, 99, 101, 110, 116, 101, 114, 95, 121, 0, -94, 1, 109, 105, 110, 86, 97, 108, 117, 101, 0, 67, 30, 0, 0, -94, 1, 109, 97, 120, 86, 97, 108, 117, 101, 0, 67, 121, 0, 0, -94, 1, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 67, 54, 40, -10, -94, 12, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 99, 101, 110, 116, 101, 114, 32, 112, 111, 105, 110, 116, 32, 121, 0, -95, 1, 1, 1, 0, 8, 105, 109, 97, 103, 101, 72, 101, 105, 103, 104, 116, 0, -94, 1, 109, 105, 110, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, -94, 1, 109, 97, 120, 86, 97, 108, 117, 101, 0, 68, -3, 0, 0, -94, 1, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 67, -95, -128, 0, -94, 12, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 115, 101, 116, 32, 105, 109, 97, 103, 101, 32, 104, 101, 105, 103, 104, 116, 0, -95, 1, 8, 1, -128, 8, 115, 116, 114, 101, 116, 99, 104, 0, -94, 8, 109, 105, 110, 86, 97, 108, 117, 101, 0, 1, 0, -94, 8, 109, 97, 120, 86, 97, 108, 117, 101, 0, 3, 0, -94, 8, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 2, 0, -94, 12, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 99, 97, 108, 99, 117, 108, 97, 116, 101, 32, 115, 116, 114, 101, 116, 99, 104, 40, 101, 115, 41, 0, -93, 0, 4, 115, 114, 99, 0, -95, 2, 4, 2, 0, 15, 112, 120, 108, 0, 29, 1, 0, 64, 0, 0, -128, 0, 29, 1, 0, 32, 0, 0, -64, 0, 50, 1, 0, 16, 64, 73, 15, -37, 29, 3, 0, -63, 0, 0, 16, 0, 2, 3, 0, -63, 1, 0, 96, 0, 29, 3, 0, 49, 3, 0, 16, 0, 50, 3, 0, -128, 63, -64, 0, 0, 4, 3, 0, 64, 3, 0, 0, 0, 3, 3, 0, 64, 1, 0, -64, 0, 4, 3, 0, -128, 1, 0, 0, 0, 3, 3, 0, -128, 3, 0, 64, 0, 29, 3, 0, 64, 3, 0, 0, 0, 3, 3, 0, 64, 3, 0, -128, 0, 13, 3, 0, -128, 3, 0, 64, 0, 3, 3, 0, 49, 3, 0, 0, 0, 36, 3, 0, -127, 3, 0, -80, 0, 4, 3, 0, 64, 1, 0, -128, 0, 3, 3, 0, 64, 3, 0, 0, 0, 29, 3, 0, -128, 3, 0, 64, 0, 36, 3, 0, 65, 3, 0, -80, 0, 4, 4, 0, -128, 1, 0, 64, 0, 3, 4, 0, -128, 3, 0, 64, 0, 29, 3, 0, 64, 4, 0, 0, 0, 50, 1, -128, 64, 1, 0, 0, 0, 40, 1, -128, -128, 1, -128, 64, 0, 29, 1, -128, 32, 0, -128, 0, 0, 52, 0, 0, 0, 1, -128, -128, 0, 29, 4, 0, -128, 3, 0, 0, 0, 3, 4, 0, -128, 3, 0, 64, 0, 3, 3, 0, 49, 4, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 50, 1, -128, 64, 2, 0, 0, 0, 40, 1, -128, -128, 1, -128, 64, 0, 29, 1, -128, 32, 0, -128, 0, 0, 52, 0, 0, 0, 1, -128, -128, 0, 12, 4, 0, -128, 3, 0, 0, 0, 13, 4, 0, 64, 3, 0, 64, 0, 29, 4, 0, 32, 4, 0, 0, 0, 3, 4, 0, 32, 4, 0, 64, 0, 3, 3, 0, 49, 4, 0, -96, 0, 54, 0, 0, 0, 0, 0, 0, 0, 50, 1, -128, 64, 3, 0, 0, 0, 40, 1, -128, -128, 1, -128, 64, 0, 29, 1, -128, 32, 0, -128, 0, 0, 52, 0, 0, 0, 1, -128, -128, 0, 29, 4, 0, -128, 3, 0, 0, 0, 3, 4, 0, -128, 3, 0, 64, 0, 14, 4, 0, 64, 4, 0, 0, 0, 4, 4, 0, -128, 1, 0, -64, 0, 3, 4, 0, -128, 4, 0, 64, 0, 3, 3, 0, 49, 4, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 50, 1, -128, 64, 4, 0, 0, 0, 40, 1, -128, -128, 1, -128, 64, 0, 29, 1, -128, 32, 0, -128, 0, 0, 52, 0, 0, 0, 1, -128, -128, 0, 13, 4, 0, -128, 3, 0, 0, 0, 12, 4, 0, 64, 3, 0, 64, 0, 29, 4, 0, 32, 4, 0, 0, 0, 3, 4, 0, 32, 4, 0, 64, 0, 17, 4, 0, -128, 4, 0, -128, 0, 1, 3, 0, 49, 4, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 29, 4, 0, -63, 1, 0, 96, 0, 1, 4, 0, -63, 3, 0, -80, 0, 49, 5, 0, -15, 4, 0, 16, 0, 29, 2, 0, -13, 5, 0, 27, 0]);
    }
