/**
 * Copyright ukkr ( http://wonderfl.net/user/ukkr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/XyT6
 */

package {
    import flash.display.*;

    public class DocumentClass extends Sprite {
        public function DocumentClass() {
            var mt:MarqueeText = new MarqueeText();
            addChild( mt );
        }
    }
}
import flash.display.*;
import flash.text.*;
import flash.events.*;

import caurina.transitions.*;
import caurina.transitions.properties.*;

class MarqueeText extends MovieClip {
	ColorShortcuts.init();
	private var _bg:Sprite;
	private var _mask:Sprite;
	private var _titleTxt:TextField;
	private var _titleTf:TextFormat;
	private var _speed:int = 1;
	private var _sideMargin:int = 4;
	private var _textRightEdge:Number;
	private var _textList:Array = [];
	private var _textIndex:int = 0;
	
	public function MarqueeText() {
		mouseChildren = false;
		init();
	}
	
	public function init():void {
		_bg = new Sprite();
		_bg.graphics.beginFill( 0x000000 );
		_bg.graphics.drawRect( 0, 0, 160, 20 );
		addChild( _bg );
		
		_titleTxt = new TextField();
		_titleTxt.x = _sideMargin;
		_titleTxt.y = 3;
		_titleTxt.width = _bg.width - _sideMargin * 2;
		_titleTxt.width = _bg.width;
		_titleTxt.selectable = false;
		_titleTxt.autoSize = TextFieldAutoSize.NONE;
		
		_titleTf = new TextFormat();
		_titleTf.size = 11;
		_titleTf.color = 0xffffff;
		_titleTf.font = "_ゴシック";
		_titleTf.align = TextFormatAlign.CENTER;
		_titleTxt.defaultTextFormat = _titleTf;
		addChild( _titleTxt );
		
		_mask = new MovieClip();
		_mask.graphics.beginFill( 0xffffff, 0 );
		_mask.graphics.drawRect( 0, 0, _bg.width - _sideMargin - 1, _bg.height );
		_mask.graphics.endFill();
		addChild( _mask );
		
		_titleTxt.mask = _mask;
		
		addEventListener( MouseEvent.ROLL_OVER, rollOverHandler );
		addEventListener( MouseEvent.ROLL_OUT, rollOutHandler );
		buttonMode = true;
		
		_textList.push( "クリックでテキスト変更" )
		_textList.push( "魅力的なインタラクティブコンテンツを作成するための業界スタンダードのオーサリング環境。それがAdobe® Flash® CS4 Professionalです。" )
		_textList.push( "Lorem ipsum dolor sit amet, consectetur adipisicing elit" )
		
		setText( _textList[ _textIndex ] );
	}
	
	private function rollOverHandler( e:MouseEvent ):void {
		Tweener.addTween( _titleTxt, { _brightness:  -1, time: 0.3 } );
	}
	private function rollOutHandler( e:MouseEvent ):void {
		Tweener.addTween( _titleTxt, { _brightness: 0, time: 0.3 } );
	}
	
	/**
	 * タイトルが変更された時の挙動
	 * @param	value
	 */
	public function setText( value:String ):void {
		_titleTxt.text = value;
		if ( _titleTxt.textWidth > _bg.width - _sideMargin * 2 ) {
			_titleTxt.autoSize = TextFieldAutoSize.LEFT;
			addEventListener( MouseEvent.MOUSE_OVER, mouseOverHandler );
			addEventListener( MouseEvent.MOUSE_OUT, mouseOutHandler );
			_textRightEdge = _titleTxt.width - _bg.width + _sideMargin;
		} else {
			if( hasEventListener( MouseEvent.MOUSE_OVER ) ) removeEventListener( MouseEvent.MOUSE_OVER, mouseOverHandler );
			if( hasEventListener( MouseEvent.MOUSE_OUT ) ) removeEventListener( MouseEvent.MOUSE_OUT, mouseOutHandler );
			_titleTxt.autoSize = TextFieldAutoSize.NONE;
			_titleTxt.width = _bg.width - _sideMargin * 2 - 4;
			_titleTxt.x = _sideMargin;
		}
		addEventListener( MouseEvent.CLICK, clickHandler );
	}
	
	private function clickHandler( e:MouseEvent ):void {
		_textIndex = ( _textIndex == _textList.length - 1 ) ? 0 : ++_textIndex;
		setText( _textList[ _textIndex ] );
		mouseOutHandler();
	}
	private function mouseOverHandler( e:MouseEvent ):void {
		addEventListener( Event.ENTER_FRAME, marqueeHandler );
	}
	private function mouseOutHandler( e:MouseEvent = null ):void {
		removeEventListener( Event.ENTER_FRAME, marqueeHandler );
		Tweener.addTween( _titleTxt, { x: _sideMargin, time: 0.5 } );
	}
	
	/**
	 * テキストの移動
	 * @param	e
	 */
	private function marqueeHandler( e:Event ):void {
		if ( _titleTxt.x > -_textRightEdge ) {
			_titleTxt.x -= _speed;
		}
	}
}