/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/XqpX
 */

package {
    //----------------------------------------------
    //タイマー
    // http://programmingatelier.net/
    //----------------------------------------------

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    import flash.utils.getTimer;
    //import cls.*;
    

    public class timer extends Sprite {
        private var arrNum:Array;
        private var btnMUP:clsButton;
        private var btnMDO:clsButton;
        private var btnSUP:clsButton;
        private var btnSDO:clsButton;
        private var btnStart:clsButton;
        private var btnCls:clsButton;
        private var arrBtn:Array;
        private var arrDat:Array = [
            {text:"カップラーメン(3分)",iTime:180},
            {text:"カップうどん(5分)",iTime:300},
            {text:"昼休み（60分）",iTime:3600}
        ];
        
        
        private var intTime:int;
        private var intSt:int;
        private var intJyoutai:int;
        
        

        
        public function timer():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void         {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.frameRate = 10;        //タイマの数値をUP/DOWNボタンの調整用
            var i:int;
            var numX:Number;
            var numY:Number;
            var numSiz:Number;
            var ledNum:clsLedNum;
            arrNum = new Array();
            intTime = 0;
            intJyoutai = 0;

            btnMUP = new clsButton("▲" , 10, 5, 100, 20,onbMUP,onbMUP,false);
            addChild(btnMUP);
            btnMDO = new clsButton("▼" , 10, 110, 100, 20,onbMDO,onbMDO,false);
            addChild(btnMDO);
            btnSUP = new clsButton("▲" , 120, 5, 100, 20,onbSUP,onbSUP,false);
            addChild(btnSUP);
            btnSDO = new clsButton("▼" , 120, 110, 100, 20,onbSDO,onbSDO,false);
            addChild(btnSDO);
            
            numX = 5;
            numY = 30;
            numSiz = 40;
            for (i = 0; i < 4; i++) {
                ledNum = new clsLedNum("0",numX,numY,numSiz);
                addChild(ledNum);
                arrNum.push(ledNum);
                numX += 30*numSiz/25.0;
                if (i==1) {
                    var ledKug:clsLedKugiri = new clsLedKugiri(":",numX,numY,numSiz);
                    addChild(ledKug);
                    numX += 10 * numSiz / 25.0;
                }
            }
            
            btnStart= new clsButton("START" , 10, 140, 150, 40,onbStart);
            addChild(btnStart);
            btnCls= new clsButton("Cls" , 170, 140, 50, 20,onbCls);
            addChild(btnCls);
            
            arrBtn = new Array();
            numY = 190;
            for (i = 0; i < arrDat.length; i++) {
                var btnSet:clsButton = new clsButton(arrDat[i].text , 10, numY, 210, 20, onSetTim);
                arrBtn.push(btnSet);
                btnSet.name = arrDat[i].iTime;
                addChild(btnSet);
                numY += 25;
            }
            fncDisp();
        }
        
        private function onbMUP(e:Event = null):void {
            var intM:int=intTime/60;
            var intS:int=intTime%60;
            intM++;
            if (intM == 100) { intM = 0;}
            intTime = intM * 60 + intS;
            fncDispNum(intTime);
        }
        private function onbMDO(e:Event=null):void {
            var intM:int=intTime/60;
            var intS:int=intTime%60;
            intM--;
            if (intM == -1) { intM = 99;}
            intTime = intM * 60 + intS;
            fncDispNum(intTime);
        }
        private function onbSUP(e:Event=null):void {
            var intM:int=intTime/60;
            var intS:int=intTime%60;
            intS++;
            if (intS == 60) { intS = 0;}
            intTime = intM * 60 + intS;
            fncDispNum(intTime);
        }
        private function onbSDO(e:Event=null):void {
            var intM:int=intTime/60;
            var intS:int=intTime%60;
            intS--;
            if (intS == -1) { intS = 59;}
            intTime = intM * 60 + intS;
            fncDispNum(intTime);
        }
        private function onbStart(e:Event = null):void {
            if (intJyoutai == 0) {
                intSt = getTimer();
                this.addEventListener(Event.ENTER_FRAME, onRun);
                intJyoutai = 1;
                fncDisp();
            }else {
                var it:int = (getTimer() - intSt) / 1000;
                fncStop(intTime-it);
            }
        }
        private function fncDispNum(iT:int):void {
            arrNum[0].setVal((int(iT  / (10*60)) % 10).toString());
            arrNum[1].setVal((int(iT  / 60) % 10).toString());
            arrNum[2].setVal((int((iT%60)  / 10) % 10).toString());
            arrNum[3].setVal((int(iT%60) % 10).toString());
        }
        public function onRun(e:Event):void {
            var it:int = (getTimer() - intSt) / 1000;
            if (intTime-it <= 0) {
                fncStop(intTime-it);
            } else {
                fncDispNum(intTime-it);
            }
        }
        private function fncStop(iT:int):void {
            intTime = iT;
            if (intTime < 0) { intTime = 0;}
            this.removeEventListener(Event.ENTER_FRAME, onRun);
            fncDispNum(intTime);
            intJyoutai = 0;
            fncDisp();
        }
        private function onbCls(e:Event = null):void {
            intTime = 0;
            fncDispNum(intTime);
        }
        private function fncDisp():void {
            var i:int;
            if (intJyoutai == 0) {
                btnStart.setText("START");
                btnMUP.enable(true);
                btnMDO.enable(true);
                btnSUP.enable(true);
                btnSDO.enable(true);
                btnCls.enable(true);
                for (i = 0; i < arrBtn.length; i++) {
                    arrBtn[i].enable(true);
                }
            }else {
                btnStart.setText("STOP");
                btnMUP.enable(false);
                btnMDO.enable(false);
                btnSUP.enable(false);
                btnSDO.enable(false);
                btnCls.enable(false);
                for (i = 0; i < arrBtn.length; i++) {
                    arrBtn[i].enable(false);
                }
            }
        }
        private function onSetTim(e:Event = null):void {
            intTime = e.target.name;
            fncDispNum(intTime);
        }
    }
}
//-------------------------------------------------------
//package cls {
    //----------------------------------------------
    //ボタンクラス:TextFieldをボタンのように使う
    //   長押し(LongPress)の対応
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.MouseCursor;
    import flash.ui.Mouse;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.getTimer;
    
//    public class  clsButton extends TextField {
    class  clsButton extends TextField {
        private var tfFormat:TextFormat;
        private var bolEnable:Boolean;
        private var fncChk:Function;
        private var fncLongPress:Function;
        private var intTim:int;
        
        //ボタンクラス:TextFieldをボタンのように使う
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:ボタンのサイズ
        // fChk:クリックしたときの関数「fChk(e:MouseEvent):void」
        // fLongPress:ボタンの長押ししたときの関数「fボタンの長押し():void」
        // bItalic：ボタンの文字をItalicにするか？
        public function clsButton(sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number , fChk:Function=null,
                fLongPress:Function=null,bItalic:Boolean=true) {
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = true;
            this.borderColor = 0xffffff;
            this.background = true;
            this.backgroundColor = 0x77dd77;
            this.textColor = 0xffffff;
            this.selectable = false;
            tfFormat = new TextFormat();
            tfFormat.align = TextFormatAlign.CENTER;
            tfFormat.size = nHeight *0.8;
            tfFormat.italic = bItalic;
            this.setTextFormat(tfFormat);
            bolEnable = false;
            fncChk = fChk;
            fncLongPress = fLongPress;
            this.enable(true);
        }
        //表示文字の変更
        // sText:表示する文字
        public function setText(sText:String):void {
            this.text = sText;
            this.setTextFormat(tfFormat);
        }
        //ボタンの有効(bflg=true)･無効(bflg=false)
        public function enable(bflg:Boolean):void {
            if (bflg == bolEnable) { return; }
            bolEnable = bflg;
            if (bolEnable) {
                if (fncChk != null) {this.addEventListener(MouseEvent.CLICK, fncChk);}
                this.addEventListener(MouseEvent.ROLL_OVER, onOver);
                this.addEventListener(MouseEvent.ROLL_OUT, onOut);
                if (fncLongPress != null) {
                    this.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
                    this.addEventListener(MouseEvent.MOUSE_UP, onUp);
                }
                this.alpha = 1.0;
            }else {
                if (fncChk != null) {this.addEventListener(MouseEvent.CLICK, fncChk);}
                this.removeEventListener(MouseEvent.ROLL_OVER, onOver);
                this.removeEventListener(MouseEvent.ROLL_OUT, onOut);
                if (fncLongPress != null) {
                    this.removeEventListener(MouseEvent.MOUSE_DOWN, onDown);
                    this.removeEventListener(MouseEvent.MOUSE_UP, onUp);
                }
                this.alpha = 0.5;
            }
        }
        //マウスオーバー処理（ボタンらしく見せる）
        public function onOver(e:MouseEvent):void {
            e.target.backgroundColor = 0x55bb55;
            //Mouse.cursor=flash.ui.MouseCursor.HAND;
        }
        public function onOut(e:MouseEvent):void {
            e.target.backgroundColor = 0x77dd77;
            //Mouse.cursor=flash.ui.MouseCursor.ARROW;
        }
        //長押し(LongPress)の対応
        public function onDown(e:MouseEvent):void {
            intTim = getTimer();
            this.addEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onUp(e:MouseEvent):void {
            this.removeEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onLongPress(e:Event):void {
            //ボタンを押し続けて0.5秒以上たったら長押し
            if (intTim < getTimer() - 500) { fncLongPress(); }
        }
    }
//}
//------------------------------------------------------------------
//package cls {
    //----------------------------------------------
    //デジタル数字クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;

//    public class clsLedNum extends Sprite {
    class clsLedNum extends Sprite {
        //デジタル数字形状（7形状*6点）
        private const arrPoint1:Array = [
            [7,0],[20,0],[23,3],[20,6],[7,6],[4,3],
            [21,7],[21,20],[24,23],[27,20],[27,7],[24,4],
            [21,28],[21,41],[24,44],[27,41],[27,28],[24,25],
            [7,42],[20,42],[23,45],[20,48],[7,48],[4,45],
            [0,28],[0,41],[3,44],[6,41],[6,28],[3,25],
            [0,7],[0,20],[3,23],[6,20],[6,7],[3,4],
            [7,21],[20,21],[23,24],[20,27],[7,27],[4,24]
        ];
        //数字（文字）に対する形状の表示ON(=1)・OFF(=0)
        // 16進対応
        private const arrFlg:Array = [
            {code:"",flg:[0,0,0,0,0,0,0]},
            {code:"-",flg:[0,0,0,0,0,0,1]},
            {code:"0",flg:[1,1,1,1,1,1,0]},
            {code:"1",flg:[0,1,1,0,0,0,0]},
            {code:"2",flg:[1,1,0,1,1,0,1]},
            {code:"3",flg:[1,1,1,1,0,0,1]},
            {code:"4",flg:[0,1,1,0,0,1,1]},
            {code:"5",flg:[1,0,1,1,0,1,1]},
            {code:"6",flg:[1,0,1,1,1,1,1]},
            {code:"7",flg:[1,1,1,0,0,0,0]},
            {code:"8",flg:[1,1,1,1,1,1,1]},
            {code:"9",flg:[1,1,1,1,0,1,1]},
            {code:"A",flg:[1,1,1,0,1,1,1]},
            {code:"B",flg:[0,0,1,1,1,1,1]},
            {code:"C",flg:[1,0,0,1,1,1,0]},
            {code:"D",flg:[0,1,1,1,1,0,1]},
            {code:"E",flg:[1,0,0,1,1,1,1]},
            {code:"F",flg:[1,0,0,0,1,1,1]},
        ];
        private const numD0:Number = 25.0;
        private var numDD:Number;    //数字幅
        private var numAng:Number;    //数字の傾き
        private var strCod:String;    //表示中の数字（文字）
        //デジタル数字
        // sCod:数字（文字）"","-","0"-"9","A"-"F"
        // nX,nY:位置
        // nSiz:数字幅
        // nAng:数字の傾き
        public function clsLedNum(sCod:String , nX:Number, nY:Number, 
                    nSiz:Number = 25.0, nAng:Number = 10 ) {
            strCod = sCod.toUpperCase();
            numDD = nSiz/numD0;
            numAng = nAng * Math.PI / 180;
            this.x = nX;
            this.y = nY;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            DispNum();
        }
        //表示数字（文字）の変更
        // sCod:数字（文字）
        public function setVal(sCod:String):void {
            if (strCod == sCod.toUpperCase()) { return; }
            strCod = sCod.toUpperCase();
            DispNum();
        }
        //数字（文字）の表示
        private function DispNum():void {
            graphics.clear();
            var no:int = 0;    //対象外は””と同じ扱いにする
            var i:int;
            for (i = 0; i < arrFlg.length; i++) {
                if (arrFlg[i].code == strCod) {no = i; }
            }
            for (i = 0; i < 7; i++) {
                var ic:uint = 0x00ff00;    //表示ONのとき
                var ar:Number =1.0;
                if (arrFlg[no].flg[i] == 0) {    //表示OFFの時
                    ic = 0x888888;
                    ar = 0.2;
                }
                dispSeg(i, ic,ar);
            }
        }
        //1形状の表示
        // no:形状のNO
        // ic:カラー
        // ar:alpha値
        private function dispSeg(no:int,ic:uint,ar:Number):void {
            var i:int;
            var dx:Number;
            graphics.lineStyle(1, ic,0);
            graphics.beginFill(ic,ar);
            dx = (48 - arrPoint1[no * 6 ][1]) * numAng;
            graphics.moveTo((arrPoint1[no*6][0]+dx)*numDD, (arrPoint1[no*6][1])*numDD);
            for (i = 1; i < 6; i++) {
                dx = (48 - arrPoint1[no * 6 + i][1]) * numAng;
                graphics.lineTo((arrPoint1[no*6+i][0]+dx)*numDD, (arrPoint1[no*6+i][1])*numDD);
            }
            graphics.endFill();
        }
    }
//}
//-----------------------------------------------------------------------
//package cls {
    //----------------------------------------------
    //デジタル数字の区切り（":"）クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;

    //public class clsLedKugiri extends Sprite {
    class clsLedKugiri extends Sprite {
        //デジタル数字形状（2形状*4点）
        private var arrPoint1:Array = [
            [0,30],[5,30],[5,35],[0,35],
            [0,20],[5,20],[5,15],[0,15]
        ];
        //文字に対する形状の表示ON(=1)・OFF(=0)
        private var arrFlg:Array = [
            {code:"",flg:[0,0]},
            {code:":",flg:[1,1]}
        ];
        private var numD0:Number = 25.0;
        private var numDD:Number;    //数字幅
        private var numAng:Number;    //数字の傾き
        private var strCod:String;    //表示中の数字（文字）
        //デジタル数字の区切り
        // sCod:文字":",""
        // nX,nY:位置
        // nSiz:数字幅
        // nAng:数字の傾き
        public function clsLedKugiri(sCod:String ,
            nX:Number, nY:Number, nSiz:Number = 25.0, nAng:Number = 10 ) {
            strCod = sCod.toUpperCase();
            numDD = nSiz/numD0;
            numAng = nAng * Math.PI / 180;
            this.x = nX;
            this.y = nY;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            DispKugiri();
        }
        //文字の変更
        // sCod:数字の区切り
        public function setVal(sCod:String):void {
            strCod = sCod.toUpperCase();
            DispKugiri();
        }
        //数字（文字）の表示
        private function DispKugiri():void {
            graphics.clear();
            var no:int = 0;    //対象外は””と同じ扱いにする
            var i:int;
            for (i = 0; i < arrFlg.length; i++) {
                if (arrFlg[i].code == strCod) {no = i; }
            }
            for (i = 0; i < 2; i++) {
                var ic:uint = 0x00ff00;    //表示ONのとき
                var ar:Number =1.0;
                if (arrFlg[no].flg[i] == 0) {    //表示OFFの時
                    ic = 0x888888;
                    ar = 0.2;
                }
                dispSeg(i, ic,ar);
            }
        }
        //1形状の表示
        // no:形状のNO
        // ic:カラー
        // ar:alpha値
        private function dispSeg(no:int,ic:uint,ar:Number):void {
            var i:int;
            var dx:Number;
            
            graphics.lineStyle(1, ic,0);
            graphics.beginFill(ic,ar);
            dx = (48 - arrPoint1[no * 4 ][1]) * numAng;
            graphics.moveTo((arrPoint1[no*4][0]+dx)*numDD, (arrPoint1[no*4][1])*numDD);
            for (i = 1; i < 4; i++) {
                dx = (48 - arrPoint1[no * 4 + i][1]) * numAng;
                graphics.lineTo((arrPoint1[no*4+i][0]+dx)*numDD, (arrPoint1[no*4+i][1])*numDD);
            }
            graphics.endFill();
        }
    }
//}