/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Xe7B
 */

package {
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.media.Video;
    import flash.media.Camera;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var _cam:Camera;
        private var _vid:Video;
        private var _bmpd:BitmapData;
        private var _cbRect:Sprite;
        private var _color:uint = 0xFFFFFF;
        private var _red:Array;
        private var _green:Array;
        private var _blue:Array;
        private var _ball:Sprite;
        
        public function FlashTest() {
            // write as3 code here..
            _cam = Camera.getCamera();
            _cam.setMode(320, 240, 15);
            _vid = new Video(320, 240);
            _vid.attachCamera(_cam);
            
            _bmpd = new BitmapData(320, 240, false);
            addChild(new Bitmap(_bmpd));
            _cbRect = new Sprite();
            addChild(_cbRect);
            
            _ball = new Sprite();
            _ball.graphics.beginFill(0x0000FF);
            _ball.graphics.drawCircle(0, 0, 40);
            _ball.graphics.endFill();
            addChild(_ball);
            
            makePalletArray();
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function makePalletArray():void
        {
            _red = new Array();
            _green = new Array();
            _blue = new Array();
            
            var levels:int = 4;
            var div:int = 256 / levels;
            for(var i:int = 0;i < 256;i++)
            {
                var value:Number = Math.floor(i / div) * div;
                _red[i] = value << 16;
                _red[i] = value << 8;
                _red[i] = value;
            }

        }

        private function onClick(e:MouseEvent):void
        {
            _color = _bmpd.getPixel(mouseX, mouseY);
        }
        
        private function onEnterFrame(e:Event):void
        {
            _bmpd.draw(_vid, new Matrix(-1, 0, 0, 1, _bmpd.width, 0));
            _bmpd.paletteMap(_bmpd, _bmpd.rect, new Point(), _red, _green, _blue);
            var rect:Rectangle = _bmpd.getColorBoundsRect(0xFFFFFF, _color, true);
            
            _cbRect.graphics.clear();
            _cbRect.graphics.lineStyle(1, 0xFF0000);
            _cbRect.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            
            if(!rect.isEmpty())
            {
                var xCenter:Number = rect.x + rect.width / 2;
                var yCenter:Number = rect.y + rect.height / 2;
                _ball.x = xCenter;
                _ball.y = yCenter;
            }

        }


    }
}