/**
 * Copyright russ ( http://wonderfl.net/user/russ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/XK6I
 */

package  {

import com.gskinner.motion.GTween;
import com.gskinner.motion.plugins.*;
import com.gskinner.motion.easing.*;

import flash.display.Shape;

import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

[SWF(widthPercent="100", heightPercent="100")]
public class GTweenSimpleSequencing extends Sprite {

    // Constants:

    // Public Properties:
    public var ball:Sprite;
    private var _logger:TextField = new TextField();

    // Protected Properties:
    private var tween1:GTween;
    private var tween2:GTween;
    private var tween3:GTween;
    private var tween4:GTween;

    // Initialization:
    public function GTweenSimpleSequencing() {
        stage.align = StageAlign.TOP_LEFT;
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.color = 0xFFFFFF; //0x000000;

        MotionBlurPlugin.install();

        ball = new Sprite();
        ball.graphics.clear();
        ball.graphics.beginFill(0x111111);
        ball.graphics.drawCircle(0,0,50);//stage.stageWidth/2, stage.stageHeight/2, 50);
        addChild(ball);

        // MotionBlurPlugin is the only plugin that has enabled set to false by default.
        // Instead of setting MotionBlurEnabled on pluginData for all of the tweens
        // you could enable it by default for all tweens with:
        // MotionBlurPlugin.enabled = true;

        tween4 = new GTween(ball, 0.4, {y:50}, {autoPlay:false, delay:0.5, ease:Sine.easeInOut}, {MotionBlurEnabled:true});
        tween3 = new GTween(ball, 0.4, {x:50}, {autoPlay:false, nextTween:tween4, delay:0.5, ease:Sine.easeInOut}, {MotionBlurEnabled:true});
        tween2 = new GTween(ball, 0.4, {y:350}, {autoPlay:false, nextTween:tween3, delay:0.5, ease:Sine.easeInOut}, {MotionBlurEnabled:true});
        tween1 = new GTween(ball, 0.5, {x:500}, {nextTween:tween2, delay:0.5, ease:Sine.easeInOut}, {MotionBlurEnabled:true});
        tween4.nextTween = tween1;

        tween1.onComplete = onTweenComplete;
        tween2.onComplete = onTweenComplete;
        tween3.onComplete = onTweenComplete;
        tween4.onComplete = onTweenComplete;

        stage.addEventListener(Event.RESIZE, onStageResize);
        addChild(_logger);
        _logger.text = "Resize the window!";
        _logger.autoSize = TextFieldAutoSize.CENTER;
        _ReCenterText();
    }

    private function _ReCenterText():void {
        _logger.x = stage.stageWidth/2 - _logger.width/2;
        _logger.y = stage.stageHeight/2 - _logger.height/2;
    }

    private function log(Msg:String):void {
        _logger.text = Msg + "\n" + "Stage size: " +  stage.stageWidth + ", " + stage.stageHeight;
        _ReCenterText();
    }

    private function onStageResize(event:Event):void {
        for each (var tween:GTween in [tween1, tween2, tween3, tween4]) {
            tween.paused = true;
        }
        tween1.setValues({x:stage.stageWidth - 50,
                          y:50});
        tween2.setValues({x:stage.stageWidth - 50,
                          y:stage.stageHeight - 50});
        tween3.setValues({x:50,
                          y:stage.stageHeight - 50});
        tween4.setValues({x:50,
                          y:50});
        log("Resized!!");
    }

    private function onTweenComplete(tween:GTween):void {
        if(tween == tween1) {
            log("Now in TOP RIGHT");
        } else if (tween == tween2) {
            log("Now in BOTTOM RIGHT");
        } else if (tween == tween3) {
            log("Now in BOTTOM LEFT");
        } else if (tween == tween4) {
            log("Now in TOP LEFT");
        }

    }

}
}
