/**
 * Copyright Antonio.Meneses ( http://wonderfl.net/user/Antonio.Meneses )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Wtlv
 */

// forked from darknet's Sandy Select Box Ray
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import sandy.core.data.Matrix4;
    import sandy.core.data.Point3D;
    import sandy.core.scenegraph.Camera3D;
    import sandy.core.scenegraph.Group;
    import sandy.core.scenegraph.Shape3D;
    import sandy.events.Shape3DEvent;
    import sandy.materials.Appearance;
    import sandy.materials.attributes.LightAttributes;
    import sandy.materials.attributes.LineAttributes;
    import sandy.materials.attributes.MaterialAttributes;
    import sandy.materials.ColorMaterial;
    import sandy.materials.Material;
    import sandy.math.Matrix4Math;
    import sandy.core.Scene3D;
    import sandy.primitive.Box;
    import sandy.primitive.Plane3D;
    import sandy.view.*;
    
    /**
     * ...
     * @author Darknet
     * 
     * Credit by: lovexylitol
     * -Converting 2D to 3D coordinates
     * 
     * Information: Ray Casting. This will move along x and z axis. y = 0.
     * Note this is just a test. Just play with the settings.
     * Cam has z = -1
         * selectionplane.enableForcedDepth = true;
         * selectionplane.depth = -1;
     * 
     */
    
    [SWF(width="464", height="464", backgroundColor="#FFFFFF", frameRate="30")]
    public class SandyRayPlane6 extends Sprite{
        
        public var scene:Scene3D;
        public var camera:Camera3D
        public var g:Group = new Group("myGroup");
        public var box:Box = new Box('box');
        public var ground:Shape3D = new Plane3D('ground', 256, 256, 10, 10, Plane3D.ZX_ALIGNED, 'quad');
        public var HEIGHT:Number = 464; //Screen Size
        public var WIDTH:Number = 464; //Screen Size
        public var selectionplane:Shape3D = new Plane3D('selectplane', 64, 32, 1, 1, Plane3D.ZX_ALIGNED, 'quad');
        public var startpoint:Point3D = new Point3D();
        public var endpoint:Point3D = new Point3D();
        
        public function SandyRayPlane6(){
            camera = new Camera3D(464,464);
            camera.far = 500;
            camera.near = 0;
            camera.y = 500;
            //camera.z = 500;
            camera.z = -500;
            camera.lookAt(0, 0, 0);
            var root:Group = createScene();
            scene = new Scene3D( "scene", this, camera, root );
            
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
            stage.addEventListener(MouseEvent.MOUSE_MOVE, frameMouseMove);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, addKey, false, 0, true);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, select_down);
            stage.addEventListener(MouseEvent.MOUSE_UP, select_out);
            
            var materialAttr:MaterialAttributes = new MaterialAttributes(
            new LineAttributes( 0.5, 0x2111BB, 0.4 ),
            new LightAttributes( true, 0.1));
            
            var material:Material = new ColorMaterial( 0x999999, 1, materialAttr );
            var app:Appearance = new Appearance( material );
            
            material = new ColorMaterial( 0xFFCC33, 1, materialAttr );
            app = new Appearance( material );
            ground.appearance = app;
            ground.useSingleContainer = false;
                        selectionplane.enableForcedDepth = true;
            selectionplane.depth = -1;
        }
        
        public function select_down(e:Event):void {
            startpoint = S2W(mouseX, mouseY);
            stage.addEventListener(MouseEvent.MOUSE_OVER, select_over);
        }
        
        public function select_over(e:Event):void {
            endpoint= S2W(mouseX, mouseY);
            var minpoint:Point3D = new Point3D();
            var maxpoint:Point3D = new Point3D();
            
            if (startpoint.z < endpoint.z) {
                minpoint.z = startpoint.z;
                maxpoint.z = endpoint.z;
                
            }else {
                minpoint.z = endpoint.z
                maxpoint.z = startpoint.z;
            }
            
            if (startpoint.x < endpoint.x) {
                minpoint.x = startpoint.x;
                maxpoint.x = endpoint.x;
            }else {
                minpoint.x = endpoint.x;
                maxpoint.x = startpoint.x;
            }            
            
            selectionplane.geometry.aVertex[0].x = minpoint.x;
            selectionplane.geometry.aVertex[0].z = minpoint.z;
            selectionplane.geometry.aVertex[1].x = maxpoint.x;
            selectionplane.geometry.aVertex[1].z = minpoint.z;
            selectionplane.geometry.aVertex[2].x = minpoint.x;
            selectionplane.geometry.aVertex[2].z = maxpoint.z;
            selectionplane.geometry.aVertex[3].x = maxpoint.x;
            selectionplane.geometry.aVertex[3].z = maxpoint.z;
            selectionplane.changed = true;//this will tell the object is change 
            
        }
        
        public function select_out(e:Event):void {
            stage.removeEventListener(MouseEvent.MOUSE_OVER, select_over);
        }
        
        
        public function frameMouseMove(e:MouseEvent):void {
            var bp:Point3D = S2W(mouseX, mouseY);
            box.x = bp.x;
            box.y = bp.y;
            box.z = bp.z;
        }
        
        public function S2W(sx:Number, sy:Number):Point3D {
            var Mcmm:Matrix4 = camera.modelMatrix;
            
            var NEAR:Number = 1;
            var FAR:Number = 500;
            
            var z1:Number = NEAR;
            var x1:Number = (sx - WIDTH/2) * z1 / camera.focalLength;
            var y1:Number = ((HEIGHT / 2 - sy) * z1 / camera.focalLength);
            
            var z2:Number = FAR;
            var x2:Number = (sx - WIDTH/2) * z2 / camera.focalLength;
            var y2:Number = ((HEIGHT / 2 - sy) * z2 / camera.focalLength);
            
            var p1:Point3D = new Point3D(x1,y1,z1);
            var p2:Point3D = new Point3D(x2,y2,z2);
            
            var rp1:Point3D = Matrix4Math.transform(Mcmm,p1);
            var rp2:Point3D = Matrix4Math.transform(Mcmm,p2);
            
            var t:Number = rp2.y / (rp2.y - rp1.y);
            var Px:Number = (rp1.x-rp2.x)*t+rp2.x;
            var Pz:Number = (rp1.z - rp2.z) * t + rp2.z;
            
            return new Point3D(Px,0,Pz);
        }
        
        private function enterFrameHandler(event:Event) : void {
            scene.render();
        }
        
        private function createScene():Group {
            g.addChild(box);
            g.addChild(ground);
            g.addChild(selectionplane);
            return g;
        }
        
        public function addKey(e:KeyboardEvent):void {
            if (e.keyCode == 39) {//right
                camera.x+=10;
            }
            if (e.keyCode == 37) {//left
                camera.x-=10;
            }
        }
        
    }
    
}