// sample test from
// http://www.libspark.org/browser/as3/BetweenAS3/trunk/tests/fp10/TweenTest.as
/*
 * BetweenAS3
 * 
 * Licensed under the MIT License
 * 
 * Copyright (c) 2009 BeInteractive! (www.be-interactive.org) and
 *                    Spark project  (www.libspark.org)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 */
package
{
	import flash.display.MovieClip;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Cubic;
	import org.libspark.betweenas3.easing.Exponential;
	import org.libspark.betweenas3.easing.Linear;
	import org.libspark.betweenas3.tweens.ITween;
	
	/**
	 * @author	yossy:beinteractive
	 */
	public class TweenTest extends Sprite
	{
		public function TweenTest()
		{
			addEventListener(Event.ADDED_TO_STAGE, initialize);
		}
		
		private function initialize(e:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, initialize);
			
			var bg:Shape = new Shape();
			bg.graphics.beginFill(0xffffff);
			bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			bg.graphics.endFill();
			addChild(bg);
			
			var mc1:MovieClip = new MovieClip();
			mc1.graphics.beginFill(0);
			mc1.graphics.drawRect(-10, -10, 20, 20);
			mc1.graphics.endFill();
			addChild(mc1);
			
			var mc2:MovieClip = new MovieClip();
			mc2.graphics.beginFill(0x666666);
			mc2.graphics.drawRect(-10, -10, 20, 20);
			mc2.graphics.endFill();
			addChild(mc2);
			
			mc1.x = 100;
			mc1.y = 100;
			
			mc2.x = 200;
			mc2.y = 100;
			
			_t = BetweenAS3.parallel(
				BetweenAS3.serial(
					BetweenAS3.tween(mc1, {$x: 100}, null, 1, Exponential.easeIn),
					BetweenAS3.tween(mc1, {$y: 100}, null, 1, Exponential.easeIn),
					BetweenAS3.tween(mc1, {$x: 0}, {$x: 100}, 1, Exponential.easeIn),
					BetweenAS3.tween(mc1, {$y: 0}, {$y: 100}, 1, Exponential.easeIn)
				),
				BetweenAS3.serial(
					BetweenAS3.tween(mc2, {$x: 100}, null, 1, Cubic.easeOut),
					BetweenAS3.tween(mc2, {$y: 100}, null, 1, Cubic.easeOut),
					BetweenAS3.tween(mc2, {$x: 0}, {$x: 100}, 1, Cubic.easeOut),
					BetweenAS3.tween(mc2, {$y: 0}, {$y: 100}, 1, Cubic.easeOut)
				)
			);
			
			_t.play();
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler)
		}
		
		private var _t:ITween;
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			if (_t.isPlaying) {
				_t.stop();
			}
			else {
				if (_t.position == _t.duration) {
					_t.gotoAndPlay(0);
				}
				else {
					_t.play();
				}
			}
		}
	}
}