/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Wm1q
 */

package {
    import flash.text.TextField;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {         
            
          deb = new TextField();   addChild(deb);  
          deb.width = 320;         deb.height = 240;  
          deb.mouseEnabled=false;
            
            
          vecKey = new Vector.<Boolean>(512,false);
          vecPress = new Vector.<int>(512, false);
          var i:int;  for (i = 0; i < 512; i++) { vecKey[i] = 0; vecPress[i] = -1; }  
          var num:int;
 
          mw = 24; mh = 24;
          num = mw*mh;
          vecGrid = new Vector.<int>(num,false);
          vecUGrid = new Vector.<int>(num, false);
          for (i = 0; i <num; i++) { vecGrid[i] = 0;}
          for (i = 0; i <num; i++) { vecUGrid[i] = -1;}
 
          vecGroup = new Vector.<xGroup>(0,false);
          var g:xGroup;
          for (i = 0; i < 4; i++)
          {
              g = new xGroup(); vecGroup.push(g);
              g.team = i;              
              if (i == 1 || i == 2) { g.human = 0; }
          }//nexti
 
 
          vecUnit = new Vector.<xUnit>(0, false);
          var a:xUnit; var k:int;
          for (i = 0; i < 16; i++)
          {
               a = new xUnit(); addUnit(a);
               //a.tx = Math.random()*mw; 
               //a.ty = Math.random()*mh; 
               a.team = Math.random()*4;
               for (k = 0; k < 32; i++)
               { if (placeUnit(a,Math.random()*mw,Math.random()*mh) == true) { break; }  }
          }//nexti
 
 
          stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
          stage.addEventListener(KeyboardEvent.KEY_UP, kup);
          stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        
        public var deb:TextField;
        
        public function kdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; vecPress[e.keyCode] = ktime; }
        public function kup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        
        public function isPress(k:int):Boolean {  if (k<0||k>=512){return false;} return vecPress[k] == ktime;  }
        
        public var vecKey:Vector.<Boolean>;
        public var vecPress:Vector.<int>;
        
        public var ktime:int = 0;
        
        public var mw:int = 0;
        public var mh:int = 0;
        public var vecGrid:Vector.<int>;
        public var vecUGrid:Vector.<int>;
        
        public var vecUnit:Vector.<xUnit>;
        public var vecGroup:Vector.<xGroup>;
        
        public var vecTeamColor:Vector.<uint> = Vector.<uint>([0x880000,0x008800, 0x000088, 0x888800]);


        
        public var curGroup:int = 0;               

        public var curTurn:int = 0;

        public var nextTurn:int = 0;

        public var curId:int = 1;
        public function addUnit(a:xUnit):void
        {
           vecUnit.push(a);  a.id = curId;   curId += 1;
        }//addunit
        
        public function placeUnit(a:xUnit, ax:int, ay:int):Boolean
        {
          if (ax < 0) { return false; } if (ay < 0) { return false; }
          if (ax >= mw) { return false; } if (ay >= mh) { return false; }
          
          var t:int;
          t = vecUGrid[(ay*mw)+ax];
          if (t != -1) { return false; }     
            
          t = vecUGrid[(a.ty*mw)+a.tx];
          if (a.id == t) { vecUGrid[(a.ty*mw)+a.tx] = -1;  }  
        
          a.tx = ax; a.ty = ay;
          vecUGrid[(ay*mw)+ax] = a.id;     
            
          return true;
        }//placeunit


        
        public function getNextUnit(cur:int, t:int):int
        {
            var num:int; var i:int; var k:int; 
            var ret:int; var a:xUnit;
            num = vecUnit.length;
            k = cur+1;
            if (k >= num || k < 0) { k = 0;}
            
            for (i = 0; i < num; i++)
            {
                a = vecUnit[k];
                if (a.team == t) { return k; }
                k+=1; if (k >= num) { k = 0;}               
            }//nexti
            
            return cur;
        }//getnextunit

        
        public function getUnit(i:int, t:int):xUnit
        {
           if (i < 0 || i>= vecUnit.length ) { return null; }
           var a:xUnit;
           a = vecUnit[i];
           if (a.team != t) { return null; }
           return a;
        }//getunit


        
        
        public function onEnter(e:Event):void
        {
            
           graphics.clear();
           graphics.lineStyle(2,0);
           
           var i:int;           var num:int;          var a:xUnit;
           var cw:Number; var ch:Number;
           var ax:Number; var ay:Number;
           var xg:xGroup;
           var curUnit:int;
      
           cw = 16; ch = 16;
           graphics.drawRect(0,0,mw*cw,mh*ch);

        
           xg = vecGroup[curGroup];           
           curUnit = xg.curUnit;
            
           num = vecUnit.length;
           for (i = 0; i < num; i++)
           {
             a = vecUnit[i];
             
             graphics.beginFill(vecTeamColor[a.team], 0.5);
             graphics.drawRect(a.tx*cw,a.ty*ch,cw,ch);   
             graphics.endFill();
             
             if (curUnit == i)
             {
               ax = a.tx*cw+cw*0.5; ay = a.ty*ch+ch*0.5;
               graphics.beginFill(0,0.2);   graphics.drawCircle(ax,ay,8); graphics.endFill();
             }//endif
             
           }//nexti 
           

                   
            if (xg.human > 0) {  moveUnit(xg); }
            else { compMove(xg); }

            if (xg.human > 0)
            {  if (isPress(Keyboard.N)) { nextTurn = 1; } }
             
             
            if (nextTurn == 1)
            {               
               curGroup += 1;
               if (curGroup >= vecGroup.length) { curTurn += 1; curGroup = 0; }
               
               deb.text = "TURN "+curTurn +"\nTEAM " + curGroup;
               
               nextTurn = 0;  
            }//endif



            ktime += 1;            
        }//onenter
        
        
        public function moveUnit(xg:xGroup):void
        {
           var a:xUnit;    var pteam:int;     var curUnit:int;
           var ax:int; var ay:int; var am:int;
           
           pteam = xg.team;      curUnit = xg.curUnit;
           
            
           a = getUnit(curUnit, pteam);
           if (a == null) { curUnit = getNextUnit(-1, pteam); }
           a = getUnit(curUnit, pteam);
           if (a == null) { deb.text = "NO UNITS - TEAM: "+pteam; return; } 
            
           am = 0; ax = 0; ay = 0;
    
           if (isPress(Keyboard.UP)) { am = 1; ay = -1; }
           else if (isPress(Keyboard.DOWN)) { am = 1; ay = 1; }
           else if (isPress(Keyboard.LEFT)) { am = 1; ax = -1; }
           else if (isPress(Keyboard.RIGHT)) { am = 1; ax = 1; }
           else if (isPress(Keyboard.SPACE)) { curUnit = getNextUnit(curUnit, pteam); } 
    
           if (am > 0)
           {
               placeUnit(a, a.tx+ax,a.ty+ay);
           }     
    
           xg.curUnit = curUnit;           
        }//moveunit
        
        
        public function compMove(xg:xGroup):void
        {
           var a:xUnit;    var pteam:int;     var curUnit:int;
           var ax:int; var ay:int; var am:int;
           
           pteam = xg.team;      curUnit = xg.curUnit;
            
           a = getUnit(curUnit, pteam);
           if (a == null) { curUnit = getNextUnit(-1, pteam); }
           a = getUnit(curUnit, pteam);
           if (a == null) {  nextTurn = 1;  return; } 
            
           if (a.lastTurn == curTurn) { nextTurn = 1; return; }  
            
           //randomly move this unit
           am = 0; ax = 0; ay = 0;
           am = Math.random() * 8;
           if ( (am & 1) >0) {  ax = Math.random() < 0.5 ? -1 : 1; }
           if ( (am & 2) >0) {  ay = Math.random() < 0.5 ? -1 : 1; }                 
  
           am = placeUnit(a, a.tx+ax,a.ty+ay) ? 1 : 0;
 
           if (am > 0) { a.lastTurn = curTurn; } //todo  only do this when out of moves 
  
           if (Math.random() < 0.5  ) {  curUnit = getNextUnit(curUnit, pteam);  }          
  
            xg.curUnit = curUnit;           
            
            //limit moves per turn (for now to avoid inf taking)
            xg.tick += 1;  if (xg.tick >= 32) { xg.tick = 0; nextTurn = 1; }            
        }//compmove        
        
        
        
    }//classend
}

internal class xUnit
{
    
  public var id:int = 0;
  public var tx:int = 0;
  public var ty:int = 0;
  public var team:int = 0;

  public var lastTurn:int = -1;  
    
}//xunit

internal class xGroup
{
  public var human:int = 1;
    
  public var team:int = 0;
  public var curUnit:int = -1;    

  public var tick:int = 0;
    
}//xboss













