/**
 * Copyright qaddodi ( http://wonderfl.net/user/qaddodi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/WT77
 */

package {
    import flash.display.Stage;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class Simulation extends Sprite {
        public var textbox:TextField = new TextField();
        public var trace:String;
        public var averageBC:Number;
        public var averageTG:Number;
        public var averageAPC:Number;
        public var averageChildren:Number;
        public var stemCellOutputArray:Array = new Array();
        public var stem_cell_array:Array = new Array();
        public var ent_cell_array:Array = new Array();
        public var i:int;
        public var j:int;
        public var timer:Timer = new Timer(1,0); 
        
        public function Simulation() {
            
            // write as3 code here..
            for(i=0; i < 50; i ++){
                stem_cell_array.push(new Stem_Cell());
                addChild(stem_cell_array[i].vis.gfx);
                //addChild(stem_cell_array[i].text);
                stem_cell_array[i].vis.gfx.x =50 + i*stem_cell_array[i].width;
                stem_cell_array[i].text.x = stem_cell_array[i].vis.gfx.x - stem_cell_array[i].width/2;
                stem_cell_array[i].vis.gfx.y = stem_cell_array[i].text.y = stage.stageHeight - 50;
                stem_cell_array[i].text.y += stem_cell_array[i].width;
                
            }
            timer.start();
            timer.addEventListener("timer",step);          
            addChild(textbox);
            
            
        }
        
        public function step(e:TimerEvent):void{

            for(i=0;i<stem_cell_array.length;i++){
                stem_cell_array[i].beta_cat = Math.round(1000*(stem_cell_array[i].beta_cat+1/stem_cell_array[i].apc))/1000;
                stem_cell_array[i].target_genes = Math.round(stem_cell_array[i].target_genes+stem_cell_array[i].beta_cat*1.2);
                stem_cell_array[i].text.text = stem_cell_array[i].apc.toString() + "\n" + stem_cell_array[i].beta_cat.toString() + "\n" + stem_cell_array[i].target_genes.toString();
                if(stem_cell_array[i].target_genes > 500){
                    ent_cell_array.push(new Enterocyte(i,stem_cell_array[i].children,timer.currentCount,stem_cell_array[i].beta_cat));
                    stem_cell_array[i].children++;
                    //stem_cell_array[i].text.text = "C:"+stem_cell_array[i].children+"\nA:"+stem_cell_array[i].apc +"\nB:"+ stem_cell_array[i].beta_cat +"\nT:"+ stem_cell_array[i].target_genes
                    stem_cell_array[i].beta_cat/=2;
                    stem_cell_array[i].target_genes /=2;
                    
                }
            }
            for(i=0;i<ent_cell_array.length;i++){
                addChild(ent_cell_array[i].vis.gfx);
                //addChild(ent_cell_array[i].text);
                //ent_cell_array[i].vis.gfx.alpha = (1-((timer.currentCount-ent_cell_array[i].initTime)/ent_cell_array[i].lifeTime));   
                ent_cell_array[i].vis.gfx.x = stem_cell_array[ent_cell_array[i].parent].vis.gfx.x;
                //ent_cell_array[i].vis.gfx.y = stem_cell_array[ent_cell_array[i].parent].vis.gfx.y - stem_cell_array[ent_cell_array[i].parent].width*2*(stem_cell_array[ent_cell_array[i].parent].children-ent_cell_array[i].child);
                ent_cell_array[i].vis.gfx.y = stem_cell_array[ent_cell_array[i].parent].vis.gfx.y - ent_cell_array[i].height*2*(stem_cell_array[ent_cell_array[i].parent].children-ent_cell_array[i].child);
                
                ent_cell_array[i].text.x = ent_cell_array[i].vis.gfx.x-ent_cell_array[i].width/2;
                ent_cell_array[i].text.y = ent_cell_array[i].vis.gfx.y+ent_cell_array[i].width;
                
                
                if(timer.currentCount-ent_cell_array[i].initTime>ent_cell_array[i].lifeTime){
                    //removeChild(ent_cell_array[i].text);
                    removeChild(ent_cell_array[i].vis.gfx);
                    ent_cell_array.removeAt(i);
                }
                
            }
            
            

            
            
            

            
            //trace = stem_cell_array[3].apc + " , " + stem_cell_array[3].beta_cat +" , "+ stem_cell_array[3].target_genes;
            averageBC = 0;
            averageTG = 0;
            averageAPC = 0;
            averageChildren=0;
            for(i=0; i<stem_cell_array.length;i++){
                averageBC += stem_cell_array[i].beta_cat;
                averageTG += stem_cell_array[i].target_genes;
                averageAPC += stem_cell_array[i].apc;
                averageChildren += stem_cell_array[i].children;
            }
            
            averageAPC/= stem_cell_array.length;
            averageChildren/= stem_cell_array.length;
            averageBC/=stem_cell_array.length;
            averageTG/=stem_cell_array.length; 
            
            trace = "Time: "+timer.currentCount.toString()+"\nChildren: "+ent_cell_array.length.toString()+"\nAverage B-cat: "+averageBC.toString()+"\nAverage T-genes: "+averageTG.toString(); 
            textbox.text = trace;
            textbox.width=1000;
            
            
           
            if(timer.currentCount==1){
                //USE THI TO DELETE APC
                //stem_cell_array[25].apc=0.01;
            }
                        
            if(timer.currentCount==10000){
                stemCellOutputArray.push(averageAPC,averageBC,averageTG,averageChildren);
            
                
                var outputText:TextField = new TextField();
                //THIS WRItes dWN THE AVERAGE APC, BETA-CAT, TARGET GENES, and CHILDREN
                outputText.text = stemCellOutputArray[0].toString()+"\n"+stemCellOutputArray[1].toString()+"\n"+stemCellOutputArray[2].toString()+"\n"+stemCellOutputArray[3].toString();
                outputText.x=0;
                outputText.y=100;
                outputText.width=1000;
                addChild(outputText);
                timer.stop();
            
            }
            
        }

        
                     
    }
}
import flash.text.TextFormat;
import flash.text.TextField;

import flash.display.Sprite;

class Stem_Cell{
    public var apc:Number = Math.round(1000*Math.random() + 500)/100;
    
    public var beta_cat:Number = 0;
    public var target_genes:Number = 0;
    public var gfx:Sprite = new Sprite();
    public var width:Number = 4;
    public var height:Number = 4;
    public var vis:Visualise = new Visualise(0xFF0000,width,height);
    public var text:TextField = new TextField();
    public var children:int = 0;
    function Stem_Cell(){
        text.text = apc.toString() + "\n" + beta_cat.toString() + "\n" + target_genes.toString();
    } 
}

class Enterocyte{
    public var textFormat:TextFormat = new TextFormat();
    public var gfx:Sprite = new Sprite();
    public var width:Number = 4;
    public var height:Number = 4;
    public var vis:Visualise = new Visualise(0x00FF00,width,height);
    public var text:TextField = new TextField();
    public var parent:int;
    public var child:int;
    public var initTime:int;
    public var lifeTime:int;
    public var beta_cat:Number;
    public var netForceX:Number;
    public var netForceY:Number;
    public var netVelX:Number = 0;
    public var netVelY:Number = 0;
    public var contactBool:Boolean;
    
    function Enterocyte(p:int,c:int,t:int,b:Number){
        beta_cat = b;
        textFormat.size = 9;
        text.defaultTextFormat = textFormat;
       // text.text = c.toString();
       text.text = contactBool.toString();
        lifeTime = Math.round(Math.random()*200+300);
        parent = p;
        child = c;
        initTime = t;
    }
    
}

class Visualise{
    public var gfx:Sprite = new Sprite();
    public function Visualise(color:Number, w:Number, h:Number){
       // gfx.graphics.beginFill(0x000000);
       // gfx.graphics.drawRect((w+1)/2,h-0.5,-w-1,2*h+1);
        //gfx.graphics.endFill();
        
        gfx.graphics.beginFill(color);
        gfx.graphics.drawRect(w/2,h,-w,2*h);
        gfx.graphics.endFill();
        
    }
}





