/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/WO6v
 */

package {
    
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private var canv:BitmapData
        private var forceField:BitmapData
        private var forceResetCount:int = 0, forceResetDelay:int = 90
        private var particles:Vector.<Particle> = new Vector.<Particle>
        private const numParticles:uint = 100000
        
        public function FlashTest() {
            // write as3 code here..
            canv = new BitmapData(400, 400, false, 0x0)
            addChild(new Bitmap(canv))
            
            forceField = new BitmapData(200, 200, false, 0x0)
            forceField.perlinNoise(50, 50, 4, 5301, false, true, 2 | 4)
            //addChild(new Bitmap(forceField)).alpha = .2
            
            for(var i:int=0; i<numParticles; i++){
                var p:Particle = new Particle
                p.x = Math.random() * canv.width
                p.y = Math.random() * canv.height
                particles.push(p)
            }
            
            addEventListener("enterFrame", loop)
        }
        
        private function loop(e:Event):void {
            if(forceResetCount++ >= forceResetDelay){
                forceResetCount = 0
                forceField.perlinNoise(50, 50, 4, Math.random() * 0xFFFFFF, false, true, 2 | 4)
            }

            //canv.fillRect(canv.rect, 0x0)
            canv.applyFilter(canv, canv.rect, new Point, new BlurFilter(4, 4, 1))
            canv.colorTransform(canv.rect, new ColorTransform(1,1,1,0.9))
            
            for(var i:int=0; i<numParticles; i++){
                var p:Particle = particles[i]
                var vec:uint = forceField.getPixel(p.x * forceField.width/canv.width, p.y * forceField.height/canv.height)
                p.vx += ((vec & 0xFF) - 128) / 500
                p.vy += (((vec >> 8) & 0xFF) - 128) / 500
                p.vx *= 0.95
                p.vy *= 0.98
                p.x += p.vx
                p.y += p.vy
                if(p.x < 0) p.x = canv.width
                else if(p.x > canv.width) p.x = 0
                if(p.y < 0) p.y = canv.height
                else if(p.y > canv.height) p.y = 0
                canv.setPixel(p.x, p.y, 0xffffff)
            }
        }
        
    }
    
}

class Particle {
    public var x:Number, y:Number, vx:Number, vy:Number
    public function Particle() {
        x = y = vx = vy = 0
    }
}
