/**
 * Copyright Alexandr.Viktorovich ( http://wonderfl.net/user/Alexandr.Viktorovich )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/W4Qn
 */

// forked from Zahurdias.Calimero's Animated grass - Jim Bumgardner
﻿﻿﻿// Animated grass - Actonscript 3 Version - Jim Bumgardner, 2008
//
package {
    import flash.display.Shape;
    import flash.events.Event;
    import flash.display.DisplayObject;
    import flash.display.Sprite;

    public class GrassAnimation extends Sprite
    {

        public static var DAMP:Number = 0.9;
        public static var TSPEED:Number = 5;  // turbulence (individual motion)
        private static var WSPEED:Number = 2;   // wind (common motion)
    
        public static var windx:Number = 0;   // Added these initializations for Flash Player 7
        public static var windy:Number = 0;
        private var mc:GrassBlade;
    
        public function GrassAnimation()
        {
            for (var i:int = 0; i <= 100; ++i) {
                mc = new GrassBlade();
                mc.x = i*5;
                mc.y = stage.stageHeight-50;
                this.addChild(mc);
            }
            
            this.addEventListener(Event.ENTER_FRAME, windBlow);
        }
    
        private function windBlow(evt:Event):void
        {
            windx += Math.random()*WSPEED - WSPEED/2;
            windx *= DAMP;
        }
    
        private function setTurb(t:Number):void
        {
            TSPEED = t;
        }
    
        private function setWind(w:Number):void
        {
            WSPEED = w;
        }

    } // end class
} // end package

    // Animated Grass - Actionscript 3 (Grass Blade) - Jim Bumgardner 2008
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.events.*;

    internal class GrassBlade extends Sprite
    {
        private var clr:Number,cx:Number,cy:Number,ex:Number,ey:Number,vx1:Number,vx2:Number;
        private var vy1:Number,vy2:Number,cyR:Number,cxR:Number,exR:Number,eyR:Number;
        
        public function GrassBlade()
        {
            clr = (0x20 + Math.floor(Math.random()*0x45)) << 8;
            cx = cxR = Math.random()*10-5;
            cy = cyR = -(75+Math.random()*50);
            ex = exR = Math.random()*10-5;
            ey = eyR = cyR*2;
            vx1 = 0;
            vx2 = 0;
            vy1 = 0;
            vy2 = 0;
            addEventListener(Event.ENTER_FRAME, bladeMove);
        }

        private function drawBlade():void
        {
          graphics.clear();
          graphics.moveTo(-5,0);
          graphics.beginFill(clr);
          graphics.curveTo(cx-5, cy, ex, ey);
          graphics.curveTo(cx+5, cy, 5, 0);
          graphics.lineTo(-5,0);
          //graphics.endFill();
        }

        private function bladeMove(evt:Event):void
        {
            var _tspeed:Number = GrassAnimation.TSPEED;
            var _damp:Number = GrassAnimation.DAMP;
            
            this.vx1 += Math.random()*_tspeed-_tspeed/2 + GrassAnimation.windx;
            this.vy1 += Math.random()*_tspeed-_tspeed/2;
            this.vx2 += Math.random()*_tspeed-_tspeed/2 + GrassAnimation.windx;
            this.vy2 += Math.random()*_tspeed-_tspeed/2;
            this.vx1 *= _damp;   // damping
            this.vx2 *= _damp;
            this.vy1 *= _damp;
            this.vy2 *= _damp;
            this.cx = this.cxR + this.vx1;
            this.cy = this.cyR + this.vy1;
            this.ex = this.exR + this.vx2 + GrassAnimation.windx;
            this.ey = this.eyR + this.vy2 + GrassAnimation.windy;
            drawBlade();
        }

    } // end class 