/**
 * Copyright telcanty ( http://wonderfl.net/user/telcanty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/VeO0
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;

    //telcanty wonderfl.net

    public class FlashTest extends Sprite {
        
        public var balls:Array;
        public var velocities:Array;

        public var ballCount:int = 2;

        public var size:int = 40;
        
        public var speed:int = 16;

        public function FlashTest() {
            // create arrays
            balls = new Array();
            velocities = new Array();
            // create balls
            for(var i:int = 0; i < ballCount; i++)
            {
                var startX:Number = stage.stageWidth * Math.random();
                var startY:Number = stage.stageHeight * Math.random();
                var ball:Sprite = createBall(0x00FF00,startX,startY);
                    ball.addEventListener(MouseEvent.MOUSE_DOWN, _mouseDown);
                balls[i] = ball;  //balls.push(ball);
                velocities[i] = createVelocity();
                this.addChild(ball);
            }

            // create event listener for release
            this.addEventListener(MouseEvent.MOUSE_UP, _mouseUp);
            // crate event listener for update
            this.addEventListener(Event.ENTER_FRAME, _update);
        }
        
        public function createBall( color:uint, x:Number, y:Number):Sprite
        {
            var ball:Sprite = new Sprite();
                ball.graphics.beginFill(color);
                ball.graphics.drawCircle(0,0, size);
                ball.graphics.endFill();
                ball.x = x;
                ball.y = y;
                //ball['velX'] = speed;
                //ball['velY'] = speed;
            return ball;
        }
        
        public function createVelocity():Object
        {
            var x:int           = speed * 2 * Math.random() - speed;
            var y:int           = speed * 2 * Math.random() - speed;
            var velocity:Object = new Object();
                velocity.x      = x;
                velocity.y      = y;
            return velocity;
        }

        private function _mouseDown(e:MouseEvent = null):void
        {
            trace("You Pressed the ball: " + e.target);
        }
        
        private function _mouseUp(e:MouseEvent = null):void
        {
            trace("Mouse was Released");
        }
        
        private function _update(e:Event = null):void
        {
            //trace("update length: " + balls.length);
            

            for(var i:int = 0; i < balls.length; i++)
            {
              //trace("iteration: " + i);
                _checkBounds(balls[i], velocities[i]);
                _moveBall(balls[i], velocities[i]);
             }
            _detectCollisions();
        }
        
        private function _detectCollisions():void{
            var ball1:Sprite = balls[0];
            var ball2:Sprite = balls[1];
            
            var distanceX:Number = ball1.x - ball2.x;
                distanceX = Math.abs(distanceX);

            var distanceY:Number = ball1.y - ball2.y;
                distanceY = Math.abs(distanceY);

            //var distance:Number = Math.sqrt(distanceX * distanceY);
            
            trace("DistanceX: "+distanceX);
            trace("DistanceY: "+distanceY);

            if(distanceX < size){
                trace("Objects Hit");

                if(distanceY < size)
                {
                    ball1.graphics.beginFill(0x000000);
                    ball1.graphics.drawCircle(0,0,size);
                    ball1.graphics.endFill();
                    ball2.graphics.beginFill(0x000000);
                    ball2.graphics.drawCircle(0,0,size);
                    ball2.graphics.endFill();
                    //ball2.z = 100;
                    
                    var x1:Number = velocities[0].x;
                    var x2:Number = velocities[1].x;
                    var y1:Number = velocities[0].y;
                    var y2:Number = velocities[1].y;

                    velocities[0].x = x2;//*= -1;
                    velocities[0].y = y2;//*= -1;
                    velocities[1].x = x1;//*= -1;
                    velocities[1].y = y1;//*= -1;
                }
            }
        }

        private function _checkBounds(ball:Sprite, velocity:Object):Object
        {
            if(ball.x <= 0)
            {
                trace('Bounce left');
                ball.graphics.beginFill(0x00FFFF);
                ball.graphics.drawCircle(0,0,size);
                ball.graphics.endFill();

                velocity.x *= -1;
            }else if(ball.x >= stage.stageWidth)
            {
                velocity.x *= -1;
                ball.graphics.clear();
                ball.graphics.beginFill(0xFF0000);
                ball.graphics.drawCircle(0,0,size);
                ball.graphics.endFill();
            }
            
            if(ball.y <= 0)
            {
                velocity.y *= -1;
                ball.graphics.beginFill(0xFF000);
                ball.graphics.drawCircle(0,0,size);
                ball.graphics.endFill();
            }else if(ball.y >= stage.stageHeight)
            {
                velocity.y *= -1;
                ball.graphics.beginFill(0xFF000);
                ball.graphics.drawCircle(0,0,size);
                ball.graphics.endFill();
            }
  
             return velocity;
        }

        private function _moveBall(ball:Sprite, velocity:Object):void
        {
            ball.x += velocity.x;
            ball.y += velocity.y;
        }












    }
}