/**
 * Copyright sph62 ( http://wonderfl.net/user/sph62 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Vcso
 */

// TweenLiteは入ってない系か
//　そのうち導入されるの期待して保存
package {
	import com.flashdynamix.utils.SWFProfiler;
	import com.greensock.easing.Quad;
	import com.greensock.plugins.TweenPlugin;
	import com.greensock.TimelineLite;
	import com.greensock.TweenLite;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
	import flash.ui.Keyboard;
	
	/**
	 * ...
	 * @author takaaki koyama
	 */
	public class Main extends Sprite {
		
		private const NUM_BALL:int = 1000;
		private const NUM_PLAYED:int = 100;
		private var _balls:Vector.<Ball>;
		private var timeline:TimelineLite;
		private var container:Sprite;
		
		public function Main():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			SWFProfiler.init(this);
			ColorManager.init();
			
			container = new Sprite();
			addChild(container)
			
			TweenLite.defaultEase = Quad.easeIn;
			timeline = new TimelineLite( { autoRemoveChildren : true});
			
			_balls = new Vector.<Ball>();
			var b:Ball, toPoint:Point;
			for (var i:int = 0; i < NUM_BALL; i++) {
				b = new Ball();
				toPoint = getRandomCirclePoint()
				b.tween = new TweenLite(b, 0.5, {
					x : toPoint.x,
					y : toPoint.y,
					scaleX : 100,
					scaleY : 100,
					paused : true,
					alpha : 0,
					onCompleteParams : [i,b],
					onComplete : function(no:int, self:Ball):void {
						container.removeChild(self);
						if (no+NUM_PLAYED >= NUM_BALL) {
							no = no - (NUM_BALL - NUM_PLAYED);
						}
						no += NUM_PLAYED;
						addTween(no);
					},
					delay : Math.random()
				})
				_balls[i] = b;
			}
			 
			for (i = 0; i < NUM_PLAYED; i++) {
				addTween(i);
			}
			
			timeline.play();
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
			
		}
		
		private function keyDownHandler(e:KeyboardEvent):void {
			if(e.keyCode == Keyboard.SPACE){
				timeline.timeScale = 0.2;
			}
			if(e.keyCode == Keyboard.ENTER){
				timeline.pause();
			}
		}
		
		private function keyUpHandler(e:KeyboardEvent):void {
			if(e.keyCode == Keyboard.SPACE){
				timeline.timeScale = 1;
			}
			if(e.keyCode == Keyboard.ENTER){
				timeline.resume();
			}
		}
		
		
		private function getRandomCirclePoint():Point{
			var l:Number = stage.stageWidth + 200;
			var r:Number = Math.random() * Math.PI * 2;
			return Point.polar(l, r);
		}
		
		private function addTween(no:int):void {
			//trace( "addTween <- no : " + no);
			var ball:Ball = _balls[no];
			ball.reset();
			ball.x = stage.stageWidth / 2;
			ball.y = stage.stageHeight / 2;
			container.addChild(ball);
			ball.tween.play();
			timeline.addChild(ball.tween);
		}
		
	}
	
}
import flash.display.BlendMode;
import frocessing.color.ColorHSV;
import com.greensock.TweenLite;
import flash.display.Sprite

class Ball extends Sprite {
	
	public var tween:TweenLite;
	
	public function Ball():void {
		draw();
		blendMode = BlendMode.ADD
	}
	
	private function draw():void {
		graphics.clear()
		graphics.beginFill(ColorManager.getRandomColor(), 1);
		graphics.drawCircle(0, 0, 1);
	}
	
	public function reset():void {
		x = 0;
		y = 0;
		scaleX = 0;
		scaleY = 0;
		draw();
		
		tween.pause();
		tween.currentTime = 0;
		tween.delay = Math.random();
	}
}

class ColorManager {
	static private var _color:ColorHSV
	static public function init():void {
		_color = new ColorHSV();
	}
	static public function getRandomColor():uint {
		_color.h = 180+Math.random() * 40;
		return _color.value.valueOf();
	}
}
