/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/V05k
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="450",height="450",backgroundColor="0xffffff")]
    public class KKLoggerUsage extends Sprite
    {
        private var _clickTimes:int = 0;
        
        public function KKLoggerUsage()
        {
            addChild(new Logger(10, 10));
            
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
        
        protected function onAddedToStage(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            stage.addEventListener(MouseEvent.CLICK, onStageMouseClick);
        }
        
        protected function onStageMouseClick(event:MouseEvent):void
        {
            _clickTimes++;
            var logText:String = "You clicked " + _clickTimes + " time";
            if(_clickTimes > 1){
                logText += "s";
            }
            Logger.log(logText);
        }
    }
}


import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

class Logger extends Sprite
{
    private var _textField:TextField;
    private var _isTrace:Boolean;
    
    static private var _instance:Logger;
    public function Logger(x:Number = 0, y:Number = 0, width:int = 200, height:int = 150, isTrace:Boolean = false)
    {
        this.x = x;
        this.y = y;
        _isTrace = isTrace;
        _instance = this;
        
        init(width, height);
    }
    
    private function init(width:int, height:int):void
    {
        graphics.beginFill(0x333333, 0.8);
        graphics.drawRect(0, 0, width, height);
        graphics.endFill();
        mouseChildren = mouseEnabled = false;
        
        _textField = new TextField();
        _textField.multiline = true;
        _textField.width = width;
        _textField.height = height;
        _textField.defaultTextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
        addChild(_textField);
    }
    
    /**
     * 出力内容を投げます。
     * @param    ... rest
     */
    static public function log(... rest):void
    {
        
        if (_instance._isTrace) {
            trace.apply(null, rest);
        }
        
        var text:String = rest.join(" ");
        
        if(_instance._textField.text == ""){
            _instance._textField.text = text;
        }else{
            _instance._textField.appendText("\n" + text);
        }
        var re:String = _instance._textField.text;
        var textList:Array = re.split("\r");
        while(_instance._textField.textHeight + 5 > _instance._textField.height){
            textList.shift();
            _instance._textField.text = textList.join("\n");
        }
        
    }
}
