/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Uzx6
 */

// forked from WLAD's Animated Arcs
package 
{
    import com.greensock.easing.Cubic;
    import com.greensock.TweenNano;
        import flash.display.Sprite;

    public class DrawingShapes extends Sprite
    {
        private var arc1:Arc;
        private var arc2:Arc;
        private var arc3:Arc;

        private var t:Text;
        
        public function DrawingShapes() 
        {
                        background( graphics );
    
            arc1 = new Arc();
            arc2 = new Arc();
            arc3 = new Arc();
            
            stage.addChild( arc1.display );
            stage.addChild( arc2.display );
            stage.addChild( arc3.display );
            
            arc1.display.x = 200;
            arc2.display.x = 200;
            arc3.display.x = 200;
            arc1.display.y = 200;
            arc2.display.y = 200;
            arc3.display.y = 200;
            arc1.radius = 100;
            arc2.radius = 100;
            arc3.radius = 100;
            
            arc1.color = 0x435EC9;
            arc2.color = 0x7A98F1;
            arc3.color = 0xFFFFFF;
            
            randomTween();

            t = new Text();
            t.format('Arial', 18, 0x7BC8C8 );
            stage.addChild( t );
        }
        
        private function randomTween():void
        {
            TweenNano.to( arc1, 0.4, 
            { 
                radius: ( 100 + Math.random() * 50 ), 
                startAngle: Math.random() * 360,
                arc: Math.random() * 360,
                    
                ease:Cubic.easeIn,
                
                onUpdate: function():void
                {
                    arc1.draw();
                    t.htmlText = "<b>[Arc 1]</b>\nR: " + arc1.radius.toFixed(4) + "\nSA: " + arc1.startAngle.toFixed(4) + "\nA: " + arc1.arc.toFixed(4) + 
                             "\n<b>[Arc 2]</b>\nR: " + arc2.radius.toFixed(4) + "\nSA: " + arc2.startAngle.toFixed(4) + "\nA: " + arc2.arc.toFixed(4) + 
                             "\n<b>[Arc 3]</b>\nR: " + arc3.radius.toFixed(4) + "\nSA: " + arc3.startAngle.toFixed(4) + "\nA: " + arc3.arc.toFixed(4);
                },
                onComplete: randomTween
            } );
            
            
            TweenNano.to( arc2, 0.4, 
            { 
                radius: ( 50 + Math.random() * 50 ), 
                startAngle: Math.random() * 360,
                arc: Math.random() * 360,
                    
                ease:Cubic.easeIn,
                
                onUpdate: arc2.draw
            } );
            
            TweenNano.to( arc3, 0.4, 
            { 
                radius: ( 100 + Math.random() * 10 ), 
                innderRadius: ( 100 - Math.random() * 10 ),
                startAngle: Math.random() * 360,
                arc: Math.random() * 220,
                    
                ease:Cubic.easeIn,
                
                onUpdate: arc3.draw
            } );
        }
        
    }

}
import flash.display.Graphics;
import flash.display.Shape;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFormat;


class Arc 
{
    public var display:Shape;
    
    /// radius of Arc.
    public var radius:Number = 0;
    
    public var innderRadius:Number = 0;
    
    /// sweep of the arc. Negative values draw clockwise.
    public var arc:Number = 0;
    
    /// [optional] starting offset angle in degrees
    public var startAngle:Number = 0;
    
    /// yRadius = [optional] y radius of arc. if different than radius, then the arc will draw as the arc of an oval. default = radius.
    public var yRadius:Number = 0;
    
    public var color:uint = 0xFF0000;
    
    public function Arc()
    {
        display = new Shape();
    }
    
    public function draw():void
    {
        display.graphics.clear();
        display.graphics.beginFill(color);
        
        var zero:Point = drawArc( radius, arc, startAngle ); 
        
        if ( innderRadius == 0 ) innderRadius = radius * 0.5;
        
        drawArc( innderRadius, -arc, startAngle + arc, 0, false );
        
        display.graphics.lineTo( zero.x, zero.y );
        
        display.graphics.endFill();
    }
    
    /**
     * Based on mc.drawArc by Ric Ewing.
     */
    private function drawArc( radius:Number, arc:Number, startAngle:Number=0, yRadius:Number=0, moveTo:Boolean = true ):Point
    {
        // if startAngle is undefined, startAngle = 0
        if (startAngle == 0) startAngle = 0;
        
        // if yRadius is undefined, yRadius = radius
        if (yRadius == 0) yRadius = radius;

        // Init vars
        var segAngle:Number, theta:Number, angle:Number, angleMid:Number, segs:Number, ax:Number, ay:Number, bx:Number, by:Number, cx:Number, cy:Number;
        // no sense in drawing more than is needed :)
        if ( abs(arc) > 360 ) arc = 360;
        
        // Flash uses 8 segments per circle, to match that, we draw in a maximum
        // of 45 degree segments. First we calculate how many segments are needed
        // for our arc.
        segs = ceil(abs(arc) / 45);
        // Now calculate the sweep of each segment
        segAngle = arc / segs;
        // The math requires radians rather than degrees. To convert from degrees
        // use the formula (degrees/180)*Math.PI to get radians. 
        theta = -(segAngle / 180) * Math.PI;
        // convert angle startAngle to radians
        angle = -(startAngle / 180) * Math.PI;
        
        // find our starting points (ax,ay) relative to the secified x,y
        // ax = posX - Math.cos(angle) * radius;
        // ay = posY - Math.sin(angle) * yRadius;
        
        ax = ay = 0;
        var posX:Number = Math.cos(angle) * radius;
        var posY:Number = Math.sin(angle) * yRadius;
        
        // if our arc is larger than 45 degrees, draw as 45 degree segments
        // so that we match Flash's native circle routines.
        if (segs > 0)
        {
            if ( moveTo ) display.graphics.moveTo(posX, posY);
            else display.graphics.lineTo( posX, posY);
            
            // Loop for drawing arc segments
            for (var i:int = 0; i < segs; i++)
            {
                // increment our angle
                angle += theta;
                // find the angle halfway between the last angle and the new
                angleMid = angle - (theta / 2);
                // calculate our end point
                bx = ax + Math.cos(angle) * radius;
                by = ay + Math.sin(angle) * yRadius;
                // calculate our control point
                cx = ax + Math.cos(angleMid) * (radius / Math.cos(theta / 2));
                cy = ay + Math.sin(angleMid) * (yRadius / Math.cos(theta / 2));
                // draw the arc segment
                display.graphics.curveTo(cx, cy, bx, by);
            }
        }
        
        return new Point( posX, posY );
    }

    /*
    * new abs function, about 25x faster than Math.abs
    */
    public function abs(value:Number):Number
    {
        return value < 0 ? -value : value;
    }

    /*
    * new ceil function about 75% faster than Math.ceil.
    */
    public function ceil(value:Number):Number
    {
        return (value % 1) ? int(value) + 1 : value;
    }
}



function background( g:Graphics, color:uint = 0x0 ):void {
    g.beginFill(     color );
    g.drawRect( 0,0,2000,2000);
    g.endFill();
}






class Text extends TextField {
    
    
    public function Text ( )
    {
        mouseEnabled = false;
        autoSize = 'left';
    }
    
    public function format( font:String, size:Number, color:uint ):void
    {
        var f:TextFormat = new TextFormat( 'Arial', 18, 0x7BC8C8 );
        setTextFormat( f );
        defaultTextFormat = f;
    }
    
}


        
        