/**
 * Copyright Nowloading_ ( http://wonderfl.net/user/Nowloading_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Uzrm
 */

package {
    import flash.display.DisplayObject;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import flash.events.*;
    [SWF(backgroundColor = 0x000000)]
    public class mf extends BasicView {
        //
        //
        //cube格納用オブジェクト
        private var field:DisplayObject3D;
        //表面用と下部用のcube
        private var ucube:Cube;
        private var dcube:Cube;
        //cubeの縦横幅とcube間の長さ;
        private var wide:int = 50;
        private var dx:int = 5;
        //cubeの色指定配列:color[x軸][z軸]
        //数値は0=green,1=brown, 2=blueに対応
        //色の指定(uColor=上部の色;dColor = 下部の色)
        private var uColor:Array = [[0,0,0,1,1],
                                    [0,0,1,2,2],
                                    [0,1,2,2,2],
                                    [0,1,1,2,2],
                                    [0,0,1,2,2],
                                   ];
        private var dColor:Array = [[1,1,1,1,1],
                                    [1,1,1,1,2],
                                    [1,1,1,2,2],
                                    [1,1,1,1,2],
                                    [1,1,1,2,2],
                                   ];
        //各cubeの高さ
        private var hCube:Array = [[6,4,2,2,3],
                                   [4,2,1,0,0],
                                   [2,1,0,0,0],
                                   [3,2,2,0,0],
                                   [4,3,3,0,0],
                                  ];
        //上下cubeの高さ管理変数
        private var high:int =20;
        //cube用colormaterial;実際に使うのはcubeMat配列のみ
        private var gr:ColorMaterial = new ColorMaterial(0x60ff60);
        private var br:ColorMaterial = new ColorMaterial(0xd0a080);
        private var bl:ColorMaterial = new ColorMaterial(0xd0ddff);
        private var g:MaterialsList = new MaterialsList( { all:gr } );
        private var l:MaterialsList = new MaterialsList( { all:br } );
        private var b:MaterialsList = new MaterialsList( { all:bl } );
        private var cubeMat:Array = [g,l,b];
        //
        //
        //plane格納用オブジェクト
        private var chara:DisplayObject3D;
        //charaの管理配列と通し番号用変数
        private var c:Array = new Array();
        private var charaNo:int = 0;
        private var plane:Plane;
        //Plane用material;実際に使うのはplaneMat配列のみ
        private var aka:WireframeMaterial = new WireframeMaterial(0xcc0000,3);
        private var ao:WireframeMaterial = new WireframeMaterial(0x0000cc,3);
        private var midori:WireframeMaterial = new WireframeMaterial(0x00cc00,3);
        private var planeMat:Array = [aka,ao,midori];
        //planeの配置;1=akaPlane,2=aoPlane,3=midoriPlane;
        private var haiti:Array = [[1,0,0,0,2],
                                   [0,1,0,0,0],
                                   [1,0,0,0,0],
                                   [0,0,0,0,3],
                                   [2,2,0,0,0],
                                  ];
        //
        //
        //radiun
        private var rad:int = 0;
        //
        //
        //土台baseと軸表示plane
        private var baseColor:ColorMaterial = new ColorMaterial(0x8a5040);
        private var baseMat:MaterialsList = new MaterialsList({all:baseColor});
        private var base:Cube;
        private var planeColor:ColorMaterial = new ColorMaterial(0xdddddd,0.2);
        private var planeX:Plane;
        private var planeY:Plane;
        private var planeZ:Plane;
        //constructer
        public function mf() {
            init();
        }
        private function init():void{
            /*for(var m:int = 0;m<planeMat.length; m++){
                planeMat[m].doubleSided = true;
            }*/
            field = new DisplayObject3D;
            chara = new DisplayObject3D;
            scene.addChild(field);
            scene.addChild(chara);
            for(var i:int = 0; i<uColor.length; i++){
                for(var j:int = 0; j<uColor[0].length; j++){
                    //Fieldの作成
                    ucube = new Cube(cubeMat[uColor[i][j]],wide,wide,high/2);
                    dcube = new Cube(cubeMat[dColor[i][j]],wide,wide,(hCube[i][j]+1)*high);
                    ucube.x = dcube.x = -((wide+dx)*Math.floor(uColor.length/2)) + ((wide+dx)*i);
                    ucube.z = dcube.z = -((wide+dx)*Math.floor(uColor[0].length/2)) + ((wide+dx)*j);
                    dcube.y = ((hCube[i][j]+1)*high)/2;
                    ucube.y = dcube.y*2 + high/4;
                    field.addChild(ucube,"UC_x"+i+"z"+j);
                    field.addChild(dcube,"DC_x"+i+"z"+j);
                    //charaの追加
                    //ここまだ代数にしてない
                    if(haiti[i][j] != 0){
                        plane = new Plane(planeMat[haiti[i][j]-1],40,60,4,8);
                        plane.x = -((wide+dx)*Math.floor(uColor.length/2)) + ((wide+dx)*i);
                        plane.z = -((wide+dx)*Math.floor(uColor[0].length/2)) + ((wide+dx)*j);
                        plane.y = ucube.y + 55;
                        c[charaNo] = plane;
                        chara.addChild(c[charaNo], "CHARA_"+charaNo);
                        charaNo +=1;
                    }
                }
            }
            //baseと軸planeの追加
            base = new Cube(baseMat,(wide+dx)*uColor.length-dx,(wide+dx)*uColor[0].length-dx,10);
            base.y = -high/2;
            scene.addChild(base);
            planeColor.doubleSided = true;
            planeX = new Plane(planeColor,500,500);
            planeX.rotationY = 90;
            scene.addChild(planeX);
            planeY = new Plane(planeColor,500,500);
            planeY.rotationX = 90;
            scene.addChild(planeY);
            planeZ = new Plane(planeColor,500,500);
            scene.addChild(planeZ);
            
            //camera.x = 400;   
            camera.y = 250;
            camera.z = -400;
            startRendering();
            addEventListener(Event.ENTER_FRAME,oEF);
        }
        private function oEF(e:Event):void{
            camera.x = 400*Math.sin(rad*Math.PI/180);
            camera.z = -400*Math.cos(rad*Math.PI/180);
            for(var n:int=0;n<charaNo; n++){
                c[n].rotationY = -rad;
            }

            rad += 2;
            if ( rad>=360){
                rad =0;
            }
        }
    }
}