/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/UmrN
 */

// MVCの練習のために抽象クラスをいじってみるとか
package  
{
	import flash.display.Sprite;
	public class MVCsample extends Sprite
	{
		private var _controller:TokeiController = new TokeiController();
		public function MVCsample() 
		{
			// コントローラー付属のview
			var analogTokei:AnalogTokeiView = _controller.getAnalogTokei();
			analogTokei.y = 60;
			this.addChild( analogTokei );
			
			var degitalTokei:DegitalTokeiView = _controller.getDegitalTokei();
			this.addChild( degitalTokei );
			
			// なんか適当にモデルを関連付けてもらうview
			var myTokei:AnalogTokeiView = _controller.makeTokei(AnalogTokeiView) as AnalogTokeiView;
			
			myTokei.hankei = 50;
			this.addChild( myTokei );
			myTokei.x = 350;
			
			_controller.start();
		}
	}
}
	// Controller
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.engine.FontDescription;
	import flash.text.TextField;
	import flash.text.TextFormat;
	class TokeiController extends Sprite {
		private var analog:AnalogTokeiView;
		private var degital:DegitalTokeiView;
		private var model:TokeiModel = new TokeiModel();
		public function TokeiController() {
			analog = new AnalogTokeiView(model);
			degital = new DegitalTokeiView(model);
		}
		public function getAnalogTokei():AnalogTokeiView {
			return analog;
		}
		public function getDegitalTokei():DegitalTokeiView {
			return degital;
		}
		public function makeTokei(viewClass:Class):AbstractTokeiView {
			var tokei:AbstractTokeiView = new viewClass(model);
			return tokei;
		}
		public function start():void {
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		public function stop():void {
			this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		private function onEnterFrame(e:Event):void {
			model.jikan = new Date();
		}
	}
	
	// 抽象View
	import flash.display.Sprite;
	class AbstractTokeiView extends Sprite {
		protected var _model:TokeiModel;
		public function AbstractTokeiView(model:TokeiModel) {
			_model = model;
			_model.addEventListener(TokeiEvent.JIKAN_HENKA, byouga);
		}
		protected function byouga(e:TokeiEvent):void {
		}
	}
	
	// アナログView
	import flash.display.Graphics;
	class AnalogTokeiView extends AbstractTokeiView {
		private var _hankei:int;
		private const PI60:Number = 2 * Math.PI / 60;
		private const PI12:Number = 2 * Math.PI / 12;
		private const R60:Number = 1.0/60;
		private const R12:Number = 1.0/12;
		private const BYOU_SCALE:Number = 0.95;
		private const FUN_SCALE:Number = 0.9;
		private const JI_SCALE:Number = 0.7;
		private var byouLength:Number;
		private var funLength:Number;
		private var jiLength:Number;
		private var hyoujiban:Sprite = new Sprite();
		public function AnalogTokeiView(model:TokeiModel) {
			super(model);
			addChild( hyoujiban );
			hankei = 200;
		}
		override protected function byouga(e:TokeiEvent):void 
		{
			var g:Graphics = hyoujiban.graphics;
			g.clear();
			g.lineStyle(0);
			g.drawCircle(0, 0, hankei);
			g.moveTo(0, 0);
			var byoukaku:Number = PI60 * e.byou;
			g.lineTo(byouLength * Math.sin(byoukaku), -byouLength * Math.cos(byoukaku));
			g.moveTo(0, 0);
			var funkaku:Number = PI60 * (e.fun + R60 * e.byou);
			g.lineTo(funLength * Math.sin(funkaku), -funLength * Math.cos(funkaku));
			g.moveTo(0, 0);
			var jikaku:Number = PI12 * e.ji + R12 * funkaku;
			g.lineTo(jiLength * Math.sin(jikaku), -jiLength * Math.cos(jikaku));
		}
		
		public function set hankei(value:int):void 
		{
			_hankei = value;
			byouLength = _hankei * BYOU_SCALE;
			funLength = _hankei * FUN_SCALE;
			jiLength = _hankei * JI_SCALE;
			hyoujiban.x = _hankei;
			hyoujiban.y = _hankei;
		}
		
		public function get hankei():int { return _hankei; }
	}

	// デジタルView
	import flash.display.Graphics;
	class DegitalTokeiView extends AbstractTokeiView {
		private var _fontSize:int;
		private var _moji:TextField = new TextField();
		public function DegitalTokeiView(model:TokeiModel) {
			super(model);
			fontSize = 40;
			_moji.autoSize = "left";
			addChild( _moji );
		}
		override protected function byouga(e:TokeiEvent):void 
		{
			_moji.text = futaketa(e.ji) + ":" + futaketa(e.fun) + ":" + futaketa(e.byou);
		}
		private function futaketa(value:int):String {
			return String("00" + value).substr( -2, 2);
		}
		public function set fontSize(value:int):void 
		{
			_fontSize = value;
			_moji.defaultTextFormat = new TextFormat("_ゴシック", value);
		}
		
		public function get fontSize():int { return _fontSize; }
	}
	
	// Model
	import flash.events.EventDispatcher;
	class TokeiModel extends EventDispatcher {
		private var _jikan:Date;
		public function TokeiModel() {
			_jikan = new Date();
			_jikan.time = 0;
		}
		public function get jikan():Date {
			var modorichi:Date = new Date();
			modorichi.time = _jikan.date;
			return modorichi;
		}
		public function set jikan(value:Date):void 
		{
//			trace( _jikan.time, value.time );
			if ( int(_jikan.time / 1000) == int(value.time / 1000) ) return;
			// 秒数が進んでたらイベント送出
			_jikan.time = value.time;
			dispatchEvent(new TokeiEvent(
				TokeiEvent.JIKAN_HENKA,
				_jikan.getHours(),
				_jikan.getMinutes(),
				_jikan.getSeconds()
			));
		}
	}

	// Event
	import flash.events.Event;
	class TokeiEvent extends Event {
		private var _ji:int;
		private var _fun:int;
		private var _byou:int;
		public static const JIKAN_HENKA:String = "jikanHenka";
		public function TokeiEvent(type:String, ji:int, fun:int, byou:int) {
			super(type);
			this.ji = ji;
			this.fun = fun;
			this.byou = byou;
		}
		override public function toString():String 
		{
			return super.toString() + "["+ ji + ":" + fun + ":" + byou + "]";
		}
		// getter
		public function get ji():int { return _ji; }
		public function get fun():int { return _fun; }
		public function get byou():int { return _byou; }
		// setter
		public function set ji(value:int):void { _ji = value;	}
		public function set fun(value:int):void { _fun = value; }
		public function set byou(value:int):void { _byou = value; }
	}