/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Ulua
 */

// forked from soundkitchen's [1日1Wonderfl]8日目: Reflection やってみたよ
// 1日1Wonderfl 10/30日目
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.media.Camera;
    import flash.media.Video;

    import com.flashdynamix.utils.SWFProfiler;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]

    /**
     *
     */
    public class Main extends Sprite
    {
        public static const CAMERA_WIDTH:Number = 240;
        public static const CAMERA_HEIGHT:Number = 180;
        public static const REFLECT_SCALE:Number = .5;
        public static const REFLECT_MARGIN:Number = 0;

        private var video:Video;
        private var container:Sprite;
        private var film:BitmapData;

        /**
         *
         */
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        /**
         *
         */
        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            SWFProfiler.init(this);

            container = new Sprite();

            var webCam:Camera,
                original:Bitmap,
                reflect:Bitmap,
                msk:Shape,
                mtx:Matrix,
                g:Graphics;

            //  get default web camera.
            webCam = Camera.getCamera();

            //  stop process if couldn't found any camera.
            if (!webCam) return;

            //  setup camera.
            webCam.setMode(CAMERA_WIDTH, CAMERA_HEIGHT, stage.frameRate >> 1);

            //  create and setup video.
            video = new Video(CAMERA_WIDTH, CAMERA_HEIGHT);
            //  reverse and fix position.
            video.scaleX *= -1;
            video.x += CAMERA_WIDTH;
            //  bind camera.
            video.attachCamera(webCam);

            //  create bitmapdata as a snapshot film.
            film = new BitmapData(CAMERA_WIDTH, CAMERA_HEIGHT, true, 0);

            //  create original bitmap.
            original = new Bitmap(film);
            container.addChild(original);

            //  create reflection bitmap.
            reflect = new Bitmap(film);
            //  reverse and fix position.
            reflect.scaleY *= -1;
            reflect.y = REFLECT_MARGIN + (CAMERA_HEIGHT << 1);
            //  cache for mask and fade.
            reflect.cacheAsBitmap = true;
            container.addChild(reflect);

            //  create mask shape.
            msk = new Shape();
            //  fix position.
            msk.y = CAMERA_HEIGHT + REFLECT_MARGIN;
            //  cache for mask and fade.
            msk.cacheAsBitmap = true;

            //  create matrix.
            mtx = new Matrix();
            mtx.createGradientBox(CAMERA_WIDTH, CAMERA_HEIGHT, Math.PI/2);

            //  draw gradient box.
            g = msk.graphics;
            g.beginGradientFill(
                GradientType.LINEAR,
                [0x00, 0x00],
                [REFLECT_SCALE, 0],
                [0, 255 * REFLECT_SCALE],
                mtx
            );
            g.drawRect(0, 0, CAMERA_WIDTH, CAMERA_HEIGHT);
            g.endFill();

            container.addChild(msk);
            reflect.mask = msk;

            //  fix position.
            container.x = (stage.stageWidth - original.width) >> 1;
            container.y = (stage.stageHeight - original.height) >> 1;
            addChild(container);

            addEventListener(Event.ENTER_FRAME, step);
        }

        private function step(evt:Event):void
        {
            film.lock();
            film.fillRect(film.rect, 0);
            film.draw(video, video.transform.matrix);
            film.unlock();
        }
    }
}

