/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/UIAZ
 */

// technical fork - never mind me,,,
// forked from bkzen's Wonderf Score 素材
package  
{
    import flash.display.Sprite;
    import flash.text.TextField;
    /**
     * ...
     * @author jc at bkzen
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class WonderfScoreMain extends Sprite
    {
        
        public function WonderfScoreMain() 
        {
            if (stage) demo();
        }
        
        /**
         * Wonderfl の Score API 用
         * ランキング表示から Tweet までをひとまとめにしたSWF素材
         * @param    api                : WonderflAPI
         * @param    score            : 取得スコア
         * @param    title            : (省略時: "GAME SCORE")ランキングのタイトル
         * @param    denominator        : (省略時: 1) 表示スコアに小数点が付く場合に使用する。
         *                 スコアが 1234 のとき、 100 に指定すると 12.34
         * @param    tweet            : (省略時はTweet無し) Twitter 連携をする時に文字列を指定すると
         *                それでつぶやかれる。%SCORE% という文字列が中にあるとそこがスコアと置き換わる。
         * @param    scoreTitle        : (省略時: SCORE)　スコアが何を意味するのか。例) LAP TIME
         * @param    addScoreAfter    : 表示スコアの後ろにつける単位などに、
         *                 例) [sec] と指定すると 12.34 [sec] のように表示される
         * @param    scoreLength        : (省略時: 99) スコア送信後に取得するランキング件数
         * @param    scoreDescend    : (省略時: 1) 降順昇順のフラグ
         *                 (1: 点数が高い順、0: 点数が低い順)
         * @param    modal            : (省略時: true) モーダル処理を入れるかどうか。
         */
        public function makeScoreWindow(
            api: *, score: int, title: String, denominator: int = 1, 
            tweet: String = null, scoreTitle: String = "SCORE", addScoreAfter: String = "",
            scoreLength: uint = 99, scoreDescend: uint = 1, modal: Boolean = true
        ): ScoreWindow
        {
            _api = api, _score = score, _title = title, _denominator = denominator, _tweet = tweet, _scoreTitle = scoreTitle, _addScoreAfter = addScoreAfter, _scoreLength = scoreLength, _scoreDescend = scoreDescend;
            return new ScoreWindow(modal);
        }
        
        private function demo():void 
        {
            var obj: Object = loaderInfo.parameters;
            var window: ScoreWindow = makeScoreWindow(null, Math.random() * 1000000, "Test", 10, "wonderfl scoreTest %SCORE%");
            addChild(window);
        }
        
    }

}
import com.adobe.serialization.json.JSON;
import com.bit101.components.InputText;
import com.bit101.components.Label;
import com.bit101.components.PushButton;
import com.bit101.components.Style;
import com.bit101.components.VScrollBar;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Loader;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.net.navigateToURL;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.utils.escapeMultiByte;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Quad;
import org.libspark.betweenas3.tweens.IObjectTween;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.tweens.ITweenGroup;
var _api: *, _score: int, _title: String, _denominator: int, _tweet: String, _scoreTitle: String, _addScoreAfter: String, _scoreLength: uint, _scoreDescend: uint;

/**
 * 閉じられた時に出力されます。
 */
[Event(name="close", type="flash.events.Event")]
class ScoreWindow extends Sprite
{
    function ScoreWindow( modal: Boolean = true )
    {
        this.modal = modal;
        if (_tweet) _tweet = _tweet.replace(/%SCORE%/g, (_score / _denominator));
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    private var modal: Boolean;
    private var modalSp: Sprite;
    
    private function init(e: Event = null): void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        var window: _ScoreWindow = new _ScoreWindow();
        window.closeHandler = onClose;
        window.x = stage.stageWidth  - window.width  >> 1;
        window.y = stage.stageHeight - window.height >> 1;
        if (modal) 
        {
            addChild(modalSp = new Sprite());
            var g: Graphics = modalSp.graphics;
            g.beginFill(0xCCCCCC, 0.5);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        addChild(window);
        stage.addEventListener(Event.RESIZE, onResize);
    }
    
    private function onResize(e:Event):void 
    {
        if (modal)
        {
            var g: Graphics = modalSp.graphics;
            g.clear();
            g.beginFill(0x333333, 0.3);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        var i: int;
        for (i = 0; i < numChildren; i++) 
        {
            var d: DisplayObject = getChildAt(i);
            d.x = stage.stageWidth  - d.width  >> 1;
            d.y = stage.stageHeight - d.height >> 1;
        }
    }
    
    private function onClose():void 
    {
        while (numChildren > 0) removeChildAt(0);
        stage.removeEventListener(Event.RESIZE, onResize);
        parent.removeChild(this);
        dispatchEvent(new Event(Event.CLOSE));
    }
}

class _ScoreWindow extends Sprite
{
    private var iconLoader: Loader, input: InputText, closeBtn: PushButton, tweetBtn: PushButton;
    private var tween: IObjectTween;
    public var closeHandler: Function;
    
    function _ScoreWindow()
    {
        alpha = 0;
        var bg: Shape = new Shape();
        var g: Graphics = bg.graphics;
        g.beginFill(0x777777);
        g.drawRoundRectComplex(0, 0,  280, 180, 5, 5, 5, 5);
        g.beginFill(0xFFFFFF);
        g.drawRoundRectComplex(1, 1,  278,  20, 5, 5, 0, 0);
        g.drawRoundRectComplex(1, 22, 278, 157, 0, 0, 5, 5);
        bg.filters = [new DropShadowFilter(2, 45, 0, 1, 16, 16)];
        addChild(bg);
        BackupStyle.styleSet();
        new Label(this, 5, 3, _title);
        iconLoader = new Loader();
        iconLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
        iconLoader.visible = false;
        iconLoader.x = 10, iconLoader.y = 60;
        addChild(iconLoader);
        new Label(this, 75,  65, _scoreTitle + " :");
        new Label(this, 75,  85, "PLAYER :");
        new Label(this, 150, 65, (_score / _denominator) + " " + _addScoreAfter);
        input = new InputText(this, 150, 85, 'Awesome!');
        iconLoader.load(new URLRequest('winner.png'));
        if (_tweet) tweetBtn = new PushButton(this, 10, 150, "TWEET", onClickTweet);
        var registBtn:PushButton = new PushButton(this, _tweet ? 100 : 35, 150, "REGISTER", new Function); registBtn.enabled = false;
        closeBtn = new PushButton(this, _tweet ? 190 : 145, 150, "CANCEL", onClickCancel);
        if (tweetBtn) tweetBtn.width = registBtn.width = closeBtn.width = 80;
        else registBtn.width = closeBtn.width = 100;
        tween = BetweenAS3.to(this, { alpha: 1 }, 1);
        tween.play();
        BackupStyle.styleBack();
    }
    
    private function onIOErrorIcon(e:IOErrorEvent):void 
    {
        iconLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
    }
    
    private function onCompLoadIcon(e:Event):void 
    {
        iconLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
        iconLoader.scaleX = iconLoader.scaleY = 0.5;
        iconLoader.visible = true;
    }
    
    private function onClickCancel(e: Event):void 
    {
        if (tween.isPlaying) tween.stop();
        tween = BetweenAS3.to(this, { alpha: 0 } );
        tween.onComplete = close;
        tween.play();
        btnDisable();
    }
    
    private function btnDisable(): void
    {
        if (tweetBtn) tweetBtn.enabled = false;
        closeBtn.enabled = false;
    }
    
    private function close(): void
    {
        while (numChildren > 0) removeChildAt(0);
        input = null;
        if (tweetBtn) tweetBtn.removeEventListener(MouseEvent.CLICK, onClickTweet);
        closeBtn.addEventListener(MouseEvent.CLICK, onClickCancel);
        tweetBtn = closeBtn = null;
        var f: Function = closeHandler;
        closeHandler = null;
        iconLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
        iconLoader.unloadAndStop();
        iconLoader = null;
        if (f != null) f();
        if (parent) parent.removeChild(this);
    }
        
    private function onClickTweet(e: Event):void 
    {
        navigateToURL(new URLRequest("http://twitter.com/share?" + 
            "text=" + escapeMultiByte(_tweet)
        ));
    }
}
class BackupStyle
{
    public static var BACKGROUND: uint = 0xCCCCCC;
    public static var BUTTON_FACE: uint = 0xFFFFFF;
    public static var INPUT_TEXT: uint = 0x333333;
    public static var LABEL_TEXT: uint = 0x666666;
    public static var DROPSHADOW: uint = 0x000000;
    public static var PANEL: uint = 0xF3F3F3;
    public static var PROGRESS_BAR: uint = 0xFFFFFF;
    
    public static var embedFonts: Boolean = true;
    public static var fontName: String = "PF Ronda Seven";
    public static var fontSize: Number = 8;
    
    private static var b: Object;
    
    public static function styleSet(): void
    {
        b = {
            BACKGROUND:        Style.BACKGROUND,    BUTTON_FACE:    Style.BUTTON_FACE, 
            INPUT_TEXT:        Style.INPUT_TEXT,    LABEL_TEXT:        Style.LABEL_TEXT, 
            DROPSHADOW:        Style.DROPSHADOW,    PANEL:            Style.PANEL, 
            PROGRESS_BAR:    Style.PROGRESS_BAR,    embedFonts:        Style.embedFonts, 
            fontName:        Style.fontName,        fontSize:        Style.fontSize
        };
        Style.BACKGROUND = BACKGROUND,         Style.BUTTON_FACE = BUTTON_FACE;
        Style.INPUT_TEXT = INPUT_TEXT,         Style.LABEL_TEXT = LABEL_TEXT;
        Style.DROPSHADOW = DROPSHADOW,         Style.PANEL = PANEL;
        Style.PROGRESS_BAR = PROGRESS_BAR,     Style.embedFonts = embedFonts;
        Style.fontName = fontName,             Style.fontSize = fontSize;
    }
    
    public static function styleBack(): void
    {
        Style.BACKGROUND = b["BACKGROUND"], Style.BUTTON_FACE = b["BUTTON_FACE"];
        Style.INPUT_TEXT = b["INPUT_TEXT"], Style.LABEL_TEXT = b["LABEL_TEXT"];
        Style.DROPSHADOW = b["DROPSHADOW"], Style.PANEL = b["PANEL"];
        Style.PROGRESS_BAR = b["PROGRESS_BAR"], Style.embedFonts = b["embedFonts"];
        Style.fontName = b["fontName"], Style.fontSize = b["fontSize"];
    }
}