/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/U6TZ
 */

package {
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    public class FlashTest extends Sprite {
        
        public var _width:int = 465;
        public var _height:int = 465;
        
        public var screen:BitmapData;
        
        public var circleArray:Array;
        
        public var numWidth:int = 20;
        public var numHeight:int = 20;
        
        public var circleRadiusMax:int = _width / numWidth * 0.4;
        public var circleRadiusMin:int = _width / numWidth * 0.1;
        
        public var numberOfOscillations:Number = 100;
        
        public var normalButton:PushButton;
        public var randomButton:PushButton;
        public var swirlButton:PushButton;
        public var buttonArray:Array;
        
        public var counter:int = 0;
        
        public function FlashTest() {
            // write as3 code here..
            
            Wonderfl.disable_capture();
            
            Style.LABEL_TEXT = 0xCCCCCC;
            Style.BUTTON_FACE = 0x666666;
            
            var back:BitmapData = new BitmapData(465, 465, false, 0x0);
            addChild(new Bitmap(back));
            
            screen = new BitmapData(465, 465, false, 0);
            addChild(new Bitmap(screen));
            
            buttonArray = [];
            
            normalButton = new PushButton(this, 465 - 110, 10, "normal", onButtonPressed);
            normalButton.toggle = true;
            normalButton.alpha = 0.7;
            normalButton.name = "0";
            buttonArray.push(normalButton);
            
            randomButton = new PushButton(this, normalButton.x, normalButton.y + normalButton.height + 5, "random", onButtonPressed);
            randomButton.toggle = true;
            randomButton.alpha = 0.7;
            randomButton.name = "1";
            buttonArray.push(randomButton);
            
            swirlButton = new PushButton(this, randomButton.x, randomButton.y + randomButton.height + 5, "rotate", onButtonPressed);
            swirlButton.toggle = true;
            swirlButton.alpha = 0.7;
            swirlButton.name = "2";
            swirlButton.selected = true;
            buttonArray.push(swirlButton);
            
            initCircle();
            addEventListener(Event.ENTER_FRAME, updateCircle);
            
        }
        
        private function onButtonPressed(e:Event):void
        {
            var selectedButtonIndex:int = parseInt(e.target.name);
            
            var i:int;
            for (i = 0; i < buttonArray.length; i += 1)
            {
                buttonArray[i].selected = false;
            }
            
            resetCircle();
            buttonArray[selectedButtonIndex].selected = true;
            
        }
        
        private function initCircle():void
        {
            var circle:Circle;
            var i:int;
            var j:int;
            var count:int = 0;
            
            circleArray = [];
            
            for (i = 0; i < numWidth; i += 1)
            {
                circleArray[i] = [];
                
                for (j = 0; j < numHeight; j += 1)
                {
                    circle = new Circle();
                    circle.x = (i + 0.5) * (_width / numWidth);
                    circle.y = (j + 0.5) * (_height / numHeight);
                    circle.degree = count * 360 / numWidth / numHeight * numberOfOscillations;
                    circle.offset = (numWidth * numHeight) / 2 - count;
                    //addChild(circle);
                    circleArray[i].push(circle);
                    
                    count += 1;
                }
            }
            
        }
        
        private function resetCircle():void
        {
            var i:int;
            var j:int;
            var count:int = 0;
            var circle:Circle;
            
            for (i = 0; i < numWidth; i += 1)
            {
                for (j = 0; j < numHeight; j += 1)
                {
                    circle = circleArray[i][j];
                    circle.degree = count * 360 / numWidth / numHeight * numberOfOscillations;
                    circle.offset = (numWidth * numHeight) / 2 - count;
                    
                    count += 1;
                }
            }
            
        }
        
        private function increment(offset:Number):Number
        {
            if (normalButton.selected == true)
            {
                return 10;
            }
            else if (randomButton.selected == true)
            {
                return 10 + Math.floor(5 * Math.random());
            }
            else if (swirlButton.selected == true)
            {
                //return .5 + offset;
                return 14 + offset / 20;
            }
            
            return 0;
        }
        
        private function updateCircle(e:Event):void
        {
            var i:int;
            var j:int;
            var circle:Circle;
            var sinValue:Number;
            var hsvColorArray:Array;
            var fillColor:uint;
            
            counter += 1;
            counter %= 360;
            
            screen.lock();
            screen.fillRect(screen.rect, 0x0);
            
            for (i = 0; i < numWidth; i += 1)
            {
                for (j = 0; j < numHeight; j += 1)
                {
                    circle = circleArray[i][j];
                    
                    circle.degree += increment(circle.offset);
                    circle.degree %= 360;
                    sinValue = (Math.sin(circle.degree * Math.PI / 180) + 1) / 2;
                    
                    hsvColorArray = hsv(counter, sinValue, 1);
                    fillColor = hsvColorArray[0] << 16 | hsvColorArray[1] << 8 | hsvColorArray[2];
                    
                    circle.graphics.clear();
                    circle.graphics.beginFill(fillColor);
                    //circle.graphics.lineStyle(1, 0xffffff);
                    circle.graphics.drawCircle(0, 0, sinValue * (circleRadiusMax - circleRadiusMin) + circleRadiusMin);
                    circle.graphics.endFill();
                    
                    screen.draw(circle, new Matrix(1, 0, 0, 1, circle.x, circle.y));
                }
            }
            
            screen.unlock();
        }
        
        private function hsv(h:Number, s:Number, v:Number):Array
        {
            var r:Number, g:Number, b:Number;
            var i:int;
            var f:Number, p:Number, q:Number, t:Number;
             
            if (s == 0){
                r = g = b = v;
                return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
            }
           
            h /= 60;
            i  = Math.floor(h);
            f = h - i;
            p = v *  (1 - s);
            q = v * (1 - s * f);
            t = v * (1 - s * (1 - f));
           
            switch( i ) {
                case 0:
                    r = v;
                    g = t;
                    b = p;
                    break;
                case 1:
                    r = q;
                    g = v;
                    b = p;
                    break;
                case 2:
                    r = p;
                    g = v;
                    b = t;
                    break;
                case 3:
                    r = p;
                    g = q;
                    b = v;
                    break;
                case 4:
                    r = t;
                    g = p;
                    b = v;
                    break;
                default:        // case 5:
                    r = v;
                    g = p;
                    b = q;
                    break;
            }
            return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
        }
    }
}

Class  
{
    import flash.display.Shape;
    /**
     * ...
     * @author ypc
     */
    class Circle extends Shape
    {
        public var degree:Number;
        public var offset:Number;
        
        public function Circle() 
        {
            super();
        }
        
    }

}