/**
 * Copyright ketz ( http://wonderfl.net/user/ketz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/TvHF
 */

// forked from goneThreeD's Shaker - Event.ENTER_FRAME callback w/ randomness
// forked from goneThreeD's Shaker - Event.ENTER_FRAME callback
package
{
    import flash.text.TextFieldAutoSize;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.utils.Timer;
    
    public class testing extends Sprite {
        
        private var shakeButton:Sprite;
        private var graphic:Sprite;
        private var shakerPos:Array;
        private var shakers:Array;
        private var numShakers:int = 20;
        private var displacement:Number = 10;
        private var currentCount:int;
        private var data:TextField;
        
        public function testing() {
            this.shakers = new Array();
            this.shakerPos = new Array();
            this.addEventListener(Event.ADDED_TO_STAGE, this.init);
        }
        private function init(e:Event):void {
            this.stage.frameRate = 30;
            this.graphics.beginFill(0x333333);
            this.graphics.drawRect(0,0,this.stage.stageWidth, this.stage.stageHeight);
            this.graphics.endFill();
            
            this.createShakers();
            
            this.shakeButton = this.createSpriteButton("Shake ");
            this.addChild(this.shakeButton);
            this.shakeButton.x = 10;
            this.shakeButton.y = 10;
            this.shakeButton.addEventListener(MouseEvent.CLICK, this.shakeCallback);
            
            this.data = new TextField;
            this.data.selectable = true;
            this.addChild(this.data);
            this.data.autoSize = TextFieldAutoSize.LEFT;
            this.data.x = 10;
            this.data.y = this.stage.stageHeight - 20;
            this.data.textColor = 0xFFFFFF;
            this.data.text = "Data:";
        }
        private function createSpriteButton(btnName:String):Sprite {
            var sBtn:Sprite = new Sprite();
            sBtn.name = btnName;
            sBtn.graphics.beginFill(0xFFFFFF);
            sBtn.graphics.drawRoundRect(0,0,80,20,5);
            var sBtnTF:TextField = new TextField();
            sBtn.addChild(sBtnTF);
            sBtnTF.text = btnName;
            sBtnTF.x = 5;
            sBtnTF.y = 3;
            sBtnTF.selectable = false;
            sBtn.alpha = .5;
            sBtn.addEventListener(MouseEvent.MOUSE_OVER, function(e:Event):void { sBtn.alpha = 1 });
            sBtn.addEventListener(MouseEvent.MOUSE_OUT, function(e:Event):void { sBtn.alpha = .5 });
            return sBtn;
        }
        private function createShakers():void {
            var graphic:Sprite;
            
            for(var i:int = 0;i < this.numShakers;i++) {
                graphic = new Sprite();
                 this.addChild(graphic);
                graphic.graphics.beginFill(0xFFFFFF);
                graphic.graphics.drawRect(0,0,10,10);
                graphic.graphics.endFill();
                // add a 30 pixel margin for the graphic so they don't show up on the edge
                graphic.x = (this.stage.stageWidth-60)*Math.random()+30;
                graphic.y = (this.stage.stageWidth-60)*Math.random()+30;
                this.shakers[i] = graphic;
                this.shakerPos[i] = new Point(graphic.x, graphic.y);
            }
        }
        private function shakeCallback(e:Event):void {
            // Just in case a click happens before a previous shake cycle is finished
            if(this.hasEventListener(Event.ENTER_FRAME)) {
                this.removeEventListener(Event.ENTER_FRAME, this.shake);
            }
            this.currentCount = 0;
            this.addEventListener(Event.ENTER_FRAME, this.shake);
        }
        private function shake(e:Event):void {
            var ranData:String = "";
            var dampening:Number = (20 - this.currentCount++)/20;
            var signX:int; 
            var signY:int;
            for(var i:int = 0;i < this.numShakers;i++) {
                signX = getRandomSign();
                signY = getRandomSign();
                this.shakers[i].x = this.shakerPos[i].x + Math.random()*10*dampening*signX;
                this.shakers[i].y = this.shakerPos[i].y + Math.random()*10*dampening*signY;
                ranData += "(" + signX + "," + signY + ")";
            }
            if(this.currentCount == 20) {
                this.data.text = ranData;
                this.removeEventListener(Event.ENTER_FRAME, this.shake);
            }
            function getRandomSign():int {
                return Math.random() < 0.5?-1:1;
            }

        }
    }
}