/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Tt7N
 */

//BlurFilterとBitmapDataを使って軌跡を残す
//軌跡の残り具合はBlurFilterの設定で変化する

// forked from KoheiTAKAMIYA's BlendMode.ADDのテスト
//BlendMode.ADDのテスト

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;

    public class FlashTest extends Sprite{
        private var blurStage:Sprite = new Sprite();
        private var filter:BlurFilter = new BlurFilter(2, 3, 1);
        private var _now:BitmapData;
        private var circle:Circle = new Circle();
        
        public function FlashTest() {
            Wonderfl.capture_delay(5);
            
            //軌跡の準備
            _now = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            blurStage.addChild(new Bitmap(_now));
            blurStage.filters = [filter];
            this.addChild(blurStage);
            
            this.addChild(circle);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, drawCircle);
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function drawCircle(event:MouseEvent):void{            
            circle.x = mouseX;
            circle.y = mouseY;
            circle.changeColor();
            event.updateAfterEvent();
        }
        //更新
        public function onEnterFrame(event:Event):void{
            _now.draw(this);
            circle.clear();
        }
    }
}

import flash.display.Sprite;
import flash.display.BlendMode;
import flash.filters.BlurFilter;

class Circle extends Sprite{
    private var blur:BlurFilter = new BlurFilter(2,2,3);

    public function Circle(){
        this.filters = [blur];
        this.blendMode = BlendMode.ADD;
    }
    
    public function changeColor(color:uint = 0x000000):uint{
        if(color == 0x000000) color = Math.round(Math.random()*0xffffff);
        this.graphics.clear();
        this.graphics.lineStyle(5,color,0.8);
        this.graphics.drawCircle(0,0,10+Math.round(Math.random()*20));
        return color;
    }
    
    public function clear():void{
        this.graphics.clear();
    }
}