/**
 * Copyright kamip ( http://wonderfl.net/user/kamip )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/TREE
 */

package 
{
	 /**
	 * Matrix3Dを使ってBitmap画像を回転
	 * クリックする度に画像が増えていく
	 * クリックし過ぎると重くなるのでご注意ください
	 * http://d.hatena.ne.jp/kamip/
	 */
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix3D;
	import flash.net.URLRequest;
	import flash.display.Bitmap;
	import flash.geom.Vector3D;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	import flash.display.BitmapData;
	
	/**
	* ...
	* @author kamip
	*/
	[SWF(width="460", height="460", backgroundColor="0xFFFFFF", frameRate="30")]
	public class MatrixSample extends Sprite
	{
		private var bitmap:Bitmap;
		private var loader:Loader;
		private var mat:Matrix3D;
		private var tx:Number = stage.stageWidth / 2;
		private var ty:Number = stage.stageHeight / 2;
		private var tf:TextField = new TextField();
		private var i:int;
		private var load:Loader;
		private var renderList:Array = new Array();
		
		//コンストラクタ
		public function MatrixSample() {			
			loader = new Loader();
			var request:URLRequest = new URLRequest("http://a1.twimg.com/profile_images/419658790/kami_s.gif");
			var lc:LoaderContext = new LoaderContext();
			lc.checkPolicyFile = true;
			loader.load(request, lc);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loaderComplete);
			stage.addEventListener(MouseEvent.CLICK, onMouseClick);
		}
		
		//マウスクリックのイベント（全てはここがスタート）
		public function onMouseClick(e:MouseEvent):void{
			var bitm:Bitmap = new Bitmap(bitmap.bitmapData.clone());
			addChild(bitm);
			bitm.x = mouseX;
			bitm.y = mouseY;
			bitm.z = 0;
			var matm:Matrix3D = bitm.transform.matrix3D;
			//onEnterFrameに引数を付けて実行
			addEventListener(Event.ENTER_FRAME, onEnterFrame(matm, bitm));
			renderList.push(bitm);
		}
		
		//画像を読み込み終わったらbitmapに格納
		public function loaderComplete(e:Event):void{
			load = Loader(e.target.loader);
			bitmap = Bitmap(load.content);
		}
		
		//魔法の書き方
		public function onEnterFrame(matm:Matrix3D, bitm:Bitmap):Function
		{
			return function():void{
				matm.appendTranslation( -tx, -ty, 0);
				matm.appendRotation(2, Vector3D.Y_AXIS);
				matm.appendTranslation(tx, ty, 0);
				bitm.transform.matrix3D = matm;
				renderList.sort(zSort);
				for (var i:int = 0; i < renderList.length; i++) {
					setChildIndex(renderList[i], i);
				}
			}
		}
		//重なり具合をzプロパティで調整
		//確か大重さんの本から。
		public function zSort(objA:DisplayObject, objB:DisplayObject):int{
			var matA:Matrix3D = objA.transform.getRelativeMatrix3D(root);
			var matB:Matrix3D = objB.transform.getRelativeMatrix3D(root);
			var posA:Vector3D = matA.position;
			var posB:Vector3D = matB.position;
			return posB.z - posA.z;
		}
		
	}
}
