/**
 * Copyright Saqoosha ( http://wonderfl.net/user/Saqoosha )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/T5pq
 */

// write as3 code here..
package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.utils.getTimer;
	
	import org.libspark.thread.utils.ParallelExecutor;
	
	[SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
	
	public class Sntk extends Sprite {
		
		private static const NUM_PANELS:int = 10;
		
		private var _panels:Array;
		
		public function Sntk() {
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this._onImageLoaded);
			loader.load(new URLRequest('http://saqoosha.net/images/sntk.jpg'), new LoaderContext(true));
		}
		
		private function _onImageLoaded(e:Event):void {
			var loader:Loader = LoaderInfo(e.target).loader;
			this._panels = [];
			for (var i:int = 0; i < NUM_PANELS; i++) {
				var p:Panel = this.addChild(new Panel(Bitmap(loader.content).bitmapData)) as Panel;
				this._panels.push(p);
			}
			this.addEventListener(Event.ENTER_FRAME, this._update);
		}
		
		private function _update(e:Event):void {
			var t:Number = getTimer() / 300;
			var r:Number = (Math.sin(getTimer() / 1000) + 1);
			var tmp:Array = [];
			for (var i:int = 0; i < NUM_PANELS; i++) {
				var p:Panel = this._panels[i];
				var a:Number = i / NUM_PANELS * Math.PI * 2 + t;
				p.x = Math.cos(a) * 150 * r + 230;
				p.y = Math.sin(a) * 70 * r + 230;
				tmp.push({
					panel: p,
					y: p.y
				});
			}
			tmp.sortOn('y', Array.NUMERIC);
			for (i = 0; i < NUM_PANELS; i++) {
				this.setChildIndex(tmp[i].panel, i);
			}
		}
	}
}


import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.PixelSnapping;
import flash.display.BlendMode;

class Panel extends Sprite {
	
	private var _image:Bitmap;
	
	public function Panel(image:BitmapData) {
		this._image = this.addChild(new Bitmap(image, PixelSnapping.AUTO, true)) as Bitmap;
		this._image.width = this._image.height = 80;
		this._image.x = this._image.y = -50;
		this.blendMode = BlendMode.ADD;
		this.alpha = 0.3;
	}
}