/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Sukr
 */

// forked from saharan's Life in Life
package{
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import com.bit101.components.Panel;
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    import net.hires.debug.Stats;

    /**
     * an implementation of Hashlife algorithm in AS3
     * see: http://en.wikipedia.org/wiki/Hashlife
     *      http://www.conwaylife.com/wiki/OTCA_metapixel
     *      http://www.conwaylife.com/wiki/124P37
     * special thanks: phi16
     * @author saharan
     */
    [SWF(width = "465", height = "465", frameRate = "60")]
    public class Hashlife extends Sprite {
        private var field:Field;
        private var drawScale:int;
        private var levelShift:int;
        private var shiftX:Number;
        private var shiftY:Number;
        private var shiftX2:Number;
        private var shiftY2:Number;
        private var bmd:BitmapData;
        private var pixels:Vector.<uint>;
        private var gcCount:int;
        private var ct:ColorTransform;
        private var pmouseX:Number;
        private var pmouseY:Number;
        private var invPixelArea:Number;
        private var pressing:Boolean;
        private var calcStep:Boolean;
        private var pause:Boolean;

        public function Hashlife() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);

            ct = new ColorTransform(0.3, 0.325, 0.35);

            bmd = new BitmapData(465, 425, false, 0);
            var bm:Bitmap = new Bitmap(bmd);
            bm.y = 40;
            addChild(bm);

            var tf:TextField = new TextField();
            tf.y = 40;
            tf.width = 465;
            tf.height = 425;
            tf.alpha = 0;
            tf.selectable = false;
            tf.text = "\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r";
            tf.scrollV = 64;
            tf.addEventListener(MouseEvent.MOUSE_WHEEL, function(e:MouseEvent):void {
                tf.scrollV = 64;
            });
            addChild(tf);

            Style.embedFonts = false;
            Style.fontSize = 12;
            Style.fontName = "Courier New";
            var panel:Panel = new Panel(this, 0, 0);
            panel.width = 465;
            panel.height = 40;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {
                if (mouseY >= 40) pressing = true;
            });
            stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void {
                pressing = false;
            });
            var speedLabel:Label = new Label(panel, 8, 20, "Speed: x1");
            var speedSlider:HSlider = new HSlider(panel, 8, 8, function(e:Event):void {
                var speed:int = speedSlider.value;
                speedLabel.text = "Speed: x" + (1 << speed);
                if (field.speed != speed) field.setSpeed(speed);
            });
            speedSlider.width = 152;
            speedSlider.height = 12;
            speedSlider.minimum = 0;
            speedSlider.maximum = 16;
            speedSlider.tick = 1;
            var scaleLabel:Label = new Label(panel, 168, 20, "Scale: x1");
            var scaleSlider:HSlider = new HSlider(panel, 168, 8, function(e:Event):void {
                var scale:int = scaleSlider.value;
                if (scale < 0) {
                    levelShift = 0;
                    drawScale = -scale;
                    scaleLabel.text = "Scale: x" + (1 << drawScale) + ".0";
                } else if (scale > 0) {
                    drawScale = 0;
                    levelShift = scale;
                    scaleLabel.text = "Scale: x" + 1 / (1 << levelShift);
                } else {
                    drawScale = 0;
                    levelShift = 0;
                    scaleLabel.text = "Scale: x1.0";
                }
            });
            scaleSlider.width = 152;
            scaleSlider.height = 12;
            scaleSlider.minimum = 10;
            scaleSlider.maximum = -4;
            scaleSlider.tick = 1;
            scaleSlider.value = 0;

            var pauseButton:PushButton = new PushButton(panel, 328, 8, "Pause", function(e:Event):void {
                pause = pauseButton.selected;
            });
            pauseButton.width = 56;
            pauseButton.height = 24;
            pauseButton.toggle = true;

            var stepButton:PushButton = new PushButton(panel, 392, 8, "Step", function(e:Event):void {
                if (pause) calcStep = true;
            });
            stepButton.width = 65;
            stepButton.height = 24;

            stage.addEventListener(MouseEvent.MOUSE_WHEEL, function(e:MouseEvent):void {
                if (e.delta > 0) {
                    levelShift--;
                    if (levelShift < 0) {
                        levelShift = 0;
                        drawScale++;
                        if (drawScale > 4) drawScale = 4;
                    }
                } else if (e.delta < 0) {
                    drawScale--;
                    if (drawScale < 0) {
                        drawScale = 0;
                        levelShift++;
                        if (levelShift > 10) levelShift = 10;
                    }
                }
                if (drawScale > 0) {
                    scaleLabel.text = "Scale: x" + (1 << drawScale) + ".0";
                    scaleSlider.value = -drawScale;
                } else if (levelShift > 0) {
                    scaleLabel.text = "Scale: x" + 1 / (1 << levelShift);
                    scaleSlider.value = levelShift;
                } else {
                    scaleLabel.text = "Scale: x1.0";
                    scaleSlider.value = 0;
                }
            });
            stage.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent):void {
                switch(e.keyCode) {
                case Keyboard.UP:
                    if (field.nm.speed < 16) field.setSpeed(field.speed + 1);
                    break;
                case Keyboard.DOWN:
                    if (field.nm.speed > 0) field.setSpeed(field.speed - 1);
                    break;
                }
                speedLabel.text = "Speed: x" + (1 << field.speed);
                speedSlider.value = field.speed;
            });

            drawScale = 0;
            levelShift = 0;

            initField();

            addEventListener(Event.ENTER_FRAME, frame);
        }

        private function initField():void {
            field = new Field();

            var s:int = 2048;

            field.init(13);
            putOTCAMetaPixelOff3x3(1024, 1024);

            var u:Node = field.universe;
            var b00:Node = field.nm.getNode(u.e00.e00.e11, u.e00.e01.e10, u.e00.e10.e01, u.e00.e11.e00);
            var b01:Node = field.nm.getNode(u.e00.e01.e11, u.e01.e00.e10, u.e00.e11.e01, u.e01.e10.e00);
            var b02:Node = field.nm.getNode(u.e01.e00.e11, u.e01.e01.e10, u.e01.e10.e01, u.e01.e11.e00);
            var b10:Node = field.nm.getNode(u.e00.e10.e11, u.e00.e11.e10, u.e10.e00.e01, u.e10.e01.e00);
            var b11:Node = field.nm.getNode(u.e00.e11.e11, u.e01.e10.e10, u.e10.e01.e01, u.e11.e00.e00);
            var b12:Node = field.nm.getNode(u.e01.e10.e11, u.e01.e11.e10, u.e11.e00.e01, u.e11.e01.e00);
            var b20:Node = field.nm.getNode(u.e10.e00.e11, u.e10.e01.e10, u.e10.e10.e01, u.e10.e11.e00);
            var b21:Node = field.nm.getNode(u.e10.e01.e11, u.e11.e00.e10, u.e10.e11.e01, u.e11.e10.e00);
            var b22:Node = field.nm.getNode(u.e11.e00.e11, u.e11.e01.e10, u.e11.e10.e01, u.e11.e11.e00);

            field.init(13);
            putOTCAMetaPixelOn3x3(1024, 1024);

            u = field.universe;
            var o11:Node = field.nm.getNode(u.e00.e11.e11, u.e01.e10.e10, u.e10.e01.e01, u.e11.e00.e00);

            field.init(17);

            // init meta field
            for (var i:int = 0; i < 39; i++) {
                for (var j:int = 0; j < 39; j++) {
                    var cell:Node = null;
                    if (i == 0) {
                        if (j == 0) cell = b00;
                        else if (j == 38) cell = b20;
                        else cell = b10;
                    } else if (i == 38) {
                        if (j == 0) cell = b02;
                        else if (j == 38) cell = b22;
                        else cell = b12;
                    } else {
                        if (j == 0) cell = b01;
                        else if (j == 38) cell = b21;
                        else cell = b11;
                    }
                    field.setCellAtLevel(i + 13, j + 13, cell);
                }
            }
            // put meta pixel on meta field
            parseRLE(37, 37, 14, 14, "11b2o11b2o11b$11b2o11b2o11b3$6bo23bo6b$5bobo5bo9bo5bobo5b$4bo2bo5bob2o3b2obo5bo2bo4b$5b2o10bobo10b2o5b$15bobobobo15b$16bo3bo16b2$2o33b2o$2o33b2o$5b2o23b2o5b2$6bobo19bobo6b$6bo2bo17bo2bo6b$7b2o19b2o7b2$7b2o19b2o7b$6bo2bo17bo2bo6b$6bobo19bobo6b2$5b2o23b2o5b$2o33b2o$2o33b2o2$16bo3bo16b$15bobobobo15b$5b2o10bobo10b2o5b$4bo2bo5bob2o3b2obo5bo2bo4b$5bobo5bo9bo5bobo5b$6bo23bo6b3$11b2o11b2o11b$11b2o11b2o", o11);

            shiftX = shiftX2 = -(1 << 17);
            shiftY = shiftY2 = -(1 << 17);
        }

        private function putOTCAMetaPixelOn3x3(x:int, y:int):void {
            parseRLE(2058, 2058, -5 + x, -5 + y, "bo2054bo$obo2052bobo$bo2054bo2$4b2o2046b2o$4b2o8b4o157b2o829b2o41b2o1001b2o$13bo3bo41b2o35b2o77b2o829b2o41bo$17bo41b2o35b2o949bobo$13bo2bo1030b2o$2016b2o5b2o20b2o$58b2o2b2o27b2o2b2o1915b2o2b2o5b2o2b2o15bobo$9b2o3bo5bo5bo5bo5bo5bo5bo7b2o2b2o27b2o2b2o1915b2o13b2o14bo$9bo3bobo3bobo3bobo3bobo3bobo3bobo3bobo1990bo$10bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo1740bo249b3o3bobo$11bobo3bobo3bobo3bobo3bobo3bobo3bobo3bo5b2o18b2o4b3o1703bo2bo251bo5bo$12bo5bo5bo5bo5bo5bo5bo5bo3bobo18b2o3bo3bo1702b5o249bo6bo$55bo2bo25b2ob2o1702b3ob2o16b2o229bo4bo2bo$56bobo26bobo1694bo9b2obo16bo230bo6b3o$57bo110b3o3b3o1603b3o10b2o16bo2b2o226bo$85bobo80b3o3b3o1602bo31bo2bo228b3o$84b2ob2o78bob2o3b2obo1602b3o10b2o16bobo10bo221bo$84bo3bo78bob2o3b2obo1604bo9b2obo16b2o10b3o189b3o3b3o20bo$85b3o80b2o5b2o1614b3ob2o30bo188bo2bobo2bo19bo$169bo5bo1615b5o16b2o10b3o189b2obobob2o18bo$184b2o8b3o14b2o1578bo2bo16bobo10bo191b2o5b2o17bo$184b2o8bo3bo12b2o1580bo17bo2bo228b3o$194bo4bo1611bo2b2o230bo$195bo3bo1612bo232bo$1777bo16bo18b2o229bo$10b2o152b2o13b2o14bo3bo7b3o1567b3o14bobo221b2ob2o20bo$10b2o152b2o2b2o5b2o2b2o13bo4bo5b2obob2o1568bo13b2o220bo2bobo2bo17bo$78b3o5b3o79b2o5b2o7b2o8bo3bo5bo5b2o1567b2o235bobo3bobo18b3o$15bo3b2o57bo2b2ob2o2bo95b2o8b3o8b2obob2o1804b3o3b3o21bo$9b2o2b2obob3o13b2o43b3o3b3o119b3o1813b2o20bo$9b2o2bo4b3o13b2o44bo5bo1936b2o19bo$13bo3bo2005b2o18bo$14b3o2025bo$28b2o3b2o2008b3o$14b3o10b3o3b3o39b2o13b2o1954bo$13bo3bo7b3o7b3o37b2o2b2o5b2o2b2o1953bo$9b2o2bo4b3o4b3o7b3o41b2o5b2o1701b2o253bo$9b2o2b2obob3o4b3o7b3o1743b2o6bobo251bo$15bo3b2o6b3o3b3o1744bobo6bo252bo$28b2o3b2o1745bo191b2o5b2o62b3o$10b2o1767b2o187b2o2b2o5b2o2b2o61bo$10b2o958b2o967b2o27b2o13b2o60bo$224b2o743bo2bo832bo3b2o127bo2bo102bo$224b2o744b2o831b2obob3o128b2o102bo$1803bo4b3o231bo$1792bobo2b2o4bo3bo14bo220b3o$1791bo3bob3o4b3o15b3o221bo$65b2o5b2o1718bo6b2o24bo219bo$61b2o2b2o5b2o2b2o1702bo12b5obo4b3o15b3o219bo$61b2o2b2o5b2o2b2o1700b3o15b3o4bo3bo14bo150bo5bo63bo$65b3o3b3o1703bo25bo4b3o161bobo3bobo61bo$64bo2bo3bo2bo1703b3o15b3o4b2obob3o160bo3bobo3bo59bo$68bobo1709bo12b5obo5bo3b2o160bo3bobo3bo58bo$64b2o7b2o26b2o115bo5bo756b2o809bo6b2o170bo9bo57bo$64b2o7b2o26bo2bobo110b3o3b3o755bo2bobo804bo3bob3o240b3o3b2o$67bo3bo31b2ob3o107b2o2bobo2b2o756b2ob3o803bobo2b2o173b2o5b2o62bo2b2o2b2o$67b2ob2o37bo105bob4ob4obo761bo1052b2o6b2o$65b3o3b3o29b2ob3o108b3o3b3o757b2ob3o1015b2o$65b2o5b2o16bo3bo8b2obo109b3o5b3o750b2obo2b2obo995bo21b2o40b2o$65bo7bo15bo5bo876b3o2b2o2bo992bo3bob2o2bo8b2o51b2o$95bo877b2o6bo997bo4bo10bo$81bo8bo3b2o865bo12b3o3b2o988b2o3bobo2bo2bob2o5b2o2bo8b2o$79b3o9b3o865b3o13bo3bo995bobo3b2o3bo6bo2bo8b2o$78bo879bo1019bob7o7bobo$79b3o9b3o19bo845b3o13bo3bo13bo976bo2bo8b3o9b2o$81bo8bo3b2o7bo7b3o847bo12b3o3b2o9b3o978b2o$95bo4bo2bob2o3bo102b2o13b2o743b2o6bo8bo992b2o9b2o$89bo5bo10bo4bo101b2o2b2o5b2o2b2o742b3o2b2o2bo9bo989bo3b2o7bobo$90bo3bo10bo4b2o105b2o5b2o751b2obo9b2o989bo4bo6bo2bo8b2o$44b2o27b2o1906bo3b2o5b2o2bo8b2o$44b2o25b2ob2o25b5o1877b2o10bo$69bo2bobo27b4o1887b2o23b2o$49bo3b2o14bo34bo1899b2o12b2o$43b2o2b2obob3o14bo4bo1929b2o29bo$43b2o2bo4b3o15bo3bo1915bo39bo3bo$47bo3bo15b2o2b3o1915bobo25b2o10bo8b2o2b2o$48b3o16b2o1920bobo25b2o10bo2b2o5bo2b2o$1988b2ob2o37b2o5bobo$48b3o1980b3o3b2o$47bo3bo$43b2o2bo4b3o13b2o150b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o78bo5bo37b3o3b2o$43b2o2b2obob3o13b2o146b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obo2bo3bo2bob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obobo5bobob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obo2bo3bo2bob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obobo5bobob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o73b3o3b3o35b2o5bobo$49bo3b2o161b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2obo9bob2o23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2obo9bob2o23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o72bo2b2ob2o2bo21b2o10bo2b2o5bo$381bo5bo151bo2bo3bo2bo147b2o4bobo4b2o589bo5bo151bo2bo3bo2bo147b2o4bobo4b2o353bo3bobo3bo21b2o10bo8b2o$44b2o175bo5bo152b3o3b3o151bob2ob2obo151bo2bobo2bo432bo5bo152b3o3b3o151bob2ob2obo151bo2bobo2bo358bobobobo36bo3bo$44b2o174b3o3b3o150b2o2bobo2b2o149b2o7b2o431bo5bo152b3o3b3o150b2o2bobo2b2o149b2o7b2o431bo5bo127bo$219bo2b2ob2o2bo149b2ob2ob2ob2o149b2o7b2o271bo5bo152b3o3b3o150bo2b2ob2o2bo149b2ob2ob2ob2o149b2o7b2o271bo5bo152b3o3b3o75b2ob2o3b2ob2o21b2o$219bo3bobo3bo152b2ob2o152b3o5b3o111bo5bo152b3o3b3o150b2o2bobo2b2o149bo3bobo3bo152b2ob2o152b3o5b3o111bo5bo152b3o3b3o150b2o2bobo2b2o76bo7bo23b2o26b2o$132b2o23b2o62bobobobo152bobo3bobo112bo5bo33b3ob3o112b3o3b3o31bo7bo110bo2b2ob2o2bo149bo3bobo3bo30b2o5b2o112bobobobo152bobo3bobo112bo5bo33b3ob3o112b3o3b3o31bo7bo110bo2b2ob2o2bo149bo3bobo3bo136b2o$133bo22bobo182bo5bo31bo2bo3bo2bo30bo7bo71b3o3b3o34bobo113b2obo3bob2o31bobobobo111b3o5b3o30b3o3b3o110bob2o3b2obo271bo5bo31bo2bo3bo2bo30bo7bo71b3o3b3o34bobo113b2obo3bob2o31bobobobo111b3o5b3o30b3o3b3o110bob2o3b2obo$133bobo82b2ob2o3b2ob2o29bo7bo71b3o3b3o33bo3bo32bo2bo3bo2bo70bob2ob2obo31bo2bobo2bo152bobobobo151bo9bo109b2o7b2o29bo9bo71bo5bo30b2ob2o3b2ob2o29bo7bo71b3o3b3o33bo3bo32bo2bo3bo2bo70bob2ob2obo31bo2bobo2bo152bobobobo151bo9bo109b2o7b2o$134b2o84bo7bo29bob2o5b2obo68b2o2bobo2b2o29bobo5bobo33bobo76b2ob2o32bo2bo3bo2bo32b2ob2o113bob2ob2obo150bo3bobo3bo70b3o3b3o70bo3bobo3bo70b3o3b3o31bo7bo29bob2o5b2obo68b2o2bobo2b2o29bobo5bobo33bobo76b2ob2o32bo2bo3bo2bo32b2ob2o113bob2ob2obo150bo3bobo3bo70b3o3b3o177b2o$147b4o8bo98bo3b2ob2o3bo67bob4ob4obo29bo7bo34bobo34bo7bo33b2ob2o33b2o5b2o32bo5bo32b2o5b2o33bo3bo33b2o5b2o71b3o3b3o71b3o3b3o71b3o3b3o70bo3bobo3bo69b2ob2ob2ob2o68bo3b2ob2o3bo67bob4ob4obo29bo7bo34bobo34bo7bo33b2ob2o33b2o5b2o32bo5bo32b2o5b2o33bo3bo33b2o5b2o71b3o3b3o71b3o3b3o71b3o3b3o177b2o2b2o$147bob2o7b2o99bo3bobo3bo29b3o5b3o30b3o3b3o74bobo34b2o5b2o33b2ob2o112bo2bo3bo2bo32bo3bo113bo2bobo2bo72bo5bo71bob2o3b2obo70bobo3bobo69b3o7b3o68bo3bobo3bo29b3o5b3o30b3o3b3o74bobo34b2o5b2o33b2ob2o112bo2bo3bo2bo32bo3bo113bo2bobo2bo72bo5bo71bob2o3b2obo180b2o$147bo112b3o3b3o30b3o5b3o29b3o5b3o69bo2bo3bo2bo30b3o3b3o111bo7bo33b2ob2o153b2obobob2o111bo7bo30bob2o3b2obo71bo5bo31b3o5b3o110b3o3b3o30b3o5b3o29b3o5b3o69bo2bo3bo2bo30b3o3b3o111bo7bo33b2ob2o153b2obobob2o111bo7bo30bob2o3b2obo$148b2o150b2o5b2o111b3o3b3o33b2ob2o113bo2bobo2bo32bobobobo111b2obo3bob2o30b2o5b2o110b4o3b4o30b2o5b2o109b2ob2o3b2ob2o29bo7bo111b2o5b2o111b3o3b3o33b2ob2o113bo2bobo2bo32bobobobo111b2obo3bob2o30b2o5b2o110b4o3b4o30b2o5b2o$302bo3bo155bo3bo113b3o3b3o32bobobobo111bo2bo3bo2bo149bo3bobo3bo31bo5bo110b2obobobobob2o151bo3bo155bo3bo113b3o3b3o32bobobobo111bo2bo3bo2bo149bo3bobo3bo31bo5bo116b2o$148b2o150bo2bobo2bo150b2o7b2o149bo9bo110b3o3b3o151bo2bobo2bo150bo3bobo3bo150bo2bobo2bo150b2o7b2o149bo9bo110b3o3b3o151bo2bobo2bo155bo14b2o$147bo151bo3bobo3bo53b2o41bo42bo9b2o7b2o17b2o78bo50bo11bo210bo58b3o3b3o150bo2bo3bo2bo149bo3bobo3bo53b2o41bo42bo9b2o7b2o17b2o78bo50bo11bo210bo58b3o3b3o154b2o15bo$118b2o2bobo22bob2o7b2o43b2o40b2o42b4o7bo2bobo2bo18b3o31b5o40b2o41bo2b2o9bobo20bo11b4o19bo3b2o38bo2bo39bobo2b2o30bo3bo29bob2o85bo3b3o67bo3bo43bo72b2o85b2o8b3o3b3o19b2o33b2o40b2o42b4o7bo2bobo2bo18b3o31b5o40b2o41bo2b2o9bobo20bo11b4o19bo3b2o38bo2bo39bobo2b2o30bo3bo29bob2o85bo3b3o67bo3bo43bo72b2o99bo2bo7b2obo$111b2o4b3obo3bo21b4o8bo41b2ob2o38bo2b2o40bo2b2o6b3o3b3o17bo4bo5b3obo18bo4bo38bob3o39bo5bo4bo2bo3bo2bo15bo2b2o7b6o16b2obob3o38b5o37bo3bob3o6b2ob2o17bo5bo5bo21bo2b2o2b3o41b2o36bobo2b5o5b2ob2o16b3o33bo7bo42b2o35b2o2bo4b2o4b2ob2o15bobo39b4o42bobo34bo2bo9b2o19b2ob2o38bo2b2o40bo2b2o6b3o3b3o17bo4bo5b3obo18bo4bo38bob3o39bo5bo4bo2bo3bo2bo15bo2b2o7b6o16b2obob3o38b5o37bo3bob3o6b2ob2o17bo5bo5bo21bo2b2o2b3o41b2o36bobo2b5o5b2ob2o16b3o33bo7bo42b2o35b2o2bo4b2o4b2ob2o15bobo100b3o7b2ob2o$111b2o3b2o6bo76bo2bo38b6o41bo2b2o30bo5bo5b2obob2o16bo2b3o42b2o39bobo2b2o4b3o3b3o16bo2bo7b2o2b3o16bo4b3o38b3ob2o37bo6b2o3bo2bobo2bo15bo33bo6b2o43b2o35bo3b2o3b2o2bo2bobo2bo14bo3bo29bo5b2o2bo43b2o34bob2o6bo3bo5bo14bo35bo5b2obo42bob2o32b2o2bo6b2ob3o18bo2bo38b6o41bo2b2o30bo5bo5b2obob2o16bo2b3o42b2o39bobo2b2o4b3o3b3o16bo2bo7b2o2b3o16bo4b3o38b3ob2o37bo6b2o3bo2bobo2bo15bo33bo6b2o43b2o35bo3b2o3b2o2bo2bobo2bo14bo3bo29bo5b2o2bo43b2o34bob2o6bo3bo5bo14bo102b3o$117bob5o72bo4bo2bo31bo3bo4b4o4bobo20bo13bo2bo22bo9bo9bob2ob3o12bo3b2o2bo31bobobo6b2o27bo12bo3b2o21bo8bobo7b3o4b2o12bo2bo3bo32bo9b2obo26bo12b5obo4b3o3b3o7bo7b2o3bo26b4o3b3o30bo9b5o25bo11bo2bo3b2o3bobo3bobo7bo6bo4bo27bob2o5b2o29bo9b2o2b2o24bo11bo6bob4ob2ob5o6bo5b3o31bo2b2o6bo6bo21bo14b2o23bo10bo2bo4bob2obobo13bo4bo2bo31bo3bo4b4o4bobo20bo13bo2bo22bo9bo9bob2ob3o12bo3b2o2bo31bobobo6b2o27bo12bo3b2o21bo8bobo7b3o4b2o12bo2bo3bo32bo9b2obo26bo12b5obo4b3o3b3o7bo7b2o3bo26b4o3b3o30bo9b5o25bo11bo2bo3b2o3bobo3bobo7bo6bo4bo27bob2o5b2o29bo9b2o2b2o24bo11bo6bob4ob2ob5o6bo5b3o110b2ob2o$118b3o35bobo35b3o5b2o15bo14b7o33b3o14b2o21b3o10b2o7b3obobo11b3o5b2o11b3o16b3obobo6bo26b3o14b3o20b3o9b2o7b2o5b2o10b3o3b3o12bo18b3o10b2o25b3o15b3o19b3o9b3o25b3o3bo3bo9b2o18b3o9b4o24b3o12b3o3bo4b3o3b3o5b3o7bo3bo25b3ob2o3b3o8b2o18b3o37b3o11b3o4b2o2b2ob2ob3ob2o3b3o22bo14b6o5b2o5b4o18b3o14bo22b3o11bo6bobo3bobo10b3o5b2o15bo14b7o33b3o14b2o21b3o10b2o7b3obobo11b3o5b2o11b3o16b3obobo6bo26b3o14b3o20b3o9b2o7b2o5b2o10b3o3b3o12bo18b3o10b2o25b3o15b3o19b3o9b3o25b3o3bo3bo9b2o18b3o9b4o24b3o12b3o3bo4b3o3b3o5b3o7bo3bo25b3ob2o3b3o8b2o18b3o37b3o11b3o4b2o2b2ob2ob3ob2o3b3o22bo96bobo$157b2o34bo21b5o13bo22bo16bo39bo23b4o12bo21b6o12bo39bo39bo20b3o4b3o9bo20b2o3b2o12bo39bo39bo22b2o15bo19bo2bo16bo39bo33b2o4bo22bob2o13bo18b2o2bo16bo39bo27bo6b3o2bo21b2o2bo13bo22bo16bo39bo23bo3b2o10bo21b5o13bo22bo16bo39bo23b4o12bo21b6o12bo39bo39bo20b3o4b3o9bo20b2o3b2o12bo39bo39bo22b2o15bo19bo2bo16bo39bo33b2o4bo22bob2o13bo18b2o2bo16bo39bo27bo6b3o2bo21b2o2bo30bo65bobo$118b3o73b3o5b2o10bo2b3o7b2o5b7o26b2o5b3o14b2o14b2o5b3o10b2o5b2o3b4o4b2o5b3o5b2o10bo3b2o7b2o5b3obobo6bo19b2o5b3o14b3o13b2o5b3o9b2o13b2o4b2o5b3o3b3o11bo12b2o5b3o10b2o18b2o5b3o15b3o12b2o5b3o9b3o6b3obo7b2o5b3o3bo3bo8bo2bo10b2o5b3o9b4o17b2o5b3o12b3o3bo11b2o5b3o7bo3bo5b2o3b2o6b2o5b3ob2o3b3o6bo2bo11b2o5b3o30b2o5b3o11b3o4b2o10bobo4b3o17bo2bo2bo6b2o5b6o5b2o5bo4bo9b2o5b3o14bo15b2o5b3o11bo6b3o3bo5b2o5b3o5b2o10bo2b3o7b2o5b7o26b2o5b3o14b2o14b2o5b3o10b2o5b2o3b4o4b2o5b3o5b2o10bo3b2o7b2o5b3obobo6bo19b2o5b3o14b3o13b2o5b3o9b2o13b2o4b2o5b3o3b3o11bo12b2o5b3o10b2o18b2o5b3o15b3o12b2o5b3o9b3o6b3obo7b2o5b3o3bo3bo8bo2bo10b2o5b3o9b4o17b2o5b3o12b3o3bo11b2o5b3o7bo3bo5b2o3b2o6b2o5b3ob2o3b3o6bo2bo11b2o5b3o30b2o5b3o11b3o4b2o10bobo4b3o17bo2bo2bo6b2o21b3o64bo$117bob5o14b2o56bo4bo2bo10b2o10b2o7bo3bo4b4o4bo2bo10b2o7bo13bo2bo13b2o7bo9bo8bob2o8b2o7bo3b2o2bo10b4o8b2o7bobobo6b2o18b2o7bo12bo3b2o12b2o7bo8bobo9b2obo6b2o7bo2bo3bo10b3o10b2o7bo9b2obo17b2o7bo12b5obo11b2o7bo7b2o3bo8bob2o5b2o7b4o3b3o7b2ob2o9b2o7bo9b5o16b2o7bo11bo2bo3b2o10b2o7bo6bo4bo7bob3o6b2o7bob2o5b2o8bo11b2o7bo9b2o2b2o15b2o7bo11bo6bobo9b2o7bo5b3o10b2o10b2o7bo2b2o6bo5bo13b2o7bo14b2o14b2o7bo10bo2bo4bob2o8b2o7bo4bo2bo10b2o10b2o7bo3bo4b4o4bo2bo10b2o7bo13bo2bo13b2o7bo9bo8bob2o8b2o7bo3b2o2bo10b4o8b2o7bobobo6b2o18b2o7bo12bo3b2o12b2o7bo8bobo9b2obo6b2o7bo2bo3bo10b3o10b2o7bo9b2obo17b2o7bo12b5obo11b2o7bo7b2o3bo8bob2o5b2o7b4o3b3o7b2ob2o9b2o7bo9b5o16b2o7bo11bo2bo3b2o10b2o7bo6bo4bo7bob3o6b2o7bob2o5b2o8bo11b2o7bo9b2o2b2o15b2o7bo11bo6bobo9b2o7bo5b3o10b2o10b2o24bo51bobo$111b2o3b2o6bo8bo5bo61bo2bo38b6o4bo36bo2b2o30bo5bo4bo2bo20bo2b3o10bobo29b2o4bo34bobo2b2o29bo2bo5bo4b2o18bo4b3o8bo29b3ob2o37bo6b2o27bo10bo4b2o16bo6b2o7bob2o32b2o35bo3b2o3b2o25bo3bo9b2o18bo5b2o2bo5bobo35b2o34bob2o6b2o23bo35bo5b2obo6b3o33bob2o32b2o2bo8bo21bo2bo38b6o4bo36bo2b2o30bo5bo4bo2bo20bo2b3o10bobo29b2o4bo34bobo2b2o29bo2bo5bo4b2o18bo4b3o8bo29b3ob2o37bo6b2o27bo10bo4b2o16bo6b2o7bob2o32b2o35bo3b2o3b2o25bo3bo9b2o18bo5b2o2bo5bobo35b2o34bob2o6b2o23bo49b2o51b2obo$111b2o4b3obo3bo7bo4bo4b2o56b2ob2o12bo25bo2b2o5b2o33bo2b2o32bo4bo4bo2bo20bo4bo11bo26bob3o5bo33bo5bo30bo2b2o5b2o2bo19b2obob3o11b2o25b5o37bo3bob3o28bo5bo8b2o17bo2b2o2b3o7b4o30b2o36bobo2b5o26b3o12bobo18bo7bo6bo35b2o35b2o2bo4b2o24bobo39b4o42bobo34bo2bo6b2o22b2ob2o12bo25bo2b2o5b2o33bo2b2o32bo4bo4bo2bo20bo4bo11bo26bob3o5bo33bo5bo30bo2b2o5b2o2bo19b2obob3o11b2o25b5o37bo3bob3o28bo5bo8b2o17bo2b2o2b3o7b4o30b2o36bobo2b5o26b3o12bobo18bo7bo6bo35b2o35b2o2bo4b2o24bobo103bo$118b2o2bobo12b3o3b2o58b2o12bobo25b2o42b4o34b3o7b2o22b5o10bobo27b2o41bo2b2o32bo10b2o22bo3b2o11b2o25bo2bo39bobo2b2o30bo3bo5bo2b2o19bob2o15bo69bo3b3o42b2obo21bo3bo11b2o30bo72b2o12b3o70b2o36b2o7bo25b2o12bobo25b2o42b4o34b3o7b2o22b5o10bobo27b2o41bo2b2o32bo10b2o22bo3b2o11b2o25bo2bo39bobo2b2o30bo3bo5bo2b2o19bob2o15bo69bo3b3o42b2obo21bo3bo11b2o30bo72b2o12b3o88b2o$134bob2ob2o75b2o145b2o13bo27bo42bo37b2o49bo28bo89bo39b2o119bo22bo16b3o116b3o37b2o117b2o145b2o13bo27bo42bo37b2o49bo28bo89bo39b2o119bo22bo16b3o116b3o$136bo81bo39b2o116b2o158b3o158b2o118bo39bob2o155b3o119bo39b2o116b2o158b3o158b2o118bo39bob2o155bo$46bo86bo2b3o11b2o44b2o44b2o14b3o27b2o44b2o44b2o35b2o7b2o44b2o44b2o44b2o44b2o44b2o39b2o3b2o44b2o44b2o44b2o15b3o26b2o44b2o44b2o36b2obo4b2o44b2o44b2o44b2o14b3o27b2o44b2o44b2o35b2o7b2o44b2o44b2o44b2o44b2o44b2o39b2o3b2o44b2o44b2o44b2o15b3o26b2o44b2o44b2o35bobo$45bobo65b2o18b2o2b2o9bo4bo40bo4bo40bo4bo11bob2o25bo4bo40bo4bo40bo4bo32b3o5bo4bo40bo4bo40bo4bo40bo4bo10b2o28bo4bo40bo4bo40bo4bo40bo4bo40bo4bo40bo4bo14bo25bo4bo40bo4bo40bo4bo35b3o2bo4bo40bo4bo40bo4bo40bo4bo11bob2o25bo4bo40bo4bo40bo4bo32b3o5bo4bo40bo4bo40bo4bo40bo4bo10b2o28bo4bo40bo4bo40bo4bo40bo4bo40bo4bo40bo4bo14bo25bo4bo40bo4bo40bo4bo33bobo$45bobo65b2o20bo2bo15bo17b6o22bo17b6o22bo10b3o4b6o22bo17b6o22bo17b6o22bo17b6o8b2obo10bo17b6o22bo17b6o22bo17b6o22bo9b3o5b6o22bo17b6o22bo17b6o22bo17b6o7b2o13bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o12bo9bo17b6o22bo17b6o22bo17b6o22bo10b3o4b6o22bo17b6o22bo17b6o22bo17b6o8b2obo10bo17b6o22bo17b6o22bo17b6o22bo9b3o5b6o22bo17b6o22bo17b6o22bo17b6o7b2o13bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o10bo$46bo88b3o10bo5bo16bo5bo16bo5bo16bo5bo16bo5bo11bo4bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo9b3o4bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo8bob2o4bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo6b3o7bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo7b2o7bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo11bo4bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo9b3o4bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo8bob2o4bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo6b3o7bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo16bo5bo7b2o7bo5bo16bo5bo16bo5bo16bo5bo16bo5bo$127b2o20b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo10bo6b6o22bo17b6o22bo17b6o22bo17b6o8b3o11bo17b6o22bo17b6o22bo17b6o22bo6b2obo7b6o22bo17b6o22bo17b6o22bo17b6o7b3o12bo17b6o22bo17b6o22bo17b6o22bo5b2o10b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo17b6o22bo10bo6b6o22bo17b6o22bo17b6o22bo17b6o8b3o11bo17b6o22bo17b6o22bo17b6o22bo6b2obo7b6o22bo17b6o22bo17b6o22bo17b6o7b3o12bo17b6o22bo17b6o22bo14b2o$112b2o13bobo41bo4bo40bo4bo40bo4bo29b2o9bo4bo40bo4bo40bo4bo40bo4bo40bo4bo40bo4bo33bo6bo4bo40bo4bo40bo4bo40bo4bo8b3o29bo4bo40bo4bo40bo4bo30bob2o6bo4bo40bo4bo40bo4bo40bo4bo5b3o32bo4bo40bo4bo40bo4bo29b2o9bo4bo40bo4bo40bo4bo40bo4bo40bo4bo40bo4bo33bo6bo4bo40bo4bo40bo4bo40bo4bo8b3o29bo4bo40bo4bo40bo4bo30bob2o6bo4bo40bo4bo40bo4bo14bo2bo$112b2o13bob2o42b2o44b2o44b2o31b3o10b2o44b2o44b2o44b2o6b2o36b2o44b2o44b2o44b2o44b2o44b2o11bo32b2o44b2o44b2o32b3o9b2o44b2o44b2o44b2o7b2obo33b2o44b2o44b2o31b3o10b2o44b2o44b2o44b2o6b2o36b2o44b2o44b2o44b2o44b2o44b2o11bo32b2o44b2o44b2o32b3o9b2o44b2o44b2o17b2o$128b2o167bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$128bo13b2o153b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o247b2o$141bobo154bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o86bobo$128bo13bo67b2o246bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o87bo$128b2o80b2o126b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o87b2o$112b2o13bob2o29b2o2bo4b2o16b2o3b2o8bo135b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o$112b2o13bobo30bob2o6b2o4b2o8bo2bobo2bo7bo2b2o130bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$127b2o20bo11bo6bobo5b2o7bo9bo5bo5bo3b2o124b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$147b3o11b3o4b2o14b2o9b2o5bobo2b2o2b2o125bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$113b2o31bo38bo9bo6bo3b2o9b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o36b3o$113b2o32b3o11b3o4b2o16bo2bobo2bo9b3o9b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o35bo2bo$149bo11bo6bobo16b2o3b2o22b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o39bo$135bo24bob2o6b2o32b3o10b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo36bo3bo$134b3o23b2o2bo4b2o31bo3b2o10bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o156bo3bo$134bob2o35bo12b2o14bobo2b2o2b2o165bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o160bo$135b3o11b2o22b2o11b2o13bo5bo3b2o44b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo156bobo$135b3o11bobo20bobo27bo2b2o49b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o$131b3ob3o13bo50bo53b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo$135b3o11b3o5bo52b2o45b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$135b2o20b3o50b2o46bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$113b2o45bo257bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o$113b2o19bo22b3o137b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo$122bo10bo15b3o5bo138b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o151b2o$118b2o2bo10bo17bo144b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo152b2o$112b2o3bo5bo25bobo145b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$112b2o2b2o2bobo12bo13b2o147bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o104b4o$117b2o3bo38b2o295bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o88b2o14bo2b2o4b2o$118b3o41b2o173b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo87b2o15bo2b2o3b2o$161bo174b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o104bo2bo$118b3o215b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo106b2o$117b2o3bo214b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$112b2o2b2o2bobo215bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o66b2o$112b2o3bo5bo48b2o44b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o38b3o24bo2bo$118b2o2bo13b2o34b2o44b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o36bo2bo23bo2b2o3b2o$122bo13bobo78bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o11bo10bo14bo2b2o4b2o$113b2o23bo16b3o3bo55b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o10bo3bob2o4b2o12b4o$113b2o23b2o13b5o2bobo10b2o43bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o10bo3bob2o$152b2o3b2o3bo10b2o203bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o12bo5b2o3bo22b2o$153b2o3bo2bo96b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o35bobo6bobo21b2o$154bo3b3o97b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o167bobo$257bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo169bo$154bo3b3o96b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o368b2o$153b2o3bo2bo96bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o207b2o$152b2o3b2o3bo10b2o243bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o227bo$153b5o2bobo10b2o123b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o213b2o9b2o3bo$153bob3o3bo136b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o206b2o5bobo9b2obob2o$151b2o144bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo207b2o5bo10bo6b2o$145b2o4b3o18b2o123b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o334b3o9b2obob2o$145b2o3bo3bo17b2o124bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o185b2o3bo$149bo5bo302bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o187bo$150b2ob2o183b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o83b2obo3bob2o$338b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o84bo2bo3bo2bo78b3o$150b2ob2o182bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo86b3o3b3o72b2o5bo17b2o$149bo5bo181b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o287b2o5bobo15b2o$150bo3bo183bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o295b2o$151b3o63b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo197b3o$151b3o62b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o196bo2bo87b2o$216b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo200bo87b2o$217b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o315bo3bo7b2ob2o$218bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o156bo3bo8bobo$378bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o160bo8bobo$257b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo156bobo10bo75b2o5b2o$256b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o191b2o52b2o5b2o$144b2o7b2o101b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo192b2o$144bob2o3b2obo102b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o289b2o$144bo3bobo3bo103bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o129b4o7b2o$144b2o2bobo2b2o263bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o128bobobo6bo2b2o9b2o$145b3o3b3o143b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo127b2ob3o4b6o9b2o$146bo5bo143b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o130b2obo5b4o$296b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo131b2obo$297b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$298bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o91b2obo$458bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o91b2obo5b4o$337b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o88bo2bo4b6o9b2o$145b2o5b2o182b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o18b2o6bo2b2o9b2o$145b2o5b2o182b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o17b2o7b2o$337b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o13bo4bo$338bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o14b3o3b3o17b2o51b3o5b3o$151bo2bo63b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o28b3o5bo2bobo2bo17b2o50b2ob2o3b2ob2o$141b3o7bo66b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o197bo2bo6b2ob2o71b2obobobobob2o$127b2o11bo4bo9bo61bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo198bo86bo3bobo3bo$127b2o10bo5bo8b2o61b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o318bo3bo82bo2bo3bo2bo$140bo8bo68bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o157bo3bo83b3o3b3o$141b2o8b2o225bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156bo7bo7bo$258b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o157bobo5bobobobo$141b2o8b2o105b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o166bobobobo$140bo8bo3bo103bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo166bob2ob2obo$127b2o10bo5bo4bo2bo103b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o286b2o5b2o$127b2o11bo4bo4bo2bo104bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o212b2o$141b3o7b2o265bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o211b2o$298b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o165b2o$298b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o166b2o$297bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$190b2o105b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o294b2o9b2o3b2o$189bo2bo105bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o286b2o5bobo8bob2ob2obo$184bo7bo265bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo285b2o4b2obo8bo7bo$183bobo3bo2bo145b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o292b2o9bob2ob2obo$133bo48b2ob2ob2ob2o145b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo294bo10b2o3b2o$131b3o52bobo148bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o367b2ob2o$130bo54b2ob2o147b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o209bobo42bo$130b2o206bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o209bobo41b2o$144bo72b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo197b3o9bo35b2o4b2obo15b2o$142b3o71b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o196bo2bo31b2o12b2o5bobo15b2o$125b2o14bo74b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo200bo31b2o20b2o$126bo14b2o40b3o3b3o25b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o315bo3bo$126b2obo17b2o33bo9bo25bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o156bo3bo17b2o27b2o$129bo17bo34bo3bobo3bo185bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o160bo7b2o6b2ob2o12b2o12b2o$130b2o13bobo35b3o3b3o65b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo156bobo8b2o6bo2bo13b2o$126b3o2b2o12b2o37bo5bo65b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o175bo2bo$128b2o126b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo177b2o$126bo2bo4bo122b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$125bobobo3bo124bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o137b2o$124bo4bo288bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o136bo2bo$116b2o6bo2bob3o5bo159b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o134bo2bo13b2o$115bobo7bo3b3ob2o3bo64b2o5b2o84b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o17b2ob2o12b2o$115bo10b2o5bo4bo64b2o5b2o84b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o18b2o$114b2o10b2o3b2o2bobo159b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$126bo4bo166bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o34b2o$131b3o51b2ob2o268bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o56b2o$127b2o57bobo148b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o$186bobo147b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$123b2o2b3o57bo148b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$124bobobo208b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o206bo5bo$125b4o209bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o204b3o3b3o$120b2o4bo91b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o196b3o4b2obo3bob2o$119bobo96b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o197bo2bo$119bo97bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo198bo$118b2o7bobo87b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o318bo3bo5bo3bo$128b2o88bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o157bo3bo5bo3bo$128bo249bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156bo$202b2o7b2o45b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o157bobo$202bob2o3b2obo45b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o$118b2o82bo3bobo3bo44bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$119bo51b2o5b2o22b2o2bobo2b2o44b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$119bobo49b2o5b2o23b3o3b3o46bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o$120b2o82bo5bo207bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo$298b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o$124bob2o170b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo$124bob2o169bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o407b2ob2o$172bo5bo118b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o249bobo$133bo37b3o3b3o118bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o249bobo$123b2o4bob2obo35bo2b2ob2o2bo22b2o253bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo249bo$123b2o2bo5bo36bo3bobo3bo22b2o133b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o271b2o$114b2o11bo5bo38bobobobo159b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo273bo$115bo7b2o6b2o4b2o198bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$115bobo5b2o4bobo5b2o30b2ob2o3b2ob2o155b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o223b2o$116b2o11b2o40bo7bo158bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o208b2o12bo2bo7b2o$217b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo197b3o7b2o11b2o2bo7b2o$216b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o196bo2bo21bo2bo$216b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo200bo22bo$217b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o315bo3bo$145b2o25bo45bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o156bo3bo22bo$145bobo23b3o204bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o160bo21bo2bo$147bo22bo3bo82b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o155bobo21b2o2bo7b2o$147b2o20bo5bo80b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o17bo2bo7b2o$141b2o26bo5bo80b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o17b2o$141bo28bo3bo82b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$142b3o113bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o29bo$144bo25bo3bo243bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o28bo21b2o$130b2o37bo5bo121b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o286b3obo$130bo38bo5bo2b2o116b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo286bo4bo$131b3o36bo3bo3b2o116b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o407bo2bo$133bo37b3o123b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o248b2o$145b2o7b2o16bo125bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o$143b2o2bo6b2o302bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o$143b6o4bo2bo180b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o$133bo9b4o5bob2o180b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$131b3o18bob2o180b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o366b2o5b2o$130bo206b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o204bo2bo3bo2bo$131b3o18bob2o182bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o206b2ob2o$133bo9b4o5bob2o14b2o46b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o196b3o6bobobobo$143b6o4b3ob2o11bo47b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o197bo2bo5bobobobo$143b2o2bo6bobobo12b3o43bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo198bo6bo9bo$145b2o7b4o15bo43b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o318bo3bobo11bo$155b2o61bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o318bo3bo$378bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo317bo7bob2ob2obo$258b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o318bobo6b2ob2o$258b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo327bo5bo$257bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o447b2ob2o$257b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o289bobo$258bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o289bobo$418bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo289bo$298b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o311b2o$298b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo312b2o$297bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$297b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o265b2o$298bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o248b2o15bobo5b2o$458bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo247b2o15bob2o4b2o$338b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o265b2o$338b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo266bo$337bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$337b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o226bo$338bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o226b2o$138b2o77b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o196b3o24bob2o4b2o$140bo75b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o32bo2bo4b2ob2o15bobo5b2o$125b2o10b2o2bo10b2o62b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o13bo7b3o14b2o$125b2o11bo2bo10b2o63b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o7bo3bo3b5obo$139bobo76bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o7bo3bo2bobobo24b2o$139b2o237bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o12bo7bobo21b2o$257b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o316bobo9bo$139b2o115b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo329bo$139bobo114b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$125b2o11bo2bo115b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$125b2o10b2o2bo116bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o$140bo277bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o$138b2o157b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o$296b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo288b2ob2o$296b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o407bo5bo$297b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$298bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o244bo7bo$458bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o244bo2bobo2bo$337b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o245b3o3b3o$336b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$336b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$337b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o$338bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo$218b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o357b3o$172b4o42b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo358bo2bo$171b2o2bo14b2o25bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o477bo9b2ob2o$170b2o2bo15b2o25b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o318bo3bo6bobo$171bo2bo43bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o318bo3bo6bobo$172b2o204bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo317bo11bo$258b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o318bobo30b2o$172b2o84b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo352b2o$171bo2bo82bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$163b2o5b2o2bo15b2o65b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$163b2o6b2o2bo14b2o66bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o288b6o5b4o10b2o$172b4o242bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo287b4o7b2obo10b2o$298b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o290b2obo7bo$298b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo293b2o5b2o$297bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$297b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o253b2o5b2o$298bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o251b2obo7bo$458bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o249bo7b2obo10b2o$338b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o40b3o5b4o10b2o$338b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o$337bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$337b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o12bo5bo18b2o$338bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o12b3o3b3o17b2o$217b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o357b3o5bob2ob2obo$216b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo357bo2bo4b2o7b2o$216b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o480bo4b2o7b2o$217b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o315bo3bo4b3o5b3o$218bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o314bo3bo6b3ob3o$378bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o318bo8bobo$257b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o316bobo6bo2bobo2bo$256b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo325bo2bo3bo2bo$256b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o446b2o5b2o$257b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$258bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o$418bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o$297b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o$296b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$296b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$297b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o$298bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo$458bo158b3o157bob2o155b3o159b2o278bo158b3o$337b2o279bo158b3o156b2obo158b3o156b2o279bo$336b3o159b2o278bo158b3o157bob2o155b3o159b2o527b2ob2o$336b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o369bobo$337b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o369bobo$338bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo369bo$218b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o357b3o31b2o$218b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo358bo2bo30b2o$217bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o477bo$217b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o318bo3bo15b2o$218bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o318bo3bo5b2o7bobo13b2o$378bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo317bo9b2o7bo15b2o$258b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o318bobo15b3o$258b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo$257bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$257b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$258bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o297b3o$418bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o295bo15b2o$298b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o40bobo13b2o$298b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19b2o$297bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$297b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o31b2o$298bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o32b2o$458bo158b3o156b2obo158b3o156b2o279bo158b3o$338b2o278bo158b3o157bob2o155b3o159b2o278bo$338b3o156b2o279bo158b3o156b2obo158b3o156b2o$337bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$91b2o13bo7bo222b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o365bo5bo$90bo2bo10b3o5b3o223bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o364b3o3b3o$89bobobo9bo7bo14b2o89b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o357b3o5bob2ob2obo$88b3obo10b2o6b2o13bobo87b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo357bo2bo7b2ob2o$88b3o29bo6b3o86b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o480bo7b2ob2o$118b2ob2ob3ob2o87b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o315bo3bo7b2ob2o$118b2ob2ob5o89bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o314bo3bo$120bo5bo251bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o318bo$90b2o29b2ob2o131b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o316bobo$90b2o164b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo$256b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$257b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o$120bo5bo131bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo$119b2o5b2o290bo158b3o157bob2o155b3o159b2o278bo158b3o$118bob2o3b2obo168b2o279bo158b3o156b2obo158b3o156b2o279bo$118bob2o3b2obo167b3o159b2o278bo158b3o157bob2o155b3o159b2o567b2ob2o$119b3o3b3o168b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o409bobo$119b3o3b3o169b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o409bobo$298bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo409bo$458bo158b3o157bob2o155b3o159b2o278bo158b3o431b2o$337b2o279bo158b3o156b2obo158b3o156b2o279bo431bobo$109bo226b3o159b2o278bo158b3o157bob2o155b3o159b2o550bo$107b3o226b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o393bo$106bo230b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o368b2o12b2o2bo3bo3bo$106b2o230bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo367b2o12bob2o7b2o$218b2o278bo158b3o157bob2o155b3o159b2o278bo158b3o357b3o22bo$218b3o156b2o279bo158b3o156b2obo158b3o156b2o279bo358bo2bo21b3o4b2o$121b2ob2o91bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o477bo$122bobo92b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o318bo3bo20b3o4b2o$109bo12bobo93bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o318bo3bo20bo$107b3o13bo254bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o316bo23bob2o7b2o$106bo151b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o16bobo20b2o2bo3bo3bo$106b2o150b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o49bo$257bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b5o24bo$257b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o20b3ob3o22bobo$258bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o46b5o21b2o$418bo158b3o156b2obo158b3o156b2o279bo158b3o445bo4bo$109bo188b2o278bo158b3o157bob2o155b3o159b2o278bo447b2o2bo$107b3o188b3o156b2o279bo158b3o156b2obo158b3o156b2o568b3o$106bo190bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$106b2o189b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o$298bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o$458bo158b3o156b2obo158b3o156b2o279bo158b3o$338b2o278bo158b3o157bob2o155b3o159b2o278bo$338b3o156b2o279bo158b3o156b2obo158b3o156b2o526bo7bo$109bo227bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o365b2o5b2o$107b3o227b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o364b3o3b3o$106bo231bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o366b2ob2o$106b2o109b2o279bo158b3o156b2obo158b3o156b2o279bo158b3o357b3o7bo3bo$216b3o159b2o278bo158b3o157bob2o155b3o159b2o278bo357bo2bo4b2o7b2o$216b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o480bo4b2o7b2o$217b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o476bo3bo8bobo$218bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo475bo3bo4bo2bo3bo2bo$109bo268bo158b3o157bob2o155b3o159b2o278bo158b3o479bo5b3o3b3o$107b3o147b2o279bo158b3o156b2obo158b3o156b2o279bo477bobo8bo3bo$106bo149b3o159b2o278bo158b3o157bob2o155b3o159b2o607b2ob2o$106b2o148b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o449bobo$257b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o449bobo$258bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo449bo$418bo158b3o157bob2o155b3o159b2o278bo158b3o471b2o$297b2o279bo158b3o156b2obo158b3o156b2o279bo472b2o$109bo186b3o159b2o278bo158b3o157bob2o155b3o159b2o$107b3o186b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o425bo$106bo190b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o408b2o15b2o6b2o$106b2o190bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo407b2o16b2o5b2o$458bo158b3o157bob2o155b3o159b2o278bo158b3o420b2o2b2o$337b2o279bo158b3o156b2obo158b3o156b2o279bo$336b3o159b2o278bo158b3o157bob2o155b3o159b2o$336b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o$109bo227b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o381b2o2b2o$107b3o228bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o365b2o17b2o5b2o$106bo111b2o278bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o9b3o5b3o16b2o6b2o$106b2o110b3o156b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o8bo2bo3b2o2bo15bo$217bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o8bo6bo2bo$217b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o10bo3bobo4b2o21b2o$218bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o32bo3bo6b2o3bo17b2o$378bo158b3o156b2obo158b3o156b2o279bo158b3o477bo6bobobo$109bo148b2o278bo158b3o157bob2o155b3o159b2o278bo479bobo$107b3o148b3o156b2o279bo158b3o156b2obo158b3o156b2o$106bo150bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$106b2o149b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o$258bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o444bo7bo$418bo158b3o156b2obo158b3o156b2o279bo158b3o444bo2bo3bo2bo$298b2o278bo158b3o157bob2o155b3o159b2o278bo449bobo$298b3o156b2o279bo158b3o156b2obo158b3o156b2o569bobo$109bo187bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o408bobo$107b3o187b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o403bo2bo3bo2bo$106bo191bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o404b3o3b3o$106b2o350bo158b3o156b2obo158b3o156b2o279bo158b3o$338b2o278bo158b3o157bob2o155b3o159b2o278bo$338b3o156b2o279bo158b3o156b2obo158b3o156b2o$337bob2o155b3o159b2o278bo158b3o157bob2o155b3o$337b3o156b2obo158b3o156b2o279bo158b3o156b2obo$109bo228bo158b3o157bob2o155b3o159b2o278bo158b3o$107b3o107b2o279bo158b3o156b2obo158b3o156b2o279bo518b3o$106bo109b3o159b2o278bo158b3o157bob2o155b3o159b2o636bo2bo7b2ob2o$106b2o108b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o480bo8bobo$217b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o476bo3bo8bobo$218bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo475bo3bo9bo$378bo158b3o157bob2o155b3o159b2o278bo158b3o479bo31b2o$257b2o279bo158b3o156b2obo158b3o156b2o279bo477bobo32b2o$109bo146b3o159b2o278bo158b3o157bob2o155b3o159b2o615bo$107b3o146b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o457bo3bo$106bo150b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o448b2o2b2o8bo10b2o$106b2o150bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo447b2o2bo5b2o2bo10b2o$418bo158b3o157bob2o155b3o159b2o278bo158b3o451bobo5b2o$297b2o279bo158b3o156b2obo158b3o156b2o279bo453b2o3b3o$296b3o159b2o278bo158b3o157bob2o155b3o159b2o$296b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o413b2o3b3o$109bo187b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o412bobo5b2o$107b3o188bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o410bo5b2o2bo10b2o$106bo351bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17b2o8bo10b2o$106b2o229b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o21bo3bo$336b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o20bo$336b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o38b2o$337b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o35bo5bo18b2o$338bo158b3o156b2obo158b3o156b2o279bo158b3o525b3o3b3o$109bo108b2o278bo158b3o157bob2o155b3o159b2o278bo518b3o4b2o2bobo2b2o$107b3o108b3o156b2o279bo158b3o156b2obo158b3o156b2o638bo2bo3b2ob2ob2ob2o$106bo110bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o477bo9b2ob2o$106b2o109b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o476bo3bo3bobo3bobo$218bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o476bo3bo2bo2bo3bo2bo$378bo158b3o156b2obo158b3o156b2o279bo158b3o477bo9bo3bo$258b2o278bo158b3o157bob2o155b3o159b2o278bo479bobo3bobo5bobo$258b3o156b2o279bo158b3o156b2obo158b3o156b2o606bo7bo$109bo147bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o$107b3o147b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o$106bo151bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o$106b2o310bo158b3o156b2obo158b3o156b2o279bo158b3o$298b2o278bo158b3o157bob2o155b3o159b2o278bo$298b3o156b2o279bo158b3o156b2obo158b3o156b2o$297bob2o155b3o159b2o278bo158b3o157bob2o155b3o$297b3o156b2obo158b3o156b2o279bo158b3o156b2obo$109bo188bo158b3o157bob2o155b3o159b2o278bo158b3o$107b3o348bo158b3o156b2obo158b3o156b2o279bo$106bo231b2o278bo158b3o157bob2o155b3o159b2o687b2ob2o$106b2o230b3o156b2o279bo158b3o156b2obo158b3o156b2o529bobo$337bob2o155b3o159b2o278bo158b3o157bob2o155b3o529bobo$337b3o156b2obo158b3o156b2o279bo158b3o156b2obo529bo$338bo158b3o157bob2o155b3o159b2o278bo158b3o551b2o$217b2o279bo158b3o156b2obo158b3o156b2o279bo518b3o31b2o$109bo106b3o159b2o278bo158b3o157bob2o155b3o159b2o636bo2bo$107b3o106b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o480bo$106bo110b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o476bo3bo7b2o8b3o12b2o$106b2o110bo158b3o156b2obo158b3o156b2o279bo158b3o156b2obo475bo3bo7b2o8bo3bo10b2o$378bo158b3o157bob2o155b3o159b2o278bo158b3o479bo17bo4bo$257b2o279bo158b3o156b2obo158b3o156b2o279bo477bobo19bo3bo$256b3o159b2o278bo158b3o157bob2o155b3o159b2o$256b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o459bo3bo$109bo147b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o458bo4bo$107b3o148bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o456bo3bo10b2o$106bo311bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17b3o12b2o$106b2o189b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o$296b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$296b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o32b2o$297b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o54b2o$298bo158b3o156b2obo158b3o156b2o279bo158b3o$109bo348bo158b3o157bob2o155b3o159b2o278bo$107b3o227b2o279bo158b3o156b2obo158b3o156b2o$106bo229b3o159b2o278bo158b3o157bob2o155b3o159b2o$106b2o228b2obo158b3o156b2o279bo158b3o156b2obo158b3o$337b3o157bob2o155b3o159b2o278bo158b3o157bob2o525bo5bo$338bo158b3o156b2obo158b3o156b2o279bo158b3o525b3o3b3o$218b2o278bo158b3o157bob2o155b3o159b2o278bo518b3o4b2o2bobo2b2o$218b3o156b2o279bo158b3o156b2obo158b3o156b2o638bo2bo2bob4ob4obo$109bo107bob2o155b3o159b2o278bo158b3o157bob2o155b3o159b2o477bo7b3o3b3o$107b3o107b3o156b2obo158b3o156b2o279bo158b3o156b2obo158b3o476bo3bo2b3o5b3o$106bo111bo158b3o157bob2o155b3o159b2o278bo158b3o157bob2o476bo3bo$106b2o270bo158b3o156b2obo158b3o156b2o279bo158b3o477bo$258b2o278bo158b3o157bob2o155b3o159b2o278bo479bobo$258b3o156b2o279bo158b3o156b2obo158b3o156b2o$257bob2o155b3o159b2o278bo158b3o157bob2o155b3o$257b3o156b2obo158b3o156b2o279bo158b3o156b2obo$109bo148bo158b3o157bob2o155b3o159b2o278bo158b3o$107b3o308bo158b3o156b2obo158b3o156b2o279bo$106bo191b2o278bo158b3o157bob2o155b3o159b2o727b2ob2o$106b2o190b3o156b2o279bo158b3o156b2obo158b3o156b2o569bobo$297bob2o155b3o159b2o278bo158b3o157bob2o155b3o569bobo$297b3o156b2obo158b3o156b2o279bo158b3o156b2obo569bo$298bo158b3o157bob2o155b3o159b2o278bo158b3o591b2o$458bo158b3o156b2obo158b3o156b2o279bo592b2o$109bo228b2o278bo158b3o157bob2o155b3o159b2o$107b3o228b3o156b2o279bo158b3o156b2obo158b3o156b2o543bo3b3ob3o$106bo230bob2o155b3o159b2o278bo158b3o157bob2o155b3o528b2o12bobo2b4o3bo$106b2o229b3o156b2obo158b3o156b2o279bo158b3o156b2obo527b2o12bo3b2o6bo$338bo158b3o157bob2o155b3o159b2o278bo158b3o542bo2bo3b2obo$217b2o279bo158b3o156b2obo158b3o156b2o279bo518b3o23b3o3bo$216b3o159b2o278bo158b3o157bob2o155b3o159b2o636bo2bo$216b2obo158b3o156b2o279bo158b3o156b2obo158b3o156b2o480bo23b3o3bo$109bo107b3o157bob2o155b3o159b2o278bo158b3o157bob2o155b3o476bo3bo22bo2bo3b2obo$107b3o108bo158b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o474bo3bo21bo3b2o6bo$106bo271bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o39bo9bo11bobo2b4o3bo$106b2o149b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o14bobo5b2o3bo12bo3b3ob3o$256b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b4o$256b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o18bo28b2o$257b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o19bo4bo23b2o$258bo158b3o156b2obo158b3o156b2o279bo158b3o606b2ob2o$109bo308bo158b3o157bob2o155b3o159b2o278bo608b3o$107b3o187b2o279bo158b3o156b2obo158b3o156b2o$106bo189b3o159b2o278bo158b3o157bob2o155b3o159b2o$106b2o188b2obo158b3o156b2o279bo158b3o156b2obo158b3o$297b3o157bob2o155b3o159b2o278bo158b3o157bob2o$298bo158b3o156b2obo158b3o156b2o279bo158b3o$458bo158b3o157bob2o155b3o159b2o278bo$337b2o279bo158b3o156b2obo158b3o156b2o$109bo226b3o159b2o278bo158b3o157bob2o155b3o159b2o524b3o5b3o$107b3o226b2obo158b3o156b2o279bo158b3o156b2obo158b3o523b3o5b3o$106bo230b3o157bob2o155b3o159b2o278bo158b3o157bob2o524b2o5b2o$106b2o230bo158b3o156b2obo158b3o156b2o279bo158b3o527bo3bo$218b2o278bo158b3o157bob2o155b3o159b2o278bo518b3o5bo2bobo2bo$218b3o156b2o279bo158b3o156b2obo158b3o156b2o638bo2bo3bo3bobo3bo$217bob2o155b3o159b2o278bo158b3o157bob2o155b3o638bo7bo2bobo2bo$217b3o156b2obo158b3o156b2o279bo158b3o156b2obo637bo3bo3b3o3b3o$109bo108bo158b3o157bob2o155b3o159b2o278bo158b3o637bo3bo$107b3o268bo158b3o156b2obo158b3o156b2o279bo638bo$106bo151b2o278bo158b3o157bob2o155b3o159b2o758bobo6b2ob2o$106b2o150b3o156b2o279bo158b3o156b2obo158b3o156b2o609bobo$257bob2o155b3o159b2o278bo158b3o157bob2o155b3o609bobo$257b3o156b2obo158b3o156b2o279bo158b3o156b2obo609bo$258bo158b3o157bob2o155b3o159b2o278bo158b3o631b2o$418bo158b3o156b2obo158b3o156b2o279bo632b2o$109bo188b2o278bo158b3o157bob2o155b3o159b2o$107b3o188b3o156b2o279bo158b3o156b2obo158b3o156b2o$106bo190bob2o155b3o159b2o278bo158b3o157bob2o155b3o568b2o14b2o7b2o$106b2o189b3o156b2obo158b3o156b2o279bo158b3o156b2obo567b2o15b2o6b2o$298bo158b3o157bob2o155b3o159b2o278bo158b3o580b5o$458bo158b3o156b2obo158b3o156b2o279bo581b4o$338b2o278bo158b3o157bob2o155b3o159b2o$338b3o156b2o279bo158b3o156b2obo158b3o156b2o530b3o8b4o$109bo227bob2o155b3o159b2o278bo158b3o157bob2o155b3o529b6o6b5o$107b3o227b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o527b2o2b3o9b2o6b2o$106bo231bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40b2o4b3o8b2o7b2o$106b2o109b2o279bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o9b3o5b2o6b2o$216b3o159b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o6bo2bo4bo2bo5b2o$216b2obo158b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o9bo4bo2bo3b3o17b2o$217b3o157bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o6bo3bo5bo3b4o18b2o$218bo158b3o156b2obo158b3o156b2o279bo158b3o635bo3bo5bo3b3o$109bo268bo158b3o157bob2o155b3o159b2o278bo640bo6bo2bo$107b3o147b2o279bo158b3o156b2obo158b3o156b2o757bobo$106bo149b3o159b2o278bo158b3o157bob2o155b3o159b2o$106b2o148b2obo158b3o156b2o279bo158b3o156b2obo158b3o$257b3o157bob2o155b3o159b2o278bo158b3o157bob2o$258bo158b3o156b2obo158b3o156b2o279bo158b3o605bo7bo$418bo158b3o157bob2o155b3o159b2o278bo604bob2o5b2obo$297b2o279bo158b3o156b2obo158b3o156b2o724bo3b2ob2o3bo$109bo186b3o159b2o278bo158b3o157bob2o155b3o159b2o564bo3bobo3bo$107b3o186b2obo158b3o156b2o279bo158b3o156b2obo158b3o564b3o3b3o$106bo190b3o157bob2o155b3o159b2o278bo158b3o157bob2o$106b2o190bo158b3o156b2obo158b3o156b2o279bo158b3o$458bo158b3o157bob2o155b3o159b2o278bo$337b2o279bo158b3o156b2obo158b3o156b2o$336b3o159b2o278bo158b3o157bob2o155b3o$336b2obo158b3o156b2o279bo158b3o156b2obo$109bo227b3o157bob2o155b3o159b2o278bo158b3o$107b3o228bo158b3o156b2obo158b3o156b2o279bo$106bo111b2o278bo158b3o157bob2o155b3o159b2o797b3o7b2ob2o$106b2o110b3o156b2o279bo158b3o156b2obo158b3o156b2o638bo2bo7bobo$217bob2o155b3o159b2o278bo158b3o157bob2o155b3o638bo10bobo$217b3o156b2obo158b3o156b2o279bo158b3o156b2obo637bo3bo7bo$218bo158b3o157bob2o155b3o159b2o278bo158b3o637bo3bo29b2o$378bo158b3o156b2obo158b3o156b2o279bo638bo33b2o$109bo148b2o278bo158b3o157bob2o155b3o159b2o758bobo$107b3o148b3o156b2o279bo158b3o156b2obo158b3o156b2o614bob2o$106bo150bob2o155b3o159b2o278bo158b3o157bob2o155b3o608b2o3bo2b2o2b3o10b2o$106b2o149b3o156b2obo158b3o156b2o279bo158b3o156b2obo607b2o3bo6b2o11b2o$258bo158b3o157bob2o155b3o159b2o278bo158b3o612b2o3b3o$418bo158b3o156b2obo158b3o156b2o279bo615bo3bo$298b2o278bo158b3o157bob2o155b3o159b2o$298b3o156b2o279bo158b3o156b2obo158b3o156b2o575bo3bo$109bo187bob2o155b3o159b2o278bo158b3o157bob2o155b3o573b2o3b3o$107b3o187b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o571bo6b2o11b2o$106bo191bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40bo2b2o2b3o10b2o$106b2o350bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19bob2o$338b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$338b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o35b2o$337bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o36b2o$337b3o156b2obo158b3o156b2o279bo158b3o686bo5bo$109bo228bo158b3o157bob2o155b3o159b2o278bo686b3o3b3o$107b3o107b2o279bo158b3o156b2obo158b3o156b2o798b3o4bo2b2ob2o2bo$106bo109b3o159b2o278bo158b3o157bob2o155b3o159b2o636bo2bo4bo3bobo3bo$106b2o108b2obo158b3o156b2o279bo158b3o156b2obo158b3o638bo6bobobobo$217b3o157bob2o155b3o159b2o278bo158b3o157bob2o634bo3bo$218bo158b3o156b2obo158b3o156b2o279bo158b3o635bo3bo3b2ob2o3b2ob2o$378bo158b3o157bob2o155b3o159b2o278bo640bo5bo7bo$257b2o279bo158b3o156b2obo158b3o156b2o757bobo$109bo146b3o159b2o278bo158b3o157bob2o155b3o159b2o$107b3o146b2obo158b3o156b2o279bo158b3o156b2obo158b3o$106bo150b3o157bob2o155b3o159b2o278bo158b3o157bob2o$106b2o150bo158b3o156b2obo158b3o156b2o279bo158b3o$418bo158b3o157bob2o155b3o159b2o278bo$297b2o279bo158b3o156b2obo158b3o156b2o$296b3o159b2o278bo158b3o157bob2o155b3o$296b2obo158b3o156b2o279bo158b3o156b2obo$109bo187b3o157bob2o155b3o159b2o278bo158b3o$107b3o188bo158b3o156b2obo158b3o156b2o279bo$106bo351bo158b3o157bob2o155b3o159b2o847b2ob2o$106b2o229b2o279bo158b3o156b2obo158b3o156b2o689bobo$336b3o159b2o278bo158b3o157bob2o155b3o689bobo$336b2obo158b3o156b2o279bo158b3o156b2obo689bo$337b3o157bob2o155b3o159b2o278bo158b3o711b2o$338bo158b3o156b2obo158b3o156b2o279bo712b2o$109bo108b2o278bo158b3o157bob2o155b3o159b2o797b3o$107b3o108b3o156b2o279bo158b3o156b2obo158b3o156b2o638bo2bo18bo3bo$106bo110bob2o155b3o159b2o278bo158b3o157bob2o155b3o638bo9b2o9bo5bo7b2o$106b2o109b3o156b2obo158b3o156b2o279bo158b3o156b2obo637bo3bo5b2o9bo13b2o$218bo158b3o157bob2o155b3o159b2o278bo158b3o637bo3bo16b2o3bo$378bo158b3o156b2obo158b3o156b2o279bo638bo22b3o$258b2o278bo158b3o157bob2o155b3o159b2o758bobo$258b3o156b2o279bo158b3o156b2obo158b3o156b2o621b3o$109bo7bo7bo37b2o92bob2o155b3o159b2o278bo158b3o157bob2o155b3o619b2o3bo$107b3o5b3o5b3o39bo91b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o617bo13b2o$106bo7bo7bo27b2o10b2o2bo91bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40bo5bo7b2o$106b2o6b2o6b2o26b2o11bo2bo251bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19bo3bo$164bobo8bo122b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$164b2o9b3o120b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o29b2o$178bo118bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o30b2o$153b2o9b2o9b3o119b3o156b2obo158b3o156b2o279bo158b3o$151bo3b2o7bobo8bo122bo158b3o157bob2o155b3o159b2o278bo726b2o$151bo4bo6bo2bo291bo158b3o156b2obo158b3o156b2o$151bo3b2o5b2o2bo171b2o278bo158b3o157bob2o155b3o159b2o$153b2o10bo172b3o156b2o279bo158b3o156b2obo158b3o$163b2o172bob2o155b3o159b2o278bo158b3o157bob2o$337b3o156b2obo158b3o156b2o279bo158b3o686bo5bo$338bo158b3o157bob2o155b3o159b2o278bo686b3o3b3o$24b2o191b2o279bo158b3o156b2obo158b3o156b2o798b3o4b2ob2ob2ob2o$24b2o190b3o159b2o278bo158b3o157bob2o155b3o159b2o636bo2bo3b3o7b3o$30b3o132bo50b2obo158b3o156b2o279bo158b3o156b2obo158b3o638bo$29bo3bo131b3o49b3o157bob2o155b3o159b2o278bo158b3o157bob2o634bo3bo5bo7bo$29b2ob2o134bo49bo158b3o156b2obo158b3o156b2o279bo158b3o635bo3bo$167b2o209bo158b3o157bob2o155b3o159b2o278bo640bo$29b2ob2o120bo102b2o279bo158b3o156b2obo158b3o156b2o757bobo$31bo122b3o99b3o159b2o278bo158b3o157bob2o155b3o768b2ob2o$114b2o5b2o34bo98b2obo158b3o156b2o279bo158b3o156b2obo$109bo4b2o5b2o33b2o99b3o157bob2o155b3o159b2o278bo158b3o767b2ob2o$107b3o148bo158b3o156b2obo158b3o156b2o279bo$24bo7bo73bo311bo158b3o157bob2o155b3o159b2o887b2ob2o$23bo2bo3bo2bo72b2o50b2o137b2o279bo158b3o156b2obo158b3o156b2o729bobo$27bobo126bo3bo5b2o9b2o117b3o159b2o278bo158b3o157bob2o155b3o729bobo$27bobo125bo5bo3bo2bo4b3o2bo117b2obo158b3o156b2o279bo158b3o156b2obo729bo$27bobo125bo4bo5bo4bo2b5o118b3o157bob2o155b3o159b2o278bo158b3o751b2o$23bo2bo3bo2bo121bo2bo7bo2b4o125bo158b3o156b2obo158b3o156b2o279bo752b2o$24b3o3b3o76bo46bobo8bob2o3bo283bo158b3o157bob2o155b3o159b2o$107b3o47bo8b2obob3o7b2o154b2o279bo158b3o156b2obo158b3o156b2o703bobo2b2o$106bo61bo3bo8bobo152b3o159b2o278bo158b3o157bob2o155b3o688b2o12bo3bob3o2b2o$106b2o57b3o15bo152b2obo158b3o156b2o279bo158b3o156b2obo687b2o13bo6b2ob2o$166bo16b2o152b3o157bob2o155b3o159b2o278bo158b3o703b5obo$114bo7bo215bo158b3o156b2obo158b3o156b2o279bo707b3o$114b2o5b2o95b2o278bo158b3o157bob2o155b3o159b2o797b3o$114b3o3b3o95b3o156b2o279bo158b3o156b2obo158b3o156b2o638bo2bo25b3o$26b2ob2o78bo6b2ob2o45b2o49bob2o155b3o159b2o278bo158b3o157bob2o155b3o638bo25b5obo$27bobo77b3o6bo3bo22b2o21b2o49b3o156b2obo158b3o156b2o279bo158b3o156b2ob2o636bo3bo20bo6b2ob2o$27bobo76bo6b2o7b2o20bo73bo158b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o13bo3bo7bo11bo3bob3o2b2o$28bo77b2o5b2o7b2o17b3o234bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o12bo10b2o12bobo2b2o$117bobo21bo35b2o79b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o13bobo2b2ob4o$113bo2bo3bo2bo53bobo78b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19bo2bobob2o20b2o$114b3o3b3o56bo77bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o41bobob2ob2o20b2o$179b2o76b3o156b2obo158b3o156b2o279bo158b3o767bob2o$109bo63b2o83bo158b3o157bob2o155b3o159b2o278bo769bo$107b3o63bo244bo158b3o156b2obo158b3o156b2o$106bo7b2o25b2o31b3o121b2o278bo158b3o157bob2o155b3o159b2o$106b2o6b2o25b2o33bo121b3o156b2o279bo158b3o156b2obo158b3o$297bob2o155b3o159b2o278bo158b3o157bob2o$132b2o163b3o156b2obo158b3o156b2o279bo158b3o$130b2o2bo7b2o154bo158b3o157bob2o155b3o159b2o278bo$130b6o6b2o314bo158b3o156b2obo158b3o156b2o$109bo20b4o204b2o278bo158b3o157bob2o155b3o159b2o$107b3o228b3o156b2o279bo158b3o156b2obo158b3o683b3o5b3o$106bo230bob2o155b3o159b2o278bo158b3o157bob2o682b2ob2o3b2ob2o$106b2o229b3o156b2obo158b3o156b2o279bo158b3o683b2obobobobob2o$130b4o204bo158b3o157bob2o155b3o159b2o278bo685bo3bobo3bo$130b6o6b2o73b2o279bo158b3o156b2obo158b3o156b2o798b3o4bo2bo3bo2bo$130b2o2bo7b2o72b3o159b2o278bo158b3o157bob2o155b3o797bo2bo5b3o3b3o$132b2o82b2obo158b3o156b2o279bo158b3o156b2obo799bo$109bo107b3o157bob2o155b3o159b2o278bo158b3o795bo3bo$107b3o31b2o75bo158b3o156b2obo158b3o156b2o279bo796bo3bo$106bo18bobo13b2o235bo158b3o157bob2o155b3o159b2o919bo7b2ob2o$106b2o18b2o129b2o279bo158b3o156b2obo158b3o156b2o757bobo9bobo$126bo129b3o159b2o278bo158b3o157bob2o155b3o769bobo$256b2obo158b3o156b2o279bo158b3o156b2obo769bo$257b3o157bob2o155b3o159b2o278bo158b3o791b2o$258bo158b3o156b2obo158b3o156b2o279bo792b2o$109bo308bo158b3o157bob2o155b3o159b2o901bo$107b3o20b2o165b2o279bo158b3o156b2obo158b3o156b2o740bo2bo$106bo23b2o164b3o159b2o278bo158b3o157bob2o155b3o728b2o10b5o8b2o$106b2o188b2obo158b3o156b2o279bo158b3o156b2obo727b2o10b3ob2o7b2o$297b3o157bob2o155b3o159b2o278bo158b3o740b2obo$298bo158b3o156b2obo158b3o156b2o279bo742b2o$458bo158b3o157bob2o155b3o159b2o$337b2o279bo158b3o156b2obo158b3o156b2o692b2o8b2o$109bo226b3o159b2o278bo158b3o157bob2o155b3o689bob3o7b2obo$107b3o226b2obo158b3o156b2o279bo158b3o156b2ob2o687bo2bobo5b3ob2o7b2o$106bo230b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o18b3obo6b5o8b2o$106b2o230bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o14b2ob2obobo5bo2bo$218b2o278bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o6b3o4bo2bob5o7bo$218b3o156b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o8bo2bo3bo2bob2ob2o17b2o$217bob2o155b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o30bo7b2o3b2o19b2o$217b3o156b2obo158b3o156b2o279bo158b3o797bo3bo5b2o$109bo108bo158b3o157bob2o155b3o159b2o278bo798bo3bo6bo$107b3o268bo158b3o156b2obo158b3o156b2o918bo$106bo151b2o278bo158b3o157bob2o155b3o159b2o758bobo$106b2o150b3o156b2o279bo158b3o156b2obo158b3o764b2o5b2o$257bob2o155b3o159b2o278bo158b3o157bob2o$162bo3b3o88b3o156b2obo158b3o156b2o279bo158b3o764bo9bo$161bobo2b5o3b2o82bo158b3o157bob2o155b3o159b2o278bo765bo3bobo3bo$161bo3b2o3b2o2b2o242bo158b3o156b2obo158b3o156b2o885bo3bobo3bo$109bo52bo2bo3b2o127b2o278bo158b3o157bob2o155b3o159b2o725bobo3bobo$107b3o53b3o3bo128b3o156b2o279bo158b3o156b2obo158b3o725bo5bo$106bo190bob2o155b3o159b2o278bo158b3o157bob2o$106b2o55b3o3bo127b3o156b2obo158b3o156b2o279bo158b3o$162bo2bo3b2o127bo158b3o157bob2o155b3o159b2o278bo$147b2o12bo3b2o3b2o2b2o282bo158b3o156b2obo158b3o156b2o$147b2o12bobo2b5o3b2o162b2o278bo158b3o157bob2o155b3o$162bo3b3o169b3o156b2o279bo158b3o156b2obo$337bob2o155b3o159b2o278bo158b3o$337b3o156b2obo158b3o156b2o279bo$338bo158b3o157bob2o155b3o159b2o967b2ob2o$217b2o279bo158b3o156b2obo158b3o156b2o798b3o8bobo$152bo63b3o159b2o278bo158b3o157bob2o155b3o797bo2bo8bobo$130b3o19b3o61b2obo158b3o156b2o279bo158b3o156b2obo799bo9bo$130bo2bo21bo61b3o157bob2o155b3o159b2o278bo158b3o795bo3bo31b2o$130bo23b2o62bo158b3o156b2obo158b3o156b2o279bo796bo3bo31b2o$130bo10bo236bo158b3o157bob2o155b3o159b2o919bo$131bobo7b3o113b2o279bo158b3o156b2obo158b3o156b2o757bobo16bo3b2o$144bo111b3o159b2o278bo158b3o157bob2o155b3o768b2o4b2obob3o11b2o$143b2o111b2obo158b3o156b2o279bo158b3o156b2obo767b2o4bo4b3o11b2o$156bo3bo96b3o157bob2o155b3o159b2o278bo158b3o773bo3bo$155b5obo96bo158b3o156b2obo158b3o156b2o279bo775b3o$154b3o4b2o255bo158b3o157bob2o155b3o159b2o$154b2ob5o135b2o279bo158b3o156b2obo158b3o156b2o735b3o$156b3o137b3o159b2o278bo158b3o157bob2o155b3o734bo3bo$296b2obo158b3o156b2o279bo158b3o156b2ob2o732bo4b3o11b2o$158bo138b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17b2obob3o11b2o$154bo2b3o138bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o18bo3b2o$153b2obo3bo7b2o288bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$147b2o3b2ob3obo2b2o4bobo166b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o36b2o$147b2o3b3ob2o4b2o6bo165b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o58b2o$152b3o15b2o164b2obo158b3o156b2o279bo158b3o$109bo227b3o157bob2o155b3o159b2o278bo847bo5bo$107b3o228bo158b3o156b2obo158b3o156b2o966b3o3b3o$106bo111b2o278bo158b3o157bob2o155b3o159b2o797b3o4b2o2bobo2b2o$106b2o46bo63b3o156b2o279bo158b3o156b2obo158b3o796bo2bo3bo3bobo3bo$154bob3o58bob2o155b3o159b2o278bo158b3o157bob2o796bo6bob2o3b2obo$155bo3bo57b3o156b2obo158b3o156b2o279bo158b3o797bo3bo2b2o7b2o$126b2o3b2o8bo17bo58bo158b3o157bob2o155b3o159b2o278bo798bo3bo$125bo2bobo2bo7bo2b2o10b2obo4b2o212bo158b3o156b2obo158b3o156b2o918bo$109bo14bo9bo5bo5bo11bo5bobo91b2o278bo158b3o157bob2o155b3o159b2o758bobo$107b3o13b2o9b2o5bobo2b2o18bo91b3o156b2o279bo158b3o156b2obo158b3o$106bo17bo9bo6bo3b2o3bo15b2o89bob2o155b3o159b2o278bo158b3o157bob2o$106b2o17bo2bobo2bo9b3o4b3o7b2o95b3o156b2obo158b3o156b2o279bo158b3o$126b2o3b2o20bo6bo97bo158b3o157bob2o155b3o159b2o278bo$143b3o4b3o8b3o254bo158b3o156b2obo158b3o156b2o$141bo3b2o3bo12bo134b2o278bo158b3o157bob2o155b3o$125b2o14bobo2b2o150b3o156b2o279bo158b3o156b2obo$109bo15b2o13bo5bo150bob2o155b3o159b2o278bo158b3o$107b3o31bo2b2o151b3o156b2obo158b3o156b2o279bo$106bo34bo156bo158b3o157bob2o155b3o159b2o1007b2ob2o$106b2o350bo158b3o156b2obo158b3o156b2o849bobo$338b2o278bo158b3o157bob2o155b3o849bobo$338b3o156b2o279bo158b3o156b2obo849bo$337bob2o155b3o159b2o278bo158b3o871b2o$337b3o156b2obo158b3o156b2o279bo872b2o$109bo228bo158b3o157bob2o155b3o159b2o981b2o$107b3o107b2o279bo158b3o156b2obo158b3o156b2o798b3o20bo$106bo109b3o159b2o278bo158b3o157bob2o155b3o797bo2bo7b2o10bo2b2o8b2o$106b2o108b2obo158b3o156b2o279bo158b3o156b2obo799bo7b2o10bo2bo9b2o$217b3o157bob2o155b3o159b2o278bo158b3o795bo3bo19bobo$218bo158b3o156b2obo158b3o156b2o279bo796bo3bo20b2o$378bo158b3o157bob2o155b3o159b2o919bo$257b2o279bo158b3o156b2obo158b3o156b2o757bobo21b2o$109bo146b3o159b2o278bo158b3o157bob2o155b3o780bobo$107b3o146b2obo158b3o156b2o279bo158b3o156b2ob2o778bo2bo9b2o$106bo150b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17bo2b2o8b2o$106b2o150bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o17bo$418bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2o$297b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o30b2o$296b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o28bobo21b2o$296b2obo158b3o156b2o279bo158b3o885bo5bo$109bo187b3o157bob2o155b3o159b2o278bo886bo$107b3o188bo158b3o156b2obo158b3o156b2o1007b2o3bo$106bo351bo158b3o157bob2o155b3o159b2o$106b2o229b2o279bo158b3o156b2obo158b3o$336b3o159b2o278bo158b3o157bob2o$336b2obo158b3o156b2o279bo158b3o$337b3o157bob2o155b3o159b2o278bo846b3o3b3o$338bo158b3o156b2obo158b3o156b2o966b3o3b3o$109bo108b2o278bo158b3o157bob2o155b3o159b2o797b3o4bob2o3b2obo$107b3o108b3o156b2o279bo158b3o156b2obo158b3o796bo2bo3bob2o3b2obo$106bo110bob2o155b3o159b2o278bo158b3o157bob2o796bo7b2o5b2o$106b2o109b3o156b2obo158b3o156b2o279bo158b3o797bo3bo4bo5bo$218bo158b3o157bob2o155b3o159b2o278bo798bo3bo$378bo158b3o156b2obo158b3o156b2o918bo$258b2o278bo158b3o157bob2o155b3o919bobo6b2ob2o$258b3o156b2o279bo158b3o156b2obo928bobo$109bo147bob2o155b3o159b2o278bo158b3o928bobo$107b3o147b3o156b2obo158b3o156b2o279bo929bobo$106bo151bo158b3o157bob2o155b3o159b2o1047b2ob2o$106b2o310bo158b3o156b2obo158b3o156b2o889bobo$298b2o278bo158b3o157bob2o155b3o889bobo$298b3o156b2o279bo158b3o156b2obo889bo$297bob2o155b3o159b2o278bo158b3o911b2o$297b3o156b2obo158b3o156b2o279bo912b2o$109bo188bo158b3o157bob2o155b3o159b2o1023bo$107b3o348bo158b3o156b2obo158b3o156b2o864bo2b2o$106bo231b2o278bo158b3o157bob2o155b3o848b2o13bo5bo3b2o$106b2o230b3o156b2o279bo158b3o156b2obo847b2o14bobo2b2o2b2o$337bob2o155b3o159b2o278bo158b3o863bo3b2o$337b3o156b2obo158b3o156b2o279bo866b3o$338bo158b3o157bob2o155b3o159b2o$217b2o279bo158b3o156b2obo158b3o156b2o798b3o25b3o$109bo106b3o159b2o278bo158b3o157bob2o155b3o797bo2bo23bo3b2o$107b3o106b2obo158b3o156b2o279bo158b3o156b2ob2o798bo23bobo2b2o2b2o$106bo110b3o157bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o33bo3bo22bo5bo3b2o$106b2o110bo158b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o11bo3bo4bo3b3o12bo2b2o$378bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o13bo2bo2bo2b2o13bo$257b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o10bobo4b2o3b2o21b2o$256b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o18bo3bobo21b2o$256b2obo158b3o156b2o279bo158b3o927bobo$109bo147b3o157bob2o155b3o159b2o278bo929bo$107b3o148bo158b3o156b2obo158b3o156b2o$106bo311bo158b3o157bob2o155b3o159b2o$106b2o189b2o279bo158b3o156b2obo158b3o$296b3o159b2o278bo158b3o157bob2o$296b2obo158b3o156b2o279bo158b3o$297b3o157bob2o155b3o159b2o278bo$298bo158b3o156b2obo158b3o156b2o$109bo348bo158b3o157bob2o155b3o159b2o$107b3o227b2o279bo158b3o156b2obo158b3o844bo7bo$106bo229b3o159b2o278bo158b3o157bob2o843b4o3b4o$106b2o228b2obo158b3o156b2o279bo158b3o844bo3bobo3bo$337b3o157bob2o155b3o159b2o278bo846bo2bobo2bo$338bo158b3o156b2obo158b3o156b2o966b3o3b3o$218b2o278bo158b3o157bob2o155b3o958b3o$218b3o156b2o279bo158b3o156b2obo957bo2bo$109bo107bob2o155b3o159b2o278bo158b3o957bo$107b3o107b3o156b2obo158b3o156b2o279bo958bo3bo$106bo111bo158b3o157bob2o155b3o159b2o1077bo3bo5b2ob2o$106b2o270bo158b3o156b2obo158b3o156b2o918bo10bobo$258b2o278bo158b3o157bob2o155b3o919bobo7bobo$258b3o156b2o279bo158b3o156b2obo929bo$257bob2o155b3o159b2o278bo158b3o951b2o$257b3o156b2obo158b3o156b2o279bo952b2o$109bo148bo158b3o157bob2o155b3o159b2o1060bo$107b3o308bo158b3o156b2obo158b3o156b2o901b2o$106bo191b2o278bo158b3o157bob2o155b3o888b2o9bob3o9b2o$106b2o190b3o156b2o279bo158b3o156b2obo887b2o13b2o8b2o$297bob2o155b3o159b2o278bo158b3o901b2o$297b3o156b2obo158b3o156b2o279bo902bo$298bo158b3o157bob2o155b3o159b2o$458bo158b3o156b2obo158b3o156b2o851bo10bo$109bo228b2o278bo158b3o157bob2o155b3o850bob2o8b2o$107b3o228b3o156b2o279bo158b3o156b2ob2o847b3ob2o8b2o8b2o$106bo230bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o43b3o4bob3o9b2o$106b2o229b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o16bo13b2o28bo$338bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o13bobo3b2o7bo28bobo$217b2o279bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o5b3o4b2ob6o18b2o16bobo$216b3o159b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o5bo2bo8bo22b2o15b2ob2o$216b2obo158b3o156b2o279bo158b3o959bo7b2ob2o$109bo46b2o5b2o52b3o157bob2o155b3o159b2o278bo956bo3bo$107b3o46b2o5b2o53bo158b3o156b2obo158b3o156b2o1076bo3bo$106bo271bo158b3o157bob2o155b3o159b2o919bo$106b2o149b2o279bo158b3o156b2obo158b3o915bobo$256b3o159b2o278bo158b3o157bob2o924b3o3b3o$256b2obo158b3o156b2o279bo158b3o924bo9bo$257b3o157bob2o155b3o159b2o278bo925bo3bobo3bo56bo$258bo158b3o156b2obo158b3o156b2o1046b3o3b3o32bo7bo15bobo$109bo47bo5bo254bo158b3o157bob2o155b3o159b2o886bo5bo31bob2o5b2obo13bobo$107b3o46b3o3b3o132b2o279bo158b3o156b2obo158b3o923bo3b2ob2o3bo14bo$106bo48bo2b2ob2o2bo130b3o159b2o278bo158b3o157bob2o924bo3bobo3bo$106b2o47b3o5b3o130b2obo158b3o156b2o279bo158b3o926b3o3b3o$297b3o157bob2o155b3o159b2o278bo$298bo158b3o156b2obo158b3o156b2o$458bo158b3o157bob2o155b3o$28bo308b2o279bo158b3o156b2obo$27b2o80bo7bo7bo210b3o159b2o278bo158b3o$26b3obo9b2o65b3o5b3o5b3o210b2obo158b3o156b2o279bo$25b2o13b2o64bo7bo7bo214b3o157bob2o155b3o159b2o1127b2ob2o32b4o11b2o$16bo9b2o78b2o6b2o6b2o214bo158b3o156b2obo158b3o156b2o969bobo32b2o3bo11bo$14b3o10bo128b3o59b2o278bo158b3o157bob2o155b3o958b3o8bobo32bo11b2obo$13bo141bo3bo58b3o156b2o279bo158b3o156b2obo957bo2bo8bo33b4ob2o5b2ob2o$14b3o10bo10bo116b2ob2o57bob2o155b3o159b2o278bo158b3o957bo33b2o10b2o$16bo9b2o8b2obo116bobo58b3o156b2obo158b3o156b2o279bo958bo3bo29b2o10b2obo8b2ob2o$25b2o8b2ob3o177bo158b3o157bob2o155b3o159b2o1077bo3bo15b2o26b3o8bobo$26b3obo5bo2bo116bobo219bo158b3o156b2obo158b3o156b2o918bo17b5o25b3o8bobo$27b2o8b2o116b2ob2o98b2o278bo158b3o157bob2o155b3o919bobo6b2o5bo4bo12b2o12bo10bo$28bo126bo3bo3b2o93b3o156b2o279bo158b3o156b2obo927b2o5bo2b3o12b2o11bobo$156b3o4b2o92bob2o155b3o159b2o278bo158b3o934b2o2bo26b2obo$257b3o156b2obo158b3o156b2o279bo937b2o30bo$258bo158b3o157bob2o155b3o159b2o1088b2o$418bo158b3o156b2obo158b3o156b2o897b2o$298b2o278bo158b3o157bob2o155b3o895b2o2bo$298b3o156b2o279bo158b3o156b2ob2o893bo2b3o12b2o$297bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40bo4bo12b2o$297b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19b5o$298bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o19b2o$458bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o33b2o$338b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o34b2o$338b3o156b2o279bo158b3o$109bo60b2o165bob2o155b3o159b2o278bo$107b3o50b2o6b2ob2o14b2o148b3o156b2obo158b3o156b2o1127bo5bo$106bo53b2o6bo2bo15b2o149bo158b3o157bob2o155b3o159b2o965b3o3b3o$106b2o60bo2bo45b2o279bo158b3o156b2obo158b3o956b3o4bo2b2ob2o2bo96b2o$5bo163b2o45b3o159b2o278bo158b3o157bob2o955bo2bo4b3o5b3o96b2o$5b3o208b2obo158b3o156b2o279bo158b3o959bo$8bo160b2o46b3o157bob2o155b3o159b2o278bo956bo3bo$7b2o159bo2bo46bo158b3o156b2obo158b3o156b2o1076bo3bo$109bo58bo2bo15b2o189bo158b3o157bob2o155b3o159b2o919bo$107b3o58b2ob2o14b2o68b2o279bo158b3o156b2obo158b3o915bobo$106bo27bobo2b2o29b2o84b3o159b2o278bo158b3o157bob2o$106b2o11b2o12bo3bob3o4b2o108b2obo158b3o156b2o279bo158b3o$119b2o13bo6b2o3b2o109b3o157bob2o155b3o159b2o278bo$135b5obo116bo158b3o156b2obo158b3o156b2o$138b3o277bo158b3o157bob2o155b3o$297b2o279bo158b3o156b2obo$109bo28b3o155b3o159b2o278bo158b3o$107b3o25b5obo154b2obo158b3o156b2o279bo$106bo12b2o13bo6b2o154b3o157bob2o155b3o159b2o1167b2ob2o$106b2o11b2o12bo3bob3o156bo158b3o156b2obo158b3o156b2o1009bobo$134bobo2b2o317bo158b3o157bob2o155b3o1009bobo$337b2o279bo158b3o156b2obo1009bo$336b3o159b2o278bo158b3o1031b2o$336b2obo158b3o156b2o279bo1032b2o$109bo227b3o157bob2o155b3o159b2o$107b3o228bo158b3o156b2obo158b3o156b2o982b3o$106bo40b2o69b2o278bo158b3o157bob2o155b3o958b3o7b2o11bo4bo6b2o$106b2o39b2o69b3o156b2o279bo158b3o156b2obo957bo2bo6b2o10bo5bo6b2o$217bob2o155b3o159b2o278bo158b3o957bo22bo$217b3o156b2obo158b3o156b2o279bo958bo3bo19b2o$218bo158b3o157bob2o155b3o159b2o1077bo3bo$378bo158b3o156b2obo158b3o156b2o918bo23b2o$109bo148b2o278bo158b3o157bob2o155b3o919bobo19bo$107b3o148b3o156b2o279bo158b3o156b2ob2o938bo5bo6b2o$106bo150bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40bo4bo6b2o$106b2o149b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19b3o$258bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$418bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o4bo22b2o$148bo5bo143b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o3bo2bo21b2o$147bobo3bobo142b3o156b2o279bo158b3o1046bo3bo$109bo36bo3bobo3bo140bob2o155b3o159b2o278bo1047bo3b2o$107b3o36bo3bobo3bo140b3o156b2obo158b3o156b2o1168bo2bo$106bo39bo9bo141bo158b3o157bob2o155b3o159b2o1008bobo$106b2o350bo158b3o156b2obo158b3o$147b2o5b2o182b2o278bo158b3o157bob2o1108b2o$338b3o156b2o279bo158b3o1109bo$337bob2o155b3o159b2o278bo1111b3o$5b2o142b2ob2o183b3o156b2obo158b3o156b2o1126b3o3b3o98bo$5b2o102bo40bobo185bo158b3o157bob2o155b3o159b2o965bo2bobo2bo$107b3o39b2ob2o63b2o279bo158b3o156b2obo158b3o956b3o5b2obobob2o$106bo43bobo63b3o159b2o278bo158b3o157bob2o955bo2bo5b2o5b2o$106b2o41b2ob2o62b2obo158b3o156b2o279bo158b3o959bo$150bobo64b3o157bob2o155b3o159b2o278bo956bo3bo$150bobo65bo158b3o156b2obo158b3o156b2o1076bo3bo$151bo226bo158b3o157bob2o155b3o1080bo7bo3bo$257b2o279bo158b3o156b2obo1076bobo8b2ob2o$109bo146b3o159b2o278bo158b3o1086bobobobo$107b3o146b2obo158b3o156b2o279bo1089bobo$106bo150b3o157bob2o155b3o159b2o1207b2ob2o$106b2o150bo158b3o156b2obo158b3o156b2o1049bobo$418bo158b3o157bob2o155b3o1049bobo$68b2o23bo41bo161b2o279bo158b3o156b2obo1049bo$69bo22b3o40b3o158b3o159b2o278bo158b3o1071b2o$69bob2o18b2obo43bo157b2obo158b3o156b2o279bo1072b2o$70bobo18b3o15bo27b2o50bo107b3o157bob2o155b3o159b2o$60bo30b3o13b3o21b2o54b3o108bo158b3o156b2obo158b3o156b2o1024b4o$59bobo30b2o12bo25bo53bo271bo158b3o157bob2o155b3o1008b2o14bo2b2o4b2o$59bobo39bo4b2o24bobo51b2o149b2o279bo158b3o156b2obo1007b2o15bo2b2o3b2o$58b2ob2o37b3o30b2o57b2o142b3o159b2o278bo158b3o1024bo2bo$61bo37b2obo66b2o21bo143b2obo158b3o156b2o279bo1026b2o$58b2o2bo7bo28b3o67bo20bobo144b3o157bob2o155b3o159b2o$59bo2bo7bobo27b2o52bo12bobo20b2o146bo158b3o156b2obo158b3o156b2o986b2o$57bo8b3o40bo44b3o10b2o49b2o278bo158b3o157bob2o155b3o958b3o24bo2bo$57b2o9b3o2bo33b3o47bo60b3o156b2o279bo158b3o156b2ob2o956bo2bo23bo2b2o3b2o$66b2o4b2o32bo49b2o59bob2o155b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o11bo10bo14bo2b2o4b2o$70b2o34b2o109b3o156b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o10bo3bob2o4b2o12b4o$127b2o89bo158b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o10bo3bob2o$128bo22bo226bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o12bo5b2o3bo22b2o$128bobo19b2o106b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o35bobo6bobo21b2o$129b2o10bo4bo49b2o60b3o156b2o279bo158b3o1087bobo$109bo30b2o3b2o30bo18bo60bob2o155b3o159b2o278bo1089bo$65bo3bo37b3o29b2o3b2o29b4o15bobo60b3o156b2obo158b3o156b2o$65bo3bo36bo33b2o4bo27b2o3b2o13b2o62bo158b3o157bob2o155b3o159b2o$106b2o33b2o34bo3bo236bo158b3o156b2obo158b3o$177bo3bo116b2o278bo158b3o157bob2o$62b2obo3bob2o104bo2b2o116b3o156b2o279bo158b3o$63b3o3b3o103bo3bo117bob2o155b3o159b2o278bo$64bo5bo226b3o156b2obo158b3o156b2o$52bo56bo44b2o142bo158b3o157bob2o155b3o159b2o$51bobo53b3o44bo303bo158b3o156b2obo158b3o$51bobo52bo48b3o180b2o278bo158b3o157bob2o1003b2obo3bob2o$52bo53b2o49bo11b2o167b3o156b2o279bo158b3o1004bo2bo3bo2bo$143b2o25bo166bob2o155b3o159b2o278bo1006b3o3b3o$65b2ob2o73bo23b3o167b3o156b2obo158b3o156b2o$66bobo71bo3b3o20bo170bo158b3o157bob2o155b3o$66bobo69b3o5bo33b2o35b2o279bo158b3o156b2obo1117b3o$67bo41bo27bo43bo34b3o159b2o278bo158b3o1116bo2bo$107b3o27b2o39b3o8bo26b2obo158b3o156b2o279bo1120bo$106bo44bo26bo8b3o27b3o157bob2o155b3o159b2o1235bo3bo7b2ob2o$106b2o41b3o34bo31bo158b3o156b2obo158b3o156b2o1076bo3bo8bobo$148bo37b2o190bo158b3o157bob2o155b3o1080bo8bobo$148b2o42b2o63b2o279bo158b3o156b2obo1076bobo10bo$169b2o21bo63b3o159b2o278bo158b3o1111b2o$138b2ob2o26bo20bobo63b2obo158b3o156b2o279bo1112b2o$109bo28b2ob2o11bo12bobo20b2o65b3o157bob2o155b3o159b2o1209b2o$107b3o44b3o10b2o89bo158b3o156b2obo158b3o156b2o1049b4o7b2o$106bo38b2o10bo260bo158b3o157bob2o155b3o1048bobobo6bo2b2o9b2o$106b2o37b2o9b2o21b2o116b2o279bo158b3o156b2obo1047b2ob3o4b6o9b2o$179b2o115b3o159b2o278bo158b3o1050b2obo5b4o$137b2o157b2obo158b3o156b2o279bo1051b2obo$123b2o11b2obo15bo141b3o157bob2o155b3o159b2o$122bobo12bob4o13bo141bo158b3o156b2obo158b3o156b2o1011b2obo$109bo12bo15bo2b3o10b3o39b2o260bo158b3o157bob2o155b3o1011b2obo5b4o$107b3o11b2o16bo3bo52bo140b2o279bo158b3o156b2ob2o1008bo2bo4b6o9b2o$106bo32b4o51bobo139b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o18b2o6bo2b2o9b2o$106b2o33bo8b3o34b2o5b2o140b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o17b2o7b2o$152bo21b3o7bo2b3o147b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o13bo4bo$138b2o11bo21b2ob2o2b4o2bo2bo148bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o14b3o3b3o17b2o$138b2o15b2o15bo4b2ob4ob2o2bo28b2o278bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o28b3o5bo2bobo2bo17b2o$155b2o16b6o6b2obo29b3o156b2o279bo158b3o1117bo2bo6b2ob2o$109bo64b2o2bo8bo29bob2o155b3o159b2o278bo1118bo$107b3o17b2o49b2obo35b3o156b2obo158b3o156b2o1238bo3bo$106bo19bobo50bobo36bo158b3o157bob2o155b3o159b2o1077bo3bo$106b2o18bo52bo198bo158b3o156b2obo158b3o1076bo7bo7bo$125b2o42b2o87b2o278bo158b3o157bob2o1077bobo5bobobobo$131b2o37bo87b3o156b2o279bo158b3o1086bobobobo$132bo34b3o87bob2o155b3o159b2o278bo1086bob2ob2obo$129b3o35bo89b3o156b2obo158b3o156b2o1206b2o5b2o$109bo19bo50b2o76bo158b3o157bob2o155b3o159b2o$107b3o71bo236bo158b3o156b2obo158b3o$106bo71b3o117b2o278bo158b3o157bob2o$106b2o21bo48bo119b3o156b2o279bo158b3o$127bobo167bob2o155b3o159b2o278bo$128bobo166b3o156b2obo158b3o156b2o$128bo169bo158b3o157bob2o155b3o$458bo158b3o156b2obo$109bo30b2o196b2o278bo158b3o$107b3o30b2o196b3o156b2o279bo$106bo230bob2o155b3o159b2o1287b2ob2o$106b2o229b3o156b2obo158b3o156b2o1129bobo$338bo158b3o157bob2o155b3o1129bobo$123b2o13b2o77b2o279bo158b3o156b2obo1117b3o9bo$124bo11bo2bo76b3o159b2o278bo158b3o1116bo2bo31b2o$124bobo9bo2bo76b2obo158b3o156b2o279bo1120bo31b2o$109bo15b2o8b2ob2o77b3o157bob2o155b3o159b2o1235bo3bo$107b3o24b2ob2o79bo158b3o156b2obo158b3o156b2o1076bo3bo17b2o$106bo26b2o3b2o238bo158b3o157bob2o155b3o1080bo7b2o6b2ob2o12b2o$106b2o26b3o2bo117b2o279bo158b3o156b2obo1076bobo8b2o6bo2bo13b2o$139bo116b3o159b2o278bo158b3o1095bo2bo$136bobo15b2o100b2obo158b3o156b2o279bo1097b2o$137bo16bobo100b3o157bob2o155b3o159b2o$156bo101bo158b3o156b2obo158b3o156b2o1057b2o$109bo46b2o260bo158b3o157bob2o155b3o1056bo2bo$93bo13b3o40b2o145b2o279bo158b3o156b2ob2o1054bo2bo13b2o$92b3o11bo43bo145b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17b2ob2o12b2o$56bo34b2obo11b2o43b3o142b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o18b2o$55bobo33b3o59bo143b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$27bo27bobo33b3o45b2o157bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o34b2o$26bobo25b2ob2o33b2o45bo318bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o56b2o$26bobo72bo33bo4b3o194b2o279bo158b3o$25b2ob2o70b3o6bo25b3o4bo193b3o159b2o278bo$99b2obo4b3o28bo197b2obo158b3o156b2o$99b3o4bo30b2o50bo147b3o157bob2o155b3o159b2o1126bo5bo$100b2o4b2o23b2o54b3o148bo158b3o156b2obo158b3o1124b3o3b3o$132bo53bo31b2o278bo158b3o157bob2o1116b3o4b2obo3bob2o$132bobo51b2o30b3o156b2o279bo158b3o1117bo2bo$133b2o57b2o23bob2o155b3o159b2o278bo1118bo$169b2o21bo24b3o156b2obo158b3o156b2o1238bo3bo5bo3bo$24bo5bo78bo59bo20bobo25bo158b3o157bob2o155b3o159b2o1077bo3bo5bo3bo$23b3o3b3o75b3o34b2o8bo12bobo20b2o186bo158b3o156b2obo158b3o1076bo$22b2o2bobo2b2o18b3o5b3o44bo37b2o8b3o10b2o89b2o278bo158b3o157bob2o1077bobo$21bob4ob4obo17b3o5b3o44b2o49bo100b3o156b2o279bo158b3o$23b3o3b3o20b2o5b2o95b2o21b2o76bob2o155b3o159b2o278bo$22b3o5b3o21bo3bo120b2o76b3o156b2obo158b3o156b2o$52bo2bobo2bo66b2o16bo112bo158b3o157bob2o155b3o$51bo3bobo3bo66bo15b3o271bo158b3o156b2obo$52bo2bobo2bo48bo18bobo8bo3bo154b2o278bo158b3o$52b3o3b3o46b3o19b2o7b3obob2o8bo41b2o100b3o156b2o279bo$106bo30bo3b2obo8bobo19bo20bo100bob2o155b3o159b2o1327b2ob2o$106b2o31b4o2bo7bo2bo17bobo3bobo4bo6bobo100b3o156b2obo158b3o156b2o1169bobo$56bo5bo70b5o2bo4bo5bo4bo16bo3b3obobo2bobo5b2o102bo158b3o157bob2o155b3o1169bobo$55b3o3b3o69bo2b3o4bo2bo3bo5bo15b2o2bo4bobobo3b2o267bo158b3o156b2obo1169bo$54b2o2bobo2b2o68b2o9b2o5bo3bo15b2ob3o5bo3b2o150b2o278bo158b3o1191b2o$29bo24b2ob2ob2ob2o87b2o16bo4bo162b3o156b2o279bo1193bo$27bobo27b2ob2o47bo61b4o6b2o4bo2bo146bob2o155b3o159b2o$28b2o25bobo3bobo43b3o62b2o6bo6bobo147b3o156b2obo158b3o156b2o1143b2o$54bo2bo3bo2bo41bo47b2o24b3o4b2o149bo158b3o157bob2o155b3o1128b2o12bo2bo7b2o$57bo3bo44b2o46bo24b2o36b2o279bo158b3o156b2obo1117b3o7b2o11b2o2bo7b2o$20bo7bo25bobo5bobo90b3o21bo36b3o159b2o278bo158b3o1116bo2bo21bo2bo$19bo2bo3bo2bo16bo8bo7bo93bo11b2o45b2obo158b3o156b2o279bo1120bo22bo$23bobo19bo89bo7b2o25bo46b3o157bob2o155b3o159b2o1235bo3bo$23bobo19b3o87b3o5bo23b3o48bo158b3o156b2obo158b3o156b2o1076bo3bo22bo$23bobo83bo28bo5b3o20bo210bo158b3o157bob2o155b3o1080bo21bo2bo$19bo2bo3bo2bo77b3o27b2o7bo33b2o7bo67b2o279bo158b3o156b2ob2o1075bobo21b2o2bo7b2o$20b3o3b3o11bo65bo24b2o48bo5b3o66b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17bo2bo7b2o$41bo64b2o24bo45b3o5bo69b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o17b2o$39b3o90bobo43bo7b2o69b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$133b2o57b2o64bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o29bo$169b2o21bo225bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o28bo21b2o$139b2o28bo20bobo104b2o279bo158b3o1206b3obo$36b2o19b2ob2o47bo29b2o13bo12bobo20b2o104b3o159b2o278bo1206bo4bo$37bo20bobo46b3o44b3o10b2o127b2obo158b3o156b2o1327bo2bo$22b2ob2o7b3o10b2o9bobo45bo34bo15bo26b2o111b3o157bob2o155b3o159b2o1168b2o$23bobo8bo12bobo9bo46b2o27b3o3b2ob2o10b2o26b2o112bo158b3o156b2obo158b3o$23bobo23bo85b2o5bobobo32bo278bo158b3o157bob2o$24bo24b2o76b2o8bo4bob2o31b2obo156b2o279bo158b3o$128bo12b3o37bo5b2o147b3o159b2o278bo$128bobo6b2o2bobo33b2o2bo5b2o147b2obo158b3o156b2o1286b2o5b2o$109bo19b2o6b6o37bob2o12b2o139b3o157bob2o155b3o159b2o1124bo2bo3bo2bo$107b3o27b3o4b2o32bobob2o3b2o7bo141bo158b3o156b2obo158b3o1126b2ob2o$106bo37b2o34bo2bo3b2o5bobo21b2o278bo158b3o157bob2o1116b3o6bobobobo$106b2o70bob2o12b2o22b3o156b2o279bo158b3o1117bo2bo5bobobobo$180bob2o33bob2o155b3o159b2o278bo1118bo6bo9bo$181b2o34b3o156b2obo158b3o156b2o1238bo3bobo11bo$218bo158b3o157bob2o155b3o1238bo3bo$378bo158b3o156b2obo1237bo7bob2ob2obo$109bo148b2o278bo158b3o1238bobo6b2ob2o$107b3o44b2o102b3o156b2o279bo1247bo5bo$106bo47bo102bob2o155b3o159b2o1367b2ob2o$16b2o5b2o81b2o47b3o99b3o156b2obo158b3o156b2o1209bobo$16b2o5b2o132bo11b2o87bo158b3o157bob2o155b3o1209bobo$135bo7b2o25bo247bo158b3o156b2obo1209bo$135b3o5bo23b3o128b2o278bo158b3o1231b2o$138bo5b3o20bo130b3o156b2o279bo1232b2o$109bo27b2o7bo33b2o7bo107bob2o155b3o159b2o$107b3o21b2o48bo5b3o107b3o156b2obo158b3o156b2o1185b2o$106bo25bo45b3o5bo111bo158b3o157bob2o155b3o1168b2o15bobo5b2o$106b2o24bobo43bo7b2o270bo158b3o156b2obo1167b2o15bob2o4b2o$133b2o57b2o144b2o278bo158b3o1185b2o$169b2o21bo145b3o156b2o279bo1186bo$169bo20bobo144bob2o155b3o159b2o$154bo12bobo20b2o145b3o156b2obo158b3o156b2o1146bo$109bo44b3o10b2o169bo158b3o157bob2o155b3o1146b2o$107b3o47bo59b2o279bo158b3o156b2ob2o1116b3o24bob2o4b2o$106bo49b2o58b3o159b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o32bo2bo4b2ob2o15bobo5b2o$106b2o108b2obo158b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o13bo7b3o14b2o$15b3o5b3o101b2o88b3o157bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o7bo3bo3b5obo$15bo2b2ob2o2bo102bo10b3o8b2o66bo158b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o7bo3bo2bobobo24b2o$16b3o3b3o103bobo7bo2bo4bo3b2o226bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o12bo7bobo21b2o$17bo5bo105b2o6bo3bo3bobo48b2o59b2o279bo158b3o1236bobo9bo$109bo27bo7bobo25bo22bo59b3o159b2o278bo1249bo$107b3o30bo32b2o19bobo59b2obo158b3o156b2o$106bo30b2obo37bo4bo10b2o61b3o157bob2o155b3o159b2o$106b2o70b2o3b2o73bo158b3o156b2obo158b3o$179b2o3b2o232bo158b3o157bob2o$93bo46bob2o34bo4b2o112b2o279bo158b3o$16b2o74b3o45b3o39b2o112b3o159b2o278bo1208b2ob2o$16b2o73b2obo46bo154b2obo158b3o156b2o1327bo5bo$91b3o15bo44b2o141b3o157bob2o155b3o159b2o$91b3o13b3o44bo143bo158b3o156b2obo158b3o1164bo7bo$92b2o12bo48b3o300bo158b3o157bob2o1164bo2bobo2bo$101bo4b2o49bo11b2o166b2o279bo158b3o1165b3o3b3o$100b3o40b2o25bo165b3o159b2o278bo$99b2obo40bo23b3o166b2obo158b3o156b2o$99b3o38bo3b3o20bo169b3o157bob2o155b3o$100b2o36b3o5bo33b2o156bo158b3o156b2obo$109bo27bo43bo36b2o278bo158b3o1277b3o$107b3o27b2o39b3o8bo28b3o156b2o279bo1278bo2bo$106bo44bo26bo8b3o27bob2o155b3o159b2o1397bo9b2ob2o$106b2o41b3o34bo30b3o156b2obo158b3o156b2o1238bo3bo6bobo$148bo37b2o30bo158b3o157bob2o155b3o1238bo3bo6bobo$148b2o42b2o184bo158b3o156b2obo1237bo11bo$169b2o21bo65b2o278bo158b3o1238bobo30b2o$138b2ob2o26bo20bobo65b3o156b2o279bo1272b2o$109bo28b2ob2o11bo12bobo20b2o65bob2o155b3o159b2o$107b3o44b3o10b2o88b3o156b2obo158b3o156b2o$106bo30b2o6b2o10bo100bo158b3o157bob2o155b3o1208b6o5b4o10b2o$106b2o27bo3bo5b2o9b2o21b2o237bo158b3o156b2obo1207b4o7b2obo10b2o$134bo4b2o38b2o117b2o278bo158b3o1210b2obo7bo$134bo5bo157b3o156b2o279bo1213b2o5b2o$123b2o172bob2o155b3o159b2o$44bo77bobo10bo4bo156b3o156b2obo158b3o156b2o1173b2o5b2o$42b5o10bo51bo12bo12b2obob2obo34b3o15b2o100bo158b3o157bob2o155b3o1171b2obo7bo$41bo2bob2o9b2o8b2o38b3o11b2o30bo2b3o19b4o14bo261bo158b3o156b2ob2o1169bo7b2obo10b2o$40bo7bo9b2o7b2o37bo45bo3bobo14b2o3b2ob2o3b2o6bobo141b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40b3o5b4o10b2o$41bo2bob2o5b2o2b2o47b2o45bob3o14bo7bo5b3o5b2o142b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o$42b5o123bo2bo5b3o3bob3o147bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$44bo125bo2bo5b2obo2b2obo148b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o12bo5bo18b2o$155b2o12bo3bo8b2ob2obo149bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o12b3o3b3o17b2o$53b2o2b2o96b2o13b3o7bobo3bobo28b2o279bo158b3o1277b3o5bob2ob2obo$40b2o16b2o7b2o40bo71bo4bo2bo26b3o159b2o278bo1277bo2bo4b2o7b2o$40b2o15b2o8b2o38b3o17b2o57b3o27b2obo158b3o156b2o1400bo4b2o7b2o$57bo48bo19bobo50b2o6bo29b3o157bob2o155b3o159b2o1235bo3bo4b3o5b3o$106b2o18bo52b2o37bo158b3o156b2obo158b3o1234bo3bo6b3ob3o$125b2o42b2o207bo158b3o157bob2o1238bo8bobo$131b2o37bo86b2o279bo158b3o1236bobo6bo2bobo2bo$132bo34b3o86b3o159b2o278bo1245bo2bo3bo2bo$129b3o35bo88b2obo158b3o156b2o1366b2o5b2o$109bo19bo50b2o75b3o157bob2o155b3o159b2o$107b3o71bo76bo158b3o156b2obo158b3o$106bo71b3o237bo158b3o157bob2o$106b2o21bo48bo118b2o279bo158b3o$127bobo166b3o159b2o278bo$128bobo165b2obo158b3o156b2o$128bo168b3o157bob2o155b3o$298bo158b3o156b2obo$109bo30b2o316bo158b3o$107b3o30b2o195b2o279bo$106bo229b3o159b2o1447b2ob2o$106b2o228b2obo158b3o156b2o1289bobo$337b3o157bob2o155b3o1289bobo$123b2o213bo158b3o156b2obo1289bo$124bo93b2o278bo158b3o1277b3o31b2o$124bobo91b3o156b2o279bo1278bo2bo30b2o$109bo15b2o4b4o82bob2o155b3o159b2o1397bo$107b3o20b2o2bo5b2o75b3o156b2obo158b3o156b2o1238bo3bo15b2o$106bo22b2o2bo4bobob2o74bo158b3o157bob2o155b3o1238bo3bo5b2o7bobo13b2o$106b2o22bo2bo2b2o5bo234bo158b3o156b2obo1237bo9b2o7bo15b2o$131b2o6bo3bo114b2o278bo158b3o1238bobo15b3o$136bo5bo11b2o102b3o156b2o279bo$137b4o13bobo100bob2o155b3o159b2o$139bo16bo100b3o156b2obo158b3o156b2o$109bo46b2o100bo158b3o157bob2o155b3o1217b3o$107b3o40b2o266bo158b3o156b2ob2o1215bo15b2o$106bo43bo147b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40bobo13b2o$106b2o43b3o144b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19b2o$153bo143bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$139b2o156b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o31b2o$139bo158bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o32b2o$140b3o4bo310bo158b3o$109bo32bo3bobo189b2o278bo$107b3o36bobo189b3o156b2o$106bo38b2ob2o187bob2o155b3o159b2o$106b2o229b3o156b2obo158b3o1285bo5bo$338bo158b3o157bob2o1284b3o3b3o$217b2o279bo158b3o1277b3o5bob2ob2obo$216b3o159b2o278bo1277bo2bo7b2ob2o$216b2obo158b3o156b2o1400bo7b2ob2o$109bo107b3o157bob2o155b3o159b2o1235bo3bo7b2ob2o$107b3o108bo158b3o156b2obo158b3o1234bo3bo$106bo271bo158b3o157bob2o1238bo$106b2o149b2o279bo158b3o1236bobo$256b3o159b2o278bo$143bo7bo22b2o5b2o73b2obo158b3o156b2o$62bo2bo76bobo5bobo21b2o5b2o74b3o157bob2o155b3o$52b3o7bo82bo3bo108bo158b3o156b2obo$51bo4bo9bo42bo7bo7bo16bo2bo3bo2bo265bo158b3o$50bo5bo8b2o26bo13b3o5b3o5b3o17bobo3bobo145b2o279bo$41bo9bo8bo31b3o11bo7bo7bo22b2ob2o146b3o159b2o1487b2ob2o$39b3o10b2o8b2o27b2obo11b2o6b2o6b2o18b2ob2ob2ob2o143b2obo158b3o156b2o1329bobo$38bo52b3o48b2o2bobo2b2o144b3o157bob2o155b3o1329bobo$39b3o10b2o8b2o27b3o49b3o3b3o146bo158b3o156b2obo1329bo$41bo9bo8bo3bo27b2o50bo5bo23b3o3b3o275bo158b3o1351b2o$50bo5bo4bo2bo36bo71bo2bo3bo2bo153b2o279bo1351bobo$51bo4bo4bo2bo35b3o70b2obo3bob2o152b3o159b2o1470bo$52b3o7b2o35b2obo233b2obo158b3o156b2o1313bo$99b3o48b2o185b3o157bob2o155b3o1288b2o12b2o2bo3bo3bo$100b2o48b2o186bo158b3o156b2obo1287b2o12bob2o7b2o$218b2o278bo158b3o1277b3o22bo$218b3o156b2o279bo1278bo2bo21b3o4b2o$44b2o5b2o164bob2o155b3o159b2o1397bo$40b2o2b2o5b2o2b2o160b3o156b2obo158b3o156b2o1238bo3bo20b3o4b2o$40b2o13b2o161bo158b3o157bob2o155b3o1238bo3bo20bo$175bo202bo158b3o156b2ob2o1236bo23bob2o7b2o$44b3o3b3o120b2ob2o80b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o16bobo20b2o2bo3bo3bo$44bo2bobo2bo120b2ob2o15b2o5b2o56b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o49bo$43bo3bobo3bo139b2o5b2o55bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b5o24bo$44bo2bobo2bo119bobobobo78b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o20b3ob3o22bobo$46bo3bo207bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o46b5o21b2o$44b2o5b2o120b2ob2o240bo158b3o1365bo4bo$43b3o5b3o55bo64b3o4b2o115b2o278bo1367b2o2bo$43b3o5b3o53b3o65bo5b2o115b3o156b2o1488b3o$106bo190bob2o155b3o159b2o$106b2o189b3o156b2obo158b3o$298bo158b3o157bob2o$194bo5bo257bo158b3o$50b3o140b3o3b3o136b2o278bo$50b3o140bob2ob2obo136b3o156b2o1446bo7bo$49b5o55bo7bo77b2ob2o137bob2o155b3o159b2o1285b2o5b2o$48b2o3b2o52b3o5b3o77b2ob2o137b3o156b2obo158b3o1284b3o3b3o$48b2o3b2o51bo7bo80b2ob2o138bo158b3o157bob2o1286b2ob2o$106b2o6b2o101b2o279bo158b3o1277b3o7bo3bo$216b3o159b2o278bo1277bo2bo4b2o7b2o$216b2obo158b3o156b2o1400bo4b2o7b2o$48b2o3b2o162b3o157bob2o155b3o1396bo3bo8bobo$44b2o2b2o3b2o163bo158b3o156b2obo1395bo3bo4bo2bo3bo2bo$44b2o3b5o139b3o182bo158b3o1399bo5b3o3b3o$50b3o140b3o61b2o279bo1397bobo8bo3bo$50b3o203b3o159b2o1527b2ob2o$192b2ob2o59b2obo158b3o156b2o1369bobo$192bo3bo60b3o157bob2o155b3o1369bobo$193b3o62bo158b3o156b2obo1369bo$194bo5b2o216bo158b3o1391b2o$200b2o95b2o279bo1392b2o$109bo186b3o159b2o$107b3o186b2obo158b3o156b2o1345bo$106bo22bo167b3o157bob2o155b3o1328b2o15b2o6b2o$106b2o20bobo167bo158b3o156b2obo1327b2o16b2o5b2o$128bobo327bo158b3o1340b2o2b2o$129bo207b2o279bo$336b3o159b2o$336b2obo158b3o156b2o$109bo227b3o157bob2o155b3o1301b2o2b2o$107b3o13bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo140bo158b3o156b2ob2o1285b2o17b2o5b2o$106bo111b2o278bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o9b3o5b3o16b2o6b2o$106b2o15bo73bo20b3o156b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o8bo2bo3b2o2bo15bo$129bo87bob2o155b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o8bo6bo2bo$123bo4bobo66bo19b3o156b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o10bo3bobo4b2o21b2o$128bobo12bobobo70bo158b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o32bo3bo6b2o3bo17b2o$123bo5bo67bo180bo158b3o1397bo6bobobo$109bo33bo3bo36bobobobo67b2o278bo1399bobo$107b3o13bo73bo60b3o156b2o$106bo36bobobo34bobobobobobo64bob2o155b3o159b2o$106b2o15bo26bo22bobobo19bo59b3o156b2obo158b3o$143bo3bo2b3o29bobo5bobo65bo158b3o157bob2o1364bo7bo$123bo29bo19bo3bo19bo220bo158b3o1364bo2bo3bo2bo$129bo13bobobo4bo29bobo113b2o278bo1369bobo$123bo4bobo42bobobo19bo100b3o156b2o1489bobo$109bo18bobo37bo15bobobobo106bob2o155b3o159b2o1328bobo$107b3o13bo5bo37bo5bo3bo19bo99b3o156b2obo158b3o1323bo2bo3bo2bo$106bo61b3o19bobo105bo158b3o157bob2o1324b3o3b3o$106b2o15bo19bobobo22bo2bobobo19bo260bo158b3o$128bobobobobo45bobo5bobo145b2o278bo$123bo23bo2bo46bo140b3o156b2o$128bobobobobobo11b3o29bobobobobobo144bob2o155b3o$123bo23bo5bo43bo139b3o156b2obo$109bo18bobo5bobo13bo20bobobo6bobobobo147bo158b3o$107b3o13bo23bo49bo19b2o279bo1438b3o$106bo21bobo5bobo29bo8bo38b3o159b2o1556bo2bo7b2ob2o$106b2o15bo23bo19bo29bo18b2obo158b3o156b2o1400bo8bobo$128bobobobobo31b3o6bo8bo30b3o157bob2o155b3o1396bo3bo8bobo$123bo46bo14bobo9bo20bo158b3o156b2obo1395bo3bo9bo$128bobo5bobo38bo7bobo190bo158b3o1399bo31b2o$123bo26bo35bo10bo59b2o279bo1397bobo32b2o$109bo18bobo5bobo4bobobo2b3o24bo78b3o159b2o1535bo$107b3o13bo29bo43bo58b2obo158b3o156b2o1377bo3bo$106bo21bobobobobobo4bo8bo104b3o157bob2o155b3o1368b2o2b2o8bo10b2o$106b2o15bo73bo60bo158b3o156b2obo1367b2o2bo5b2o2bo10b2o$128bobobobobo6bobobo20bo249bo158b3o1371bobo5b2o$93bo29bo43bo5bobobo19bo99b2o279bo1373b2o3b3o$92b3o48bo3bo20b3o15bo109b3o159b2o$91b2obo28bo46bo2bo11bobo9bo98b2obo158b3o156b2o1333b2o3b3o$91b3o15bo19bo13bobobo37bobo109b3o157bob2o155b3o1332bobo5b2o$91b3o13b3o13bo4bobo42bobobo8bo10bo100bo158b3o156b2ob2o1330bo5b2o2bo10b2o$92b2o12bo21bobo327bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17b2o8bo10b2o$101bo4b2o15bo5bo43bo3bo19bo139b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o21bo3bo$100b3o233b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o20bo$99b2obo20bo49bobobo19bo138b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o38b2o$99b3o235b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o35bo5bo18b2o$100b2o21bo73bo140bo158b3o1445b3o3b3o$109bo76bo31b2o278bo1438b3o4b2o2bobo2b2o$107b3o13bo61bobo9bo20b3o156b2o1558bo2bo3b2ob2ob2ob2o$23bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo4bo22bo55bobo29bob2o155b3o159b2o1397bo9b2ob2o$106b2o15bo4bobo55bo10bo19b3o156b2obo158b3o1396bo3bo3bobo3bobo$23bo77bo26bobo12bobobo70bo158b3o157bob2o1396bo3bo2bo2bo3bo2bo$123bo5bo67bo180bo158b3o1397bo9bo3bo$23bo22bobobobo7bobo5bobo30bo41bo40bobobobo67b2o278bo1399bobo3bobo5bobo$123bo73bo60b3o156b2o1526bo7bo$23bo20bobobobobobo5bobo5bobo11bobobobo12bo7bo33bobobo34bobobobobobo64bob2o155b3o159b2o$107b3o13bo26bo22bobobo19bo59b3o156b2obo158b3o$23bo20bobo5bobo5bobobo3bobo11bobobobo12bo4bo40bo2b3o29bobo5bobo65bo158b3o157bob2o$106b2o15bo29bo19bo23bo220bo158b3o$23bo20bobo5bobo5bobobo3bobo11bobo16bo27bo13bobobo4bo29bobo113b2o278bo$123bo4bobo42bobobo19bo100b3o156b2o$23bo20bobo5bobo5bobo2bo2bobo11bobo16bo26bobo37bo15bobobobo106bob2o155b3o$123bo5bo37bo9bo19bo99b3o156b2obo$23bo20bobo5bobo5bobo3bobobo15bobobobobobo4bo7bo58b3o19bobo105bo158b3o$107b3o13bo19bo3bo22bo2bobobo19bo260bo$23bo20bobo5bobo5bobo3bobobo15bobobobobobo4bo4bo21bobobobobo45bobo5bobo145b2o1607b2ob2o$106b2o15bo19bo3bo2bo46bo140b3o156b2o1449bobo$23bo20bobobobobobo5bobo5bobo23bobo4bo26bobobobobobo11b3o29bobobobobobo144bob2o155b3o1449bobo$123bo19bobobo5bo43bo139b3o156b2obo1449bo$23bo22bobobobo7bobo5bobo23bobo4bo26bobo5bobo13bo20bo3bo6bobobobo147bo158b3o1471b2o$123bo23bo49bo19b2o279bo1438b3o31b2o$23bo77bo7bo18bobo5bobo29bo4bo3bo38b3o159b2o1556bo2bo$107b3o13bo23bo19bo29bo18b2obo158b3o156b2o1400bo$23bo77bo4bo21bobobobobo31b3o2bobobo8bo30b3o157bob2o155b3o1396bo3bo7b2o8b3o12b2o$106b2o15bo46bo14bobo9bo20bo158b3o156b2obo1395bo3bo7b2o8bo3bo10b2o$23bo77bo26bobo5bobo38bo7bobo190bo158b3o1399bo17bo4bo$123bo26bo35bo10bo59b2o279bo1397bobo19bo3bo$23bo6bobobobo7bobobobobobo5bobobobobobo30bo26bobo5bobo4bobobo2b3o24bo78b3o159b2o$123bo29bo43bo58b2obo158b3o156b2o1379bo3bo$23bo4bobobobobobo5bobobobobobo5bobobobobobo15bobo12bo7bo18bobobobobobo8bo4b2o103b3o157bob2o155b3o1378bo4bo$107b3o13bo73bo60bo158b3o156b2ob2o1376bo3bo10b2o$23bo4bobo5bobo5bobo13bobo23bobo12bo4bo21bobobobobo6bobobo19b2o249bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17b3o12b2o$106b2o15bo43bo5bobobo19bo99b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o$23bo4bobo5bobo5bobobobobo7bobobobobo13bobo16bo45bo20b3o15bo109b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$123bo46bo6bo7bobo9bo98b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o32b2o$23bo4bobo5bobo5bobobobobo7bobobobobo13bobo16bo27bo13bobobo37bobo109b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o54b2o$123bo4bobo42bobobo8bo10bo100bo158b3o$23bo4bobo5bobo5bobo13bobo23bobobobobobo4bo7bo18bobo327bo$107b3o13bo5bo47bo19bo139b2o$23bo4bobo5bobo5bobo13bobo23bobobobobobo4bo4bo229b3o159b2o$106b2o15bo49bobobo19bo138b2obo158b3o$23bo4bobobobobobo5bobo13bobo31bobo4bo235b3o157bob2o1445bo5bo$123bo73bo140bo158b3o1445b3o3b3o$23bo6bobobobo7bobo13bobo31bobo4bo84bo31b2o278bo1438b3o4b2o2bobo2b2o$123bo61bobo9bo20b3o156b2o1558bo2bo2bob4ob4obo$23bo77bo7bo19bo55bobo29bob2o155b3o159b2o1397bo7b3o3b3o$107b3o13bo4bobo55bo10bo19b3o156b2obo158b3o1396bo3bo2b3o5b3o$23bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo4bo21bobo12bobobo70bo158b3o157bob2o1396bo3bo$106b2o15bo5bo67bo180bo158b3o1397bo$147bo36bobobobo67b2o278bo1399bobo$123bo73bo60b3o156b2o$143bobobo34bobobobobobo64bob2o155b3o$123bo26bo22bobobo19bo59b3o156b2obo$109bo33bo6b3o29bobo5bobo65bo158b3o$107b3o13bo29bo23bo19bo220bo$106bo22bo13bobobo4bo29bobo113b2o1647b2ob2o$106b2o15bo4bobo42bobobo19bo100b3o156b2o1489bobo$128bobo36b2o15bobobobo106bob2o155b3o1489bobo$123bo5bo37bo5bo23bo99b3o156b2obo1489bo$168b3o19bobo105bo158b3o1511b2o$123bo21bo24bo2bobobo19bo260bo1512b2o$109bo18bobobobobo45bobo5bobo145b2o$107b3o13bo21bo4bo46bo140b3o156b2o1463bo3b3ob3o$106bo21bobobobobobo11b3o29bobobobobobo144bob2o155b3o1448b2o12bobo2b4o3bo$106b2o15bo21bo7bo43bo139b3o156b2obo1447b2o12bo3b2o6bo$128bobo5bobo13bo22bo8bobobobo147bo158b3o1462bo2bo3b2obo$123bo21bo51bo19b2o279bo1438b3o23b3o3bo$128bobo5bobo29bo6bo40b3o159b2o1556bo2bo$123bo21bo21bo29bo18b2obo158b3o156b2o1400bo23b3o3bo$109bo18bobobobobo31b3o4bo10bo30b3o157bob2o155b3o1396bo3bo22bo2bo3b2obo$107b3o13bo46bo14bobo9bo20bo158b3o156b2ob2o1394bo3bo21bo3b2o6bo$106bo21bobo5bobo36bo9bobo190bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o39bo9bo11bobo2b4o3bo$106b2o15bo26bo35bo10bo59b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o14bobo5b2o3bo12bo3b3ob3o$128bobo5bobo4bobobo2b3o22bo80b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b4o$123bo29bo43bo58b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o18bo28b2o$128bobobobobobo4bo3bo4bo104b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o19bo4bo23b2o$123bo73bo60bo158b3o1526b2ob2o$109bo18bobobobobo6bo3bo20bo249bo1528b3o$93bo13b3o13bo43bo5bobobo19bo99b2o$92b3o11bo36bo3bo20b3o15bo109b3o159b2o$91b2obo11b2o15bo46bo2bo3bo7bobo9bo98b2obo158b3o$91b3o49bobobo37bobo109b3o157bob2o$91b3o29bo49bo3bo8bo10bo100bo158b3o$92b2o364bo$101bo21bo49bo3bo19bo139b2o$100b3o6bo226b3o159b2o1444b3o5b3o$99b2obo4b3o13bo49bobobo19bo138b2obo158b3o1443b3o5b3o$99b3o4bo230b3o157bob2o1444b2o5b2o$100b2o4b2o15bo73bo140bo158b3o1447bo3bo$186bo31b2o278bo1438b3o5bo2bobo2bo$123bo61bobo9bo20b3o156b2o1558bo2bo3bo3bobo3bo$185bobo29bob2o155b3o1558bo7bo2bobo2bo$123bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo4bo4bobobobo19b3o156b2obo1557bo3bo3b3o3b3o$109bo108bo158b3o1557bo3bo$107b3o268bo1558bo$106bo151b2o1678bobo6b2ob2o$106b2o56b2o92b3o156b2o1529bobo$164bo26b3o63bob2o155b3o1529bobo$165b3o23b3o4b2o57b3o156b2obo1529bo$167bo22bo3bo3b2o58bo158b3o1551b2o$189bo5bo222bo1552b2o$109bo80b2ob2o103b2o$107b3o188b3o156b2o$106bo83b2ob2o102bob2o155b3o1488b2o14b2o7b2o$106b2o81bo5bo101b3o156b2obo1487b2o15b2o6b2o$146b2o42bo3bo103bo158b3o1500b5o$145bo2bo42b3o264bo1501b4o$145bo7bo37b3o144b2o$145bo2bo3bobo183b3o156b2o1450b3o8b4o$109bo35b2ob2ob2ob2o181bob2o155b3o1449b6o6b5o$107b3o39bobo185b3o156b2ob2o1447b2o2b3o9b2o6b2o$106bo41b2ob2o185bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40b2o4b3o8b2o7b2o$106b2o109b2o279bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o9b3o5b2o6b2o$216b3o159b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o6bo2bo4bo2bo5b2o$190b2o7b2o15b2obo158b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o9bo4bo2bo3b3o17b2o$190bob2o3b2obo16b3o157bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o6bo3bo5bo3b4o18b2o$146b3o3b3o35bo3bobo3bo17bo158b3o1555bo3bo5bo3b3o$109bo35bo9bo34b2o2bobo2b2o177bo1560bo6bo2bo$107b3o35bo3bobo3bo35b3o3b3o57b2o1677bobo$106bo39b3o3b3o37bo5bo57b3o159b2o$106b2o39bo5bo102b2obo158b3o$257b3o157bob2o$258bo158b3o1525bo7bo$418bo1524bob2o5b2obo$297b2o1644bo3b2ob2o3bo$109bo81b2o5b2o96b3o159b2o1484bo3bobo3bo$107b3o81b2o5b2o96b2obo158b3o1484b3o3b3o$106bo190b3o157bob2o$106b2o190bo158b3o$458bo$148b2ob2o184b2o$149bobo184b3o$149bobo184b2obo$109bo40bo186b3o$107b3o228bo$106bo111b2o1717b3o7b2ob2o$106b2o110b3o156b2o1558bo2bo7bobo$217bob2o155b3o1558bo10bobo$217b3o156b2obo1557bo3bo7bo$164bo53bo158b3o1557bo3bo29b2o$163bobo212bo1558bo33b2o$109bo53bobo92b2o1678bobo$107b3o52b2ob2o91b3o156b2o1534bob2o$106bo150bob2o155b3o1528b2o3bo2b2o2b3o10b2o$106b2o149b3o156b2obo1527b2o3bo6b2o11b2o$258bo158b3o1532b2o3b3o$418bo1535bo3bo$298b2o$298b3o156b2o1495bo3bo$109bo187bob2o155b3o1493b2o3b3o$107b3o187b3o156b2ob2o1491bo6b2o11b2o$106bo191bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40bo2b2o2b3o10b2o$106b2o350bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19bob2o$338b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$338b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o35b2o$160bo7bo168bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o36b2o$159b4o3b4o167b3o1606bo5bo$109bo49bo3bobo3bo168bo1606b3o3b3o$107b3o50bo2bobo2bo48b2o1718b3o4bo2b2ob2o2bo$106bo53b3o3b3o47b3o159b2o1556bo2bo4bo3bobo3bo$106b2o108b2obo158b3o1558bo6bobobobo$217b3o157bob2o1554bo3bo$218bo158b3o1555bo3bo3b2ob2o3b2ob2o$378bo1560bo5bo7bo$257b2o1677bobo$109bo146b3o159b2o$107b3o50b2o94b2obo158b3o$106bo53b2o95b3o157bob2o$106b2o150bo158b3o$418bo$93bo203b2o$92b3o201b3o$91b2obo201b2obo$91b3o15bo187b3o$91b3o13b3o188bo$92b2o12bo1840b2ob2o$101bo4b2o67b3ob3o9b2o144b2o1609bobo$100b3o71bob2ob2obo7b2ob2o6b2o133b3o1609bobo$99b2obo70b2o7b2o7bo2bo6b2o133b2obo1609bo$99b3o72bob2ob2obo8bo2bo142b3o1631b2o$100b2o73b3ob3o10b2o144bo1632b2o$218b2o1717b3o$192b2o24b3o156b2o1558bo2bo18bo3bo$191bo2bo22bob2o155b3o1558bo9b2o9bo5bo7b2o$174b2o15bo2bo6b2o14b3o156b2obo1557bo3bo5b2o9bo13b2o$174b2o14b2ob2o6b2o15bo158b3o1557bo3bo16b2o3bo$191b2o185bo1558bo22b3o$258b2o1678bobo$258b3o156b2o1541b3o$109bo147bob2o155b3o1539b2o3bo$107b3o147b3o156b2ob2o1537bo13b2o$106bo86b2o5b2o56bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o40bo5bo7b2o$106b2o85b2o5b2o216bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19bo3bo$298b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$298b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o29b2o$297bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o30b2o$297b3o$109bo188bo1646b2o$107b3o$106bo231b2o$106b2o230b3o$337bob2o$337b3o1606bo5bo$194bo5bo137bo1606b3o3b3o$193bobo3bobo15b2o1718b3o4b2ob2ob2ob2o$109bo7bo7bo66bo3bobo3bo13b3o159b2o1556bo2bo3b3o7b3o$107b3o5b3o5b3o66bo3bobo3bo13b2obo158b3o1558bo$106bo7bo7bo69bo9bo14b3o157bob2o1554bo3bo5bo7bo$106b2o6b2o6b2o94bo158b3o1555bo3bo$193b2o5b2o176bo1560bo$257b2o1677bobo$256b3o1688b2ob2o$256b2obo$195bo3bo57b3o1687b2ob2o$193b2o63bo$192bo3bobo3b2o1743b2ob2o$192bo3bobo98b2o1649bobo$193b3o100b3o1649bobo$200bo2bo92b2obo1649bo$200b2o95b3o1671b2o$30b2o266bo1672b2o$30b2o$337b2o1623bobo2b2o$42bobo2b2o287b3o1608b2o12bo3bob3o2b2o$29b2o10bo3bob3o286b2obo1607b2o13bo6b2ob2o$29b2o11bo6b2o286b3o1623b5obo$43b5obo288bo1627b3o$46b3o169b2o1717b3o$218b3o156b2o1558bo2bo25b3o$46b3o168bob2o155b3o1558bo25b5obo$43b5obo167b3o156b2ob2o1556bo3bo20bo6b2ob2o$29b2o11bo6b2o3b2o65b2o95bo158b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o13bo3bo7bo11bo3bob3o2b2o$29b2o10bo3bob3o4b2o65b2o255bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o12bo10b2o12bobo2b2o$42bobo2b2o209b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o13bobo2b2ob4o$258b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o19bo2bobob2o20b2o$30b2o225bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o41bobob2ob2o20b2o$30b2o225b3o1687bob2o$258bo1689bo$55b2o$55b2o241b2o$298b3o$297bob2o$297b3o$298bo2$109bo4b2o5b2o215b2o$107b3o3bo2bo3bo2bo214b3o1603b3o5b3o$106bo7bo2bobo2bo214bob2o1602b2ob2o3b2ob2o$106b2o9bobo217b3o1603b2obobobobob2o$115b3ob3o216bo1605bo3bobo3bo$113b3o5b3o93b2o1718b3o4bo2bo3bo2bo$55b3o3b3o49b2o7b2o92b3o1717bo2bo5b3o3b3o$55b3o3b3o49b2o7b2o92b2obo1719bo$54bob2o3b2obo44bo4bob2ob2obo94b3o1715bo3bo$54bob2o3b2obo42b3o4bob2ob2obo95bo1716bo3bo$55b2o5b2o42bo1832bo7b2ob2o$56bo5bo43b2o8b2ob2o136b2o1677bobo9bobo$117bobo136b3o1689bobo$117bobo136b2obo1689bo$57b2ob2o56bo138b3o1711b2o$58bobo197bo1712b2o$58bobo48bo1851bo$58bobo32bo13b3o187b2o1660bo2bo$57b2ob2o30b3o11bo189b3o1648b2o10b5o8b2o$58bobo30b2obo11b2o188b2obo1647b2o10b3ob2o7b2o$58bobo30b3o203b3o1660b2obo$59bo31b3o204bo1662b2o$92b2o$101bo235b2o1612b2o8b2o$100b3o6bo226b3o1609bob3o7b2obo$99b2obo4b3o226b2ob2o1607bo2bobo5b3ob2o7b2o$99b3o4bo230b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o18b3obo6b5o8b2o$100b2o4b2o230bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o14b2ob2obobo5bo2bo$218b2o119b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o6b3o4bo2bob5o7bo$218b3o119b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o8bo2bo3bo2bob2ob2o17b2o$217bob2o120b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o30bo7b2o3b2o19b2o$217b3o1717bo3bo5b2o$109bo108bo1718bo3bo6bo$107b3o1827bo$106bo151b2o1678bobo$106b2o150b3o1684b2o5b2o$257bob2o$257b3o1684bo9bo$258bo1685bo3bobo3bo$1944bo3bobo3bo$109bo12bo175b2o1645bobo3bobo$107b3o11bobo174b3o1645bo5bo$106bo14bobo173bob2o$106b2o12b2ob2o172b3o$298bo4$109bo$107b3o$106bo1840b2ob2o$106b2o109b2o1718b3o8bobo$216b3o1717bo2bo8bobo$216b2obo1719bo9bo$118b2o5b2o90b3o1715bo3bo31b2o$117bo2bo3bo2bo90bo1716bo3bo31b2o$109bo10b2ob2o1814bo$107b3o9bobobobo131b2o1677bobo16bo3b2o$106bo12bobobobo130b3o1688b2o4b2obob3o11b2o$106b2o9bo9bo128b2obo1687b2o4bo4b3o11b2o$116bo11bo128b3o1693bo3bo$258bo1695b3o$120b2ob2o$118bo2bobo2bo170b2o1655b3o$109bo8b3o3b3o169b3o1654bo3bo$107b3o186b2ob2o1652bo4b3o11b2o$106bo190b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17b2obob3o11b2o$106b2o10b2o178bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o18bo3b2o$118b2o179b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o$300b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o36b2o$301b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o58b2o2$109bo1836bo5bo$107b3o1835b3o3b3o$106bo111b2o1717b3o4b2o2bobo2b2o$106b2o110b3o1716bo2bo3bo3bobo3bo$217bob2o1716bo6bob2o3b2obo$217b3o1717bo3bo2b2o7b2o$218bo1718bo3bo$1937bo$109bo148b2o1678bobo$107b3o148b3o$106bo150bob2o$70b2o34b2o149b3o$70b2o186bo2$2003bo24b2o$46b2o14b2o7b2o1929bobo23bo$46b2o15b2o6b2o1929bobo8bo12bobo9bo$59b5o1937b2ob2o7b3o10b2o9bobo$59b4o1884b2ob2o50bobo11bo6bo13bobo$1948bobo51bobo10b2o6b2o11b2ob2o$49b2o8b4o1885bobo49bobobobo15bobo$48bobob2o5b5o1885bo51b2ob2o$47b2o3b2o9b2o6b2o1898b2o$48bobob2o8b2o7b2o1898b2o48bo$49b2o58bo1851b2o57b2o13bo5bo$107b3o107b2o1718b3o20bo38b3o3b3o12bobo11b3o3b3o$70b2o34bo109b3o1717bo2bo7b2o10bo2b2o8b2o24bo9bo24bo2b2ob2o2bo$70b2o34b2o108b2obo1719bo7b2o10bo2bo9b2o24bo3bobo3bo24b3o5b3o$12b2o5bo197b3o1715bo3bo19bobo37b3o3b3o$12b2o4bobo197bo1716bo3bo20b2o38bo5bo$17bo3bo1917bo71b2o$17bo3bo235b2o1677bobo21b2o50b2o$16b3ob3o86bo146b3o1700bobo49bo$17bo3bo85b3o146b2ob2o1698bo2bo9b2o$17b2ob2o84bo16bo133b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o17bo2b2o8b2o$18bobo85b2o14bobo28bo104bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o17bo71b2o$19bo102bobo21b2o4bobo104b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2o68b2o$93bo27b2ob2o20bo5bobo105b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o30b2o60bo$92b3o49bobo4b2ob2o105b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o28bobo21b2o$91b2obo36b2o11b2o1799bo5bo$91b3o15bo22bo18b2ob2o1789bo$14bo3bo72b3o13b3o22bobo1811b2o3bo$14bo3bo73b2o12bo26b2o16b2ob2o$101bo4b2o$100b3o$11b2obo3bob2o77b2obo33b2o$12b3o3b3o78b3o33bobo11bo7bo1787b3o3b3o$13bo5bo80b2o35bo1807b3o3b3o$109bo9b2o5b2o19b3o7b3o58b2o1717b3o4bob2o3b2obo47b3o3b3o$107b3o8bo2bo3bo2bo19b2ob2ob2ob2o59b3o1716bo2bo3bob2o3b2obo47bo2bobo2bo$106bo12bo2bobo2bo15b2o4b3o3b3o59bob2o1716bo7b2o5b2o48b2obobob2o$106b2o14bobo18bobo4bo5bo60b3o1717bo3bo4bo5bo49b2o5b2o$120b3ob3o16bo74bo1718bo3bo$118b3o5b3o1808bo92b2obo3bob2o$118b2o7b2o1809bobo6b2ob2o78bo2bo3bo2bo$12b2o5b2o97b2o7b2o1819bobo53bo3bo22b3o3b3o$12b2o5b2o88bo9bob2ob2obo1820bobo53b2ob2o$107b3o9b3o3b3o1820bobo52bobobobo$106bo13bo5bo1820b2ob2o53bobo$106b2o14b3o3b3o1817bobo53b2ob2o$29b2o90bo2bo3bo2bo1816bobo54bobo$29b2o94bobo1821bo55bobo25b2ob2o$121b2o7b2o1839b2o33bo27bobo$121b2o7b2o1839b2o61bobo$5b2o14b3o6b2o77bo14bo3bo1834bo71bo$5b2o12bo3bo6b2o75b3o14b2ob2o1834bo2b2o$18bo4bo82bo15b3o3b3o1816b2o13bo5bo3b2o$18bo3bo83b2o14b2o5b2o16bo5bo1793b2o14bobo2b2o2b2o$122bo7bo15bobo3bobo1808bo3b2o$8b3o7bo3bo122bo3bobo3bo1809b3o$6b2obob2o5bo4bo121bo3bobo3bo$6b2o5bo5bo3bo6b2o113bo9bo61b2o1718b3o25b3o$6b2obob2o8b3o6b2o77bo106b3o1717bo2bo23bo3b2o$8b3o96b3o36b2o5b2o61b2ob2o1718bo23bobo2b2o2b2o$106bo110b3obo22b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o33bo3bo22bo5bo3b2o$29b2o75b2o110bob2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o11bo3bo4bo3b3o12bo2b2o$29b2o117b2ob2o66b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o18b2ob2o13bo2bo2bo2b2o13bo$149bobo68b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o19b2o21b4o10bobo4b2o3b2o21b2o$148b2ob2o68b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o44b2o18bo3bobo21b2o$124b2ob2o20bobo1795bobo$109bo15bobo20b2ob2o1795bo$107b3o15bobo21bobo$106bo19bo22bobo122b3o1642b2o5b2o$106b2o42bo121bo4bo11b2o1624b2o2b2o5b2o2b2o$272bo5bo10b2o1624b2o13b2o$265bobobo7bo$165b2o96b7o5b2o1643bo5bo$164b5o93bo1656b3o3b3o$109bo38b2o14bo4bo5b2o86b7o5b2o1641bo2b2ob2o2bo$107b3o38b2o14b3o2bo5b2o88bobobo7bo1640bo3bobo3bo16bo7bo$106bo58bo2b2o102bo5bo1641bobobobo17b4o3b4o$106b2o58b2o104bo4bo1337bo328bo3bobo3bo$150bo3bo119b3o1337bo2bo299b2ob2o3b2ob2o15bo2bobo2bo$148b2obobob2o9b2o1445b5o10b2o289bo7bo17b3o3b3o$147bob2o3b2obo7bo2b2o76b4o1362b2ob3o10b2o307b3o$146bo2bo5bo2bo5b3o2bo5b2o68b2o2bo1363bob2o320bo2bo$109bo37bob2o3b2obo6bo4bo5b2o67b2o2bo1365b2o72b2o5b2o240bo$107b3o38b2obobob2o7b5o71bo4bo2bo25b2o1408b2o3bo5bo3b2o236bo3bo$106bo43bo3bo10b2o71b3o5b2o25b2ob2o1336b2o68bo15bo225bo10bo3bo5b2ob2o$106b2o129bo36bo2bo1335bob2o68bo13bo225b3o9bo10bobo$238b3o5b2o26bo2bo4bo1318b2o9b2ob3o10b2o294bo3bo9bobo7bobo$240bo4bo2bo26b2o5b3o1316b2o10b5o10b2o293bo5bo19bo$244b2o2bo36bo1328bo2bo210b2o7b4o82bo5bo$245b2o2bo25b2o5b3o1330bo211bo2bo6bo3bo82bo3bo$109bo136b4o7bo16bo2bo4bo1543b2o2bo10bo$107b3o145b2o17bo2bo1410b2o5b2o119bo10bo2bo4bob2obo83bo3bo$106bo25b2o122b2o15b2ob2o1410b2obobob2o117b3o11bo6b3o85bo5bo$106b2o23bo2bo139b2o1336b2o74bo2bobo2bo116bo105b2o2bo5bo$131bobo2bo1475b2o74b3o3b3o117b3o11bo6b3o81b2o3bo3bo$132bo1683bo10bo2bo4bob2o86b3o$133b2obo78b2o1404b2o203b2o2bo8bo86bo$135bo79b2o1394b2o7bo2b2o11b2o189bo2bo6b2o$109bo1486b2o5b2o6b2o6b6o11b2o190b2o7bo$107b3o118b4o1360b2o2b2o5b2o2b2o12b4o77b2o89bo$106bo27b2o78b2o12bo2b2o1359b2o13b2o93b2o84bo3bo$106b2o26b2o4b3o71b2o13bo2b2o1052b2o424bo60b2o12bo8b2o2b2o$140b3o86bo2bo1053bobo423b2o59b2o12bo2b2o5bo2b2o$139bo3bo86b2o571bo318bo134bobo28bo256bo75b4o76b2o7bob3o11b2o60b2o5bobo129b2o8b3o$139b2ob2o575b2o81b2ob2o314b4o9bo123bo29b2o254bobo64b2o6b6o76b2o11b2o10b2o61b3o3b2o130b2o7bo2bo$139bo3bo86b2o15b2ob2o466b5o11b2o54b2o10b2o2bo3b2o217b2o82b2o4b2o3bo9bo2b2o110b2o13b2o278bobo64b2o7bo2b2o88b2o224bo$109bo30bobo86bo2bo12bobo3bo466bo4bo11bo53bo2bo11bob2o3bo217bo7b3o5b4o64bo5b2o12bo5bo108b2ob2o12bo277b2ob2o73b2o90bo75b3o3b2o93b2o5b2o19b2o15bo3bo$107b3o30bobo71b2o13bo2b2o5b2o3bobo3bo467b3o2bo10bo49bo4bo2b2o9bo2bo3bo219bo6bo7b2obo65bo4b3o12bobo2b2o108bo2bo11bo430b2o64b2o25b2o5bobo88b2o2b2o5b2o2b2o16b2o14bo3bo$106bo34bo72b2o12bo2b2o6b2o3bo4bo455bo13bo2b2o11b3o43bo3bo3bo2bo11b2o5b3o213b3o7b2obo7bo10bo51b3o20bo3b2o3bo91bo13bo2bo4b2o6b3o328b3o3b3o7b2o81b2o16bo48bo24bo2b2o5bo2b2o84b2o13b2o15bo20bo$106b2o120b4o11b2o5b3o450b3o14b2o15bo41b7o5bo12bo8bo213bo11b2o5b2o11b3o49bo24b3o4b3o87b3o14b2o15bo327bo3bobo3bo6b2o99b2o47bobo22bo8b2o2b2o120bo5bo7bobo$252bo449bo75bo283bo83bo85bo361bo3b2ob2o3bo94b2o11b2o47b2o23bo3bo128b3o3b3o$215b2o486b3o14b2o57b7o5bo34b2o14b2o9b2o184b2o5b2o11b3o74b3o4b3o87b3o14b2o342bob2o5b2obo94b2o7bob3o78bo127bo2bobo2bo$215b2o376b2o3bo106bo13bo2b2o57bo3bo3bo2bo33b2o15b2o8b2o184b2o7bo10bo74bo3b2o3bo91bo13bo2bo343bo7bo107b2o209b2ob2o$68b2o66b2ob2o452b3obob2o4b2o111b3o2bo60bo4bo2b2o45b5o201b2obo85bobo2b2o108bo2bo459bo$69bo39bo25bo5bo451b3o4bo4b2o111bo4bo65bo2bo46b4o202b4o84bo5bo108b2ob2o449b2o$69bob2o20bo13b3o410b2o5b2o52bo14bo3bo117b5o4b2obo59b2o11b2obo227bo83bob2o12bo2b2o110b2o6b2obo441b2o$70bobo19b3o11bo27bo7bo377b2o5b2o50b3o15b3o119b2o6b2ob3o70b2ob3o20b2o8b4o189b6o78b3ob2o12bo122b2ob3o658bo7bo$60bo30b2obo11b2o26bo2bobo2bo435bo154bo75bo18bobob2o5b5o187bo4bo78bo147bo643bo14bobobobo$59bobo29b3o40b3o3b3o436b3o15b3o127b2ob3o70b2ob3o18b2o3b2o9b2o8b2o177b3ob2o78b3ob2o135b2ob3o333b3o291b2o5b2o8b2o13bobobobo$59bobo29b3o487bo14bo3bo124bo2bobo70bo2bobo21bobob2o8b2o9b2o179bobo2bo78bobo2bo131bo2bobo279b3o5b3o45bobo290bo2bo3bo2bo6bobo12bob2ob2obo$58b2ob2o29b2o499b3o4bo124b2o74b2o26b2o207b2o82b2o131b2o282b2ob2o3b2ob2o43bo3bo290bo2bobo2bo15bo6b2o5b2o$101bo491b3obob2o938b2obobobobob2o43bo3bo293bobo17bobo37b2o5b2o$58b2ob2o7b3o27b3o6bo483b2o3bo941bo3bobo3bo211b2o127b3ob3o15bobo33b2o3bo5bo3b2o$59bob2o6bo2bo26b2obo4b3o1430bo2bo3bo2bo45b3o4b2o156bobo125b3o5b3o12b2ob2o32bo15bo$57bo13b2o26b3o4bo1434b3o3b3o53b2o155b3o6bo119b2o7b2o50bo13bo$57b2o9bo3bo27b2o4b2o1652b2ob3ob2ob2o81b2o26bo3bo3b2o7b2o$68bo2b2o1688b5ob2ob2o81bo2bo11b4o8bobobobo3bob2ob2obo38b3o$70bob2o60b2o5b2o1620bo5bo76b3o10b2o6b2o2bo6b2o2bobo2bob4o3b3o38bo2bo$134b2o5b2o1621b2ob2o76bo3bobo7b2o5b2o2bo7b2o7b2o2bo5bo39bo$1845bo3bobo3b2o10bo2bo7b2o2bobo2b2o21b3o3b3o18bo3bo$109bo409b3o5b3o1011b2o303b2o20b2o10bobobobo22bo2bo3bo2bo17bo3bo11b2o5b2o$107b3o409b3o5b3o207bo37b2o288b2o474b2o305bo3bo28bo3bo23b2obo3bob2o3b2ob2o9bo15b2obobob2o$106bo413b2o5b2o203bo3bo28b2o7bobo187bo3bo86b2o6b2ob2o14b2o679bo5bo10bo48bo38b2o54bobo11bobo12bo2bobo2bo$106b2o414bo3bo204bo7bo25b2o6b2obo81bo104bo5bo85b2o6bo2bo15b2o678b2o5b2o9b3o44b3o37bo2bo53bobo26b3o3b3o$520bo2bobo2bo202bo2b2o5bo32b2o14bo68bo3bo34bobo2b2o58bo99bo2bo694bob2o3b2obo11bo42bo32b2o5b2o2bo15b2o37bo$519bo3bobo3bo190bo11b2o5b2obo32bo14b3o57b2o2b2o8bo18b2o12bo3bob3o4b2o43bo7b2o3bo8bo86b2o695bob2o3b2obo10b2o42b2o18b2o5b2o4b2o6b2o2bo14b2o$62b2o7b2o447bo2bobo2bo189b3o12b3o3b2ob3o48bo56b2o2bo5b2o2bo18b2o13bo6b2o3b2o41b3o9b3o9b3o782b3o3b3o5b2o54b2o34b4o72b2o$62bob2o3b2obo447b3o3b3o188bo27bo29bo14b3o61bobo5b2o11bo23b5obo46bo27bo83b2o10b3ob3o679b3o3b3o6bo54bo12bo9bo76b2o10b2o$62bo3bobo3bo36bo608b3o12b3o3b2ob3o29b2o14bo64b2o3b3o12b3o24b3o48b3o9b3o9b3o83bo2bo8bob2ob2obo693bobo50bobo12bo3bobo3bo75bobo$62b2o2bobo2b2o34b3o610bo11b2o5b2obo30b2obo17bo83bo4bobo3bobo63bo7b2o3bo8bo77b2o6bo2bo7b2o7b2o693b2o50b2o13bo3bobo3bo76bo$63b3o3b3o34bo624bo2b2o5bo32bobo17b3o58b2o3b3o12b3o7bo3bo12b3o58bo91b2o6b2ob2o7bob2ob2obo762bobo3bobo88bo$64bo5bo35b2o623bo7bo35b2o20bo56bobo5b2o11bo5bo11bo5b5obo57bo5bo95b2o9b3ob3o764bo5bo44bo44b2ob2o$527b2o203bo3bo59b2o56bo5b2o2bo15bo3bo5bo3bo3bo6b2o3b2o52bo3bo820b2o28b2o77b3o38b3o2b2obo$527b2o208bo116b2o8bo16bo11bo3bo3bob3o4b2o877b2o27bo2bo79bo14b5o17bob2ob2o$859bo3bo21bo3bo8bobo2b2o995b2o13b7o16bo2b3o$65b2ob2o788bo24bobo3bobo926bo90bo5b5ob2o15b2o22b2o$66bobo6b2o32bo1683bo26bo3bo88bo6b2o18bo2bo18bo$66bobo7bo30b3o1654b2ob2o3b2o17b2obo21bo2b2o2bo12b2o73b2o4bo22b2o3b2o16b3o$67bo5b3o30bo995b2o661bobo5bo16bo2bo22bobo7bo9bo80bo47bo$73bo32b2o994b2o661bobo5bobo13b2o2bo22b3ob2o4b2o6bobo80bo$1766bo7b2o12bo31b2o5bo6b2o93bo5bo$122bo2bo1662b2o3bo12b2o5bo6b6o2b2o98b3o3b3o$70bo54bo7b3o1669b2o4b3obo9b2o19b2o5b2o72bo2b2ob2o2bo$68b3o50bo9bo4bo1654b2o3b2o9bo3bobobo2b2obobo2bo2bo16b2o5b2o72b3o5b3o$67bo41bo11b2o8bo5bo35bo1622b2o12b3o4b3o4bobo2b3o$67b2o38b3o17bo8bo36b2o1636bo8bo2bo7bo113bo7bo$81bo24bo17b2o8b2o24b2o9bob3o1613b2ob2o2b2o14b2o7b2o121bobo5bobo$79b3o24b2o52b2o13b2o509b2o5b2o105bo7b2o979b2ob2o19bo88bo7bo36bo3bo$78bo45b2o8b2o38b2o510b2o5b2o104b2o6bo2bo1089b2ob2o3b2ob2o31bo2bo3bo2bo$78b2o47bo8bo37bo391b2o5b2o96bo71bo54bo8bo2b2o161bob2o822b2o8b2o134bobo3bobo$64b3o54b2o8bo5bo10b2o412b2o2b2o5b2o2b2o91bobo69b2o55b2obo4bo2bo10bo150bo2b2o2b3o113b3o3b3o695bo10bo92bobobobo37b2ob2o$63bo2b2o53bo9bo4bo11b2o24bo387b2o13b2o90bo3bo3b2o62b2o57b3o6bo11b3o148bo6b2o113bo3bobo3bo695b3o4b3o91bo3bobo3bo32b2ob2ob2ob2o56bo$62bo3b2o57bo7b3o38b2o493b5o3b2o56bo6b2o2b2o9bo66bo34b2o109b4o3b3o12bo100bo3b2ob2o3bo696bo4bo93bo2b2ob2o2bo32b2o2bobo2b2o55bobo$63b3o56bo2bo34b2o13b2o10b2o479bobobobo58b3o21b3o40b3o6bo11b3o35bo108b3o3bo3bo13b3o98bob2o5b2obo682b2o30b2o80b3o3b3o34b3o3b3o56bobo$63b2o95b2o9bob3o11b2o480bo3bo58bo27bo36bob2obo4bo2bo10bo38b3o70bo33bo27bo99bo7bo684bo32bo81bo5bo36bo5bo58bo$66bo106b2o558b3o21b3o36bo10bo2b2o50bo70b3o32b3o3bo3bo13b3o794b3o26b3o$64b2o107bo495bo3bo61bo6b2o2b2o9bo38bo3bo6bo2bo125bo33b4o3b3o12bo798bo26bo79b2o13b2o9b2o13b2o$64b2o390b2o210bobobobo66b2o54b4o7b2o125b2o35bo6b2o917b2o2b2o5b2o2b2o9b2o2b2o5b2o2b2o$53b2o5b2o2b2o389bo2bo136b2o72b5o68b2o228bo2b2o2b3o584b2o90b2o242b2o5b2o17b2o5b2o8b2o5b2o$52bobo9b2o8b2o247b2o130bobobo10b2o2bobo90bo5bo21b2o72bo3bo69bo229bob2o589b2o81b2o7b2o79b2o204b2o5b2o$52bo6b3o12b2o247b2o131bo2bo3b2o4b3obo3bo12b2o74b3o3b3o95bobo13b3o3b3o954b2o88b2o$51b2o8b4o395bo2b2o3b2o6bo13b2o73b2ob2ob2ob2o95bo14b3o3b3o891b3o53b3o25bobo2b2o$63b3o391bobo9bob5o88b3o7b3o108bob2o3b2obo869b2o6b3o8b2obob2o50bo3bo11b2o10bo3bob3o$63bob2o403b3o212bob2o3b2obo869b2o6bo3bo5bo5b2o50b2ob2o11b2o11bo6b2o54bo5bo$62b2o2bo499bo7bo111b2o5b2o878bo4bo5b2obob2o80b5obo54b3o3b3o$62b2ob2o403b3o214bo5bo401b2o5b2o470bo3bo7b3o52b2ob2o28b3o55bob2ob2obo$63bobo403bob5o619b2o5b2o539bo87b2o7b2o$64bo403b2o6bo13b2o103b3o3b3o65b3o5b3o894bo3bo95b3o54b2o7b2o$469b3obo3bo12b2o102bo2bo3bo2bo63b2ob2o3b2ob2o892bo4bo92b5obo53b3o5b3o$57b2o411b2o2bobo90bo26b2obo3bob2o63b2obobobobob2o7b2ob2o872b2o6bo3bo12b2o65b2o11bo6b2o3b2o49b3ob3o$56bobo507b3o100bo3bobo3bo7bo5bo871b2o6b3o14b2o50bo7bo6b2o10bo3bob3o4b2o51bobo$56bo508bo2bo66b2o32bo2bo3bo2bo5b5ob2ob2o945bo2bo3bo2bo18bobo2b2o55bo2bobo2bo$55b2o301b2o205bobobo65bo2bobo29b3o3b3o5b2ob3ob2ob2o949bobo83bo2bo3bo2bo$6b2o53b2o36bo6b2o215b3o3b3o22bobo2bo206b3o68b2ob3o41b3o6bo872b2o77bobo10b2o72b2o5b2o$6b2o2b2o50bo37b2o4b2o215bo2bobo2bo20b3ob2o79b2o128bo5b2o68bo41bobo878b2o77bobo10b2o$10b2o47b3o37b2o222b2obobob2o19bo84bo2bo133b2o62b2ob3o43b2o263b4o5b6o675bo2bo3bo2bo$59bo263b2o5b2o20b4o80bo7bo179bo3bo8b2obo31b2ob2o219b6o5b4o40bob2o7b4o676b3o3b3o$108bo245bob2o13bo64bo2bo3bobo177bo5bo43bobo220b4o7b2obo40bo7bob2o$10b2o54b2o39bobo261b2o63b2ob2ob2ob2o182bo43bobo84b2o46b2o89b2obo7bo41b2o5b2o$10b2o26b2o25bobo15b2o23bo263b2o66bobo172bo8bo3b2o44bo84bo2bo44bo2bo90b2o5b2o$38b2o24b2obo15b2o24b3o63b2o190b2o2b2o6bo42b2o15b2ob2o169b3o9b3o132b2o46b2o142b2o5b2o$59bo5b2o44bo63b2o148b2ob2o28bobo18b3o40b2o70bo117bo288b2o5b2o41bo7bob2o1049b2o$28b3o26b3o6bo256bo2bobo2bo26bobo21bo3bo98b2o5b3o118b3o9b3o19bo251b2obo7bo26b2o12bob2o7b4o1046b2o$27bo4bo6b2o15bo112bo5bo147bobo3bobo15bo10b2o19b3o4b3o5b2o11b4o53b3o14b2o3bo4bo83b2o20b2ob2o13bo8bo3b2o7bo7b3o248b4o7b2obo12b2o12b2o12b4o5b6o672b2o13b2o73b2o13b2o$26bo5bo6b2o16b3o6bo15b2o84b3o3b3o146b3o3b3o15b3o9bo7b2o2b2o6bo9bo4bo3b2o6b2o2bo12b2o39bo3bo12b2o3bobo3bo82bo22bobo28bo4bo2bob2o3bo251b6o5b4o12b2o713b2o2b2o5b2o2b2o73b2o2b2o5b2o2b2o253b2o$27bo31bo5b2o15b2o20b2o62bo2bobo2bo146b2o5b2o18bo5b2obobo10b2o14bo3bobo3b2o5b2o2bo13b2o12b3o3b3o11bo6bo4bo17bobo3bo82bo21bobo22bo5bo10bo4bo996b2o5b2o81b2o5b2o247b2o7bobo13b2o$28b2o34b2obo35b2ob2o62b2ob2o148b2o5b2o17bo11bo9b2o14bo3bobo12bo2bo26bo9bo8b3o7bo3bo18bo3b2o81b2o22bo24bo3bo10bo4b2o1342b2o6b2obo13b2o$65bobo18b3o15b4o215b2o5b2o17b2o6bo2bo10bo15b2ob2o15b2o27bo3bobo3bo7bo1542b2o$28b2o36b2o18bobo16b2o252b2o76b3o3b3o9b3o7bo3bo7b3o155b5o1358bo$27bo58bobo318b2o29bo5bo12bo6bo4bo5b2obob2o154b4o1341bo$14b2o10bo5bo6b2o46bobo78bo7bo229bo2bo54bo3bo5bo5b2o156bo1341b3o15bo$14b2o11bo4bo6b2o48bo79bobobobo229b2o2bo13b2o39b3o8b2obob2o45b5o1448b2obo13b2o$28b3o90bo47bobobobo230b2o2bo12b2o52b3o46bo4bo1464b2obo13b2o$121b3o44bob2ob2obo230b4o120bo1465bobo13b2o$38b2o48bo35bo43b2o5b2o317bo31bo3bo1467b2o$38b2o48bo34b2o20b2o47b2o226b2o69b2o33bo$110bo35bo46bobo226b2o69bobo1516b2o$110b3o33bobo44bo30b2o852bo933b2o$113bo33b2o43b2o30b2o226b2o5b2o605b2o5b6o8b4o293b2o5b2o439b2o5b2o105b2o6b2o7b2o$112b2o102b2o4bo13bo3b3o55b2o63b2o74b2ob2o4b2obobo5bobob2o45b2o554bo6bobobo9bo2b2o288b2o2b2o5b2o2b2o431b2o2b2o5b2o2b2o101bo7b2o6bo2b2o$216bo3b3o12bobo2b5o53bo7b3o5b4o35b2o6b2ob2o15b2o57bobo5b2ob2o7b2ob2o44b2o33bobo2b2o19b2o495bo5bo4bo9bo2b2o287b2o13b2o431b2o13b2o102bo5bo2bo4b6o18bo5bo$217bo3bobo11bo3b2o58bo6bo7b2obo35b2o6bo2bo17b2o34b2o5b2o13bobo7b6ob6o47b5o9bo18bo3bob3o19bo492b3o7bo13bo2bo4bo847b3o7b2obo5b4o9bo7b3o3b3o$214b3o5b2o12bo2bo3b2obo49b3o7b2obo7bo10bo32bo2bo16bo7b4o21b2o2b2o5b2o2b2o10bo10bob2ob2obo34b3o13b4o9b3o17bo6b2o15b3o493bo11b2o11b2o5b3o845bo9b2obo18b3o4b2o2bobo2b2o$79b2o7b2o11bo24bo87bo22b3o3b2ob3o47bo11b2o5b2o11b3o31b2o25bo2b2o20b2o13b2o62bo3bo29bo4bo12b5obo16bo530bo855bo23bo3bo3bobo3bo$79bob2o3b2obo10b3o22b3o121bo81bo58bo2b2o55bo11bo19bo9bo4bo13b4o9b3o3b3o15b3o538b2o5b3o285b3o3b3o563b2o18b3o4bob2o3b2obo$79bo3bobo3bo9b2obo21b2o2bo41b2ob2o62b3o3b2ob3o59b2o5b2o11b3o31b2o26bo2bo4bo52bo9bo18b3o9bo3bo13b5o9bo4bo558bo2bo4bo287bo2bobo2bo563b2o5b4o9bo6b2o7b2o$79b2o2bobo2b2o9b3o21b2o3b2o11b2o28bobo62bo2bo3b2obo61b2o7bo10bo32bo2bo26b2o5b3o52bobobobo19bo29b2o19b3o15b3o537bo2b2o290bo3bobo3bo567b6o$10b2o68b3o3b3o11b2o19bobo2bobo13bo10b3o8b2o5bobo61bo3b2o73b2obo35b2o6bo2bo36bo51bobobobo20b3o9bo3bo13b2o20bo12b5obo535bo2b2o291b4o3b4o568bo2b2o$10b2o69bo5bo33b2o3b2o9b2o3bobo7bo2bo4bo3b2o6bo62bobo2b5o69b4o35b2o6b2ob2o25b2o5b3o53b2ob2o23bo9bo4bo46bo6b2o3b2o513bob2o12b4o293bo7bo558bob2o8b2o$116b2o19bobo3b2o6bo3bo3bobo59bob2o11bo3b3o60bo59b2o25bo2bo4bo52bo2bo3bo2bo31bo3bo45bo3bob3o4b2o511b3ob2o874b3ob2o$6b2o6b2o100b2o21bo11bo7bobo57b3ob2o76b6o83bo2b2o23bo7bo25b2o5b2o34b3o46bobo2b2o517bo763bo7bo107bo$6b2o2b2o2bo61b2o13b2o46b2o13bo63bo81bo4bo83bo2b2o675b3ob2o756bobo5bobo107b3ob2o$10b2o3b3o58b2o2b2o5b2o2b2o58b2obo64b3ob2o76b3ob2o82b4o23b3o7b3o642bobo2bo757bo3bo112bobo2bo$18bo61b2o5b2o132bobo2bo32bo43bobo2bo108b2ob2ob2ob2o647b2o754bo2bo3bo2bo113b2o$17bo154b2o51b2o31b2o47b2o109b3o3b3o1405bobo3bobo$16bo137bob2o14bobo82b2o160bo5bo959bo448b2ob2o$15bo138b3o17bo83b2o2b2o9bo1110b3o444b2ob2ob2ob2o$14bo76bo63bo18b2o68b3o26b3o21bo1085bo3bo443b2o2bobo2b2o138b2o13b2o$13bo77bo2b2o72b2o23b2o9b3ob3o31bo3bo29bo16b2o2bo1085b2ob2o444b3o3b3o139b2o2b2o5b2o2b2o$12bo77bo5bo36b2o33bo22b2ob2o7bob2ob2obo19bo9bo4bo26b3o16bo5bo1084b2ob2o445bo5bo144b2o5b2o$11bo79bobo2b2o35bobo33b3o19bo2bo7b2o7b2o16b3o9bo3bo12b2o2b2o9bo17b2o2bobo$12b3o63bo12bo3b2o38bo35bo14bo4bo2bo8bob2ob2obo16bo28b2o33b2o3bo12bo1072b2ob2o$15bo60b3o14b3o39b2o20b2o25b3o5b2o10b3ob3o18b3o9bo3bo12b2o33b3o14b3o1070b2ob2o$14bo60bo41b2o10b2o26bo25bo47bo9bo4bo12bo53bo138b2o632b2o295bo3bo3b2o439b2o$13bo62b3o14b3o20bo2bo9bo28b3o23b3o5b2o48bo3bo46b3o14b3o107b2ob2o27b2o631bo2bo295b3o4b2o439b2o$12bo65bo12bo3b2o20b2o11b3o27bo25bo4bo2bo49b3o45b2o3bo12bo110bobo662b2o297bo660b2o$11bo79bobo2b2o4b2o28bo58bo2bo15b2o59bo13b2o4b2o2bobo123bobo1622b2o$12b3o75bo5bo5b2o87b2ob2o14b2o57b3o13b2o5bo5bo123bo1613bo$15bo75bo2b2o97b2o67bo5bo24b2o2bo1737bo2bo$14bo76bo168bobo5b2o27bo1736b5o8b2o$13bo247b2o1707b2o5b2o54b2ob3o8b2o$12bo1953b2o2b2o5b2o2b2o51bob2o$11bo1954b2o13b2o52b2o$12b3o$15bo2019b2o$14bo18b2o4b3o1992bob2o$13bo19b2o3bo3bo1822bo156b2o9b2ob3o8b2o$12bo25b2ob2o1817bo3bo157b2o10b5o8b2o$11bo27bobo1817bo8b2o2b2o161bo2bo$12b3o224bo31b2o1586bo2b2o5bo2b2o7b2o5b2o80bo7bo57bo$15bo23bobo193b2o2bo16b2o13bo1588b2o5bobo7b2o2b2o5b2o2b2o75bo2bo3bo2bo66b2o$14bo23b2ob2o191bo5bo14bobo14b3o1586b3o3b2o8b2o13b2o79bobo70b2o$13bo24bo3bo190b2o2bobo17bo16bo78b2o2b2o4bo2b2o12b2o1591bobo$12bo26b3o188bo3b2o3bo22b2o3bo85b2ob2o6b2obo12b2o1479b3o3b2o104bobo$11bo216b3o4b3o24b3obob2o87bobo6bo1493b2o5bobo99bo2bo3bo2bo$12b3o212bo34b3o4bo88b2o4b3o1478b2o12bo2b2o5bo2b2o96b3o3b3o$15bo212b3o4b3o27bo3bo2bo1572b2o12bo8b2o2b2o$14bo215bo3b2o3bo26b3o3b3o83b2o4b3o1493bo3bo$13bo219b2o2bobo35bo81bobo6bo1498bo$12bo221bo5bo25b3o3b3o78b2ob2o6b2obo$11bo223b2o2bo25bo3bo2bo80b2o2b2o4bo2b2o$12b3o224bo22b3o4bo635b2o974b2o5b2o$15bo16b3o5b3o219b3obob2o633b2o2bo972bo2bo3bo2bo109bo$5b3o6bo17bo2b2ob2o2bo219b2o3bo635b6o972bo2bobo2bo109bobo$5bo2bo4bo19b3o3b3o861b4o4bo3bo968bobo112bo2bo$5bo6bo21bo5bo870b7o964b3ob3o88b2o18bobo3bo5bo5bo5bo5bo5bo5bo5bo$5bo5bo906bo961b3o5b3o86b2o18b2o5bo3bobo3bobo3bobo3bobo3bobo3bobo3bobo$6bobo3b3o896b7o962b2o7b2o114bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo$15bo887b4o4bo3bo964b2o7b2o115bobo3bobo3bobo3bobo3bobo3bobo3bobo3bo$14bo14b2o13b2o844b2o11b6o972bob2ob2obo71b2o2b2o27b2o2b2o7bo5bo5bo5bo5bo5bo5bo3b2o$11bobo15b2o2b2o5b2o2b2o844b2o11b2o2bo973b3o3b3o71b2o2b2o27b2o2b2o$11b2o20b2o5b2o863b2o975bo5bo$1009b2o1030bo2bo$1008bobo949b2o35b2o41bo$1008bo41b2o829b2o77b2o35b2o41bo3bo$4b2o1001b2o41b2o829b2o157b4o8b2o$4b2o2046b2o2$bo2054bo$obo2052bobo$bo2054bo", null, 3, 3, 2048, 2048);
        }

        private function putOTCAMetaPixelOff3x3(x:int, y:int):void {
            parseRLE(2058, 2058, -5 + x, -5 + y, "bo2054bo$obo2052bobo$bo2054bo2$4b2o2046b2o$4b2o8b4o157b2o829b2o41b2o1001b2o$13bo3bo41b2o35b2o77b2o829b2o41bo$17bo41b2o35b2o949bobo$13bo2bo1030b2o$2016b2o5b2o20b2o$58b2o2b2o27b2o2b2o1915b2o2b2o5b2o2b2o15bobo$9b2o3bo5bo5bo5bo5bo5bo5bo7b2o2b2o27b2o2b2o1915b2o13b2o14bo$9bo3bobo3bobo3bobo3bobo3bobo3bobo3bobo1990bo$10bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo1740bo249b3o3bobo$11bobo3bobo3bobo3bobo3bobo3bobo3bobo3bo5b2o18b2o4b3o1703bo2bo251bo5bo$12bo5bo5bo5bo5bo5bo5bo5bo3bobo18b2o3bo3bo1702b5o249bo6bo$55bo2bo25b2ob2o1702b3ob2o16b2o229bo4bo2bo$56bobo26bobo1694bo9b2obo16bo230bo6b3o$57bo110b3o3b3o1603b3o10b2o16bo2b2o226bo$85bobo80b3o3b3o1602bo31bo2bo228b3o$84b2ob2o78bob2o3b2obo1602b3o10b2o16bobo10bo221bo$84bo3bo78bob2o3b2obo1604bo9b2obo16b2o10b3o189b3o3b3o20bo$85b3o80b2o5b2o1614b3ob2o30bo188bo2bobo2bo19bo$169bo5bo1615b5o16b2o10b3o189b2obobob2o18bo$184b2o8b3o14b2o1578bo2bo16bobo10bo191b2o5b2o17bo$184b2o8bo3bo12b2o1580bo17bo2bo228b3o$194bo4bo1611bo2b2o230bo$195bo3bo1612bo232bo$1777bo16bo18b2o229bo$10b2o152b2o13b2o14bo3bo7b3o1567b3o14bobo221b2ob2o20bo$10b2o152b2o2b2o5b2o2b2o13bo4bo5b2obob2o1568bo13b2o220bo2bobo2bo17bo$78b3o5b3o79b2o5b2o7b2o8bo3bo5bo5b2o1567b2o235bobo3bobo18b3o$15bo3b2o57bo2b2ob2o2bo95b2o8b3o8b2obob2o1804b3o3b3o21bo$9b2o2b2obob3o13b2o43b3o3b3o119b3o1813b2o20bo$9b2o2bo4b3o13b2o44bo5bo1936b2o19bo$13bo3bo2005b2o18bo$14b3o2025bo$28b2o3b2o2008b3o$14b3o10b3o3b3o39b2o13b2o1954bo$13bo3bo7b3o7b3o37b2o2b2o5b2o2b2o1953bo$9b2o2bo4b3o4b3o7b3o41b2o5b2o1701b2o253bo$9b2o2b2obob3o4b3o7b3o1743b2o6bobo251bo$15bo3b2o6b3o3b3o1744bobo6bo252bo$28b2o3b2o1745bo191b2o5b2o62b3o$10b2o1767b2o187b2o2b2o5b2o2b2o61bo$10b2o958b2o967b2o27b2o13b2o60bo$224b2o743bo2bo832bo3b2o127bo2bo102bo$224b2o744b2o831b2obob3o128b2o102bo$1803bo4b3o231bo$1792bobo2b2o4bo3bo14bo220b3o$1791bo3bob3o4b3o15b3o221bo$65b2o5b2o1718bo6b2o24bo219bo$61b2o2b2o5b2o2b2o1702bo12b5obo4b3o15b3o219bo$61b2o2b2o5b2o2b2o1700b3o15b3o4bo3bo14bo150bo5bo63bo$65b3o3b3o1703bo25bo4b3o161bobo3bobo61bo$64bo2bo3bo2bo1703b3o15b3o4b2obob3o160bo3bobo3bo59bo$68bobo1709bo12b5obo5bo3b2o160bo3bobo3bo58bo$64b2o7b2o26b2o115bo5bo756b2o809bo6b2o170bo9bo57bo$64b2o7b2o26bo2bobo110b3o3b3o755bo2bobo804bo3bob3o240b3o3b2o$67bo3bo31b2ob3o107b2o2bobo2b2o756b2ob3o803bobo2b2o173b2o5b2o62bo2b2o2b2o$67b2ob2o37bo105bob4ob4obo761bo1052b2o6b2o$65b3o3b3o29b2ob3o108b3o3b3o757b2ob3o1015b2o$65b2o5b2o16bo3bo8b2obo109b3o5b3o750b2obo2b2obo995bo21b2o40b2o$65bo7bo15bo5bo876b3o2b2o2bo992bo3bob2o2bo8b2o51b2o$95bo877b2o6bo997bo4bo10bo$81bo8bo3b2o865bo12b3o3b2o988b2o3bobo2bo2bob2o5b2o2bo8b2o$79b3o9b3o865b3o13bo3bo995bobo3b2o3bo6bo2bo8b2o$78bo879bo1019bob7o7bobo$79b3o9b3o19bo845b3o13bo3bo13bo976bo2bo8b3o9b2o$81bo8bo3b2o7bo7b3o847bo12b3o3b2o9b3o978b2o$95bo4bo2bob2o3bo102b2o13b2o743b2o6bo8bo992b2o9b2o$89bo5bo10bo4bo101b2o2b2o5b2o2b2o742b3o2b2o2bo9bo989bo3b2o7bobo$90bo3bo10bo4b2o105b2o5b2o751b2obo9b2o989bo4bo6bo2bo8b2o$44b2o27b2o1906bo3b2o5b2o2bo8b2o$44b2o25b2ob2o25b5o1877b2o10bo$69bo2bobo27b4o1887b2o23b2o$49bo3b2o14bo34bo1899b2o12b2o$43b2o2b2obob3o14bo4bo1929b2o29bo$43b2o2bo4b3o15bo3bo1915bo39bo3bo$47bo3bo15b2o2b3o1915bobo25b2o10bo8b2o2b2o$48b3o16b2o1920bobo25b2o10bo2b2o5bo2b2o$1988b2ob2o37b2o5bobo$48b3o1980b3o3b2o$47bo3bo$43b2o2bo4b3o13b2o150b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o31b2o5b2o78bo5bo37b3o3b2o$43b2o2b2obob3o13b2o146b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obo2bo3bo2bob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obobo5bobob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obo2bo3bo2bob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2obobo5bobob2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o23b2o2b2o5b2o2b2o73b3o3b3o35b2o5bobo$49bo3b2o161b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2obo9bob2o23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2o13b2o23b2obo9bob2o23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o23bo15bo23b2o13b2o23b2o13b2o23b2o13b2o72bo2b2ob2o2bo21b2o10bo2b2o5bo$381bo5bo151bo2bo3bo2bo147b2o4bobo4b2o589bo5bo151bo2bo3bo2bo147b2o4bobo4b2o353bo3bobo3bo21b2o10bo8b2o$44b2o175bo5bo152b3o3b3o151bob2ob2obo151bo2bobo2bo432bo5bo152b3o3b3o151bob2ob2obo151bo2bobo2bo358bobobobo36bo3bo$44b2o174b3o3b3o150b2o2bobo2b2o149b2o7b2o431bo5bo152b3o3b3o150b2o2bobo2b2o149b2o7b2o431bo5bo127bo$219bo2b2ob2o2bo149b2ob2ob2ob2o149b2o7b2o271bo5bo152b3o3b3o150bo2b2ob2o2bo149b2ob2ob2ob2o149b2o7b2o271bo5bo152b3o3b3o75b2ob2o3b2ob2o21b2o$219bo3bobo3bo152b2ob2o152b3o5b3o111bo5bo152b3o3b3o150b2o2bobo2b2o149bo3bobo3bo152b2ob2o152b3o5b3o111bo5bo152b3o3b3o150b2o2bobo2b2o76bo7bo23b2o26b2o$132b2o23b2o62bobobobo152bobo3bobo112bo5bo33b3ob3o112b3o3b3o31bo7bo110bo2b2ob2o2bo149bo3bobo3bo30b2o5b2o112bobobobo152bobo3bobo112bo5bo33b3ob3o112b3o3b3o31bo7bo110bo2b2ob2o2bo149bo3bobo3bo136b2o$133bo22bobo182bo5bo31bo2bo3bo2bo30bo7bo71b3o3b3o34bobo113b2obo3bob2o31bobobobo111b3o5b3o30b3o3b3o110bob2o3b2obo271bo5bo31bo2bo3bo2bo30bo7bo71b3o3b3o34bobo113b2obo3bob2o31bobobobo111b3o5b3o30b3o3b3o110bob2o3b2obo$133bobo82b2ob2o3b2ob2o29bo7bo71b3o3b3o33bo3bo32bo2bo3bo2bo70bob2ob2obo31bo2bobo2bo152bobobobo151bo9bo109b2o7b2o29bo9bo71bo5bo30b2ob2o3b2ob2o29bo7bo71b3o3b3o33bo3bo32bo2bo3bo2bo70bob2ob2obo31bo2bobo2bo152bobobobo151bo9bo109b2o7b2o$134b2o84bo7bo29bob2o5b2obo68b2o2bobo2b2o29bobo5bobo33bobo76b2ob2o32bo2bo3bo2bo32b2ob2o113bob2ob2obo150bo3bobo3bo70b3o3b3o70bo3bobo3bo70b3o3b3o31bo7bo29bob2o5b2obo68b2o2bobo2b2o29bobo5bobo33bobo76b2ob2o32bo2bo3bo2bo32b2ob2o113bob2ob2obo150bo3bobo3bo70b3o3b3o177b2o$147b4o8bo98bo3b2ob2o3bo67bob4ob4obo29bo7bo34bobo34bo7bo33b2ob2o33b2o5b2o32bo5bo32b2o5b2o33bo3bo33b2o5b2o71b3o3b3o71b3o3b3o71b3o3b3o70bo3bobo3bo69b2ob2ob2ob2o68bo3b2ob2o3bo67bob4ob4obo29bo7bo34bobo34bo7bo33b2ob2o33b2o5b2o32bo5bo32b2o5b2o33bo3bo33b2o5b2o71b3o3b3o71b3o3b3o71b3o3b3o177b2o2b2o$147bob2o7b2o99bo3bobo3bo29b3o5b3o30b3o3b3o74bobo34b2o5b2o33b2ob2o112bo2bo3bo2bo32bo3bo113bo2bobo2bo72bo5bo71bob2o3b2obo70bobo3bobo69b3o7b3o68bo3bobo3bo29b3o5b3o30b3o3b3o74bobo34b2o5b2o33b2ob2o112bo2bo3bo2bo32bo3bo113bo2bobo2bo72bo5bo71bob2o3b2obo180b2o$147bo112b3o3b3o30b3o5b3o29b3o5b3o69bo2bo3bo2bo30b3o3b3o111bo7bo33b2ob2o153b2obobob2o111bo7bo30bob2o3b2obo71bo5bo31b3o5b3o110b3o3b3o30b3o5b3o29b3o5b3o69bo2bo3bo2bo30b3o3b3o111bo7bo33b2ob2o153b2obobob2o111bo7bo30bob2o3b2obo$148b2o150b2o5b2o111b3o3b3o33b2ob2o113bo2bobo2bo32bobobobo111b2obo3bob2o30b2o5b2o110b4o3b4o30b2o5b2o109b2ob2o3b2ob2o29bo7bo111b2o5b2o111b3o3b3o33b2ob2o113bo2bobo2bo32bobobobo111b2obo3bob2o30b2o5b2o110b4o3b4o30b2o5b2o$302bo3bo155bo3bo113b3o3b3o32bobobobo111bo2bo3bo2bo149bo3bobo3bo31bo5bo110b2obobobobob2o151bo3bo155bo3bo113b3o3b3o32bobobobo111bo2bo3bo2bo149bo3bobo3bo31bo5bo116b2o$148b2o150bo2bobo2bo150b2o7b2o149bo9bo110b3o3b3o151bo2bobo2bo150bo3bobo3bo150bo2bobo2bo150b2o7b2o149bo9bo110b3o3b3o151bo2bobo2bo155bo14b2o$147bo151bo3bobo3bo53b2o41bo42bo9b2o7b2o17b2o78bo50bo11bo210bo58b3o3b3o150bo2bo3bo2bo149bo3bobo3bo53b2o41bo42bo9b2o7b2o17b2o78bo50bo11bo210bo58b3o3b3o154b2o15bo$118b2o2bobo22bob2o7b2o43b2o40b2o42b4o7bo2bobo2bo18b3o31b5o40b2o41bo2b2o9bobo20bo11b4o19bo3b2o38bo2bo39bobo2b2o30bo3bo29bob2o85bo3b3o67bo3bo43bo72b2o85b2o8b3o3b3o19b2o33b2o40b2o42b4o7bo2bobo2bo18b3o31b5o40b2o41bo2b2o9bobo20bo11b4o19bo3b2o38bo2bo39bobo2b2o30bo3bo29bob2o85bo3b3o67bo3bo43bo72b2o99bo2bo7b2obo$111b2o4b3obo3bo21b4o8bo41b2ob2o38bo2b2o40bo2b2o6b3o3b3o17bo4bo5b3obo18bo4bo38bob3o39bo5bo4bo2bo3bo2bo15bo2b2o7b6o16b2obob3o38b5o37bo3bob3o6b2ob2o17bo5bo5bo21bo2b2o2b3o41b2o36bobo2b5o5b2ob2o16b3o33bo7bo42b2o35b2o2bo4b2o4b2ob2o15bobo39b4o42bobo34bo2bo9b2o19b2ob2o38bo2b2o40bo2b2o6b3o3b3o17bo4bo5b3obo18bo4bo38bob3o39bo5bo4bo2bo3bo2bo15bo2b2o7b6o16b2obob3o38b5o37bo3bob3o6b2ob2o17bo5bo5bo21bo2b2o2b3o41b2o36bobo2b5o5b2ob2o16b3o33bo7bo42b2o35b2o2bo4b2o4b2ob2o15bobo100b3o7b2ob2o$111b2o3b2o6bo76bo2bo38b6o41bo2b2o30bo5bo5b2obob2o16bo2b3o42b2o39bobo2b2o4b3o3b3o16bo2bo7b2o2b3o16bo4b3o38b3ob2o37bo6b2o3bo2bobo2bo15bo33bo6b2o43b2o35bo3b2o3b2o2bo2bobo2bo14bo3bo29bo5b2o2bo43b2o34bob2o6bo3bo5bo14bo35bo5b2obo42bob2o32b2o2bo6b2ob3o18bo2bo38b6o41bo2b2o30bo5bo5b2obob2o16bo2b3o42b2o39bobo2b2o4b3o3b3o16bo2bo7b2o2b3o16bo4b3o38b3ob2o37bo6b2o3bo2bobo2bo15bo33bo6b2o43b2o35bo3b2o3b2o2bo2bobo2bo14bo3bo29bo5b2o2bo43b2o34bob2o6bo3bo5bo14bo102b3o$117bob5o72bo4bo2bo31bo3bo4b4o27bo13bo2bo22bo9bo9bob2ob3o12bo3b2o2bo31bobobo6b2o27bo12bo3b2o21bo8bobo7b3o4b2o12bo2bo3bo32bo9b2obo26bo12b5obo4b3o3b3o7bo7b2o3bo26b4o3b3o30bo9b5o25bo11bo2bo3b2o3bobo3bobo7bo6bo4bo27bob2o5b2o29bo9b2o2b2o24bo11bo6bob4ob2ob5o6bo5b3o31bo2b2o6bo28bo14b2o23bo10bo2bo4bob2obobo13bo4bo2bo31bo3bo4b4o27bo13bo2bo22bo9bo9bob2ob3o12bo3b2o2bo31bobobo6b2o27bo12bo3b2o21bo8bobo7b3o4b2o12bo2bo3bo32bo9b2obo26bo12b5obo4b3o3b3o7bo7b2o3bo26b4o3b3o30bo9b5o25bo11bo2bo3b2o3bobo3bobo7bo6bo4bo27bob2o5b2o29bo9b2o2b2o24bo11bo6bob4ob2ob5o6bo5b3o110b2ob2o$118b3o35bobo35b3o5b2o15bo14b7o33b3o14b2o21b3o10b2o7b3obobo11b3o5b2o11b3o16b3obobo6bo26b3o14b3o20b3o9b2o7b2o5b2o10b3o3b3o12bo18b3o10b2o25b3o15b3o19b3o9b3o25b3o3bo3bo10bo18b3o9b4o24b3o12b3o3bo4b3o3b3o5b3o7bo3bo25b3ob2o3b3o9bo18b3o37b3o11b3o4b2o2b2ob2ob3ob2o3b3o22bo14b6o5b2o6b2obo17b3o14bo22b3o11bo6bobo3bobo10b3o5b2o15bo14b7o33b3o14b2o21b3o10b2o7b3obobo11b3o5b2o11b3o16b3obobo6bo26b3o14b3o20b3o9b2o7b2o5b2o10b3o3b3o12bo18b3o10b2o25b3o15b3o19b3o9b3o25b3o3bo3bo10bo18b3o9b4o24b3o12b3o3bo4b3o3b3o5b3o7bo3bo25b3ob2o3b3o9bo18b3o37b3o11b3o4b2o2b2ob2ob3ob2o3b3o22bo96bobo$157b2o34bo21b5o13bo18b2o2b2o15bo39bo23b4o12bo21b6o12bo39bo39bo20b3o4b3o9bo20b2o3b2o12bo39bo39bo22b2o15bo20bob2obo13bo39bo33b2o4bo22bob2o13bo19b2o18bo39bo27bo6b3o2bo21b2o2bo13bo19b5o15bo39bo23bo3b2o10bo21b5o13bo18b2o2b2o15bo39bo23b4o12bo21b6o12bo39bo39bo20b3o4b3o9bo20b2o3b2o12bo39bo39bo22b2o15bo20bob2obo13bo39bo33b2o4bo22bob2o13bo19b2o18bo39bo27bo6b3o2bo21b2o2bo30bo65bobo$118b3o73b3o5b2o10bo2b3o7b2o5b7o26b2o5b3o14b2o14b2o5b3o10b2o5b2o3b4o4b2o5b3o5b2o10bo3b2o7b2o5b3obobo6bo19b2o5b3o14b3o13b2o5b3o9b2o13b2o4b2o5b3o3b3o11b2o3b2o6b2o5b3o10b2o18b2o5b3o15b3o12b2o5b3o9b3o6b3obo7b2o5b3o3bo3bo9bob3o8b2o5b3o9b4o17b2o5b3o12b3o3bo11b2o5b3o7bo3bo5b2o3b2o6b2o5b3ob2o3b3o7bo2b3o8b2o5b3o30b2o5b3o11b3o4b2o10bobo4b3o17bo2bo2bo6b2o5b6o5b2o5bo2b3o9b2o5b3o14bo15b2o5b3o11bo6b3o3bo5b2o5b3o5b2o10bo2b3o7b2o5b7o26b2o5b3o14b2o14b2o5b3o10b2o5b2o3b4o4b2o5b3o5b2o10bo3b2o7b2o5b3obobo6bo19b2o5b3o14b3o13b2o5b3o9b2o13b2o4b2o5b3o3b3o11b2o3b2o6b2o5b3o10b2o18b2o5b3o15b3o12b2o5b3o9b3o6b3obo7b2o5b3o3bo3bo9bob3o8b2o5b3o9b4o17b2o5b3o12b3o3bo11b2o5b3o7bo3bo5b2o3b2o6b2o5b3ob2o3b3o7bo2b3o8b2o5b3o30b2o5b3o11b3o4b2o10bobo4b3o17bo2bo2bo6b2o21b3o64bo$117bob5o14b2o56bo4bo2bo10b2o10b2o7bo3bo4b4o18b2o7bo13bo2bo13b2o7bo9bo8bob2o8b2o7bo3b2o2bo10b4o8b2o7bobobo6b2o18b2o7bo12bo3b2o12b2o7bo8bobo9b2obo6b2o7bo2bo3bo10b2o3bo7b2o7bo9b2obo17b2o7bo12b5obo11b2o7bo7b2o3bo8bob2o5b2o7b4o3b3o8b2o3bo7b2o7bo9b5o16b2o7bo11bo2bo3b2o10b2o7bo6bo4bo7bob3o6b2o7bob2o5b2o6b6o8b2o7bo9b2o2b2o15b2o7bo11bo6bobo9b2o7bo5b3o10b2o10b2o7bo2b2o6bo19b2o7bo14b2o14b2o7bo10bo2bo4bob2o8b2o7bo4bo2bo10b2o10b2o7bo3bo4b4o18b2o7bo13bo2bo13b2o7bo9bo8bob2o8b2o7bo3b2o2bo10b4o8b2o7bobobo6b2o18b2o7bo12bo3b2o12b2o7bo8bobo9b2obo6b2o7bo2bo3bo10b2o3bo7b2o7bo9b2obo17b2o7bo12b5obo11b2o7bo7b2o3bo8bob2o5b2o7b4o3b3o8b2o3bo7b2o7bo9b5o16b2o7bo11bo2bo3b2o10b2o7bo6bo4bo7bob3o6b2o7bob2o5b2o6b6o8b2o7bo9b2o2b2o15b2o7bo11bo6bobo9b2o7bo5b3o10b2o10b2o24bo51bobo$111b2o3b2o6bo8bo5bo61bo2bo38b6o41bo2b2o30bo5bo4bo2bo20bo2b3o10b2o30b2o39bobo2b2o29bo2bo5bo4b2o18bo4b3o38b3ob2o37bo6b2o27bo10bo4b2o16bo6b2o43b2o35bo3b2o3b2o25bo3bo9b2o18bo5b2o2bo7b3o33b2o34bob2o6b2o23bo35bo5b2obo42bob2o32b2o2bo8bo21bo2bo38b6o41bo2b2o30bo5bo4bo2bo20bo2b3o10b2o30b2o39bobo2b2o29bo2bo5bo4b2o18bo4b3o38b3ob2o37bo6b2o27bo10bo4b2o16bo6b2o43b2o35bo3b2o3b2o25bo3bo9b2o18bo5b2o2bo7b3o33b2o34bob2o6b2o23bo49b2o51b2obo$111b2o4b3obo3bo7bo4bo4b2o56b2ob2o38bo2b2o40bo2b2o32bo4bo4bo2bo20bo4bo38bob3o39bo5bo30bo2b2o5b2o2bo19b2obob3o38b5o37bo3bob3o28bo5bo8b2o17bo2b2o2b3o41b2o36bobo2b5o26b3o12bobo18bo7bo42b2o35b2o2bo4b2o24bobo39b4o42bobo34bo2bo6b2o22b2ob2o38bo2b2o40bo2b2o32bo4bo4bo2bo20bo4bo38bob3o39bo5bo30bo2b2o5b2o2bo19b2obob3o38b5o37bo3bob3o28bo5bo8b2o17bo2b2o2b3o41b2o36bobo2b5o26b3o12bobo18bo7bo42b2o35b2o2bo4b2o24bobo103bo$118b2o2bobo12b3o3b2o58b2o40b2o42b4o34b3o7b2o22b5o40b2o41bo2b2o32bo10b2o22bo3b2o38bo2bo39bobo2b2o30bo3bo5bo2b2o19bob2o85bo3b3o42b2obo21bo3bo43bo72b2o12bobo70b2o36b2o7bo25b2o40b2o42b4o34b3o7b2o22b5o40b2o41bo2b2o32bo10b2o22bo3b2o38bo2bo39bobo2b2o30bo3bo5bo2b2o19bob2o85bo3b3o42b2obo21bo3bo43bo72b2o12bobo88b2o$134bob2ob2o77bo144b2o41bo42bo37b2o78bo89bo160bo22bo135bobo158bo144b2o41bo42bo37b2o78bo89bo160bo22bo135bobo$136bo81bo759bo159bo759bo$46bo86bo2b3o11b2o$45bobo65b2o18b2o2b2o9bo4bo$45bobo65b2o20bo2bo15bo$46bo88b3o10bo5bo$127b2o20b6o$112b2o13bobo$112b2o13bob2o$128b2o$128bo13b2o1802b2o$141bobo1802bobo$128bo13bo67b2o1736bo$128b2o80b2o1736b2o$112b2o13bob2o29b2o2bo4b2o16b2o3b2o8bo$112b2o13bobo30bob2o6b2o14bo2bobo2bo7bo2b2o$127b2o20bo11bo6bobo14bo9bo5bo5bo3b2o$147b3o11b3o4b2o14b2o9b2o5bobo2b2o2b2o$113b2o31bo38bo9bo6bo3b2o$113b2o32b3o11b3o4b2o16bo2bobo2bo9b3o$149bo11bo6bobo16b2o3b2o$135bo24bob2o6b2o32b3o$134b3o23b2o2bo4b2o31bo3b2o$134bob2o35bo12b2o14bobo2b2o2b2o$135b3o11b2o22b2o11b2o13bo5bo3b2o$135b3o11bobo20bobo27bo2b2o$131b3ob3o13bo50bo$135b3o11b3o5bo52b2o$135b2o20b3o50b2o$113b2o45bo$113b2o19bo22b3o$122bo10bo15b3o5bo1813b2o$118b2o2bo10bo17bo1819b2o$112b2o3bo5bo25bobo$112b2o2b2o2bobo12bo13b2o1812b4o$117b2o3bo38b2o1784b2o14bo2b2o4b2o$118b3o41b2o1783b2o15bo2b2o3b2o$161bo1802bo2bo$118b3o1844b2o$117b2o3bo$112b2o2b2o2bobo1842b2o$112b2o3bo5bo48b2o1790bo2bo$118b2o2bo13b2o34b2o1790bo2b2o3b2o$122bo13bobo1809bo14bo2b2o4b2o$113b2o23bo16b3o3bo1781b2o4b2o12b4o$113b2o23b2o13b5o2bobo10b2o1767bo$152b2o3b2o3bo10b2o1768b2o3bo22b2o$153b2o3bo2bo1785bobo21b2o$154bo3b3o1786bobo$1948bo$154bo3b3o1866b2o$153b2o3bo2bo1865b2o$152b2o3b2o3bo10b2o1873bo$153b5o2bobo10b2o1859b2o9b2o3bo$153bob3o3bo1864b2o5bobo9b2obob2o$151b2o1873b2o5bo10bo6b2o$145b2o4b3o18b2o1859b3o9b2obob2o$145b2o3bo3bo17b2o1871b2o3bo$149bo5bo1892bo$150b2ob2o1789b2obo3bob2o$1944bo2bo3bo2bo78b3o$150b2ob2o1790b3o3b3o72b2o5bo17b2o$149bo5bo1870b2o5bobo15b2o$150bo3bo1879b2o$151b3o$151b3o1873b2o$2027b2o$1947b2ob2o$1948bobo$1948bobo$1949bo75b2o5b2o$1971b2o52b2o5b2o$144b2o7b2o1816b2o$144bob2o3b2obo1794b2o$144bo3bobo3bo1793b4o7b2o$144b2o2bobo2b2o1792bobobo6bo2b2o9b2o$145b3o3b3o1793b2ob3o4b6o9b2o$146bo5bo1797b2obo5b4o$1950b2obo2$1950b2obo$1950b2obo5b4o$1949bo2bo4b6o9b2o$145b2o5b2o1796b2o6bo2b2o9b2o$145b2o5b2o1796b2o7b2o$1946bo4bo$1945b3o3b3o17b2o51b3o5b3o$151bo2bo1790bo2bobo2bo17b2o50b2ob2o3b2ob2o$141b3o7bo1795b2ob2o71b2obobobobob2o$127b2o11bo4bo9bo1868bo3bobo3bo$127b2o10bo5bo8b2o1868bo2bo3bo2bo$140bo8bo1875b3o3b3o$141b2o8b2o1792bo7bo$1946bobobobo$141b2o8b2o1793bobobobo$140bo8bo3bo1791bob2ob2obo$127b2o10bo5bo4bo2bo1791b2o5b2o$127b2o11bo4bo4bo2bo1878b2o$141b3o7b2o1879b2o$1986b2o$1986b2o2$190b2o1801b2o9b2o3b2o$189bo2bo1792b2o5bobo8bob2ob2obo$184bo7bo1792b2o4b2obo8bo7bo$183bobo3bo2bo1799b2o9bob2ob2obo$133bo48b2ob2ob2ob2o1800bo10b2o3b2o$131b3o52bobo1758b2ob2o$130bo54b2ob2o1758bobo42bo$130b2o1816bobo41b2o$144bo1804bo35b2o4b2obo15b2o$142b3o1826b2o12b2o5bobo15b2o$125b2o14bo1829b2o20b2o$126bo14b2o40b3o3b3o$126b2obo17b2o33bo9bo1764b2o27b2o$129bo17bo34bo3bobo3bo1754b2o6b2ob2o12b2o12b2o$130b2o13bobo35b3o3b3o1755b2o6bo2bo13b2o$126b3o2b2o12b2o37bo5bo1764bo2bo$128b2o1826b2o$126bo2bo4bo$125bobobo3bo1822b2o$124bo4bo1825bo2bo$116b2o6bo2bob3o5bo1817bo2bo13b2o$115bobo7bo3b3ob2o3bo64b2o5b2o1743b2ob2o12b2o$115bo10b2o5bo4bo64b2o5b2o1745b2o$114b2o10b2o3b2o2bobo$126bo4bo1839b2o$131b3o51b2ob2o1781b2o$127b2o57bobo$186bobo$123b2o2b3o57bo$124bobobo1817bo5bo$125b4o1816b3o3b3o$120b2o4bo1817b2obo3bob2o$119bobo$119bo$118b2o7bobo1817bo3bo$128b2o1817bo3bo$128bo$202b2o7b2o$202bob2o3b2obo$118b2o82bo3bobo3bo$119bo51b2o5b2o22b2o2bobo2b2o$119bobo49b2o5b2o23b3o3b3o$120b2o82bo5bo2$124bob2o$124bob2o1819b2ob2o$172bo5bo1769bobo$133bo37b3o3b3o1768bobo$123b2o4bob2obo35bo2b2ob2o2bo22b2o1744bo$123b2o2bo5bo36bo3bobo3bo22b2o1766b2o$114b2o11bo5bo38bobobobo1793bo$115bo7b2o6b2o4b2o$115bobo5b2o4bobo5b2o30b2ob2o3b2ob2o1780b2o$116b2o11b2o40bo7bo1767b2o12bo2bo7b2o$1947b2o11b2o2bo7b2o$1961bo2bo$1962bo2$145b2o25bo1789bo$145bobo23b3o1787bo2bo$147bo22bo3bo1785b2o2bo7b2o$147b2o20bo5bo1785bo2bo7b2o$141b2o26bo5bo1786b2o$141bo28bo3bo1772b2o$142b3o1801b3o23bo$144bo25bo3bo1771b3o22b2o$130b2o37bo5bo1770b2o2bo$130bo38bo5bo2b2o1767bobo$131b3o36bo3bo3b2o1767b3o$133bo37b3o$145b2o7b2o16bo$143b2o2bo6b2o$143b6o4bo2bo$133bo9b4o5bob2o$131b3o18bob2o1789b2o5b2o$130bo1813bo2bo3bo2bo$131b3o18bob2o1791b2ob2o$133bo9b4o5bob2o14b2o1774bobobobo$143b6o4b3ob2o11bo1775bobobobo$143b2o2bo6bobobo12b3o1770bo9bo$145b2o7b4o15bo1769bo11bo$155b2o$1945bob2ob2obo$1947b2ob2o$1946bo5bo$1947b2ob2o$1948bobo$1948bobo$1949bo$1971b2o$1971b2o2$1964b2o$1947b2o15bobo5b2o$1947b2o15bob2o4b2o$1965b2o$1965bo2$1965bo$1965b2o$138b2o1824bob2o4b2o$140bo1803b2ob2o15bobo5b2o$125b2o10b2o2bo10b2o1793b3o14b2o$125b2o11bo2bo10b2o1789b5obo$139bobo1802bobo24b2o$139b2o1806bobo21b2o$1948bo$139b2o1807bo$139bobo$125b2o11bo2bo$125b2o10b2o2bo$140bo$138b2o$1947b2ob2o$1946bo5bo2$1945bo7bo$1945bo2bobo2bo$1945b3o3b3o6$172b4o$171b2o2bo14b2o1755b2ob2o$170b2o2bo15b2o1756bobo$171bo2bo1773bobo$172b2o1775bo$1971b2o$172b2o1797b2o$171bo2bo$163b2o5b2o2bo15b2o$163b2o6b2o2bo14b2o1755b6o5b4o10b2o$172b4o1771b4o7b2obo10b2o$1950b2obo7bo$1952b2o5b2o2$1952b2o5b2o$1950b2obo7bo$1950bo7b2obo10b2o$1950b3o5b4o10b2o3$1946bo5bo18b2o$1945b3o3b3o17b2o$1945bob2ob2obo$1944b2o7b2o$1944b2o7b2o$1944b3o5b3o$1946b3ob3o$1948bobo$1945bo2bobo2bo$1944bo2bo3bo2bo$1945b2o5b2o11$1947b2ob2o$1948bobo$1948bobo$1949bo$1971b2o$1971b2o2$1957b2o$1947b2o7bobo13b2o$1947b2o7bo15b2o$1956b3o4$1956b3o$1956bo15b2o$1956bobo13b2o$1957b2o2$1971b2o$1971b2o5$91b2o13bo7bo1831bo5bo$90bo2bo10b3o5b3o1830b3o3b3o$89bobobo9bo7bo14b2o1817bob2ob2obo$88b3obo10b2o6b2o13bobo1818b2ob2o$88b3o29bo6b3o1817b2ob2o$118b2ob2ob3ob2o1817b2ob2o$118b2ob2ob5o$120bo5bo$90b2o29b2ob2o$90b2o3$120bo5bo$119b2o5b2o$118bob2o3b2obo$118bob2o3b2obo1818b2ob2o$119b3o3b3o1820bobo$119b3o3b3o1820bobo$1949bo$1971b2o$1970bobo$109bo1860bo$107b3o1862bo$106bo1840b2o12b2o2bo3bo3bo$106b2o1839b2o12bob2o7b2o$1962bo$1962b3o4b2o$121b2ob2o$122bobo1837b3o4b2o$109bo12bobo1837bo$107b3o13bo1837bob2o7b2o$106bo1854b2o2bo3bo3bo$106b2o1839bobo22bo$1948bo21bo$1948b2o20bobo$1948b2o21b2o$1947bo2bo$109bo1837b3o$107b3o$106bo$106b2o4$1945bo7bo$109bo1835b2o5b2o$107b3o1835b3o3b3o$106bo1840b2ob2o$106b2o1839bo3bo$1944b2o7b2o$1944b2o7b2o$1948bobo$1944bo2bo3bo2bo$109bo1835b3o3b3o$107b3o1837bo3bo$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo$107b3o1854bo$106bo1840b2o15b2o6b2o$106b2o1839b2o16b2o5b2o$1960b2o2b2o4$109bo1850b2o2b2o$107b3o1836b2o17b2o5b2o$106bo1838b3o16b2o6b2o$106b2o1836b2o2bo15bo$1944bo2bo$1943bo4b2o21b2o$1948b2o3bo17b2o$1944bobobo$109bo$107b3o$106bo$106b2o$1945bo7bo$1944bo2bo3bo2bo$1948bobo$1948bobo$109bo1838bobo$107b3o1834bo2bo3bo2bo$106bo1838b3o3b3o$106b2o5$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo1845bo$107b3o1846bo3bo$106bo1840b2o2b2o8bo10b2o$106b2o1839b2o2bo5b2o2bo10b2o$1951bobo5b2o$1952b2o3b3o2$1952b2o3b3o$109bo1841bobo5b2o$107b3o1841bo5b2o2bo10b2o$106bo1844b2o8bo10b2o$106b2o1848bo3bo$1955bo$1971b2o$1946bo5bo18b2o$1945b3o3b3o$109bo1834b2o2bobo2b2o$107b3o1834b2ob2ob2ob2o$106bo1840b2ob2o$106b2o1837bobo3bobo$1944bo2bo3bo2bo$1947bo3bo$1944bobo5bobo$1945bo7bo$109bo$107b3o$106bo$106b2o5$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo$107b3o$106bo1840b2o8b3o12b2o$106b2o1839b2o8bo3bo10b2o$1957bo4bo$1958bo3bo2$1958bo3bo$109bo1847bo4bo$107b3o1847bo3bo10b2o$106bo1850b3o12b2o$106b2o2$1971b2o$1971b2o2$109bo$107b3o$106bo$106b2o$1946bo5bo$1945b3o3b3o$1944b2o2bobo2b2o$1943bob4ob4obo$109bo1835b3o3b3o$107b3o1834b3o5b3o$106bo$106b2o5$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo$107b3o1852bo3b3ob3o$106bo1840b2o12bobo2b4o3bo$106b2o1839b2o12bo3b2o6bo$1962bo2bo3b2obo$1963b3o3bo2$1963b3o3bo$109bo1852bo2bo3b2obo$107b3o1851bo3b2o6bo$106bo1841b2o11bobo2b4o3bo$106b2o1839b3o12bo3b3ob3o2$1971b2o$1971b2o$1947b4o$109bo1837b3o$107b3o$106bo$106b2o5$109bo1834b3o5b3o$107b3o1834b3o5b3o$106bo1838b2o5b2o$106b2o1839bo3bo$1945bo2bobo2bo$1944bo3bobo3bo$1945bo2bobo2bo$1945b3o3b3o$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo$107b3o$106bo1840b2o14b2o7b2o$106b2o1839b2o15b2o6b2o$1960b5o$1960b4o2$1949b3o8b4o$109bo1838b6o6b5o$107b3o1838b2o2b3o9b2o6b2o$106bo1839b2o4b3o8b2o7b2o$106b2o1837b2o6b2o$1944bo2bo5b2o$1944bo2bo3b3o17b2o$1945bo3b4o18b2o$1945bo3b3o$109bo1836bo2bo$107b3o$106bo$106b2o2$1945bo7bo$1943bob2o5b2obo$1943bo3b2ob2o3bo$109bo1834bo3bobo3bo$107b3o1835b3o3b3o$106bo$106b2o5$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo$107b3o1843bob2o$106bo1840b2o3bo2b2o2b3o10b2o$106b2o1839b2o3bo6b2o11b2o$1952b2o3b3o$1954bo3bo2$1954bo3bo$109bo1842b2o3b3o$107b3o1842bo6b2o11b2o$106bo1845bo2b2o2b3o10b2o$106b2o1845bob2o2$1971b2o$1971b2o$1946bo5bo$109bo1835b3o3b3o$107b3o1834bo2b2ob2o2bo$106bo1837bo3bobo3bo$106b2o1838bobobobo2$1943b2ob2o3b2ob2o$1945bo7bo2$109bo$107b3o$106bo$106b2o5$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo$107b3o1849bo3bo$106bo1840b2o9bo5bo7b2o$106b2o1839b2o9bo13b2o$1958b2o3bo$1960b3o2$1960b3o$109bo7bo7bo37b2o1793b2o3bo$107b3o5b3o5b3o39bo1792bo13b2o$106bo7bo7bo27b2o10b2o2bo1791bo5bo7b2o$106b2o6b2o6b2o26b2o11bo2bo1792bo3bo$164bobo8bo$164b2o9b3o1793b2o$178bo1792b2o$153b2o9b2o9b3o$151bo3b2o7bobo8bo$151bo4bo6bo2bo$151bo3b2o5b2o2bo$153b2o10bo$163b2o$1946bo5bo$1945b3o3b3o$24b2o1918b2ob2ob2ob2o$24b2o1917b3o7b3o$30b3o132bo$29bo3bo131b3o1777bo7bo$29b2ob2o134bo$167b2o$29b2ob2o120bo$31bo122b3o1790b2ob2o$114b2o5b2o34bo$109bo4b2o5b2o33b2o1789b2ob2o$107b3o$24bo7bo73bo1840b2ob2o$23bo2bo3bo2bo72b2o50b2o1788bobo$27bobo126bo3bo5b2o9b2o1769bobo$27bobo125bo5bo3bo2bo4b3o2bo1770bo$27bobo125bo4bo5bo4bo2b5o1792b2o$23bo2bo3bo2bo121bo2bo7bo2b4o1798b2o$24b3o3b3o76bo46bobo8bob2o3bo$107b3o47bo8b2obob3o7b2o1779bobo2b2o$106bo61bo3bo8bobo1763b2o12bo3bob3o2b2o$106b2o57b3o15bo1763b2o13bo6b2ob2o$166bo16b2o1778b5obo$114bo7bo1843b3o$114b2o5b2o$114b3o3b3o1843b3o$26b2ob2o78bo6b2ob2o45b2o1795b5obo$27bobo77b3o6bo3bo22b2o21b2o1794bo6b2ob2o$27bobo76bo6b2o7b2o20bo1804bo11bo3bob3o2b2o$28bo77b2o5b2o7b2o17b3o1804b2o12bobo2b2o$117bobo21bo35b2o1768b3o$113bo2bo3bo2bo53bobo1766b2ob2o20b2o$114b3o3b3o56bo1766b2ob2o20b2o$179b2o1766bob2o$109bo63b2o1773bo$107b3o63bo$106bo7b2o25b2o31b3o$106b2o6b2o25b2o33bo2$132b2o$130b2o2bo7b2o$130b6o6b2o$109bo20b4o$107b3o1834b3o5b3o$106bo1836b2ob2o3b2ob2o$106b2o1835b2obobobobob2o$130b4o1810bo3bobo3bo$130b6o6b2o1800bo2bo3bo2bo$130b2o2bo7b2o1801b3o3b3o$132b2o$109bo$107b3o31b2o$106bo18bobo13b2o1804b2ob2o$106b2o18b2o1820bobo$126bo1821bobo$1949bo$1971b2o$1971b2o$109bo1851bo$107b3o20b2o1827bo2bo$106bo23b2o1815b2o10b5o8b2o$106b2o1839b2o10b3ob2o7b2o$1960b2obo$1961b2o2$1951b2o8b2o$109bo1838bob3o7b2obo$107b3o1838bo2bobo5b3ob2o7b2o$106bo1841b3obo6b5o8b2o$106b2o1837b2ob2obobo5bo2bo$1944bo2bob5o7bo$1944bo2bob2ob2o17b2o$1945b2o3b2o19b2o$1947b2o$109bo1838bo$107b3o$106bo$106b2o1837b2o5b2o2$162bo3b3o1775bo9bo$161bobo2b5o3b2o1768bo3bobo3bo$161bo3b2o3b2o2b2o1768bo3bobo3bo$109bo52bo2bo3b2o1774bobo3bobo$107b3o53b3o3bo1776bo5bo$106bo$106b2o55b3o3bo$162bo2bo3b2o$147b2o12bo3b2o3b2o2b2o$147b2o12bobo2b5o3b2o$162bo3b3o3$1947b2ob2o$1948bobo$152bo1795bobo$130b3o19b3o1794bo$130bo2bo21bo1815b2o$130bo23b2o1815b2o$130bo10bo$131bobo7b3o1811bo3b2o$144bo1802b2o4b2obob3o11b2o$143b2o1802b2o4bo4b3o11b2o$156bo3bo1792bo3bo$155b5obo1792b3o$154b3o4b2o$154b2ob5o1792b3o$156b3o1794bo3bo$1953bo4b3o11b2o$158bo1794b2obob3o11b2o$154bo2b3o1795bo3b2o$153b2obo3bo7b2o$147b2o3b2ob3obo2b2o4bobo1800b2o$147b2o3b3ob2o4b2o6bo1800b2o$152b3o15b2o$109bo1836bo5bo$107b3o1835b3o3b3o$106bo1837b2o2bobo2b2o$106b2o46bo1789bo3bobo3bo$154bob3o1785bob2o3b2obo$155bo3bo1784b2o7b2o$126b2o3b2o8bo17bo$125bo2bobo2bo7bo2b2o10b2obo4b2o$109bo14bo9bo5bo5bo11bo5bobo$107b3o13b2o9b2o5bobo2b2o18bo$106bo17bo9bo6bo3b2o3bo15b2o$106b2o17bo2bobo2bo9b3o4b3o7b2o$126b2o3b2o20bo6bo$143b3o4b3o8b3o$141bo3b2o3bo12bo$125b2o14bobo2b2o$109bo15b2o13bo5bo$107b3o31bo2b2o$106bo34bo1805b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo1851b2o$107b3o1850bo$106bo1840b2o10bo2b2o8b2o$106b2o1839b2o10bo2bo9b2o$1959bobo$1960b2o2$1960b2o$109bo1849bobo$107b3o1849bo2bo9b2o$106bo1852bo2b2o8b2o$106b2o1852bo$1961b2o$1949bo21b2o$1949bo21b2o2$109bo$107b3o1839bo$106bo1842bo$106b2o3$1945b3o3b3o$1945b3o3b3o$109bo1834bob2o3b2obo$107b3o1834bob2o3b2obo$106bo1838b2o5b2o$106b2o1838bo5bo3$1947b2ob2o$1948bobo$109bo1838bobo$107b3o1838bobo$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo1853bo$107b3o1853bo2b2o$106bo1840b2o13bo5bo3b2o$106b2o1839b2o14bobo2b2o2b2o$1963bo3b2o$1965b3o2$1965b3o$109bo1853bo3b2o$107b3o1853bobo2b2o2b2o$106bo1855bo5bo3b2o$106b2o1840b3o12bo2b2o$1942b2o4b2o13bo$1948b2o21b2o$1947bobo21b2o$1947bobo$109bo1838bo$107b3o$106bo$106b2o5$109bo$107b3o1835bo7bo$106bo1837b4o3b4o$106b2o1836bo3bobo3bo$1945bo2bobo2bo$1945b3o3b3o3$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$1971b2o$1971b2o$109bo1850bo$107b3o1850b2o$106bo1840b2o9bob3o9b2o$106b2o1839b2o13b2o8b2o$1961b2o$1961bo2$1950bo10bo$109bo1839bob2o8b2o$107b3o1838b3ob2o8b2o8b2o$106bo1844b3o4bob3o9b2o$106b2o1838bo13b2o28bo$1945bobo3b2o7bo28bobo$1944b2ob6o18b2o16bobo$1948bo22b2o15b2ob2o$1947b2ob2o$109bo46b2o5b2o$107b3o46b2o5b2o$106bo$106b2o$1945b3o3b3o$1944bo9bo$1944bo3bobo3bo56bo$1945b3o3b3o32bo7bo15bobo$109bo47bo5bo1782bo5bo31bob2o5b2obo13bobo$107b3o46b3o3b3o1819bo3b2ob2o3bo14bo$106bo48bo2b2ob2o2bo1819bo3bobo3bo$106b2o47b3o5b3o1820b3o3b3o4$28bo$27b2o80bo7bo7bo$26b3obo9b2o65b3o5b3o5b3o$25b2o13b2o64bo7bo7bo1824b2ob2o32b4o11b2o$16bo9b2o78b2o6b2o6b2o1824bobo32b2o3bo11bo$14b3o10bo128b3o1789bobo32bo11b2obo$13bo141bo3bo1789bo33b4ob2o5b2ob2o$14b3o10bo10bo116b2ob2o1811b2o10b2o$16bo9b2o8b2obo116bobo1812b2o10b2obo8b2ob2o$25b2o8b2ob3o1916b2o26b3o8bobo$26b3obo5bo2bo116bobo1796b5o25b3o8bobo$27b2o8b2o116b2ob2o1787b2o5bo4bo12b2o12bo10bo$28bo126bo3bo3b2o1782b2o5bo2b3o12b2o11bobo$156b3o4b2o1789b2o2bo26b2obo$1956b2o30bo$1988b2o$1956b2o$1954b2o2bo$1954bo2b3o12b2o$1954bo4bo12b2o$1955b5o$1957b2o$1971b2o$1971b2o2$109bo60b2o$107b3o50b2o6b2ob2o14b2o1757bo5bo$106bo53b2o6bo2bo15b2o1756b3o3b3o$106b2o60bo2bo1772bo2b2ob2o2bo96b2o$5bo163b2o1773b3o5b3o96b2o$5b3o$8bo160b2o$7b2o159bo2bo$109bo58bo2bo15b2o$107b3o58b2ob2o14b2o$106bo27bobo2b2o29b2o$106b2o11b2o12bo3bob3o4b2o$119b2o13bo6b2o3b2o$135b5obo$138b3o2$109bo28b3o$107b3o25b5obo$106bo12b2o13bo6b2o1804b2ob2o$106b2o11b2o12bo3bob3o1806bobo$134bobo2b2o1807bobo$1949bo$1971b2o$1971b2o$109bo$107b3o1851b3o$106bo40b2o1798b2o11bo4bo6b2o$106b2o39b2o1798b2o10bo5bo6b2o$1960bo$1961b2o2$1961b2o$109bo1850bo$107b3o1849bo5bo6b2o$106bo1853bo4bo6b2o$106b2o1853b3o2$1948b2o21b2o$148bo5bo1793b3o20b2o$147bobo3bobo1792b2o$109bo36bo3bobo3bo1792b2o$107b3o36bo3bobo3bo1792b2o$106bo39bo9bo1791bo$106b2o$147b2o5b2o1893b2o$2049bo$2050b3o$5b2o142b2ob2o1791b3o3b3o98bo$5b2o102bo40bobo1792bo2bobo2bo$107b3o39b2ob2o1791b2obobob2o$106bo43bobo1792b2o5b2o$106b2o41b2ob2o$150bobo$150bobo$151bo1795bo3bo$1947b2ob2o$109bo1836bobobobo$107b3o1838bobo$106bo1840b2ob2o$106b2o1840bobo$1948bobo$68b2o23bo41bo1813bo$69bo22b3o40b3o1833b2o$69bob2o18b2obo43bo1832b2o$70bobo18b3o15bo27b2o50bo$60bo30b3o13b3o21b2o54b3o1773b4o$59bobo30b2o12bo25bo53bo1760b2o14bo2b2o4b2o$59bobo39bo4b2o24bobo51b2o1759b2o15bo2b2o3b2o$58b2ob2o37b3o30b2o57b2o1770bo2bo$61bo37b2obo66b2o21bo1772b2o$58b2o2bo7bo28b3o67bo20bobo$59bo2bo7bobo27b2o52bo12bobo20b2o1773b2o$57bo8b3o40bo44b3o10b2o1795bo2bo$57b2o9b3o2bo33b3o47bo1806bo2b2o3b2o$66b2o4b2o32bo49b2o1790bo14bo2b2o4b2o$70b2o34b2o1835b2o4b2o12b4o$127b2o1813bo$128bo22bo1791b2o3bo22b2o$128bobo19b2o1795bobo21b2o$129b2o10bo4bo49b2o1749bobo$109bo30b2o3b2o30bo18bo1751bo$65bo3bo37b3o29b2o3b2o29b4o15bobo$65bo3bo36bo33b2o4bo27b2o3b2o13b2o$106b2o33b2o34bo3bo$177bo3bo$62b2obo3bob2o104bo2b2o$63b3o3b3o103bo3bo$64bo5bo$52bo56bo44b2o$51bobo53b3o44bo$51bobo52bo48b3o1786b2obo3bob2o$52bo53b2o49bo11b2o1773bo2bo3bo2bo$143b2o25bo1774b3o3b3o$65b2ob2o73bo23b3o$66bobo71bo3b3o20bo$66bobo69b3o5bo33b2o$67bo41bo27bo43bo$107b3o27b2o39b3o8bo$106bo44bo26bo8b3o1757b2ob2o$106b2o41b3o34bo1761bobo$148bo37b2o1760bobo$148b2o42b2o1755bo$169b2o21bo1778b2o$138b2ob2o26bo20bobo1778b2o$109bo28b2ob2o11bo12bobo20b2o1757b2o$107b3o44b3o10b2o1779b4o7b2o$106bo38b2o10bo1789bobobo6bo2b2o9b2o$106b2o37b2o9b2o21b2o1766b2ob3o4b6o9b2o$179b2o1769b2obo5b4o$137b2o1811b2obo$123b2o11b2obo15bo$122bobo12bob4o13bo1793b2obo$109bo12bo15bo2b3o10b3o39b2o1752b2obo5b4o$107b3o11b2o16bo3bo52bo1752bo2bo4b6o9b2o$106bo32b4o51bobo1753b2o6bo2b2o9b2o$106b2o33bo8b3o34b2o5b2o1754b2o7b2o$152bo21b3o7bo2b3o1756bo4bo$138b2o11bo21b2ob2o2b4o2bo2bo1755b3o3b3o17b2o$138b2o15b2o15bo4b2ob4ob2o2bo1755bo2bobo2bo17b2o$155b2o16b6o6b2obo1758b2ob2o$109bo64b2o2bo8bo$107b3o17b2o49b2obo$106bo19bobo50bobo$106b2o18bo52bo1765bo7bo$125b2o42b2o1775bobobobo$131b2o37bo1775bobobobo$132bo34b3o1775bob2ob2obo$129b3o35bo1777b2o5b2o$109bo19bo50b2o$107b3o71bo$106bo71b3o$106b2o21bo48bo$127bobo$128bobo$128bo2$109bo30b2o$107b3o30b2o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$123b2o13b2o1809bo$124bo11bo2bo1831b2o$124bobo9bo2bo1831b2o$109bo15b2o8b2ob2o$107b3o24b2ob2o1818b2o$106bo26b2o3b2o1807b2o6b2ob2o12b2o$106b2o26b3o2bo1807b2o6bo2bo13b2o$139bo1815bo2bo$136bobo15b2o1800b2o$137bo16bobo$156bo1799b2o$109bo46b2o1797bo2bo$93bo13b3o40b2o1803bo2bo13b2o$92b3o11bo43bo1804b2ob2o12b2o$56bo34b2obo11b2o43b3o1803b2o$55bobo33b3o59bo$27bo27bobo33b3o45b2o1830b2o$26bobo25b2ob2o33b2o45bo1831b2o$26bobo72bo33bo4b3o$25b2ob2o70b3o6bo25b3o4bo$99b2obo4b3o28bo$99b3o4bo30b2o50bo1756bo5bo$100b2o4b2o23b2o54b3o1755b3o3b3o$132bo53bo1757b2obo3bob2o$132bobo51b2o$133b2o57b2o$169b2o21bo1754bo3bo$24bo5bo78bo59bo20bobo1754bo3bo$23b3o3b3o75b3o34b2o8bo12bobo20b2o$22b2o2bobo2b2o18b3o5b3o44bo37b2o8b3o10b2o$21bob4ob4obo17b3o5b3o44b2o49bo$23b3o3b3o20b2o5b2o95b2o21b2o$22b3o5b3o21bo3bo120b2o$52bo2bobo2bo66b2o16bo$51bo3bobo3bo66bo15b3o$52bo2bobo2bo48bo18bobo8bo3bo$52b3o3b3o46b3o19b2o7b3obob2o8bo41b2o$106bo30bo3b2obo8bobo19bo20bo1750b2ob2o$106b2o31b4o2bo7bo2bo17bobo3bobo4bo6bobo1751bobo$56bo5bo70b5o2bo4bo5bo4bo16bo3b3obobo2bobo5b2o1752bobo$55b3o3b3o69bo2b3o4bo2bo3bo5bo15b2o2bo4bobobo3b2o1758bo$54b2o2bobo2b2o68b2o9b2o5bo3bo15b2ob3o5bo3b2o1783b2o$29bo24b2ob2ob2ob2o87b2o16bo4bo1796bo$27bobo27b2ob2o47bo61b4o6b2o4bo2bo$28b2o25bobo3bobo43b3o62b2o6bo6bobo1772b2o$54bo2bo3bo2bo41bo47b2o24b3o4b2o1758b2o12bo2bo7b2o$57bo3bo44b2o46bo24b2o1766b2o11b2o2bo7b2o$20bo7bo25bobo5bobo90b3o21bo1781bo2bo$19bo2bo3bo2bo16bo8bo7bo93bo11b2o1791bo$23bobo19bo89bo7b2o25bo$23bobo19b3o87b3o5bo23b3o1792bo$23bobo83bo28bo5b3o20bo1793bo2bo$19bo2bo3bo2bo77b3o27b2o7bo33b2o7bo1770b2o2bo7b2o$20b3o3b3o11bo65bo24b2o48bo5b3o1771bo2bo7b2o$41bo64b2o24bo45b3o5bo1775b2o$39b3o90bobo43bo7b2o1759b2o$133b2o57b2o1752b3o23bo$169b2o21bo1753b3o22b2o$139b2o28bo20bobo1753b2o2bo$36b2o19b2ob2o47bo29b2o13bo12bobo20b2o1755bobo$37bo20bobo46b3o44b3o10b2o1778b3o$22b2ob2o7b3o10b2o9bobo45bo34bo15bo26b2o$23bobo8bo12bobo9bo46b2o27b3o3b2ob2o10b2o26b2o$23bobo23bo85b2o5bobobo32bo$24bo24b2o76b2o8bo4bob2o31b2obo$128bo12b3o37bo5b2o$128bobo6b2o2bobo33b2o2bo5b2o1756b2o5b2o$109bo19b2o6b6o37bob2o12b2o1746bo2bo3bo2bo$107b3o27b3o4b2o32bobob2o3b2o7bo1750b2ob2o$106bo37b2o34bo2bo3b2o5bobo1749bobobobo$106b2o70bob2o12b2o1750bobobobo$180bob2o1760bo9bo$181b2o1760bo11bo2$1945bob2ob2obo$109bo1837b2ob2o$107b3o44b2o1790bo5bo$106bo47bo1792b2ob2o$16b2o5b2o81b2o47b3o1790bobo$16b2o5b2o132bo11b2o1777bobo$135bo7b2o25bo1778bo$135b3o5bo23b3o1801b2o$138bo5b3o20bo1803b2o$109bo27b2o7bo33b2o7bo$107b3o21b2o48bo5b3o1774b2o$106bo25bo45b3o5bo1760b2o15bobo5b2o$106b2o24bobo43bo7b2o1759b2o15bob2o4b2o$133b2o57b2o1771b2o$169b2o21bo1772bo$169bo20bobo$154bo12bobo20b2o1773bo$109bo44b3o10b2o1796b2o$107b3o47bo1806bob2o4b2o$106bo49b2o1786b2ob2o15bobo5b2o$106b2o1839b3o14b2o$15b3o5b3o101b2o1814b5obo$15bo2b2ob2o2bo102bo10b3o8b2o1792bobo24b2o$16b3o3b3o103bobo7bo2bo4bo3b2o1795bobo21b2o$17bo5bo105b2o6bo3bo3bobo48b2o1750bo$109bo27bo7bobo25bo22bo1751bo$107b3o30bo32b2o19bobo$106bo30b2obo37bo4bo10b2o$106b2o70b2o3b2o$179b2o3b2o$93bo46bob2o34bo4b2o$16b2o74b3o45b3o39b2o1763b2ob2o$16b2o73b2obo46bo1804bo5bo$91b3o15bo44b2o$91b3o13b3o44bo1790bo7bo$92b2o12bo48b3o1787bo2bobo2bo$101bo4b2o49bo11b2o1774b3o3b3o$100b3o40b2o25bo$99b2obo40bo23b3o$99b3o38bo3b3o20bo$100b2o36b3o5bo33b2o$109bo27bo43bo$107b3o27b2o39b3o8bo$106bo44bo26bo8b3o1757b2ob2o$106b2o41b3o34bo1761bobo$148bo37b2o1760bobo$148b2o42b2o1755bo$169b2o21bo1778b2o$138b2ob2o26bo20bobo1778b2o$109bo28b2ob2o11bo12bobo20b2o$107b3o44b3o10b2o$106bo30b2o6b2o10bo1789b6o5b4o10b2o$106b2o27bo3bo5b2o9b2o21b2o1766b4o7b2obo10b2o$134bo4b2o38b2o1769b2obo7bo$134bo5bo1811b2o5b2o$123b2o$44bo77bobo10bo4bo1811b2o5b2o$42b5o10bo51bo12bo12b2obob2obo34b3o15b2o1752b2obo7bo$41bo2bob2o9b2o8b2o38b3o11b2o30bo2b3o19b4o14bo1753bo7b2obo10b2o$40bo7bo9b2o7b2o37bo45bo3bobo14b2o3b2ob2o3b2o6bobo1753b3o5b4o10b2o$41bo2bob2o5b2o2b2o47b2o45bob3o14bo7bo5b3o5b2o$42b5o123bo2bo5b3o3bob3o$44bo125bo2bo5b2obo2b2obo1757bo5bo18b2o$155b2o12bo3bo8b2ob2obo1756b3o3b3o17b2o$53b2o2b2o96b2o13b3o7bobo3bobo1756bob2ob2obo$40b2o16b2o7b2o40bo71bo4bo2bo1754b2o7b2o$40b2o15b2o8b2o38b3o17b2o57b3o1755b2o7b2o$57bo48bo19bobo50b2o6bo1756b3o5b3o$106b2o18bo52b2o1765b3ob3o$125b2o42b2o1777bobo$131b2o37bo1774bo2bobo2bo$132bo34b3o1774bo2bo3bo2bo$129b3o35bo1777b2o5b2o$109bo19bo50b2o$107b3o71bo$106bo71b3o$106b2o21bo48bo$127bobo$128bobo$128bo2$109bo30b2o$107b3o30b2o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$123b2o1824bo$124bo1846b2o$124bobo1844b2o$109bo15b2o4b4o$107b3o20b2o2bo5b2o1815b2o$106bo22b2o2bo4bobob2o1803b2o7bobo13b2o$106b2o22bo2bo2b2o5bo1803b2o7bo15b2o$131b2o6bo3bo1812b3o$136bo5bo11b2o$137b4o13bobo$139bo16bo$109bo46b2o1798b3o$107b3o40b2o1804bo15b2o$106bo43bo1805bobo13b2o$106b2o43b3o1803b2o$153bo$139b2o1830b2o$139bo1831b2o$140b3o4bo$109bo32bo3bobo$107b3o36bobo$106bo38b2ob2o$106b2o1838bo5bo$1945b3o3b3o$1945bob2ob2obo$1947b2ob2o$1947b2ob2o$109bo1837b2ob2o$107b3o$106bo$106b2o2$143bo7bo22b2o5b2o$62bo2bo76bobo5bobo21b2o5b2o$52b3o7bo82bo3bo$51bo4bo9bo42bo7bo7bo16bo2bo3bo2bo$50bo5bo8b2o26bo13b3o5b3o5b3o17bobo3bobo$41bo9bo8bo31b3o11bo7bo7bo22b2ob2o1797b2ob2o$39b3o10b2o8b2o27b2obo11b2o6b2o6b2o18b2ob2ob2ob2o1795bobo$38bo52b3o48b2o2bobo2b2o1795bobo$39b3o10b2o8b2o27b3o49b3o3b3o1797bo$41bo9bo8bo3bo27b2o50bo5bo23b3o3b3o1788b2o$50bo5bo4bo2bo36bo71bo2bo3bo2bo1786bobo$51bo4bo4bo2bo35b3o70b2obo3bob2o1786bo$52b3o7b2o35b2obo1869bo$99b3o48b2o1795b2o12b2o2bo3bo3bo$100b2o48b2o1795b2o12bob2o7b2o$1962bo$1962b3o4b2o$44b2o5b2o$40b2o2b2o5b2o2b2o1905b3o4b2o$40b2o13b2o1905bo$175bo1785bob2o7b2o$44b3o3b3o120b2ob2o1783b2o2bo3bo3bo$44bo2bobo2bo120b2ob2o15b2o5b2o1745bobo22bo$43bo3bobo3bo139b2o5b2o1746bo21bo$44bo2bobo2bo119bobobobo1769b2o20bobo$46bo3bo1897b2o21b2o$44b2o5b2o120b2ob2o1769bo2bo$43b3o5b3o55bo64b3o4b2o1764b3o$43b3o5b3o53b3o65bo5b2o$106bo$106b2o2$194bo5bo$50b3o140b3o3b3o$50b3o140bob2ob2obo1743bo7bo$49b5o55bo7bo77b2ob2o1745b2o5b2o$48b2o3b2o52b3o5b3o77b2ob2o1745b3o3b3o$48b2o3b2o51bo7bo80b2ob2o1747b2ob2o$106b2o6b2o1831bo3bo$1944b2o7b2o$1944b2o7b2o$48b2o3b2o1893bobo$44b2o2b2o3b2o1889bo2bo3bo2bo$44b2o3b5o139b3o1749b3o3b3o$50b3o140b3o1751bo3bo$50b3o1894b2ob2o$192b2ob2o1751bobo$192bo3bo1751bobo$193b3o1753bo$194bo5b2o1769b2o$200b2o1769b2o$109bo$107b3o1854bo$106bo22bo1817b2o15b2o6b2o$106b2o20bobo1816b2o16b2o5b2o$128bobo1829b2o2b2o$129bo3$109bo1850b2o2b2o$107b3o13bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo1748b2o17b2o5b2o$106bo1838b3o16b2o6b2o$106b2o15bo73bo1746b2o2bo15bo$129bo1814bo2bo$123bo4bobo66bo1745bo4b2o21b2o$128bobo12bobobo1800b2o3bo17b2o$123bo5bo67bo1746bobobo$109bo33bo3bo36bobobobo$107b3o13bo73bo$106bo36bobobo34bobobobobobo$106b2o15bo26bo22bobobo19bo$143bo3bo2b3o29bobo5bobo1752bo7bo$123bo29bo19bo3bo19bo1746bo2bo3bo2bo$129bo13bobobo4bo29bobo1763bobo$123bo4bobo42bobobo19bo1750bobo$109bo18bobo37bo15bobobobo1757bobo$107b3o13bo5bo37bo5bo3bo19bo1746bo2bo3bo2bo$106bo61b3o19bobo1752b3o3b3o$106b2o15bo19bobobo22bo2bobobo19bo$128bobobobobo45bobo5bobo$123bo23bo2bo46bo$128bobobobobobo11b3o29bobobobobobo$123bo23bo5bo43bo$109bo18bobo5bobo13bo20bobobo6bobobobo$107b3o13bo23bo49bo$106bo21bobo5bobo29bo8bo1769b2ob2o$106b2o15bo23bo19bo29bo1750bobo$128bobobobobo31b3o6bo8bo1761bobo$123bo46bo14bobo9bo1751bo$128bobo5bobo38bo7bobo1783b2o$123bo26bo35bo10bo1773b2o$109bo18bobo5bobo4bobobo2b3o24bo1777bo$107b3o13bo29bo43bo1758bo3bo$106bo21bobobobobobo4bo8bo1794b2o2b2o8bo10b2o$106b2o15bo73bo1749b2o2bo5b2o2bo10b2o$128bobobobobo6bobobo20bo1782bobo5b2o$93bo29bo43bo5bobobo19bo1754b2o3b3o$92b3o48bo3bo20b3o15bo$91b2obo28bo46bo2bo11bobo9bo1754b2o3b3o$91b3o15bo19bo13bobobo37bobo1763bobo5b2o$91b3o13b3o13bo4bobo42bobobo8bo10bo1753bo5b2o2bo10b2o$92b2o12bo21bobo1820b2o8bo10b2o$101bo4b2o15bo5bo43bo3bo19bo1758bo3bo$100b3o1852bo$99b2obo20bo49bobobo19bo1773b2o$99b3o1844bo5bo18b2o$100b2o21bo73bo1747b3o3b3o$109bo76bo1757b2o2bobo2b2o$107b3o13bo61bobo9bo1746b2ob2ob2ob2o$23bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo4bo22bo55bobo1759b2ob2o$106b2o15bo4bobo55bo10bo1747bobo3bobo$23bo77bo26bobo12bobobo1796bo2bo3bo2bo$123bo5bo67bo1749bo3bo$23bo22bobobobo7bobo5bobo30bo41bo40bobobobo1753bobo5bobo$123bo73bo1747bo7bo$23bo20bobobobobobo5bobo5bobo11bobobobo12bo7bo33bobobo34bobobobobobo$107b3o13bo26bo22bobobo19bo$23bo20bobo5bobo5bobobo3bobo11bobobobo12bo4bo40bo2b3o29bobo5bobo$106b2o15bo29bo19bo23bo$23bo20bobo5bobo5bobobo3bobo11bobo16bo27bo13bobobo4bo29bobo$123bo4bobo42bobobo19bo$23bo20bobo5bobo5bobo2bo2bobo11bobo16bo26bobo37bo15bobobobo$123bo5bo37bo9bo19bo$23bo20bobo5bobo5bobo3bobobo15bobobobobobo4bo7bo58b3o19bobo$107b3o13bo19bo3bo22bo2bobobo19bo$23bo20bobo5bobo5bobo3bobobo15bobobobobobo4bo4bo21bobobobobo45bobo5bobo1754b2ob2o$106b2o15bo19bo3bo2bo46bo1750bobo$23bo20bobobobobobo5bobo5bobo23bobo4bo26bobobobobobo11b3o29bobobobobobo1755bobo$123bo19bobobo5bo43bo1751bo$23bo22bobobobo7bobo5bobo23bobo4bo26bobo5bobo13bo20bo3bo6bobobobo1780b2o$123bo23bo49bo1773b2o$23bo77bo7bo18bobo5bobo29bo4bo3bo$107b3o13bo23bo19bo29bo$23bo77bo4bo21bobobobobo31b3o2bobobo8bo1760b2o8b3o12b2o$106b2o15bo46bo14bobo9bo1749b2o8bo3bo10b2o$23bo77bo26bobo5bobo38bo7bobo1769bo4bo$123bo26bo35bo10bo1760bo3bo$23bo6bobobobo7bobobobobobo5bobobobobobo30bo26bobo5bobo4bobobo2b3o24bo$123bo29bo43bo1760bo3bo$23bo4bobobobobobo5bobobobobobo5bobobobobobo15bobo12bo7bo18bobobobobobo8bo4b2o1803bo4bo$107b3o13bo73bo1759bo3bo10b2o$23bo4bobo5bobo5bobo13bobo23bobo12bo4bo21bobobobobo6bobobo19b2o1788b3o12b2o$106b2o15bo43bo5bobobo19bo$23bo4bobo5bobo5bobobobobo7bobobobobo13bobo16bo45bo20b3o15bo$123bo46bo6bo7bobo9bo1773b2o$23bo4bobo5bobo5bobobobobo7bobobobobo13bobo16bo27bo13bobobo37bobo1783b2o$123bo4bobo42bobobo8bo10bo$23bo4bobo5bobo5bobo13bobo23bobobobobobo4bo7bo18bobo$107b3o13bo5bo47bo19bo$23bo4bobo5bobo5bobo13bobo23bobobobobobo4bo4bo$106b2o15bo49bobobo19bo$23bo4bobobobobobo5bobo13bobo31bobo4bo1844bo5bo$123bo73bo1747b3o3b3o$23bo6bobobobo7bobo13bobo31bobo4bo84bo1757b2o2bobo2b2o$123bo61bobo9bo1745bob4ob4obo$23bo77bo7bo19bo55bobo1757b3o3b3o$107b3o13bo4bobo55bo10bo1746b3o5b3o$23bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo4bo21bobo12bobobo$106b2o15bo5bo67bo$147bo36bobobobo$123bo73bo$143bobobo34bobobobobobo$123bo26bo22bobobo19bo$109bo33bo6b3o29bobo5bobo$107b3o13bo29bo23bo19bo$106bo22bo13bobobo4bo29bobo1762b2ob2o$106b2o15bo4bobo42bobobo19bo1750bobo$128bobo36b2o15bobobobo1757bobo$123bo5bo37bo5bo23bo1751bo$168b3o19bobo1778b2o$123bo21bo24bo2bobobo19bo1773b2o$109bo18bobobobobo45bobo5bobo$107b3o13bo21bo4bo46bo1764bo3b3ob3o$106bo21bobobobobobo11b3o29bobobobobobo1754b2o12bobo2b4o3bo$106b2o15bo21bo7bo43bo1749b2o12bo3b2o6bo$128bobo5bobo13bo22bo8bobobobo1771bo2bo3b2obo$123bo21bo51bo1765b3o3bo$128bobo5bobo29bo6bo$123bo21bo21bo29bo1765b3o3bo$109bo18bobobobobo31b3o4bo10bo1775bo2bo3b2obo$107b3o13bo46bo14bobo9bo1763bo3b2o6bo$106bo21bobo5bobo36bo9bobo1760b2o11bobo2b4o3bo$106b2o15bo26bo35bo10bo1749b3o12bo3b3ob3o$128bobo5bobo4bobobo2b3o22bo$123bo29bo43bo1773b2o$128bobobobobobo4bo3bo4bo1818b2o$123bo73bo1749b4o$109bo18bobobobobo6bo3bo20bo1778b3o$93bo13b3o13bo43bo5bobobo19bo$92b3o11bo36bo3bo20b3o15bo$91b2obo11b2o15bo46bo2bo3bo7bobo9bo$91b3o49bobobo37bobo$91b3o29bo49bo3bo8bo10bo$92b2o$101bo21bo49bo3bo19bo$100b3o6bo1834b3o5b3o$99b2obo4b3o13bo49bobobo19bo1746b3o5b3o$99b3o4bo1838b2o5b2o$100b2o4b2o15bo73bo1749bo3bo$186bo1758bo2bobo2bo$123bo61bobo9bo1746bo3bobo3bo$185bobo1757bo2bobo2bo$123bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo4bo4bobobobo1747b3o3b3o$109bo$107b3o$106bo1840b2ob2o$106b2o56b2o1782bobo$164bo26b3o1754bobo$165b3o23b3o4b2o1749bo$167bo22bo3bo3b2o1771b2o$189bo5bo1775b2o$109bo80b2ob2o$107b3o$106bo83b2ob2o1752b2o14b2o7b2o$106b2o81bo5bo1751b2o15b2o6b2o$146b2o42bo3bo1765b5o$145bo2bo42b3o1766b4o$145bo7bo37b3o$145bo2bo3bobo1794b3o8b4o$109bo35b2ob2ob2ob2o1792b6o6b5o$107b3o39bobo1796b2o2b3o9b2o6b2o$106bo41b2ob2o1793b2o4b3o8b2o7b2o$106b2o1837b2o6b2o$1944bo2bo5b2o$190b2o7b2o1743bo2bo3b3o17b2o$190bob2o3b2obo1744bo3b4o18b2o$146b3o3b3o35bo3bobo3bo1744bo3b3o$109bo35bo9bo34b2o2bobo2b2o1745bo2bo$107b3o35bo3bobo3bo35b3o3b3o$106bo39b3o3b3o37bo5bo$106b2o39bo5bo2$1945bo7bo$1943bob2o5b2obo$1943bo3b2ob2o3bo$109bo81b2o5b2o1744bo3bobo3bo$107b3o81b2o5b2o1745b3o3b3o$106bo$106b2o2$148b2ob2o$149bobo$149bobo$109bo40bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$164bo1806b2o$163bobo1805b2o$109bo53bobo$107b3o52b2ob2o1786bob2o$106bo1840b2o3bo2b2o2b3o10b2o$106b2o1839b2o3bo6b2o11b2o$1952b2o3b3o$1954bo3bo2$1954bo3bo$109bo1842b2o3b3o$107b3o1842bo6b2o11b2o$106bo1845bo2b2o2b3o10b2o$106b2o1845bob2o2$1971b2o$160bo7bo1802b2o$159b4o3b4o1776bo5bo$109bo49bo3bobo3bo1775b3o3b3o$107b3o50bo2bobo2bo1775bo2b2ob2o2bo$106bo53b3o3b3o1775bo3bobo3bo$106b2o1838bobobobo2$1943b2ob2o3b2ob2o$1945bo7bo2$109bo$107b3o50b2o$106bo53b2o$106b2o2$93bo$92b3o$91b2obo$91b3o15bo$91b3o13b3o$92b2o12bo1840b2ob2o$101bo4b2o67b3ob3o9b2o1755bobo$100b3o71bob2ob2obo7b2ob2o6b2o1745bobo$99b2obo70b2o7b2o7bo2bo6b2o1746bo$99b3o72bob2ob2obo8bo2bo1776b2o$100b2o73b3ob3o10b2o1777b2o2$192b2o1765bo3bo$191bo2bo1752b2o9bo5bo7b2o$174b2o15bo2bo6b2o1744b2o9bo13b2o$174b2o14b2ob2o6b2o1755b2o3bo$191b2o1767b3o2$1960b3o$109bo1848b2o3bo$107b3o1848bo13b2o$106bo86b2o5b2o1756bo5bo7b2o$106b2o85b2o5b2o1757bo3bo2$1971b2o$1971b2o2$109bo$107b3o$106bo$106b2o2$1946bo5bo$194bo5bo1744b3o3b3o$193bobo3bobo1742b2ob2ob2ob2o$109bo7bo7bo66bo3bobo3bo1740b3o7b3o$107b3o5b3o5b3o66bo3bobo3bo$106bo7bo7bo69bo9bo1742bo7bo$106b2o6b2o6b2o$193b2o5b2o2$1947b2ob2o2$195bo3bo1747b2ob2o$193b2o$192bo3bobo3b2o1743b2ob2o$192bo3bobo1749bobo$193b3o1752bobo$200bo2bo1745bo$200b2o1769b2o$30b2o1939b2o$30b2o$1962bobo2b2o$42bobo2b2o1898b2o12bo3bob3o2b2o$29b2o10bo3bob3o1897b2o13bo6b2ob2o$29b2o11bo6b2o1912b5obo$43b5obo1916b3o$46b3o$1966b3o$46b3o1914b5obo$43b5obo1912bo6b2ob2o$29b2o11bo6b2o3b2o65b2o1826bo11bo3bob3o2b2o$29b2o10bo3bob3o4b2o65b2o1825b2o12bobo2b2o$42bobo2b2o1898b3o$1946b2ob2o20b2o$30b2o1914b2ob2o20b2o$30b2o1915bob2o$1948bo$55b2o$55b2o6$109bo4b2o5b2o$107b3o3bo2bo3bo2bo1820b3o5b3o$106bo7bo2bobo2bo1820b2ob2o3b2ob2o$106b2o9bobo1823b2obobobobob2o$115b3ob3o1822bo3bobo3bo$113b3o5b3o1820bo2bo3bo2bo$55b3o3b3o49b2o7b2o1821b3o3b3o$55b3o3b3o49b2o7b2o$54bob2o3b2obo44bo4bob2ob2obo$54bob2o3b2obo42b3o4bob2ob2obo$55b2o5b2o42bo1840b2ob2o$56bo5bo43b2o8b2ob2o1827bobo$117bobo1828bobo$117bobo1829bo$57b2ob2o56bo1852b2o$58bobo1910b2o$58bobo48bo1851bo$58bobo32bo13b3o1849bo2bo$57b2ob2o30b3o11bo1840b2o10b5o8b2o$58bobo30b2obo11b2o1839b2o10b3ob2o7b2o$58bobo30b3o1866b2obo$59bo31b3o1867b2o$92b2o$101bo1849b2o8b2o$100b3o6bo1838bob3o7b2obo$99b2obo4b3o1838bo2bobo5b3ob2o7b2o$99b3o4bo1841b3obo6b5o8b2o$100b2o4b2o1837b2ob2obobo5bo2bo$1944bo2bob5o7bo$1944bo2bob2ob2o17b2o$1945b2o3b2o19b2o$1947b2o$109bo1838bo$107b3o$106bo$106b2o1837b2o5b2o2$1944bo9bo$1944bo3bobo3bo$1944bo3bobo3bo$109bo12bo1822bobo3bobo$107b3o11bobo1822bo5bo$106bo14bobo$106b2o12b2ob2o5$109bo$107b3o$106bo1840b2ob2o$106b2o1840bobo$1948bobo$1949bo$118b2o5b2o1844b2o$117bo2bo3bo2bo1843b2o$109bo10b2ob2o$107b3o9bobobobo1829bo3b2o$106bo12bobobobo1821b2o4b2obob3o11b2o$106b2o9bo9bo1819b2o4bo4b3o11b2o$116bo11bo1824bo3bo$1954b3o$120b2ob2o$118bo2bobo2bo1827b3o$109bo8b3o3b3o1826bo3bo$107b3o1843bo4b3o11b2o$106bo1846b2obob3o11b2o$106b2o10b2o1835bo3b2o$118b2o$1971b2o$1971b2o2$109bo1836bo5bo$107b3o1835b3o3b3o$106bo1837b2o2bobo2b2o$106b2o1836bo3bobo3bo$1944bob2o3b2obo$1944b2o7b2o3$109bo$107b3o$106bo$70b2o34b2o$70b2o2$2003bo24b2o$46b2o14b2o7b2o1929bobo23bo$46b2o15b2o6b2o1929bobo8bo12bobo9bo$59b5o1937b2ob2o7b3o10b2o9bobo$59b4o1884b2ob2o50bobo11bo6bo13bobo$1948bobo51bobo10b2o6b2o11b2ob2o$49b2o8b4o1885bobo49bobobobo15bobo$48bobob2o5b5o1885bo51b2ob2o$47b2o3b2o9b2o6b2o1898b2o$48bobob2o8b2o7b2o1898b2o48bo$49b2o58bo1851b2o57b2o13bo5bo$107b3o1850bo38b3o3b3o12bobo11b3o3b3o$70b2o34bo1840b2o10bo2b2o8b2o24bo9bo24bo2b2ob2o2bo$70b2o34b2o1839b2o10bo2bo9b2o24bo3bobo3bo24b3o5b3o$12b2o5bo1939bobo37b3o3b3o$12b2o4bobo1939b2o38bo5bo$17bo3bo1989b2o$17bo3bo1938b2o50b2o$16b3ob3o86bo1849bobo49bo$17bo3bo85b3o1849bo2bo9b2o$17b2ob2o84bo16bo1835bo2b2o8b2o$18bobo85b2o14bobo28bo1806bo71b2o$19bo102bobo21b2o4bobo1806b2o68b2o$93bo27b2ob2o20bo5bobo1794bo21b2o60bo$92b3o49bobo4b2ob2o1793bo21b2o$91b2obo36b2o11b2o$91b3o15bo22bo18b2ob2o$14bo3bo72b3o13b3o22bobo1814bo$14bo3bo73b2o12bo26b2o16b2ob2o1793bo$101bo4b2o$100b3o$11b2obo3bob2o77b2obo33b2o$12b3o3b3o78b3o33bobo11bo7bo1787b3o3b3o$13bo5bo80b2o35bo1807b3o3b3o$109bo9b2o5b2o19b3o7b3o1784bob2o3b2obo47b3o3b3o$107b3o8bo2bo3bo2bo19b2ob2ob2ob2o1785bob2o3b2obo47bo2bobo2bo$106bo12bo2bobo2bo15b2o4b3o3b3o1787b2o5b2o48b2obobob2o$106b2o14bobo18bobo4bo5bo1789bo5bo49b2o5b2o$120b3ob3o16bo$118b3o5b3o1901b2obo3bob2o$118b2o7b2o1818b2ob2o78bo2bo3bo2bo$12b2o5b2o97b2o7b2o1819bobo53bo3bo22b3o3b3o$12b2o5b2o88bo9bob2ob2obo1820bobo53b2ob2o$107b3o9b3o3b3o1820bobo52bobobobo$106bo13bo5bo1820b2ob2o53bobo$106b2o14b3o3b3o1817bobo53b2ob2o$29b2o90bo2bo3bo2bo1816bobo54bobo$29b2o94bobo1821bo55bobo25b2ob2o$121b2o7b2o1839b2o33bo27bobo$121b2o7b2o1839b2o61bobo$5b2o14b3o6b2o77bo14bo3bo1834bo71bo$5b2o12bo3bo6b2o75b3o14b2ob2o1834bo2b2o$18bo4bo82bo15b3o3b3o1816b2o13bo5bo3b2o$18bo3bo83b2o14b2o5b2o16bo5bo1793b2o14bobo2b2o2b2o$122bo7bo15bobo3bobo1808bo3b2o$8b3o7bo3bo122bo3bobo3bo1809b3o$6b2obob2o5bo4bo121bo3bobo3bo$6b2o5bo5bo3bo6b2o113bo9bo1809b3o$6b2obob2o8b3o6b2o77bo1853bo3b2o$8b3o96b3o36b2o5b2o1808bobo2b2o2b2o$106bo1855bo5bo3b2o$29b2o75b2o1840b3o12bo2b2o$29b2o117b2ob2o1789b2o4b2o13bo$149bobo1796b2o21b2o$148b2ob2o1794bobo21b2o$124b2ob2o20bobo1795bobo$109bo15bobo20b2ob2o1795bo$107b3o15bobo21bobo$106bo19bo22bobo122b3o1642b2o5b2o$106b2o42bo121bo4bo11b2o1624b2o2b2o5b2o2b2o$272bo5bo10b2o1624b2o13b2o$265bobobo7bo$165b2o96b7o5b2o1643bo5bo$164b5o93bo1656b3o3b3o$109bo38b2o14bo4bo5b2o86b7o5b2o1641bo2b2ob2o2bo$107b3o38b2o14b3o2bo5b2o88bobobo7bo1640bo3bobo3bo16bo7bo$106bo58bo2b2o102bo5bo1641bobobobo17b4o3b4o$106b2o58b2o104bo4bo1337bo328bo3bobo3bo$150bo3bo119b3o1337bo2bo299b2ob2o3b2ob2o15bo2bobo2bo$148b2obobob2o9b2o1445b5o10b2o289bo7bo17b3o3b3o$147bob2o3b2obo7bo2b2o76b4o1362b2ob3o10b2o$146bo2bo5bo2bo5b3o2bo5b2o68b2o2bo1363bob2o$109bo37bob2o3b2obo6bo4bo5b2o67b2o2bo1365b2o72b2o5b2o$107b3o38b2obobob2o7b5o71bo4bo2bo25b2o1408b2o3bo5bo3b2o$106bo43bo3bo10b2o71b3o5b2o25b2ob2o1336b2o68bo15bo225bo20b2ob2o$106b2o129bo36bo2bo1335bob2o68bo13bo225b3o20bobo$238b3o5b2o26bo2bo4bo1318b2o9b2ob3o10b2o294bo3bo19bobo$240bo4bo2bo26b2o5b3o1316b2o10b5o10b2o293bo5bo19bo$244b2o2bo36bo1328bo2bo210b2o7b4o82bo5bo$245b2o2bo25b2o5b3o1330bo211bo2bo6bo3bo82bo3bo$109bo136b4o7bo16bo2bo4bo1543b2o2bo10bo$107b3o145b2o17bo2bo1410b2o5b2o119bo10bo2bo4bob2obo83bo3bo$106bo25b2o122b2o15b2ob2o1410b2obobob2o117b3o11bo6b3o85bo5bo$106b2o23bo2bo139b2o1336b2o74bo2bobo2bo116bo105b2o2bo5bo$131bobo2bo1475b2o74b3o3b3o117b3o11bo6b3o81b2o3bo3bo$132bo1683bo10bo2bo4bob2o86b3o$133b2obo78b2o1404b2o203b2o2bo8bo86bo$135bo79b2o1394b2o7bo2b2o11b2o189bo2bo6b2o$109bo1486b2o5b2o6b2o6b6o11b2o190b2o7bo$107b3o118b4o1360b2o2b2o5b2o2b2o12b4o77b2o89bo$106bo27b2o78b2o12bo2b2o1359b2o13b2o93b2o84bo3bo$106b2o26b2o4b3o71b2o13bo2b2o1052b2o424bo60b2o12bo8b2o2b2o$140b3o86bo2bo1053bobo423b2o59b2o12bo2b2o5bo2b2o$139bo3bo86b2o571bo318bo134bobo28bo256bo75b4o76b2o7bob3o11b2o60b2o5bobo$139b2ob2o575b2o81b2ob2o314b4o9bo123bo29b2o254bobo64b2o6b6o76b2o11b2o10b2o61b3o3b2o$139bo3bo86b2o15b2ob2o466b5o11b2o54b2o10b2o2bo3b2o217b2o82b2o4b2o3bo9bo2b2o110b2o13b2o278bobo64b2o7bo2b2o88b2o$109bo30bobo86bo2bo12bobo3bo466bo4bo11bo53bo2bo11bob2o3bo217bo7b3o5b4o64bo5b2o12bo5bo108b2ob2o12bo277b2ob2o73b2o90bo75b3o3b2o93b2o5b2o19b2o$107b3o30bobo71b2o13bo2b2o5b2o3bobo3bo467b3o2bo10bo49bo4bo2b2o9bo2bo3bo219bo6bo7b2obo65bo4b3o12bobo2b2o108bo2bo11bo430b2o64b2o25b2o5bobo88b2o2b2o5b2o2b2o16b2o$106bo34bo72b2o12bo2b2o6b2o3bo4bo455bo13bo2b2o11b3o43bo3bo3bo2bo11b2o5b3o213b3o7b2obo7bo10bo51b3o20bo3b2o3bo91bo13bo2bo4b2o6b3o328b3o3b3o7b2o81b2o16bo48bo24bo2b2o5bo2b2o84b2o13b2o15bo$106b2o120b4o11b2o5b3o450b3o14b2o15bo41b7o5bo12bo8bo213bo11b2o5b2o11b3o49bo24b3o4b3o87b3o14b2o15bo327bo3bobo3bo6b2o99b2o47bobo22bo8b2o2b2o120bo5bo$252bo449bo75bo283bo83bo85bo361bo3b2ob2o3bo94b2o11b2o47b2o23bo3bo128b3o3b3o$215b2o486b3o14b2o57b7o5bo34b2o14b2o9b2o184b2o5b2o11b3o74b3o4b3o87b3o14b2o342bob2o5b2obo94b2o7bob3o78bo127bo2bobo2bo$215b2o376b2o3bo106bo13bo2b2o57bo3bo3bo2bo33b2o15b2o8b2o184b2o7bo10bo74bo3b2o3bo91bo13bo2bo343bo7bo107b2o209b2ob2o$68b2o66b2ob2o452b3obob2o4b2o111b3o2bo60bo4bo2b2o45b5o201b2obo85bobo2b2o108bo2bo459bo$69bo39bo25bo5bo451b3o4bo4b2o111bo4bo65bo2bo46b4o202b4o84bo5bo108b2ob2o449b2o$69bob2o20bo13b3o410b2o5b2o52bo14bo3bo117b5o4b2obo59b2o11b2obo227bo83bob2o12bo2b2o110b2o6b2obo441b2o$70bobo19b3o11bo27bo7bo377b2o5b2o50b3o15b3o119b2o6b2ob3o70b2ob3o20b2o8b4o189b6o78b3ob2o12bo122b2ob3o658bo7bo$60bo30b2obo11b2o26bo2bobo2bo435bo154bo75bo18bobob2o5b5o187bo4bo78bo147bo643bo14bobobobo$59bobo29b3o40b3o3b3o436b3o15b3o127b2ob3o70b2ob3o18b2o3b2o9b2o8b2o177b3ob2o78b3ob2o135b2ob3o333b3o291b2o5b2o8b2o13bobobobo$59bobo29b3o487bo14bo3bo124bo2bobo70bo2bobo21bobob2o8b2o9b2o179bobo2bo78bobo2bo131bo2bobo279b3o5b3o45bobo290bo2bo3bo2bo6bobo12bob2ob2obo$58b2ob2o29b2o499b3o4bo124b2o74b2o26b2o207b2o82b2o131b2o282b2ob2o3b2ob2o43bo3bo290bo2bobo2bo15bo6b2o5b2o$101bo491b3obob2o938b2obobobobob2o43bo3bo293bobo17bobo37b2o5b2o$58b2ob2o7b3o27b3o6bo483b2o3bo941bo3bobo3bo211b2o127b3ob3o15bobo33b2o3bo5bo3b2o$59bob2o6bo2bo26b2obo4b3o1430bo2bo3bo2bo45b3o4b2o156bobo125b3o5b3o12b2ob2o32bo15bo$57bo13b2o26b3o4bo1434b3o3b3o53b2o155b3o6bo119b2o7b2o50bo13bo$57b2o9bo3bo27b2o4b2o1652b2ob3ob2ob2o81b2o26bo3bo3b2o7b2o$68bo2b2o1688b5ob2ob2o81bo2bo11b4o8bobobobo3bob2ob2obo38b3o$70bob2o60b2o5b2o1620bo5bo76b3o10b2o6b2o2bo6b2o2bobo2bob4o3b3o38bo2bo$134b2o5b2o1621b2ob2o76bo3bobo7b2o5b2o2bo7b2o7b2o2bo5bo39bo$1845bo3bobo3b2o10bo2bo7b2o2bobo2b2o21b3o3b3o18bo3bo$109bo409b3o5b3o1011b2o303b2o20b2o10bobobobo22bo2bo3bo2bo17bo3bo11b2o5b2o$107b3o409b3o5b3o207bo37b2o288b2o474b2o305bo3bo28bo3bo23b2obo3bob2o3b2ob2o9bo15b2obobob2o$106bo413b2o5b2o203bo3bo28b2o7bobo187bo3bo86b2o6b2ob2o14b2o679bo5bo10bo48bo38b2o54bobo11bobo12bo2bobo2bo$106b2o414bo3bo204bo7bo25b2o6b2obo81bo104bo5bo85b2o6bo2bo15b2o678b2o5b2o9b3o44b3o37bo2bo53bobo26b3o3b3o$520bo2bobo2bo202bo2b2o5bo32b2o14bo68bo3bo34bobo2b2o58bo99bo2bo694bob2o3b2obo11bo42bo32b2o5b2o2bo15b2o37bo$519bo3bobo3bo190bo11b2o5b2obo32bo14b3o57b2o2b2o8bo18b2o12bo3bob3o4b2o43bo7b2o3bo8bo86b2o695bob2o3b2obo10b2o42b2o18b2o5b2o4b2o6b2o2bo14b2o$62b2o7b2o447bo2bobo2bo189b3o12b3o3b2ob3o48bo56b2o2bo5b2o2bo18b2o13bo6b2o3b2o41b3o9b3o9b3o782b3o3b3o5b2o54b2o34b4o72b2o$62bob2o3b2obo447b3o3b3o188bo27bo29bo14b3o61bobo5b2o11bo23b5obo46bo27bo83b2o10b3ob3o679b3o3b3o6bo54bo12bo9bo76b2o10b2o$62bo3bobo3bo36bo608b3o12b3o3b2ob3o29b2o14bo64b2o3b3o12b3o24b3o48b3o9b3o9b3o83bo2bo8bob2ob2obo693bobo50bobo12bo3bobo3bo75bobo$62b2o2bobo2b2o34b3o610bo11b2o5b2obo30b2obo17bo83bo4bobo3bobo63bo7b2o3bo8bo77b2o6bo2bo7b2o7b2o693b2o50b2o13bo3bobo3bo76bo$63b3o3b3o34bo624bo2b2o5bo32bobo17b3o58b2o3b3o12b3o7bo3bo12b3o58bo91b2o6b2ob2o7bob2ob2obo762bobo3bobo88bo$64bo5bo35b2o623bo7bo35b2o20bo56bobo5b2o11bo5bo11bo5b5obo57bo5bo95b2o9b3ob3o764bo5bo44bo44b2ob2o$527b2o203bo3bo59b2o56bo5b2o2bo15bo3bo5bo3bo3bo6b2o3b2o52bo3bo820b2o28b2o77b3o38b3o2b2obo$527b2o208bo116b2o8bo16bo11bo3bo3bob3o4b2o877b2o27bo2bo79bo14b5o17bob2ob2o$859bo3bo21bo3bo8bobo2b2o995b2o13b7o16bo2b3o$65b2ob2o788bo24bobo3bobo926bo90bo5b5ob2o15b2o22b2o$66bobo6b2o32bo1683bo26bo3bo88bo6b2o18bo2bo18bo$66bobo7bo30b3o1654b2ob2o3b2o17b2obo21bo2b2o2bo12b2o73b2o4bo22b2o3b2o16b3o$67bo5b3o30bo995b2o661bobo5bo16bo2bo22bobo7bo9bo80bo47bo$73bo32b2o994b2o661bobo5bobo13b2o2bo22b3ob2o4b2o6bobo80bo$1766bo7b2o12bo31b2o5bo6b2o93bo5bo$122bo2bo1662b2o3bo12b2o5bo6b6o2b2o98b3o3b3o$70bo54bo7b3o1669b2o4b3obo9b2o19b2o5b2o72bo2b2ob2o2bo$68b3o50bo9bo4bo1654b2o3b2o9bo3bobobo2b2obobo2bo2bo16b2o5b2o72b3o5b3o$67bo41bo11b2o8bo5bo35bo1622b2o12b3o4b3o4bobo2b3o$67b2o38b3o17bo8bo36b2o1636bo8bo2bo7bo113bo7bo$81bo24bo17b2o8b2o24b2o9bob3o1613b2ob2o2b2o14b2o7b2o121bobo5bobo$79b3o24b2o52b2o13b2o509b2o5b2o105bo7b2o979b2ob2o19bo88bo7bo36bo3bo$78bo45b2o8b2o38b2o510b2o5b2o104b2o6bo2bo1089b2ob2o3b2ob2o31bo2bo3bo2bo$78b2o47bo8bo37bo391b2o5b2o96bo71bo54bo8bo2b2o161bob2o822b2o8b2o134bobo3bobo$64b3o54b2o8bo5bo10b2o412b2o2b2o5b2o2b2o91bobo69b2o55b2obo4bo2bo10bo150bo2b2o2b3o113b3o3b3o695bo10bo92bobobobo37b2ob2o$63bo2b2o53bo9bo4bo11b2o24bo387b2o13b2o90bo3bo3b2o62b2o57b3o6bo11b3o148bo6b2o113bo3bobo3bo695b3o4b3o91bo3bobo3bo32b2ob2ob2ob2o56bo$62bo3b2o57bo7b3o38b2o493b5o3b2o56bo6b2o2b2o9bo66bo34b2o109b4o3b3o12bo100bo3b2ob2o3bo696bo4bo93bo2b2ob2o2bo32b2o2bobo2b2o55bobo$63b3o56bo2bo34b2o13b2o10b2o479bobobobo58b3o21b3o40b3o6bo11b3o35bo108b3o3bo3bo13b3o98bob2o5b2obo682b2o30b2o80b3o3b3o34b3o3b3o56bobo$63b2o95b2o9bob3o11b2o480bo3bo58bo27bo36bob2obo4bo2bo10bo38b3o70bo33bo27bo99bo7bo684bo32bo81bo5bo36bo5bo58bo$66bo106b2o558b3o21b3o36bo10bo2b2o50bo70b3o32b3o3bo3bo13b3o794b3o26b3o$64b2o107bo495bo3bo61bo6b2o2b2o9bo38bo3bo6bo2bo125bo33b4o3b3o12bo798bo26bo79b2o13b2o9b2o13b2o$64b2o390b2o210bobobobo66b2o54b4o7b2o125b2o35bo6b2o917b2o2b2o5b2o2b2o9b2o2b2o5b2o2b2o$53b2o5b2o2b2o389bo2bo136b2o72b5o68b2o228bo2b2o2b3o584b2o90b2o242b2o5b2o17b2o5b2o8b2o5b2o$52bobo9b2o8b2o247b2o130bobobo10b2o2bobo90bo5bo21b2o72bo3bo69bo229bob2o589b2o81b2o7b2o79b2o204b2o5b2o$52bo6b3o12b2o247b2o131bo2bo3b2o4b3obo3bo12b2o74b3o3b3o95bobo13b3o3b3o954b2o88b2o$51b2o8b4o395bo2b2o3b2o6bo13b2o73b2ob2ob2ob2o95bo14b3o3b3o891b3o53b3o25bobo2b2o$63b3o391bobo9bob5o88b3o7b3o108bob2o3b2obo869b2o6b3o8b2obob2o50bo3bo11b2o10bo3bob3o$63bob2o403b3o212bob2o3b2obo869b2o6bo3bo5bo5b2o50b2ob2o11b2o11bo6b2o54bo5bo$62b2o2bo499bo7bo111b2o5b2o878bo4bo5b2obob2o80b5obo54b3o3b3o$62b2ob2o403b3o214bo5bo401b2o5b2o470bo3bo7b3o52b2ob2o28b3o55bob2ob2obo$63bobo403bob5o619b2o5b2o539bo87b2o7b2o$64bo403b2o6bo13b2o103b3o3b3o65b3o5b3o894bo3bo95b3o54b2o7b2o$469b3obo3bo12b2o102bo2bo3bo2bo63b2ob2o3b2ob2o892bo4bo92b5obo53b3o5b3o$57b2o411b2o2bobo90bo26b2obo3bob2o63b2obobobobob2o7b2ob2o872b2o6bo3bo12b2o65b2o11bo6b2o3b2o49b3ob3o$56bobo507b3o100bo3bobo3bo7bo5bo871b2o6b3o14b2o50bo7bo6b2o10bo3bob3o4b2o51bobo$56bo508bo2bo66b2o32bo2bo3bo2bo5b5ob2ob2o945bo2bo3bo2bo18bobo2b2o55bo2bobo2bo$55b2o301b2o205bobobo65bo2bobo29b3o3b3o5b2ob3ob2ob2o949bobo83bo2bo3bo2bo$6b2o53b2o36bo6b2o215b3o3b3o22bobo2bo206b3o68b2ob3o41b3o6bo872b2o77bobo10b2o72b2o5b2o$6b2o2b2o50bo37b2o4b2o215bo2bobo2bo20b3ob2o79b2o128bo5b2o68bo41bobo878b2o77bobo10b2o$10b2o47b3o37b2o222b2obobob2o19bo84bo2bo133b2o62b2ob3o43b2o263b4o5b6o675bo2bo3bo2bo$59bo263b2o5b2o20b4o80bo7bo179bo3bo8b2obo31b2ob2o219b6o5b4o40bob2o7b4o676b3o3b3o$108bo245bob2o13bo64bo2bo3bobo177bo5bo43bobo220b4o7b2obo40bo7bob2o$10b2o54b2o39bobo261b2o63b2ob2ob2ob2o182bo43bobo84b2o46b2o89b2obo7bo41b2o5b2o$10b2o26b2o25bobo15b2o23bo263b2o66bobo172bo8bo3b2o44bo84bo2bo44bo2bo90b2o5b2o$38b2o24b2obo15b2o24b3o63b2o190b2o2b2o6bo42b2o15b2ob2o169b3o9b3o132b2o46b2o142b2o5b2o$59bo5b2o44bo63b2o148b2ob2o28bobo18b3o40b2o70bo117bo288b2o5b2o41bo7bob2o1049b2o$28b3o26b3o6bo256bo2bobo2bo26bobo21bo3bo98b2o5b3o118b3o9b3o19bo251b2obo7bo26b2o12bob2o7b4o1046b2o$27bo4bo6b2o15bo112bo5bo147bobo3bobo15bo10b2o19b3o4b3o5b2o11b4o53b3o14b2o3bo4bo83b2o20b2ob2o13bo8bo3b2o7bo7b3o248b4o7b2obo12b2o12b2o12b4o5b6o672b2o13b2o73b2o13b2o$26bo5bo6b2o16b3o6bo15b2o84b3o3b3o146b3o3b3o15b3o9bo7b2o2b2o6bo9bo4bo3b2o6b2o2bo12b2o39bo3bo12b2o3bobo3bo82bo22bobo28bo4bo2bob2o3bo251b6o5b4o12b2o713b2o2b2o5b2o2b2o73b2o2b2o5b2o2b2o253b2o$27bo31bo5b2o15b2o20b2o62bo2bobo2bo146b2o5b2o18bo5b2obobo10b2o14bo3bobo3b2o5b2o2bo13b2o12b3o3b3o11bo6bo4bo17bobo3bo82bo21bobo22bo5bo10bo4bo996b2o5b2o81b2o5b2o247b2o7bobo13b2o$28b2o34b2obo35b2ob2o62b2ob2o148b2o5b2o17bo11bo9b2o14bo3bobo12bo2bo26bo9bo8b3o7bo3bo18bo3b2o81b2o22bo24bo3bo10bo4b2o1342b2o6b2obo13b2o$65bobo18b3o15b4o215b2o5b2o17b2o6bo2bo10bo15b2ob2o15b2o27bo3bobo3bo7bo1542b2o$28b2o36b2o18bobo16b2o252b2o76b3o3b3o9b3o7bo3bo7b3o95b2o58b5o1358bo$27bo58bobo318b2o29bo5bo12bo6bo4bo5b2obob2o92bobo59b4o1341bo$14b2o10bo5bo6b2o46bobo78bo7bo229bo2bo54bo3bo5bo5b2o93bo62bo1341b3o15bo$14b2o11bo4bo6b2o48bo79bobobobo229b2o2bo13b2o39b3o8b2obob2o45b5o1448b2obo13b2o$28b3o90bo47bobobobo230b2o2bo12b2o52b3o46bo4bo1464b2obo13b2o$121b3o44bob2ob2obo230b4o120bo1465bobo13b2o$38b2o48bo35bo43b2o5b2o317bo31bo3bo1467b2o$38b2o48bo34b2o20b2o47b2o226b2o69b2o33bo$110bo35bo46bobo226b2o69bobo1516b2o$110b3o33bobo44bo30b2o852bo933b2o$113bo33b2o43b2o30b2o226b2o5b2o605b2o5b6o8b4o293b2o5b2o439b2o5b2o105b2o6b2o7b2o$112b2o102b2o4bo13bo3b3o55b2o63b2o74b2ob2o4b2obobo5bobob2o45b2o554bo6bobobo9bo2b2o288b2o2b2o5b2o2b2o431b2o2b2o5b2o2b2o101bo7b2o6bo2b2o$216bo3b3o12bobo2b5o53bo7b3o5b4o35b2o6b2ob2o15b2o57bobo5b2ob2o7b2ob2o44b2o33bobo2b2o19b2o495bo5bo4bo9bo2b2o287b2o13b2o431b2o13b2o102bo5bo2bo4b6o18bo5bo$217bo3bobo11bo3b2o58bo6bo7b2obo35b2o6bo2bo17b2o34b2o5b2o13bobo7b6ob6o47b5o9bo18bo3bob3o19bo492b3o7bo13bo2bo4bo847b3o7b2obo5b4o9bo7b3o3b3o$214b3o5b2o12bo2bo3b2obo49b3o7b2obo7bo10bo32bo2bo16bo7b4o21b2o2b2o5b2o2b2o10bo10bob2ob2obo34b3o13b4o9b3o17bo6b2o15b3o493bo11b2o11b2o5b3o845bo9b2obo18b3o4b2o2bobo2b2o$79b2o7b2o11bo24bo87bo22b3o3b2ob3o47bo11b2o5b2o11b3o31b2o25bo2b2o20b2o13b2o62bo3bo29bo4bo12b5obo16bo530bo855bo23bo3bo3bobo3bo$79bob2o3b2obo10b3o22b3o121bo81bo58bo2b2o55bo11bo19bo9bo4bo13b4o9b3o3b3o15b3o538b2o5b3o285b3o3b3o563b2o18b3o4bob2o3b2obo$79bo3bobo3bo9b2obo21b2o2bo41b2ob2o62b3o3b2ob3o59b2o5b2o11b3o31b2o26bo2bo4bo52bo9bo18b3o9bo3bo13b5o9bo4bo558bo2bo4bo287bo2bobo2bo563b2o5b4o9bo6b2o7b2o$79b2o2bobo2b2o9b3o21b2o3b2o11b2o28bobo62bo2bo3b2obo61b2o7bo10bo32bo2bo26b2o5b3o52bobobobo19bo29b2o19b3o15b3o537bo2b2o290bo3bobo3bo567b6o$10b2o68b3o3b3o11b2o19bobo2bobo13bo10b3o8b2o5bobo61bo3b2o73b2obo35b2o6bo2bo36bo51bobobobo20b3o9bo3bo13b2o20bo12b5obo535bo2b2o291b4o3b4o568bo2b2o$10b2o69bo5bo33b2o3b2o9b2o3bobo7bo2bo4bo3b2o6bo62bobo2b5o69b4o35b2o6b2ob2o25b2o5b3o53b2ob2o23bo9bo4bo46bo6b2o3b2o513bob2o12b4o293bo7bo558bob2o8b2o$116b2o19bobo3b2o6bo3bo3bobo59bob2o11bo3b3o60bo59b2o25bo2bo4bo52bo2bo3bo2bo31bo3bo45bo3bob3o4b2o511b3ob2o874b3ob2o$6b2o6b2o100b2o21bo11bo7bobo57b3ob2o76b6o83bo2b2o23bo7bo25b2o5b2o34b3o46bobo2b2o517bo763bo7bo107bo$6b2o2b2o2bo61b2o13b2o46b2o13bo63bo81bo4bo83bo2b2o675b3ob2o756bobo5bobo107b3ob2o$10b2o3b3o58b2o2b2o5b2o2b2o58b2obo64b3ob2o76b3ob2o82b4o23b3o7b3o642bobo2bo757bo3bo112bobo2bo$18bo61b2o5b2o132bobo2bo32bo43bobo2bo108b2ob2ob2ob2o647b2o754bo2bo3bo2bo113b2o$17bo154b2o51b2o31b2o47b2o109b3o3b3o1405bobo3bobo$16bo137bob2o14bobo82b2o160bo5bo959bo448b2ob2o$15bo138b3o17bo83b2o2b2o9bo1110b3o444b2ob2ob2ob2o$14bo76bo63bo18b2o68b3o26b3o21bo1085bo3bo443b2o2bobo2b2o138b2o13b2o$13bo77bo2b2o72b2o23b2o9b3ob3o31bo3bo29bo16b2o2bo1085b2ob2o444b3o3b3o139b2o2b2o5b2o2b2o$12bo77bo5bo36b2o33bo22b2ob2o7bob2ob2obo19bo9bo4bo26b3o16bo5bo1084b2ob2o445bo5bo144b2o5b2o$11bo79bobo2b2o35bobo33b3o19bo2bo7b2o7b2o16b3o9bo3bo12b2o2b2o9bo17b2o2bobo$12b3o63bo12bo3b2o38bo35bo14bo4bo2bo8bob2ob2obo16bo28b2o33b2o3bo12bo1072b2ob2o$15bo60b3o14b3o39b2o20b2o25b3o5b2o10b3ob3o18b3o9bo3bo12b2o33b3o14b3o1070b2ob2o$14bo60bo41b2o10b2o26bo25bo47bo9bo4bo12bo53bo138b2o632b2o295bo3bo3b2o439b2o$13bo62b3o14b3o20bo2bo9bo28b3o23b3o5b2o48bo3bo46b3o14b3o107b2ob2o27b2o631bo2bo295b3o4b2o439b2o$12bo65bo12bo3b2o20b2o11b3o27bo25bo4bo2bo49b3o45b2o3bo12bo110bobo662b2o297bo660b2o$11bo79bobo2b2o4b2o28bo58bo2bo15b2o59bo13b2o4b2o2bobo123bobo1622b2o$12b3o75bo5bo5b2o87b2ob2o14b2o57b3o13b2o5bo5bo123bo1613bo$15bo75bo2b2o97b2o67bo5bo24b2o2bo1737bo2bo$14bo76bo168bobo5b2o27bo1736b5o8b2o$13bo247b2o1707b2o5b2o54b2ob3o8b2o$12bo1953b2o2b2o5b2o2b2o51bob2o$11bo1954b2o13b2o52b2o$12b3o$15bo2019b2o$14bo18b2o4b3o1992bob2o$13bo19b2o3bo3bo1822bo156b2o9b2ob3o8b2o$12bo25b2ob2o1817bo3bo157b2o10b5o8b2o$11bo27bobo1817bo8b2o2b2o161bo2bo$12b3o224bo31b2o1586bo2b2o5bo2b2o7b2o5b2o80bo7bo57bo$15bo23bobo193b2o2bo16b2o13bo1588b2o5bobo7b2o2b2o5b2o2b2o75bo2bo3bo2bo66b2o$14bo23b2ob2o191bo5bo14bobo14b3o1586b3o3b2o8b2o13b2o79bobo70b2o$13bo24bo3bo190b2o2bobo17bo16bo78b2o2b2o4bo2b2o12b2o1591bobo$12bo26b3o188bo3b2o3bo22b2o3bo85b2ob2o6b2obo12b2o1479b3o3b2o104bobo$11bo216b3o4b3o24b3obob2o87bobo6bo1493b2o5bobo99bo2bo3bo2bo$12b3o212bo34b3o4bo88b2o4b3o1478b2o12bo2b2o5bo2b2o96b3o3b3o$15bo212b3o4b3o27bo3bo2bo1572b2o12bo8b2o2b2o$14bo215bo3b2o3bo26b3o3b3o83b2o4b3o1493bo3bo$13bo219b2o2bobo35bo81bobo6bo1498bo$12bo221bo5bo25b3o3b3o78b2ob2o6b2obo$11bo223b2o2bo25bo3bo2bo80b2o2b2o4bo2b2o$12b3o224bo22b3o4bo635b2o974b2o5b2o$15bo16b3o5b3o219b3obob2o633b2o2bo972bo2bo3bo2bo109bo$5b3o6bo17bo2b2ob2o2bo219b2o3bo635b6o972bo2bobo2bo109bobo$5bo2bo4bo19b3o3b3o861b4o4bo3bo968bobo112bo2bo$5bo6bo21bo5bo870b7o964b3ob3o88b2o18bobo3bo5bo5bo5bo5bo5bo5bo5bo$5bo5bo906bo961b3o5b3o86b2o18b2o5bo3bobo3bobo3bobo3bobo3bobo3bobo3bobo$6bobo3b3o896b7o962b2o7b2o114bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo2bo$15bo887b4o4bo3bo964b2o7b2o115bobo3bobo3bobo3bobo3bobo3bobo3bobo3bo$14bo14b2o13b2o844b2o11b6o972bob2ob2obo71b2o2b2o27b2o2b2o7bo5bo5bo5bo5bo5bo5bo3b2o$11bobo15b2o2b2o5b2o2b2o844b2o11b2o2bo973b3o3b3o71b2o2b2o27b2o2b2o$11b2o20b2o5b2o863b2o975bo5bo$1009b2o1030bo2bo$1008bobo949b2o35b2o41bo$1008bo41b2o829b2o77b2o35b2o41bo3bo$4b2o1001b2o41b2o829b2o157b4o8b2o$4b2o2046b2o2$bo2054bo$obo2052bobo$bo2054bo", null, 3, 3, 2048, 2048);
        }

        private function parseRLE(w:int, h:int, offsetX:int, offsetY:int, data:String, cell:Node = null, repx:int = 1, repy:int = 1, repdx:int = 0, repdy:int = 0):void {
            //var bmd:BitmapData = new BitmapData(w, h, false);
            var y:int = 0;
            var pos:int = 0;
            var len:int = data.length;
            var x:int = 0;
            while (pos < len) {
                switch(data.charAt(pos)) {
                case "b":
                    x++;
                    break;
                case "o":
                    //bmd.setPixel(x, y, 0);
                    if (cell) {
                        for (var i:int = 0; i < repx; i++) {
                            for (var j:int = 0; j < repy; j++) {
                                field.setCellAtLevel(x + i * repdx + offsetX, y + j * repdy + offsetY, cell);
                            }
                        }
                    } else {
                        for (i = 0; i < repx; i++) {
                            for (j = 0; j < repy; j++) {
                                field.setCell(x + i * repdx + offsetX, y + j * repdy + offsetY);
                            }
                        }
                    }
                    x++;
                    break;
                case "1":
                case "2":
                case "3":
                case "4":
                case "5":
                case "6":
                case "7":
                case "8":
                case "9":
                    var num:String = data.charAt(pos);
                    while (data.charAt(++pos) != "b" && data.charAt(pos) != "o" && data.charAt(pos) != "$") num += data.charAt(pos);
                    var numPix:int = parseInt(num);
                    if (data.charAt(pos) == "b") x += numPix;
                    else if (data.charAt(pos) == "o") for (var k:int = 0; k < numPix; k++) {
                        // bmd.setPixel(x, y, 0);
                        if (cell) {
                            for (i = 0; i < repx; i++) {
                                for (j = 0; j < repy; j++) {
                                    field.setCellAtLevel(x + i * repdx + offsetX, y + j * repdy + offsetY, cell);
                                }
                            }
                        } else {
                            for (i = 0; i < repx; i++) {
                                for (j = 0; j < repy; j++) {
                                    field.setCell(x + i * repdx + offsetX, y + j * repdy + offsetY);
                                }
                            }
                        }
                        x++;
                    } else if (data.charAt(pos) == "$") {
                        x = 0;
                        y += numPix;
                    } else throw new Error(pos + " " + data.charAt(pos));
                    break;
                case "$":
                    x = 0;
                    y++;
                    break;
                default:
                    throw new Error(pos + " " + data.charAt(pos));
                }
                pos++;
            }
        }

        private function frame(e:Event):void {
            if (gcCount == 0 && field.nm.shouldRunGC()) gcCount = 120;
            if (gcCount > 0 &&--gcCount == 0) field.gc();
            update();
            draw();
        }

        private function update():void {
            if (pressing) {
                shiftX += (mouseX - pmouseX << levelShift) / (1 << drawScale);
                shiftY += (mouseY - pmouseY << levelShift) / (1 << drawScale);
                if (shiftX > -(1 << 16)) shiftX = -(1 << 16);
                if (shiftY > -(1 << 16)) shiftY = -(1 << 16);
                if (shiftX < -(1 << 18) + (1 << 16)) shiftX = -(1 << 18) + (1 << 16);
                if (shiftY < -(1 << 18) + (1 << 16)) shiftY = -(1 << 18) + (1 << 16);
            }
            shiftX2 += (shiftX - shiftX2) * 0.2;
            shiftY2 += (shiftY - shiftY2) * 0.2;
            if (pause) {
                if (calcStep) {
                    calcStep = false;
                    field.step();
                }
            } else field.step();
            pmouseX = mouseX;
            pmouseY = mouseY;
        }

        private function draw():void {
            bmd.colorTransform(bmd.rect, ct);
            pixels = bmd.getVector(bmd.rect);
            invPixelArea = 1 / (1.0 * (1 << levelShift) * (1 << levelShift));
            drawNode(field.universe, field.level - levelShift, (465 >> 1) + (shiftX2 * (1 << drawScale) >> levelShift), (425 >> 1) + (shiftY2 * (1 << drawScale) >> levelShift));
            bmd.setVector(bmd.rect, pixels);
        }

        private function drawNode(node:Node, level:int, left:Number, top:Number):void {
            if (level == 0) {
                if (node.population * invPixelArea > 0.008) {
                    var size:int = 1 << drawScale;
                    if (size > 2) size--;
                    var x:int = left;
                    for (var i:int = 0; i < size; i++) {
                        var y:int = top;
                        var offset:int = y * 465;
                        for (var j:int = 0; j < size; j++) {
                            if (x >= 0 && y >= 0 && x < 465 && y < 425) pixels[offset + x] = 0x30ffd0;
                            y++;
                            offset += 465;
                        }
                        x++;
                    }
                }
            } else {
                var nodeSize:int = 1 << drawScale << level;
                if (left + nodeSize < 0 || top + nodeSize < 0 || left > 465 || top > 425) return;
                level--;
                var subNodeSize:int = nodeSize >> 1;
                drawNode(node.e00, level, left, top);
                drawNode(node.e01, level, left + subNodeSize, top);
                drawNode(node.e10, level, left, top + subNodeSize);
                drawNode(node.e11, level, left + subNodeSize, top + subNodeSize);
            }
        }

    }

}

class Field {
    internal var universe:Node;
    internal var level:int;
    internal var nm:NodeManager;
    internal var speed:int;

    public function Field() {
        nm = new NodeManager();
    }

    internal function init(level:int):void {
        universe = createEmptyNode(level);
        this.level = level;
        speed = 0;
    }

    internal function setSpeed(speed:int):void {
        if (this.speed != speed) nm.clearSlowCache();
        this.speed = speed;
    }

    internal function setCell(x:int, y:int):void {
        if (x < 0 || y < 0 || x >= (1 << level) || y >= (1 << level)) return;
        universe = setAlive(universe, x, y, 0, 0);
    }

    internal function setCellAtLevel(x:int, y:int, nodeToSet:Node):void {
        if (x < 0 || y < 0 || x >= (1 << level - nodeToSet.level) || y >= (1 << level - nodeToSet.level)) return;
        universe = setNodeAtLevel(universe, x, y, 0, 0, nodeToSet);
    }

    private function setAlive(node:Node, x:int, y:int, left:int, top:int):Node {
        if (node.level == 0) return nm.leafNodes[1];
        var subNodeSize:int = 1 << node.level - 1;
        var inL:Boolean = x < left + subNodeSize;
        var inT:Boolean = y < top + subNodeSize;
        if (inT) if (inL) return nm.getNode(setAlive(node.e00, x, y, left, top), node.e01, node.e10, node.e11);
        else return nm.getNode(node.e00, setAlive(node.e01, x, y, left + subNodeSize, top), node.e10, node.e11);
        else if (inL) return nm.getNode(node.e00, node.e01, setAlive(node.e10, x, y, left, top + subNodeSize), node.e11);
        else return nm.getNode(node.e00, node.e01, node.e10, setAlive(node.e11, x, y, left + subNodeSize, top + subNodeSize));
    }

    private function setNodeAtLevel(node:Node, x:int, y:int, left:int, top:int, nodeToSet:Node):Node {
        if (node.level - nodeToSet.level == 0) return nodeToSet;
        var subNodeSize:int = 1 << node.level - nodeToSet.level - 1;
        var inL:Boolean = x < left + subNodeSize;
        var inT:Boolean = y < top + subNodeSize;
        if (inT) if (inL) return nm.getNode(setNodeAtLevel(node.e00, x, y, left, top, nodeToSet), node.e01, node.e10, node.e11);
        else return nm.getNode(node.e00, setNodeAtLevel(node.e01, x, y, left + subNodeSize, top, nodeToSet), node.e10, node.e11);
        else if (inL) return nm.getNode(node.e00, node.e01, setNodeAtLevel(node.e10, x, y, left, top + subNodeSize, nodeToSet), node.e11);
        else return nm.getNode(node.e00, node.e01, node.e10, setNodeAtLevel(node.e11, x, y, left + subNodeSize, top + subNodeSize, nodeToSet));
    }

    internal function gc():void {
        nm.gc(universe);
    }

    internal function step():void {
        var d:int = universe.level - 1;
        while (
            universe.level < 3 + speed ||
            universe.e00.population != universe.e00.e11.e11.population ||
            universe.e01.population != universe.e01.e10.e10.population ||
            universe.e10.population != universe.e10.e01.e01.population ||
            universe.e11.population != universe.e11.e00.e00.population
        ) {
            var emptyNode:Node = createEmptyNode(d);
            universe = nm.getNode(
                nm.getNode(emptyNode, emptyNode, emptyNode, universe.e00),
                nm.getNode(emptyNode, emptyNode, universe.e01, emptyNode),
                nm.getNode(emptyNode, universe.e10, emptyNode, emptyNode),
                nm.getNode(universe.e11, emptyNode, emptyNode, emptyNode)
            );
            d++;
        }
        universe = universe.step(nm, speed);
        level = universe.level;
    }

    private function createEmptyNode(level:int):Node {
        if (level == 0) return nm.leafNodes[0];
        var node:Node = createEmptyNode(level - 1);
        return nm.getNode(node, node, node, node);
    }
}

class NodeManager {
    private var map:Vector.<Node>;
    private var stack:Vector.<Node>;
    private var nodePool:Node;
    private var alive:Node;
    private var dead:Node;
    internal var speed:int;
    internal var leafNodes:Vector.<Node>;

    public function NodeManager() {
        map = new Vector.<Node>(0x800000, true);
        stack = new Vector.<Node>(0x10000, true);
        leafNodes = new Vector.<Node>(2, true);
        leafNodes[0] = new Node(0, false);
        leafNodes[1] = new Node(0, true);
    }

    internal function shouldRunGC():Boolean {
        return !nodePool;
    }

    internal function clearSlowCache():void {
        for (var i:int = 0; i < 0x800000; i++) {
            var node:Node = map[i];
            while (node) {
                node.cachedNextGen = null;
                node = node.nextLinkList;
            }
        }
    }

    internal function gc(universe:Node):void {
        var stackCount:int = 1;
        const stack:Vector.<Node> = this.stack;
        stack[0] = universe;
        while (stackCount > 0) { // depth-first search
            var node:Node = stack[--stackCount];
            if (!node.gcCheck) {
                node.gcCheck = true;
                if (node.level > 1) {
                    stack[stackCount++] = node.e00;
                    stack[stackCount++] = node.e01;
                    stack[stackCount++] = node.e10;
                    stack[stackCount++] = node.e11;
                    if (node.cachedNextPow2Gen) stack[stackCount++] = node.cachedNextPow2Gen;
                    if (node.cachedNextGen) stack[stackCount++] = node.cachedNextGen;
                }
            }
        }
        const map:Vector.<Node> = this.map;
        for (var i:int = 0; i < 0x800000; i++) {
            node = map[i];
            var prev:Node = null;
            while (node) {
                var next:Node = node.nextLinkList;
                if (node.gcCheck) { // release caches collected
                    if (node.cachedNextPow2Gen && !node.cachedNextPow2Gen.gcCheck) node.cachedNextPow2Gen = null;
                    if (node.cachedNextGen && !node.cachedNextGen.gcCheck) node.cachedNextGen = null;
                    prev = node;
                } else { // delete and pool the node
                    node.nextLinkList = nodePool;
                    nodePool = node;
                    if (prev) prev.nextLinkList = next;
                    else map[i] = next;
                }
                node = next;
            }
        }
        for (i = 0; i < 0x800000; i++) {
            node = map[i];
            while (node) {
                node.gcCheck = false; // reset flag for next gc
                node = node.nextLinkList;
            }
        }
    }

    private function putNode(node:Node, index:int):Node {
        node.nextLinkList = map[index];
        map[index] = node;
        return node;
    }

    internal function getNode(e00:Node, e01:Node, e10:Node, e11:Node):Node {
        var hash:int = Node.calcHash(e00, e01, e10, e11);
        var index:int = hash & 0x7fffff;
        var list:Node = map[index];
        while (list) {
            if (e00 == list.e00 && e01 == list.e01 && e10 == list.e10 && e11 == list.e11) return list;
            list = list.nextLinkList;
        }
        if (!nodePool) return putNode(new Node(e00.level + 1, false, e00, e01, e10, e11), index);
        var node:Node = nodePool;
        nodePool = nodePool.nextLinkList;
        node.init(e00.level + 1, false, e00, e01, e10, e11);
        return putNode(node, index);
    }
}

class Node {
    private static var ID_COUNT:int = 0;
    internal var level:int;
    internal var e00:Node;
    internal var e01:Node;
    internal var e10:Node;
    internal var e11:Node;
    internal var cachedNextPow2Gen:Node;
    internal var cachedNextGen:Node;
    internal var nextLinkList:Node;
    internal var id:int;
    internal var population:int;
    internal var gcCheck:Boolean;

    public function Node(level:int, alive:Boolean, e00:Node = null, e01:Node = null, e10:Node = null, e11:Node = null) {
        init(level, alive, e00, e01, e10, e11);
    }

    internal function init(level:int, alive:Boolean, e00:Node = null, e01:Node = null, e10:Node = null, e11:Node = null):void {
        this.e00 = e00;
        this.e01 = e01;
        this.e10 = e10;
        this.e11 = e11;
        this.level = level;
        population = level == 0 ? alive ? 1 : 0 : e00.population + e01.population + e10.population + e11.population;
        id = ++ID_COUNT;
        cachedNextPow2Gen = null;
        cachedNextGen = null;
        nextLinkList = null;
        gcCheck = false;
    }

    internal function hashCode():int {
        if (level == 0) return population;
        var t:int = 527 + e00.id;
        t = (t << 5) - t + e01.id;
        t = (t << 5) - t + e10.id;
        return (t << 5) - t + e11.id;
    }

    internal static function calcHash(e00:Node, e01:Node, e10:Node, e11:Node):int {
        var t:int = 527 + e00.id;
        t = (t << 5) - t + e01.id;
        t = (t << 5) - t + e10.id;
        return (t << 5) - t + e11.id;
    }

    internal function step(nm:NodeManager, speed:int):Node {
        if (level == 2) { // based on bitboard
            if (cachedNextPow2Gen) return cachedNextPow2Gen;
            if (population == 0) return cachedNextPow2Gen = e00;
            var p00:int = e00.e00.population;
            var p01:int = e00.e01.population;
            var p02:int = e01.e00.population;
            var p03:int = e01.e01.population;
            var p10:int = e00.e10.population;
            var p11:int = e00.e11.population;
            var p12:int = e01.e10.population;
            var p13:int = e01.e11.population;
            var p20:int = e10.e00.population;
            var p21:int = e10.e01.population;
            var p22:int = e11.e00.population;
            var p23:int = e11.e01.population;
            var p30:int = e10.e10.population;
            var p31:int = e10.e11.population;
            var p32:int = e11.e10.population;
            var p33:int = e11.e11.population;
            var n00:int = p00 << 3 | p01 << 2 | p10 << 1 | p11;
            var n01:int = p01 << 3 | p02 << 2 | p11 << 1 | p12;
            var n02:int = p02 << 3 | p03 << 2 | p12 << 1 | p13;
            var n10:int = p10 << 3 | p11 << 2 | p20 << 1 | p21;
            var n11:int = p11 << 3 | p12 << 2 | p21 << 1 | p22;
            var n12:int = p12 << 3 | p13 << 2 | p22 << 1 | p23;
            var n20:int = p20 << 3 | p21 << 2 | p30 << 1 | p31;
            var n21:int = p21 << 3 | p22 << 2 | p31 << 1 | p32;
            var n22:int = p22 << 3 | p23 << 2 | p32 << 1 | p33;
            var s0:int = ~(n00 | n01);
            var s1:int = n00 ^ n01;
            var s2:int = n00 & n01;
            var s3:int = n02 & s2;
            s2 = s2 & ~n02 | s1 & n02;
            s1 = s1 & ~n02 | s0 & n02;
            s0 &= ~n02;
            s3 = s3 & ~n10 | s2 & n10;
            s2 = s2 & ~n10 | s1 & n10;
            s1 = s1 & ~n10 | s0 & n10;
            s0 &= ~n10;
            s3 = s3 & ~n12 | s2 & n12;
            s2 = s2 & ~n12 | s1 & n12;
            s1 = s1 & ~n12 | s0 & n12;
            s0 &= ~n12;
            s3 = s3 & ~n20 | s2 & n20;
            s2 = s2 & ~n20 | s1 & n20;
            s1 = s1 & ~n20 | s0 & n20;
            s0 &= ~n20;
            s3 = s3 & ~n21 | s2 & n21;
            s2 = s2 & ~n21 | s1 & n21;
            s1 = s1 & ~n21 | s0 & n21;
            s3 = s3 & ~n22 | s2 & n22;
            s2 = s2 & ~n22 | s1 & n22;
            n11 = s3 | (s2 & n11);
            return cachedNextPow2Gen = nm.getNode(nm.leafNodes[n11 >> 3 & 1], nm.leafNodes[n11 >> 2 & 1], nm.leafNodes[n11 >> 1 & 1], nm.leafNodes[n11 & 1]);
        } else {
            if (population == 0) return cachedNextPow2Gen = cachedNextGen = e00;
            var t00:Node;
            var t01:Node;
            var t02:Node;
            var t10:Node;
            var t11:Node;
            var t12:Node;
            var t20:Node;
            var t21:Node;
            var t22:Node;
            if (level > speed + 2) { // calc slowly
                if (cachedNextGen) return cachedNextGen;
                t00 = nm.getNode(e00.e00.e11, e00.e01.e10, e00.e10.e01, e00.e11.e00);
                t01 = nm.getNode(e00.e01.e11, e01.e00.e10, e00.e11.e01, e01.e10.e00);
                t02 = nm.getNode(e01.e00.e11, e01.e01.e10, e01.e10.e01, e01.e11.e00);
                t10 = nm.getNode(e00.e10.e11, e00.e11.e10, e10.e00.e01, e10.e01.e00);
                t11 = nm.getNode(e00.e11.e11, e01.e10.e10, e10.e01.e01, e11.e00.e00);
                t12 = nm.getNode(e01.e10.e11, e01.e11.e10, e11.e00.e01, e11.e01.e00);
                t20 = nm.getNode(e10.e00.e11, e10.e01.e10, e10.e10.e01, e10.e11.e00);
                t21 = nm.getNode(e10.e01.e11, e11.e00.e10, e10.e11.e01, e11.e10.e00);
                t22 = nm.getNode(e11.e00.e11, e11.e01.e10, e11.e10.e01, e11.e11.e00);
                return cachedNextGen = nm.getNode(
                    nm.getNode(t00, t01, t10, t11).step(nm, speed),
                    nm.getNode(t01, t02, t11, t12).step(nm, speed),
                    nm.getNode(t10, t11, t20, t21).step(nm, speed),
                    nm.getNode(t11, t12, t21, t22).step(nm, speed)
                );
            } else { // calc quickly
                if (cachedNextPow2Gen) return cachedNextPow2Gen;
                t00 = e00.step(nm, speed);
                t01 = nm.getNode(e00.e01, e01.e00, e00.e11, e01.e10).step(nm, speed);
                t02 = e01.step(nm, speed);
                t10 = nm.getNode(e00.e10, e00.e11, e10.e00, e10.e01).step(nm, speed);
                t11 = nm.getNode(e00.e11, e01.e10, e10.e01, e11.e00).step(nm, speed);
                t12 = nm.getNode(e01.e10, e01.e11, e11.e00, e11.e01).step(nm, speed);
                t20 = e10.step(nm, speed);
                t21 = nm.getNode(e10.e01, e11.e00, e10.e11, e11.e10).step(nm, speed);
                t22 = e11.step(nm, speed);
                return cachedNextPow2Gen = nm.getNode(
                    nm.getNode(t00, t01, t10, t11).step(nm, speed),
                    nm.getNode(t01, t02, t11, t12).step(nm, speed),
                    nm.getNode(t10, t11, t20, t21).step(nm, speed),
                    nm.getNode(t11, t12, t21, t22).step(nm, speed)
                );
            }
        }
    }
}