/**
 * Copyright Robbie.Maglone ( http://wonderfl.net/user/Robbie.Maglone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/SjMb
 */

// forked from kstyle's forked from: LightFolium
// forked from ProjectNya's LightFolium
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] LightFoliumクラスだ！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1131
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var flare:FlareMap;
        private var detection:DetectPixels;
        private static var max:uint = 30;
        private static var cx:int = 232;
        private static var cy:int = 250;
        private static var fw:uint = 340;
        private static var fh:uint = 360;
        private static var tw:uint = 320;
        private static var th:uint = 320;
        private var area:Rectangle;
        private var folium:Sprite;
        private var lights:Array;
        private var nx:uint = 1;
        private var ny:uint = 1;

        public function Main() {
            Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            folium = new Sprite();
            addChild(folium);
            folium.x = cx - fw*0.5;
            folium.y = fh - th;
            lights = new Array();
            for (var n:uint = 0; n < max; n++) {
                var light:LightFolium = new LightFolium();
                var angle:Number = 360/max*n;
                light.init(fw*0.5, cy - fh + th, angle);
                folium.addChild(light);
                light.fly(150, 1, nx, ny);
                lights.push(light);
            }
            var rect:Rectangle = new Rectangle(0, 0, fw, fh);
            flare = new FlareMap(rect);
            addChild(flare);
            flare.x = cx;
            flare.y = fh;
            area = new Rectangle(0, fh - th, tw, th);
            detection = new DetectPixels(4);
            detection.search(folium, area, 0x66FFFFFF);
            flare.map = detection.pixels();
            flare.setup(6, 2, 60);
            flare.start();
            addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, change, false, 0, true);
        }
        private function draw(evt:Event):void {
            detection.search(folium, area, 0x66FFFFFF);
            flare.map = detection.pixels();
        }
        private function change(evt:Event):void {
            nx = Math.max(9 - uint(Math.abs((stage.mouseX - cx)/232*9)), 1);
            ny = Math.max(9- uint(Math.abs((stage.mouseY - cy)/232*9)), 1);
            apply();
        }
        private function apply():void {
            for (var n:Number = 0; n < max; n++) {
                var light:LightFolium = lights[n];
                light.fly(150, 1, nx, ny);
            }
        }

    }

}


import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.events.Event;

class LightFolium extends Sprite {
    private var light:Light;
    private var blink:Number;
    private var b:Number;
    private static var color1:uint = 0x66FFFF;
    private static var color2:uint = 0x3399FF;
    private var trans:ColorTransform;
    private var tx:Number;
    private var ty:Number;
    private var cx:Number;
    private var cy:Number;
    private var r:Number;
    private var angle:Number;
    private var a:Number;
    private var nx:Number;
    private var ny:Number;
    private static var radian:Number = Math.PI/180;
    private static var deceleration:Number = 0.2;

    public function LightFolium() {
        light = new Light();
        addChild(light);
        trans = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
    }

    public function init(x:int, y:int, a:Number):void {
        this.x = cx = x;
        this.y = cy = y;
        angle = a;
        _blink(angle, 10);
    }
    private function _blink(blink:Number, b:Number):void {
        this.blink = blink;
        this.b = b;
    }
    private function blinking():void {
        blink += b;
        setRGB(Math.sin(blink*radian));
        light.transform.colorTransform = trans;
    }
    private function setRGB(percent:Number):void {
        var r1:int = (color1 >> 16 & 0xFF);
        var g1:int = (color1 >> 8 & 0xFF);
        var b1:int = (color1 & 0xFF);
        var r2:int = (color2 >> 16 & 0xFF);
        var g2:int = (color2 >> 8 & 0xFF);
        var b2:int = (color2 & 0xFF);
        trans.alphaMultiplier = 0.75 + 0.5*percent;
        trans.redOffset = (r1 + r2)*0.5 + (r2 - r1)*0.5*percent;
        trans.greenOffset = (g1 + g2)*0.5 + (g2 - g1)*0.5*percent;
        trans.blueOffset = (b1 + b2)*0.5 + (b2 - b1)*0.5*percent;
    }
    public function fly(r:Number, a:Number, nx:Number, ny:Number, dec:Number = 0.2):void {
        this.r = r;
        this.a = a;
        this.nx = nx;
        this.ny = ny;
        deceleration = dec;
        addEventListener(Event.ENTER_FRAME, flying, false, 0, true);
    }
    private function flying(evt:Event):void {
        blinking();
        angle += a;
        tx = cx + r*Math.sin(angle*nx*radian)*Math.cos(angle*radian);
        ty = cy + r*Math.sin(angle*ny*radian)*Math.sin(angle*radian);
        x += (tx - x)*deceleration;
        y += (ty - y)*deceleration;
    }

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Light extends Shape {
    private static var center:uint = 3;
    private static var light:uint = 15;
    private static var color:uint = 0xFFFFFF;

    public function Light() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, center);
        graphics.endFill();
        var colors:Array = [color, color];
        var alphas:Array = [0.6, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(light*2, light*2, 0, -light, -light);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
        graphics.drawCircle(0, 0, light);
        graphics.endFill();
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.filters.BlurFilter;
import flash.display.BlendMode;
//import sketchbook.colors.ColorUtil;

class FlareMap extends Sprite {
    private var rect:Rectangle;
    private var fire:Rectangle;
    private var flare:BitmapData;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var rPalette:Array;
    private var gPalette:Array;
    private var bPalette:Array;
    private static var point:Point = new Point(0, 0);
    private var speed:Point = new Point(0, -6);
    private var unit:uint = 8;
    private var segments:uint = 8;
    private var blur:BlurFilter;
    private var mapList:Array;
    private var faded:uint = 0;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FlareMap(r:Rectangle) {
        rect = r;
        initialize();
        draw();
    }

    public function setup(s:uint = 6, u:uint = 8, seg:uint = 8):void {
        speed.y = - s;
        unit = u;
        segments = seg;
    }
    public function set map(list:Array):void {
        mapList = list;
    }
    private function initialize():void {
        rPalette = new Array();
        gPalette = new Array();
        bPalette = new Array();
        for (var n:uint = 0; n < 256; n++) {
            var luminance:uint = (n < 128) ? n*2 : 0;
            //var rgb:Object = ColorUtil.HLS2RGB(n*360/256, luminance, 100);
            var rgb:Object = HLS2RGB(n*360/256, luminance, 100);
            var color:uint = rgb.r << 16 | rgb.g << 8 | rgb.b;
            rPalette[n] = color;
            gPalette[n] = 0;
            bPalette[n] = 0;
        }
        blur = new BlurFilter(2, 8, 3);
        blendMode = BlendMode.ADD;
    }
    private function draw():void {
        fire = new Rectangle(0, 0, rect.width, rect.height + 10);
        flare = new BitmapData(fire.width, fire.height, false, 0xFF000000);
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        bitmap.x = - rect.width*0.5;
        bitmap.y = - rect.height;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, apply, false, 0, true);
    }
    private function apply(evt:Event):void {
        if (!mapList) return;
        flare.lock();
        bitmapData.lock();
        for (var n:uint = 0; n < segments; n++) {
            var id:uint = Math.random()*mapList.length;
            var px:int = mapList[id].x;
            var py:int = mapList[id].y;
            var range:Rectangle = new Rectangle(px, py, unit, 2)
            flare.fillRect(range, 0xFFFFFF);
        }
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        flare.unlock();
        bitmapData.unlock();
    }
    private function clear(evt:Event):void {
        faded ++;
        flare.lock();
        bitmapData.lock();
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        if (faded > 20) {
            bitmapData.fillRect(rect, 0x000000);
            removeEventListener(Event.ENTER_FRAME, clear);
            dispatchEvent(new Event(FlareMap.COMPLETE));
        }
        flare.unlock();
        bitmapData.unlock();
    }
    private function createEggMask(target:Shape):void {
        var w:Number = rect.width;
        var h:Number = rect.height*1.5;
        target.graphics.beginFill(0xFFFFFF);
        target.graphics.moveTo(-w*0.5, -h*0.2);
        target.graphics.curveTo(-w*0.4, -h, 0, -h);
        target.graphics.curveTo(w*0.4, -h, w*0.5, -h*0.2);
        target.graphics.curveTo(w*0.5, 0, 0, 0);
        target.graphics.curveTo(-w*0.5, 0, -w*0.5, -h*0.2);
        target.graphics.endFill();
    }
    private function HLS2RGB(h:Number, l:Number, s:Number):Object{
        var max:Number;
        var min:Number;
        h = (h < 0)? h % 360+360 : (h>=360)? h%360: h;
        l = (l < 0)? 0 : (l > 100)? 100 : l;
        s = (s < 0)? 0 : (s > 100)? 100 : s;
        l *= 0.01;
        s *= 0.01;
        if (s == 0) {
            var val:Number = l*255;
            return {r:val, g:val, b:val};
        }
        if (l < 0.5) {
            max = l*(1 + s)*255;
        } else {
            max = (l*(1 - s) + s)*255;
        }
        min = (2*l)*255 - max;
        return _hMinMax2RGB(h, min, max);
    }
    private function _hMinMax2RGB(h:Number, min:Number, max:Number):Object{
        var r:Number;
        var g:Number;
        var b:Number;
        var area:Number = Math.floor(h/60);
        switch(area){
            case 0:
                r = max;
                g = min + h * (max - min)/60;
                b = min;
                break;
            case 1:
                r = max - (h - 60)*(max - min)/60;
                g = max;
                b = min;
                break;
            case 2:
                r = min ;
                g = max;
                b = min + (h - 120)*(max - min)/60;
                break;
            case 3:
                r = min;
                g = max - (h - 180)*(max - min)/60;
                b =max;
                break;
            case 4:
                r = min + (h - 240)*(max - min)/60;
                g = min;
                b = max;
                break;
            case 5:
                r = max;
                g = min;
                b = max - (h - 300)*(max - min)/60;
                break;
            case 6:
                r = max;
                g = min + h*(max - min)/60;
                b = min;
                break;
        }
        r = Math.min(255, Math.max(0, Math.round(r)));
        g = Math.min(255, Math.max(0, Math.round(g)));
        b = Math.min(255, Math.max(0, Math.round(b)));
        return {r:r, g:g, b:b};
    }

}


import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF):void {
        bd = t;
        rect = r;
        threshold = th;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x;
                    var py:int = y*accuracy + rect.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}
