/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/SOsN
 */

// forked from takishiki's mp3プレーヤー的な
/*
 * mp3プレーヤーもどき
 * 再生、一時停止、ジャンプ、ボリューム調整
 * 
 * 
 * ♪使用音楽素材について♪
 * 音楽素材/魔王魂（http://maoudamashii.jokersounds.com/）の素材を使わせていただきました。
 * ありがとうございます。
 * 
 */
package 
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.external.ExternalInterface;
    import flash.geom.ColorTransform;
    import flash.display.DisplayObject;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.display.StageAlign;
    import flash.system.Security;
    
    //[SWF(width = 220, height = 80, frameRate = 30, backgroundColor = 0xFFFFFF)]
    public class Main extends Sprite 
    {
        private var _snd:Sound;
        private var _channel:SoundChannel;
        private var _transform:SoundTransform;
        
        private var _playBtn:Sprite;
        private var _stopBtn:Sprite;
        private var _volBgSp:Sprite;
        private var _volSp:Sprite;
        private var _posBgSp:Sprite;
        private var _posSp:Sprite;
        
        private var _tf:TextField;
        
        private const _mp3url:String = "http://vaindog.raindrop.jp/wonderfl/sound/bgm_maoudamashii_cyber06.mp3";
        private var _cntFlag:Boolean;
        private var _playFlag:Boolean;
        private var _pos:int;
        
        // constructor
        public function Main():void {
            this.addEventListener(Event.ENTER_FRAME, stageSizeCheck);
        }
        
        // 
        private function stageSizeCheck(event:Event):void {
            if (stage.stageWidth * stage.stageHeight == 0) return;
            
            this.removeEventListener(Event.ENTER_FRAME, stageSizeCheck);
            init();
        }
        
        // 
        private function init():void {
            stage.align = StageAlign.TOP_LEFT;
            
            _pos = 0;
            _cntFlag = false;
            _playFlag = false;
            
            var g:Graphics;
            
            // 見た目部分の描画とか配置とか適当に
            
            // ポジション背景（背景といいつつクリック判定はこっち）
            _posBgSp = new Sprite();
            g = _posBgSp.graphics;
            g.lineStyle();
            g.beginFill(0xDDDDDD);
            g.drawRect(0, 0, stage.stageWidth - 20 , 10);
            g.endFill();
            _posBgSp.x = 10;
            _posBgSp.y = 40;
            _posBgSp.buttonMode = true;
            _posBgSp.addEventListener(MouseEvent.CLICK, posChange);
            this.addChild(_posBgSp);
            // ポジション
            _posSp = new Sprite();
            g = _posSp.graphics;
            g.lineStyle();
            g.beginFill(0x999999);
            g.drawRect(0, 0, stage.stageWidth - 20 , 10);
            g.endFill();
            _posSp.x = 10;
            _posSp.y = 40;
            _posSp.scaleX = 0;
            _posSp.mouseEnabled = false;
            this.addChild(_posSp);
            
            // ボリューム背景（背景といいつつクリック判定はこっち）
            _volBgSp = new Sprite();
            g = _volBgSp.graphics;
            g.lineStyle();
            g.beginFill(0xFF0000, 0);
            g.drawRect(0, 0, 100, -20);
            g.endFill();
            g.lineStyle();
            g.beginFill(0xDDDDDD);
            g.moveTo(0, 0);
            g.lineTo(100, 0);
            g.lineTo(100, -20);
            g.lineTo(0, 0);
            g.endFill();
            _volBgSp.x = 70;
            _volBgSp.y = 80;
            _volBgSp.buttonMode = true;
            _volBgSp.mouseEnabled = true;
            _volBgSp.addEventListener(MouseEvent.CLICK, volChange);
            this.addChild(_volBgSp);
            // ボリューム
            _volSp = new Sprite();
            g = _volSp.graphics;
            g.lineStyle();
            g.beginFill(0x999999);
            g.moveTo(0, 0);
            g.lineTo(100, 0);
            g.lineTo(100, -20);
            g.lineTo(0, 0);
            g.endFill();
            _volSp.x = 70;
            _volSp.y = 80;
            _volSp.buttonMode = false;
            _volSp.mouseEnabled = false;
            _volSp.scaleX = _volSp.scaleY = 1.0;
            this.addChild(_volSp);
            
            // 再生ボタン
            _playBtn = new Sprite();
            g = _playBtn.graphics;
            g.lineStyle(1, 0x666666);
            g.beginFill(0xCCCCCC, 1.0);
            g.drawCircle(0, 0, 10);
            g.endFill();
            // 三角
            g.lineStyle();
            g.beginFill(0x333333, 1.0);
            g.moveTo( -5, -5);
            g.lineTo(5, 0);
            g.lineTo( -5, 5);
            g.lineTo( -5, -5);
            g.endFill();
            
            _playBtn.x = 20;
            _playBtn.y = 70;
            _playBtn.buttonMode = true;
            _playBtn.mouseEnabled = true;
            _playBtn.addEventListener(MouseEvent.CLICK, playBtnClick);
            _playBtn.addEventListener(MouseEvent.MOUSE_OVER, spMouseOver);
            _playBtn.addEventListener(MouseEvent.MOUSE_OUT, spMouseOut);
            this.addChild(_playBtn);
            
            // 停止ボタン
            _stopBtn = new Sprite();
            g = _stopBtn.graphics;
            g.lineStyle(1, 0x666666);
            g.beginFill(0xCCCCCC, 1.0);
            g.drawCircle(0, 0, 10);
            g.endFill();
            // 四角
            g.lineStyle();
            g.beginFill(0x333333, 1.0);
            g.drawRect( -5, -5, 10, 10);
            g.endFill();
            
            _stopBtn.x = 50;
            _stopBtn.y = 70;
            _stopBtn.buttonMode = true;
            _stopBtn.mouseEnabled = false;
            _stopBtn.addEventListener(MouseEvent.CLICK, stopBtnClick);
            _stopBtn.addEventListener(MouseEvent.MOUSE_OVER, spMouseOver);
            _stopBtn.addEventListener(MouseEvent.MOUSE_OUT, spMouseOut);
            this.addChild(_stopBtn);
            
            setHighlight(_playBtn, 0x333333);
            setHighlight(_stopBtn, 0x333333);
            
            // トータルタイム及び現在のタイム表示
            _tf = new TextField();
            _tf.autoSize = TextFieldAutoSize.RIGHT;
            _tf.text = "00:00 / 00:00";
            _tf.x = 10;
            _tf.y = 10;
            _tf.textColor = 0x000000;
            _tf.selectable = false;
            _tf.multiline = false;
            _tf.type = TextFieldType.DYNAMIC;
            _tf.mouseEnabled = false;
            this.addChild(_tf);
            
            _snd = new Sound();
            Security.loadPolicyFile("http://vaindog.raindrop.jp/crossdomain.xml");
            var req:URLRequest = new URLRequest(_mp3url);
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            _snd.load(req, context);
            
            _transform = new SoundTransform();
            _transform.volume = 1.0;    // 音量最大
            _transform.pan = 0.0;    // パンは中央
            
            _channel = new SoundChannel();
            _channel.soundTransform = _transform;
            _channel.addEventListener(Event.SOUND_COMPLETE, onPlaybackComplete);
            
            _channel = _snd.play(_pos);
            _channel.stop();
            
            // フレーム処理
            this.addEventListener(Event.ENTER_FRAME, sndLengthCheck);
        }
        
        // 
        private function volChange(event:MouseEvent):void {
            var ratio:Number = event.localX / _volBgSp.width;
            _transform.volume = ratio;
            _channel.soundTransform = _transform;
            
            _volSp.scaleX = _volSp.scaleY = ratio;
        }
        
        // 
        private function posChange(event:MouseEvent):void {
            var realLength:int = Math.round(_snd.length / (_snd.bytesLoaded / _snd.bytesTotal))
            var ratio:Number = event.localX / _posBgSp.width;
            
            _pos = int(realLength * ratio);
            playSound();
        }
        
        // フレーム処理
        private function sndLengthCheck(event:Event):void {
            var realLength:int = Math.round(_snd.length / (_snd.bytesLoaded / _snd.bytesTotal))
            
            var pos:int;
            if (_playFlag) {
                pos = _channel.position;
                _pos = pos;
            }else {
                pos = _pos;
            }
            
            _tf.text = ms2TimeStr(pos) + " / " + ms2TimeStr(realLength);
            
            var ratio:Number = pos / realLength;
            _posSp.scaleX = ratio;
        }
        
        // ミリ秒　から　分：秒の文字列　を取得
        private function ms2TimeStr(ms:int):String {
            var m:int = int(ms / 1000 / 60);
            var s:int = int((ms - m * 1000 * 60) / 1000);
            
            var str:String;
            str = numFormatter(m, 2) + ":" + numFormatter(s, 2);
            
            return str;
        }
        
        // 再生終了時
        private function onPlaybackComplete(event:Event):void {
            _playBtn.mouseEnabled = true;
            _stopBtn.mouseEnabled = false;
            
            _playFlag = false;
            playSound();
        }
        
        // 再生ボタンが押されたとき
        private function playBtnClick(event:MouseEvent):void {
            _stopBtn.mouseEnabled = true;
            _playBtn.mouseEnabled = false;
            
            _playFlag = true;
            playSound();
            
            if (!_cntFlag) _cntFlag = true;
        }
        
        // 停止ボタンが押されたとき
        private function stopBtnClick(event:MouseEvent):void {
            _playBtn.mouseEnabled = true;
            _stopBtn.mouseEnabled = false;
            
            _playFlag = false;
            playSound();
        }
        
        // 
        private function playSound():void {
            _channel.stop();
            _channel = _snd.play(_pos);
            _channel.soundTransform = _transform;
            _channel.addEventListener(Event.SOUND_COMPLETE, onPlaybackComplete);
            
            if (!_playFlag) _channel.stop();
        }
        
        // マウスオーバー・アウト
        // MouseOut
        private function spMouseOut(event:MouseEvent):void {
            var sp:Sprite = event.currentTarget as Sprite;
            setHighlight(sp, 0x333333);
        }
        
        // MouseOver
        private function spMouseOver(event:MouseEvent):void {
            var sp:Sprite = event.currentTarget as Sprite;
            setHighlight(sp, 0);
        }
        
        // ハイライト
        private function setHighlight(target:DisplayObject, color:uint = 0):void {
            var ct:ColorTransform = target.transform.colorTransform;    // colorTransformオブジェクトを取得
            // colorをrgb各成分に分解
            var r:int = (color & 0xFF0000) >> 16;
            var g:int = (color & 0x00FF00) >> 8;
            var b:int = (color & 0x0000FF);
            // オフセット量としてセット
            ct.redOffset = r;
            ct.greenOffset = g;
            ct.blueOffset = b;
            
            target.transform.colorTransform = ct;    // 更新後のcolorTransformオブジェクトを設定
        }
        
        // 数値　から　指定桁数の文字列（頭にゼロを付加したもの）　を取得
        private function numFormatter(num:Number, digit:int):String {
            var str:String = String(num);
            var len:int = str.length;
            if (len >= digit) return str;
            
            len = digit - len;
            for (var i:int = 0; i < len; i++) {
                str = "0" + str;
            }
            
            return str;
        }
    }
    
}

